/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.impl;

import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.serialization.JpsGlobalElementSaver;
import org.jetbrains.jps.model.serialization.JpsGlobalLoader;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.model.serialization.JpsProjectLoader;
import org.jetbrains.jps.model.serialization.JpsSerializationManager;

public class JpsSerializationManagerImpl
extends JpsSerializationManager {
    @Override
    @NotNull
    public JpsModel loadModel(@NotNull String projectPath, @Nullable String optionsPath) throws IOException {
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "org/jetbrains/jps/model/serialization/impl/JpsSerializationManagerImpl", "loadModel"));
        }
        JpsModel model2 = JpsElementFactory.getInstance().createModel();
        if (optionsPath != null) {
            JpsGlobalLoader.loadGlobalSettings(model2.getGlobal(), optionsPath);
        }
        Map<String, String> pathVariables = JpsModelSerializationDataService.computeAllPathVariables(model2.getGlobal());
        JpsProjectLoader.loadProject(model2.getProject(), pathVariables, projectPath);
        JpsModel jpsModel = model2;
        if (jpsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/impl/JpsSerializationManagerImpl", "loadModel"));
        }
        return jpsModel;
    }

    @Override
    public void saveGlobalSettings(@NotNull JpsGlobal global, @NotNull String optionsPath) throws IOException {
        if (global == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/model/serialization/impl/JpsSerializationManagerImpl", "saveGlobalSettings"));
        }
        if (optionsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsPath", "org/jetbrains/jps/model/serialization/impl/JpsSerializationManagerImpl", "saveGlobalSettings"));
        }
        JpsGlobalElementSaver.saveGlobalElement(global, optionsPath);
    }
}

