/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.java.compiler;

import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;

public class JpsJavaCompilerOptionsSerializer
extends JpsProjectExtensionSerializer {
    private final String myCompilerId;

    public JpsJavaCompilerOptionsSerializer(String componentName, String compilerId) {
        super("compiler.xml", componentName);
        this.myCompilerId = compilerId;
    }

    @Override
    public void loadExtension(@NotNull JpsProject project2, @NotNull Element componentTag) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/java/compiler/JpsJavaCompilerOptionsSerializer", "loadExtension"));
        }
        if (componentTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/java/compiler/JpsJavaCompilerOptionsSerializer", "loadExtension"));
        }
        JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project2);
        JpsJavaCompilerOptions options = (JpsJavaCompilerOptions)XmlSerializer.deserialize((Element)componentTag, JpsJavaCompilerOptions.class);
        configuration.setCompilerOptions(this.myCompilerId, options);
    }

    @Override
    public void loadExtensionWithDefaultSettings(@NotNull JpsProject project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/java/compiler/JpsJavaCompilerOptionsSerializer", "loadExtensionWithDefaultSettings"));
        }
        JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project2);
        configuration.setCompilerOptions(this.myCompilerId, new JpsJavaCompilerOptions());
    }

    @Override
    public void saveExtension(@NotNull JpsProject project2, @NotNull Element componentTag) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/java/compiler/JpsJavaCompilerOptionsSerializer", "saveExtension"));
        }
        if (componentTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/java/compiler/JpsJavaCompilerOptionsSerializer", "saveExtension"));
        }
    }
}

