/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.library;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaLibraryType;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.library.JpsLibraryPropertiesSerializer;
import org.jetbrains.jps.model.serialization.library.JpsLibraryRootTypeSerializer;

public class JpsLibraryTableSerializer {
    private static final JpsLibraryRootTypeSerializer[] PREDEFINED_ROOT_TYPES_SERIALIZERS = new JpsLibraryRootTypeSerializer[]{new JpsLibraryRootTypeSerializer("CLASSES", JpsOrderRootType.COMPILED, true), new JpsLibraryRootTypeSerializer("SOURCES", JpsOrderRootType.SOURCES, true)};
    private static final String NAME_ATTRIBUTE = "name";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String PROPERTIES_TAG = "properties";
    private static final String JAR_DIRECTORY_TAG = "jarDirectory";
    private static final String URL_ATTRIBUTE = "url";
    private static final String ROOT_TAG = "root";
    private static final String RECURSIVE_ATTRIBUTE = "recursive";
    private static final String LIBRARY_TAG = "library";
    private static final JpsLibraryPropertiesSerializer<JpsDummyElement> JAVA_LIBRARY_PROPERTIES_SERIALIZER = new JpsLibraryPropertiesSerializer<JpsDummyElement>((JpsLibraryType)JpsJavaLibraryType.INSTANCE, null){

        @Override
        public JpsDummyElement loadProperties(@Nullable Element propertiesElement) {
            return JpsElementFactory.getInstance().createDummyElement();
        }

        @Override
        public void saveProperties(JpsDummyElement properties, Element element) {
        }
    };
    private static final String MODULE_LEVEL = "module";
    private static final String PROJECT_LEVEL = "project";
    private static final String APPLICATION_LEVEL = "application";

    public static void loadLibraries(@Nullable Element libraryTableElement, JpsLibraryCollection result2) {
        for (Element libraryElement : JDOMUtil.getChildren((Element)libraryTableElement, (String)LIBRARY_TAG)) {
            result2.addLibrary(JpsLibraryTableSerializer.loadLibrary(libraryElement));
        }
    }

    public static void saveLibraries(JpsLibraryCollection libraryCollection, Element libraryTableElement) {
        ArrayList<JpsLibrary> libraries = new ArrayList<JpsLibrary>();
        for (JpsLibrary library : libraryCollection.getLibraries()) {
            if (library.getType() instanceof JpsSdkType) continue;
            libraries.add(library);
        }
        libraries.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        for (JpsLibrary library : libraries) {
            Element libraryTag = new Element(LIBRARY_TAG);
            JpsLibraryTableSerializer.saveLibrary(library, libraryTag, library.getName());
            libraryTableElement.addContent(libraryTag);
        }
    }

    public static JpsLibrary loadLibrary(Element libraryElement) {
        return JpsLibraryTableSerializer.loadLibrary(libraryElement, libraryElement.getAttributeValue(NAME_ATTRIBUTE));
    }

    public static JpsLibrary loadLibrary(Element libraryElement, String name) {
        String typeId = libraryElement.getAttributeValue(TYPE_ATTRIBUTE);
        JpsLibraryPropertiesSerializer<?> loader = JpsLibraryTableSerializer.getLibraryPropertiesSerializer(typeId);
        JpsLibrary library = JpsLibraryTableSerializer.createLibrary(name, loader, libraryElement.getChild(PROPERTIES_TAG));
        MultiMap jarDirectories = new MultiMap();
        MultiMap recursiveJarDirectories = new MultiMap();
        for (Element jarDirectory : JDOMUtil.getChildren((Element)libraryElement, (String)JAR_DIRECTORY_TAG)) {
            String url = jarDirectory.getAttributeValue(URL_ATTRIBUTE);
            String rootTypeId = jarDirectory.getAttributeValue(TYPE_ATTRIBUTE);
            JpsOrderRootType rootType = rootTypeId != null ? JpsLibraryTableSerializer.getRootType(rootTypeId) : JpsOrderRootType.COMPILED;
            boolean recursive = Boolean.parseBoolean(jarDirectory.getAttributeValue(RECURSIVE_ATTRIBUTE));
            jarDirectories.putValue((Object)rootType, (Object)url);
            if (!recursive) continue;
            recursiveJarDirectories.putValue((Object)rootType, (Object)url);
        }
        for (Element rootsElement : libraryElement.getChildren()) {
            String rootTypeId = rootsElement.getName();
            if (rootTypeId.equals(JAR_DIRECTORY_TAG) || rootTypeId.equals(PROPERTIES_TAG)) continue;
            JpsOrderRootType rootType = JpsLibraryTableSerializer.getRootType(rootTypeId);
            for (Element rootElement : JDOMUtil.getChildren((Element)rootsElement, (String)ROOT_TAG)) {
                boolean recursive;
                String url = rootElement.getAttributeValue(URL_ATTRIBUTE);
                JpsLibraryRoot.InclusionOptions options = jarDirectories.get((Object)rootType).contains(url) ? ((recursive = recursiveJarDirectories.get((Object)rootType).contains(url)) ? JpsLibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT_RECURSIVELY : JpsLibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT) : JpsLibraryRoot.InclusionOptions.ROOT_ITSELF;
                library.addRoot(url, rootType, options);
            }
        }
        return library;
    }

    public static void saveLibrary(JpsLibrary library, Element libraryElement, String libraryName) {
        if (libraryName != null) {
            libraryElement.setAttribute(NAME_ATTRIBUTE, libraryName);
        }
        JpsLibraryTableSerializer.saveProperties((JpsTypedLibrary)library, libraryElement);
        ArrayList<Element> jarDirectoryElements = new ArrayList<Element>();
        for (JpsLibraryRootTypeSerializer serializer2 : JpsLibraryTableSerializer.getSortedSerializers()) {
            List roots = library.getRoots(serializer2.getType());
            if (roots.isEmpty() && !serializer2.isWriteIfEmpty()) continue;
            Element typeElement = new Element(serializer2.getTypeId());
            for (JpsLibraryRoot root : roots) {
                typeElement.addContent(new Element(ROOT_TAG).setAttribute(URL_ATTRIBUTE, root.getUrl()));
                if (root.getInclusionOptions() == JpsLibraryRoot.InclusionOptions.ROOT_ITSELF) continue;
                Element jarDirectoryElement = new Element(JAR_DIRECTORY_TAG).setAttribute(URL_ATTRIBUTE, root.getUrl());
                boolean recursive = root.getInclusionOptions() == JpsLibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT_RECURSIVELY;
                jarDirectoryElement.setAttribute(RECURSIVE_ATTRIBUTE, Boolean.toString(recursive));
                if (!serializer2.getType().equals(JpsOrderRootType.COMPILED)) {
                    jarDirectoryElement.setAttribute(TYPE_ATTRIBUTE, serializer2.getTypeId());
                }
                jarDirectoryElements.add(jarDirectoryElement);
            }
            libraryElement.addContent(typeElement);
        }
        libraryElement.addContent(jarDirectoryElements);
    }

    private static <P extends JpsElement> void saveProperties(JpsTypedLibrary<P> library, Element libraryElement) {
        JpsLibraryType type = library.getType();
        if (!type.equals(JpsJavaLibraryType.INSTANCE)) {
            JpsLibraryPropertiesSerializer<JpsElement> serializer2 = JpsLibraryTableSerializer.getLibraryPropertiesSerializer(type);
            libraryElement.setAttribute(TYPE_ATTRIBUTE, serializer2.getTypeId());
            Element element = new Element(PROPERTIES_TAG);
            serializer2.saveProperties(library.getProperties(), element);
            if (!element.getContent().isEmpty() || !element.getAttributes().isEmpty()) {
                libraryElement.addContent(element);
            }
        }
    }

    private static <P extends JpsElement> JpsLibrary createLibrary(String name, JpsLibraryPropertiesSerializer<P> loader, Element propertiesElement) {
        return JpsElementFactory.getInstance().createLibrary(name, (JpsLibraryType)loader.getType(), loader.loadProperties(propertiesElement));
    }

    private static JpsOrderRootType getRootType(String rootTypeId) {
        for (JpsLibraryRootTypeSerializer serializer2 : PREDEFINED_ROOT_TYPES_SERIALIZERS) {
            if (!serializer2.getTypeId().equals(rootTypeId)) continue;
            return serializer2.getType();
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsLibraryRootTypeSerializer serializer2 : extension.getLibraryRootTypeSerializers()) {
                if (!serializer2.getTypeId().equals(rootTypeId)) continue;
                return serializer2.getType();
            }
        }
        return JpsOrderRootType.COMPILED;
    }

    private static Collection<JpsLibraryRootTypeSerializer> getSortedSerializers() {
        ArrayList<JpsLibraryRootTypeSerializer> serializers = new ArrayList<JpsLibraryRootTypeSerializer>();
        Collections.addAll(serializers, PREDEFINED_ROOT_TYPES_SERIALIZERS);
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            serializers.addAll(extension.getLibraryRootTypeSerializers());
        }
        Collections.sort(serializers);
        return serializers;
    }

    private static JpsLibraryPropertiesSerializer<?> getLibraryPropertiesSerializer(@Nullable String typeId) {
        if (typeId != null) {
            for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
                for (JpsLibraryPropertiesSerializer<?> loader : extension.getLibraryPropertiesSerializers()) {
                    if (!loader.getTypeId().equals(typeId)) continue;
                    return loader;
                }
            }
        }
        return JAVA_LIBRARY_PROPERTIES_SERIALIZER;
    }

    private static <P extends JpsElement> JpsLibraryPropertiesSerializer<P> getLibraryPropertiesSerializer(@NotNull JpsLibraryType<P> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", TYPE_ATTRIBUTE, "org/jetbrains/jps/model/serialization/library/JpsLibraryTableSerializer", "getLibraryPropertiesSerializer"));
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsLibraryPropertiesSerializer<?> loader : extension.getLibraryPropertiesSerializers()) {
                if (!((JpsLibraryType)loader.getType()).equals(type)) continue;
                return loader;
            }
        }
        throw new IllegalArgumentException("unknown type library:" + type);
    }

    public static JpsElementReference<? extends JpsCompositeElement> createLibraryTableReference(String level) {
        JpsElementFactory elementFactory = JpsElementFactory.getInstance();
        if (level.equals(PROJECT_LEVEL)) {
            return elementFactory.createProjectReference();
        }
        if (level.equals(APPLICATION_LEVEL)) {
            return elementFactory.createGlobalReference();
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            JpsElementReference<? extends JpsCompositeElement> reference = extension.createLibraryTableReference(level);
            if (reference == null) continue;
            return reference;
        }
        throw new UnsupportedOperationException();
    }

    public static String getLevelId(JpsElementReference<? extends JpsCompositeElement> reference) {
        if (reference instanceof JpsModuleReference) {
            return MODULE_LEVEL;
        }
        JpsCompositeElement element = (JpsCompositeElement)reference.resolve();
        if (element instanceof JpsProject) {
            return PROJECT_LEVEL;
        }
        if (element instanceof JpsGlobal) {
            return APPLICATION_LEVEL;
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            String levelId = extension.getLibraryTableLevelId(reference);
            if (levelId == null) continue;
            return levelId;
        }
        return null;
    }
}

