/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.runConfigurations;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.hash.HashMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.runConfiguration.JpsRunConfigurationType;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.runConfigurations.JpsRunConfigurationPropertiesSerializer;
import org.jetbrains.jps.model.serialization.runConfigurations.JpsUnknownRunConfigurationType;

public class JpsRunConfigurationSerializer {
    private static final Logger LOG = Logger.getInstance(JpsRunConfigurationSerializer.class);

    public static void loadRunConfigurations(@NotNull JpsProject project2, @Nullable Element runManagerTag) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/runConfigurations/JpsRunConfigurationSerializer", "loadRunConfigurations"));
        }
        HashMap serializers = new HashMap();
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsRunConfigurationPropertiesSerializer<?> jpsRunConfigurationPropertiesSerializer : extension.getRunConfigurationPropertiesSerializers()) {
                serializers.put(jpsRunConfigurationPropertiesSerializer.getTypeId(), jpsRunConfigurationPropertiesSerializer);
            }
        }
        for (Element configurationTag : JDOMUtil.getChildren((Element)runManagerTag, (String)"configuration")) {
            if (Boolean.parseBoolean(configurationTag.getAttributeValue("default"))) continue;
            String typeId = configurationTag.getAttributeValue("type");
            JpsRunConfigurationPropertiesSerializer jpsRunConfigurationPropertiesSerializer = (JpsRunConfigurationPropertiesSerializer)serializers.get(typeId);
            String name = configurationTag.getAttributeValue("name");
            if (jpsRunConfigurationPropertiesSerializer != null) {
                JpsRunConfigurationSerializer.loadRunConfiguration(name, configurationTag, jpsRunConfigurationPropertiesSerializer, project2);
                continue;
            }
            if (typeId != null) {
                project2.addRunConfiguration(name, (JpsRunConfigurationType)new JpsUnknownRunConfigurationType(typeId), (JpsElement)JpsElementFactory.getInstance().createDummyElement());
                continue;
            }
            LOG.info("Run configuration '" + name + "' wasn't loaded because 'type' attribute is missing");
        }
    }

    private static <P extends JpsElement> void loadRunConfiguration(String name, Element configurationTag, JpsRunConfigurationPropertiesSerializer<P> serializer2, JpsProject project2) {
        P properties = serializer2.loadProperties(configurationTag);
        project2.addRunConfiguration(name, (JpsRunConfigurationType)serializer2.getType(), properties);
    }
}

