/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.service.impl;

import com.intellij.util.ConcurrencyUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.service.SharedThreadPool;

public class SharedThreadPoolImpl
extends SharedThreadPool {
    private final ExecutorService myService = Executors.newCachedThreadPool(ConcurrencyUtil.newNamedThreadFactory((String)"JPS thread pool"));

    public void execute(@NotNull Runnable command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/jps/service/impl/SharedThreadPoolImpl", "execute"));
        }
        this.executeOnPooledThread(command);
    }

    @NotNull
    public Future<?> executeOnPooledThread(@NotNull Runnable action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/jps/service/impl/SharedThreadPoolImpl", "executeOnPooledThread"));
        }
        Future<?> future2 = this.myService.submit(() -> {
            if (action2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/jps/service/impl/SharedThreadPoolImpl", "lambda$executeOnPooledThread$0"));
            }
            try {
                action2.run();
            }
            finally {
                Thread.interrupted();
            }
        });
        if (future2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/service/impl/SharedThreadPoolImpl", "executeOnPooledThread"));
        }
        return future2;
    }
}

