/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rsa;

import com.intellij.licensecommon.util.InvalidLicenseKeyException;
import java.math.BigInteger;

public class GroupUtil {
    public static String encodeGroups(BigInteger value2) {
        BigInteger MOD = BigInteger.valueOf(60466176L);
        StringBuffer buffer = new StringBuffer();
        int groupCount = 0;
        while (value2.compareTo(BigInteger.ZERO) != 0) {
            int d2 = value2.mod(MOD).intValue();
            String group = GroupUtil.encodeGroup(d2);
            if (groupCount > 0) {
                buffer.append("-");
            }
            buffer.append(group);
            value2 = value2.divide(MOD);
            ++groupCount;
        }
        String key = buffer.toString();
        return key;
    }

    public static String encodeGroup(int value2) {
        StringBuffer buffer = new StringBuffer();
        int MOD = 36;
        for (int i2 = 0; i2 < 5; ++i2) {
            int d2 = value2 % 36;
            char c2 = d2 < 10 ? (char)(48 + d2) : (char)(65 + d2 - 10);
            buffer.append(c2);
            value2 /= 36;
        }
        return buffer.toString();
    }

    public static BigInteger decodeGroups(String key) throws InvalidLicenseKeyException {
        BigInteger value2 = BigInteger.ZERO;
        int index = key.length();
        BigInteger MOD = BigInteger.valueOf(60466176L);
        while (index >= 0) {
            int index1 = key.lastIndexOf(45, index - 1) + 1;
            String group = key.substring(index1, index);
            int d2 = GroupUtil.decodeGroup(group);
            value2 = value2.multiply(MOD);
            value2 = value2.add(BigInteger.valueOf(d2));
            index = index1 - 1;
        }
        return value2;
    }

    public static int decodeGroup(String group) throws InvalidLicenseKeyException {
        if (group.length() != 5) {
            throw new InvalidLicenseKeyException();
        }
        int MOD = 36;
        int value2 = 0;
        for (int i2 = group.length() - 1; i2 >= 0; --i2) {
            int d2;
            char c2 = group.charAt(i2);
            if ('0' <= c2 && c2 <= '9') {
                d2 = c2 - 48;
            } else if ('A' <= c2 && c2 <= 'Z') {
                d2 = c2 - 65 + 10;
            } else {
                throw new InvalidLicenseKeyException();
            }
            value2 *= 36;
            value2 += d2;
        }
        return value2;
    }
}

