/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rsa;

import com.intellij.licensecommon.util.InvalidLicenseKeyException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSADecoder {
    private final BigInteger myDigitsMod;
    private final BigInteger publicExponent;
    private final BigInteger publicModulus;
    private final int digitsPerChunk;
    private final int chunkSize;

    public RSADecoder(BigInteger publicExponent, BigInteger publicModulus) {
        this(publicExponent, publicModulus, 16);
    }

    public RSADecoder(BigInteger publicExponent, BigInteger publicModulus, int alphabetSize) {
        this.publicModulus = publicModulus;
        this.publicExponent = publicExponent;
        int keyLength = publicModulus.bitLength();
        this.chunkSize = keyLength / 8 - 1;
        int digits = (int)Math.ceil((double)keyLength / Math.log(alphabetSize) * Math.log(2.0));
        if (digits % 5 != 0) {
            digits = (digits / 5 + 1) * 5;
        }
        this.digitsPerChunk = digits;
        this.myDigitsMod = new BigInteger(Integer.toString(alphabetSize));
    }

    public byte[] decode(String data) throws InvalidLicenseKeyException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            BigInteger chunkBytes = BigInteger.ZERO;
            int digitsRead = 0;
            for (int i2 = 0; i2 < data.length(); ++i2) {
                char c2 = data.charAt(i2);
                if (c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '-') continue;
                chunkBytes = chunkBytes.multiply(this.myDigitsMod).add(RSADecoder.decodeChar(c2));
                if (++digitsRead != this.digitsPerChunk) continue;
                BigInteger decodedChunk = chunkBytes.modPow(this.publicExponent, this.publicModulus);
                byte[] decodedBytes = decodedChunk.toByteArray();
                stream.write(decodedBytes, Math.max(decodedBytes.length - this.chunkSize, 0), Math.min(decodedBytes.length, this.chunkSize));
                chunkBytes = BigInteger.ZERO;
                digitsRead = 0;
            }
            if (digitsRead != 0) {
                throw new InvalidLicenseKeyException();
            }
            stream.close();
            return stream.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    private static BigInteger decodeChar(char c2) throws InvalidLicenseKeyException {
        int d2;
        if ('0' <= c2 && c2 <= '9') {
            d2 = c2 - 48;
        } else if ('A' <= c2 && c2 <= 'Z') {
            d2 = c2 - 65 + 10;
        } else if ('a' <= c2 && c2 <= 'z') {
            d2 = c2 - 97 + 36;
        } else if ('!' <= c2 && c2 <= ')') {
            d2 = c2 - 33 + 62;
        } else {
            throw new InvalidLicenseKeyException();
        }
        return BigInteger.valueOf(d2);
    }

    public String decodeString(String data) throws InvalidLicenseKeyException {
        try {
            return new String(this.decode(data), "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            return "";
        }
    }

    public Map<String, String> decodeProperties(String data) throws InvalidLicenseKeyException {
        HashMap<String, String> result2 = new HashMap<String, String>();
        String serialized = this.decodeString(data);
        StringTokenizer tokenizer = new StringTokenizer(serialized, "\n", false);
        while (tokenizer.hasMoreTokens()) {
            String key = tokenizer.nextToken();
            String value2 = tokenizer.nextToken();
            result2.put(key, value2);
        }
        return result2;
    }
}

