/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rsa;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSAEncoder {
    private final BigInteger privateExponent;
    private final BigInteger privateModulus;
    private final int chunkSize;
    private final int digitsPerChunk;
    private int digitsGenerated = 0;
    private final BigInteger myDigitsMod;
    private final boolean myAddDashes;

    public RSAEncoder(BigInteger privateExponent, BigInteger privateModulus) {
        this(privateExponent, privateModulus, 16, true);
    }

    public RSAEncoder(BigInteger privateExponent, BigInteger privateModulus, int alphabetSize, boolean addDashes) {
        this.privateExponent = privateExponent;
        this.privateModulus = privateModulus;
        this.myAddDashes = addDashes;
        int keyLength = privateModulus.bitLength();
        this.myDigitsMod = new BigInteger(String.valueOf(alphabetSize));
        int digits = (int)Math.ceil((double)keyLength / Math.log(alphabetSize) * Math.log(2.0));
        if (digits % 5 != 0) {
            digits = (digits / 5 + 1) * 5;
        }
        this.digitsPerChunk = digits;
        this.chunkSize = keyLength / 8 - 1;
    }

    public String encode(byte[] data) {
        byte[] original;
        int leap = data.length % this.chunkSize;
        if (leap == 0) {
            original = data;
        } else {
            original = new byte[data.length + this.chunkSize - leap];
            System.arraycopy(data, 0, original, this.chunkSize - leap, data.length);
        }
        StringBuilder encoded = new StringBuilder();
        for (int i2 = 0; i2 < original.length; i2 += this.chunkSize) {
            this.encodeChunk(original, encoded, i2, this.chunkSize);
        }
        return encoded.toString();
    }

    public String encodeString(String data) {
        try {
            return this.encode(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e2) {
            return "";
        }
    }

    private void encodeChunk(byte[] original, StringBuilder encoded, int offset, int len) {
        if (len == 0) {
            return;
        }
        byte[] buf = new byte[this.chunkSize];
        System.arraycopy(original, offset, buf, 0, len);
        BigInteger chunk = new BigInteger(1, buf);
        if (chunk.compareTo(this.privateModulus) >= 0) {
            throw new IllegalArgumentException("result is too long");
        }
        BigInteger encodedChunk = chunk.modPow(this.privateExponent, this.privateModulus);
        this.appendFormatted(encoded, this.encode(encodedChunk));
    }

    private void appendFormatted(StringBuilder result2, CharSequence s2) {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            this.appendSeparator(result2);
            result2.append(s2.charAt(i2));
        }
    }

    private CharSequence encode(BigInteger value2) {
        StringBuilder buf = new StringBuilder();
        for (int i2 = 0; i2 < this.digitsPerChunk; ++i2) {
            buf.append(RSAEncoder.digitChar(value2.mod(this.myDigitsMod)));
            value2 = value2.divide(this.myDigitsMod);
        }
        return new ReverseCharSequence(buf);
    }

    private void appendSeparator(StringBuilder buf) {
        if (this.digitsGenerated > 0 && this.digitsGenerated % 5 == 0) {
            if (this.digitsGenerated % 30 == 0) {
                buf.append('\n');
            } else if (this.myAddDashes) {
                buf.append('-');
            }
        }
        ++this.digitsGenerated;
    }

    private static char digitChar(BigInteger digit) {
        int d2 = digit.intValue();
        char c2 = d2 < 10 ? (char)(48 + d2) : (d2 < 36 ? (char)(65 + d2 - 10) : (d2 < 62 ? (char)(97 + d2 - 36) : (char)(33 + d2 - 62)));
        return c2;
    }

    public String encodeProperties(Map<String, String> properties) {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value2 = entry.getValue();
            if (key.indexOf(10) >= 0 || value2.indexOf(10) >= 0) {
                throw new RuntimeException("Keys and values are not allowed to contain linefeeds");
            }
            buf.append(key).append('\n').append(value2).append('\n');
        }
        return this.encodeString(buf.toString());
    }

    private static class ReverseCharSequence
    implements CharSequence {
        private final CharSequence mySequence;

        public ReverseCharSequence(CharSequence sequence) {
            this.mySequence = sequence;
        }

        public int length() {
            return this.mySequence.length();
        }

        public char charAt(int index) {
            return this.mySequence.charAt(this.mySequence.length() - index - 1);
        }

        public CharSequence subSequence(int start2, int end) {
            int length = this.mySequence.length();
            return new ReverseCharSequence(this.mySequence.subSequence(length - end, length - start2));
        }
    }
}

