/*
 * Decompiled with CFR 0.152.
 */
package y.algo;

import y.algo.Bipartitions;
import y.algo.GraphConnectivity;
import y.algo.NodeOrders;
import y.algo.Trees;
import y.algo.u;
import y.base.EdgeCursor;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;

public final class GraphChecker {
    private GraphChecker() {
    }

    public static boolean isAcyclic(Graph graph) {
        return NodeOrders.topological(graph, new int[graph.nodeCount()]);
    }

    public static boolean isCyclic(Graph graph) {
        return !GraphChecker.isAcyclic(graph);
    }

    public static boolean isPlanar(Graph graph) {
        return new u().b(graph);
    }

    public static boolean isConnected(Graph graph) {
        return GraphConnectivity.isConnected(graph);
    }

    public static boolean isStronglyConnected(Graph graph) {
        return GraphConnectivity.isStronglyConnected(graph);
    }

    public static boolean isBiconnected(Graph graph) {
        return GraphConnectivity.isBiconnected(graph);
    }

    public static boolean isBipartite(Graph graph) {
        return Bipartitions.isBipartite(graph);
    }

    public static boolean isNaryTree(Graph graph, int n2) {
        return Trees.isNaryTree(graph, n2);
    }

    public static boolean isRootedTree(Graph graph) {
        return Trees.isRootedTree(graph);
    }

    public static boolean isTree(Graph graph) {
        return Trees.isTree(graph);
    }

    public static boolean isForest(Graph graph) {
        return Trees.isForest(graph);
    }

    public static boolean isSelfLoopFree(Graph graph) {
        boolean bl;
        block3: {
            boolean bl2 = GraphConnectivity.z;
            EdgeCursor edgeCursor = graph.edges();
            while (edgeCursor.ok()) {
                bl = edgeCursor.edge().isSelfLoop();
                if (!bl2) {
                    if (bl) {
                        return false;
                    }
                    edgeCursor.next();
                    if (!bl2) continue;
                }
                break block3;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSimple(Graph graph) {
        boolean bl = GraphConnectivity.z;
        int[] nArray = new int[graph.N()];
        NodeCursor nodeCursor = graph.nodes();
        do {
            if (!nodeCursor.ok()) return 1 != 0;
            Node node = nodeCursor.node();
            int n2 = node.index();
            int n3 = 1;
            block1: while (true) {
                int n4 = n2 + n3;
                if (bl) return n4 != 0;
                int n5 = n4;
                NodeCursor nodeCursor2 = node.successors();
                while (nodeCursor2.ok()) {
                    Node node2 = nodeCursor2.node();
                    int n6 = node2.index();
                    n2 = nArray[n6];
                    n3 = n5;
                    if (bl) continue block1;
                    if (n2 == n3) {
                        return false;
                    }
                    nArray[n6] = n5;
                    nodeCursor2.next();
                    if (!bl) continue;
                }
                break;
            }
            nodeCursor.next();
        } while (!bl);
        return 1 != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isMultipleEdgeFree(Graph graph) {
        boolean bl = GraphConnectivity.z;
        int[] nArray = new int[graph.N()];
        NodeCursor nodeCursor = graph.nodes();
        do {
            if (!nodeCursor.ok()) return 1 != 0;
            Node node = nodeCursor.node();
            int n2 = node.index();
            int n3 = 1;
            block1: while (true) {
                int n4 = n2 + n3;
                if (bl) return n4 != 0;
                int n5 = n4;
                NodeCursor nodeCursor2 = node.neighbors();
                while (nodeCursor2.ok()) {
                    Node node2 = nodeCursor2.node();
                    int n6 = node2.index();
                    n2 = nArray[n6];
                    n3 = n5;
                    if (bl) continue block1;
                    if (n2 == n3) {
                        return false;
                    }
                    nArray[n6] = n5;
                    nodeCursor2.next();
                    if (!bl) continue;
                }
                break;
            }
            nodeCursor.next();
        } while (!bl);
        return 1 != 0;
    }
}

