/*
 * Decompiled with CFR 0.152.
 */
package y.algo;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import y.algo.GraphChecker;
import y.algo.GraphConnectivity;
import y.algo.q;
import y.algo.t;
import y.algo.v;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeMap;
import y.base.YCursor;
import y.util.GraphHider;
import y.util.GraphPartitionManager;
import y.util.Maps;

public class Groups {
    private Groups() {
    }

    public static int edgeBetweennessClustering(Graph graph, NodeMap nodeMap, boolean bl, int n2, int n3, DataProvider dataProvider) {
        if (graph.isEmpty()) {
            return 0;
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("minGroupCount (" + n2 + ") must not be greater than maxGroupCount (" + n3 + ")");
        }
        if (n2 > graph.N()) {
            throw new IllegalArgumentException("minGroupCount (" + n2 + ") must not be greater than graph.N() (" + graph.N() + ")");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("maxGroupCount (" + n3 + ") must be greater than 0");
        }
        q q2 = new q(graph);
        EdgeMap edgeMap = null;
        if (dataProvider != null) {
            edgeMap = q2.createEdgeMap();
            q2.b(q2.edges(), dataProvider, edgeMap);
        }
        NodeMap nodeMap2 = q2.createNodeMap();
        q2.c(q2.nodes(), nodeMap, nodeMap2);
        t t2 = new t();
        int n4 = t2.b(q2, nodeMap2, n2, n3, bl, edgeMap);
        q2.d(graph.nodes(), nodeMap2, nodeMap);
        return n4;
    }

    public static int edgeBetweennessClustering(Graph graph, NodeMap nodeMap, double d2, int n2, int n3, boolean bl) {
        Object object;
        boolean bl2 = GraphConnectivity.z;
        if (graph.isEmpty()) {
            return 0;
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("minGroupCount (" + n2 + ") must not be greater than maxGroupCount (" + n3 + ")");
        }
        if (n2 > graph.N()) {
            throw new IllegalArgumentException("minGroupCount (" + n2 + ") must not be greater than graph.N() (" + graph.N() + ")");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("maxGroupCount (" + n3 + ") must be greater than 0");
        }
        q q2 = new q(graph);
        NodeMap nodeMap2 = q2.createNodeMap();
        q2.c(q2.nodes(), nodeMap, nodeMap2);
        GraphHider graphHider = new GraphHider(q2);
        graphHider.simplifyGraph();
        if (bl) {
            object = q2.edges();
            while (object.ok()) {
                Edge edge = object.edge();
                if (nodeMap2.getInt(edge.source()) != nodeMap2.getInt(edge.target())) {
                    graphHider.hide(edge);
                }
                object.next();
                if (!bl2) continue;
            }
        }
        object = new v();
        ((v)object).c(d2 < 0.0 || d2 > 1.0 ? 0.5 : d2);
        ((v)object).e(n2);
        ((v)object).b(n3);
        int n4 = ((v)object).b(q2, nodeMap2);
        q2.d(graph.nodes(), nodeMap2, nodeMap);
        return n4;
    }

    public static int biconnectedComponentGrouping(Graph graph, NodeMap nodeMap) {
        int n2;
        block5: {
            boolean bl = GraphConnectivity.z;
            if (GraphChecker.isConnected(graph)) {
                return Groups.b(graph, nodeMap);
            }
            q q2 = new q(graph);
            NodeMap nodeMap2 = q2.createNodeMap();
            NodeMap nodeMap3 = q2.createNodeMap();
            int n3 = GraphConnectivity.connectedComponents(q2, nodeMap3);
            GraphPartitionManager graphPartitionManager = new GraphPartitionManager(q2, nodeMap3);
            graphPartitionManager.hideAll();
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                block6: {
                    int n7;
                    Integer n8 = new Integer(n6);
                    graphPartitionManager.displayPartition(n8);
                    n2 = n7 = Groups.b(q2, nodeMap2);
                    if (bl) break block5;
                    if (n2 == 0) {
                        n7 = 1;
                    }
                    n4 += n7;
                    NodeCursor nodeCursor = q2.nodes();
                    while (nodeCursor.ok()) {
                        Node node = nodeCursor.node();
                        nodeMap2.setInt(node, nodeMap2.getInt(node) + n5);
                        nodeCursor.next();
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block6;
                    }
                    n5 = n4;
                    ++n6;
                }
                if (!bl) continue;
            }
            graphPartitionManager.unhideAll();
            q2.d(graph.nodes(), nodeMap2, nodeMap);
            n2 = n4;
        }
        return n2;
    }

    private static int b(Graph graph, NodeMap nodeMap) {
        Object object;
        YCursor yCursor;
        boolean bl = GraphConnectivity.z;
        NodeMap nodeMap2 = Maps.createIndexNodeMap(new Object[graph.N()]);
        NodeMap nodeMap3 = Maps.createIndexNodeMap(new boolean[graph.N()]);
        EdgeMap edgeMap = Maps.createIndexEdgeMap(new int[graph.E()]);
        int n2 = GraphConnectivity.biconnectedComponents(graph, edgeMap, nodeMap3);
        if (n2 < 1) {
            return 0;
        }
        EdgeList[] edgeListArray = GraphConnectivity.toEdgeListArray(graph, edgeMap, n2);
        Arrays.sort(edgeListArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((EdgeList)object).size() - ((EdgeList)object2).size();
            }
        });
        int n3 = 0;
        while (n3 < edgeListArray.length) {
            EdgeList edgeList = edgeListArray[n3];
            if (edgeList.size() > 1) {
                yCursor = edgeList.edges();
                while (yCursor.ok()) {
                    object = yCursor.edge();
                    nodeMap2.set(((Edge)object).source(), edgeList);
                    nodeMap2.set(((Edge)object).target(), edgeList);
                    yCursor.next();
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break;
                }
            } else {
                ++n3;
            }
            if (!bl) continue;
        }
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        int n4 = 0;
        yCursor = graph.nodes();
        while (yCursor.ok()) {
            Integer n5;
            Integer n6;
            object = nodeMap2.get(yCursor.node());
            if (object == null) {
                ++n4;
                n6 = new Integer(n4);
            } else {
                n6 = n5 = (Integer)hashMap.get(object);
            }
            if (n5 == null) {
                n5 = new Integer(n4++);
                hashMap.put(object, n5);
            }
            nodeMap.setInt(yCursor.node(), n5);
            yCursor.next();
            if (!bl) continue;
        }
        return n4;
    }
}

