/*
 * Decompiled with CFR 0.152.
 */
package y.algo;

import java.util.Arrays;
import y.algo.Bfs;
import y.algo.Dfs;
import y.algo.GraphConnectivity;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.WrongGraphStructure;
import y.base.YList;
import y.base.c;
import y.util.Maps;

public class Trees {
    private Trees() {
    }

    public static EdgeList[] getTreeEdges(Graph graph) {
        return Trees.getTreeEdges(graph, Trees.getTreeNodes(graph));
    }

    public static EdgeList[] getTreeEdges(Graph graph, NodeList[] nodeListArray) {
        boolean bl = GraphConnectivity.z;
        EdgeList[] edgeListArray = new EdgeList[nodeListArray.length];
        int[] nArray = new int[graph.nodeCount()];
        int n2 = 1;
        int n3 = 0;
        block0: while (true) {
            int n4 = n3;
            int n5 = nodeListArray.length;
            block1: while (n4 < n5) {
                NodeCursor nodeCursor;
                EdgeList edgeList;
                block7: {
                    NodeList nodeList = nodeListArray[n3];
                    edgeList = new EdgeList();
                    nodeCursor = nodeList.nodes();
                    while (nodeCursor.ok()) {
                        nArray[nodeCursor.node().index()] = n2;
                        nodeCursor.next();
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block7;
                    }
                    nodeCursor = nodeList.nodes();
                }
                while (nodeCursor.ok()) {
                    Node node = nodeCursor.node();
                    if (bl) continue block0;
                    EdgeCursor edgeCursor = node.outEdges();
                    while (edgeCursor.ok()) {
                        Edge edge = edgeCursor.edge();
                        n4 = nArray[edge.opposite(node).index()];
                        n5 = n2;
                        if (bl) continue block1;
                        if (n4 == n5 && !edge.isSelfLoop()) {
                            edgeList.push(edge);
                        }
                        edgeCursor.next();
                        if (!bl) continue;
                    }
                    nodeCursor.next();
                    if (!bl) continue;
                }
                edgeListArray[n3] = edgeList;
                ++n3;
                ++n2;
                if (!bl) continue block0;
            }
            break;
        }
        return edgeListArray;
    }

    /*
     * Unable to fully structure code
     */
    public static NodeList[] getTreeNodes(Graph var0) {
        var11_1 = GraphConnectivity.z;
        var1_2 = new int[var0.nodeCount()];
        var2_3 = new YList();
        var3_4 = new NodeList();
        var5_5 = false;
        var6_6 = var0.nodes();
        while (var6_6.ok()) {
            var4_7 = var6_6.node();
            var1_2[var4_7.index()] = var4_7.outDegree();
            v0 = var4_7.outDegree();
            if (!var11_1) {
                if (v0 == 0 && var4_7.inDegree() == 1) {
                    var3_4.addLast(var4_7);
                }
                var6_6.next();
                if (!var11_1) continue;
            }
            ** GOTO lbl20
        }
        while (true) {
            v0 = var3_4.isEmpty();
lbl20:
            // 2 sources

            if (v0 != 0) break;
            var4_7 = var3_4.popNode();
            if (var4_7.inDegree() <= 0) continue;
            var6_6 = var4_7.firstInEdge().source();
            v1 = var6_6.index();
            var1_2[v1] = var1_2[v1] - 1;
            if (var6_6.inDegree() > 1 || var1_2[var6_6.index()] != 0) continue;
            var3_4.addLast(var6_6);
            if (var11_1) break;
        }
        var6_6 = var0.nodes();
        block2: while (true) {
            v2 = var6_6.ok();
            block3: while (v2 != 0) {
                block14: {
                    block13: {
                        var4_7 = var6_6.node();
                        var8_9 = var1_2[var4_7.index()];
                        if (var8_9 != 0 || var4_7.inDegree() == 1 || var4_7.outDegree() <= 0) break block13;
                        var7_8 = new NodeList();
                        var7_8.addLast(var4_7);
                        Trees.b(var4_7, var7_8);
                        var2_3.addLast(var7_8);
                        if (!var11_1) break block14;
                    }
                    if (var8_9 > 0 && var8_9 < var4_7.outDegree()) {
                        var7_8 = new NodeList();
                        var7_8.addLast(var4_7);
                        var9_10 = var4_7.successors();
                        while (var9_10.ok()) {
                            var10_11 = var9_10.node();
                            v2 = var1_2[var10_11.index()];
                            if (var11_1) continue block3;
                            if (v2 == 0 && var10_11.inDegree() == 1) {
                                var7_8.addLast(var10_11);
                                Trees.b(var10_11, var7_8);
                            }
                            var9_10.next();
                            if (!var11_1) continue;
                        }
                        var2_3.addLast(var7_8);
                    }
                }
                var6_6.next();
                if (!var11_1) continue block2;
            }
            break;
        }
        return (NodeList[])var2_3.toArray(new NodeList[var2_3.size()]);
    }

    /*
     * Unable to fully structure code
     */
    public static NodeList[] getUndirectedTreeNodes(Graph var0) {
        block11: {
            var9_1 = GraphConnectivity.z;
            var1_2 = new NodeList[var0.nodeCount()];
            var2_3 = new EdgeList[var0.nodeCount()];
            var3_4 = new YList();
            var4_5 = new NodeList();
            for (var6_6 = 0; var6_6 < var0.nodeCount(); ++var6_6) {
                var1_2[var6_6] = new NodeList();
                if (!var9_1) continue;
            }
            var6_7 = var0.nodes();
            while (var6_7.ok()) {
                var7_8 = var6_7.node().index();
                var1_2[var7_8] = new NodeList();
                var2_3[var7_8] = new EdgeList();
                v0 = var6_7.node();
                if (!var9_1) {
                    block10: {
                        var8_10 = v0.edges();
                        while (var8_10.ok()) {
                            var2_3[var7_8].add(var8_10.edge());
                            var8_10.next();
                            if (!var9_1) {
                                if (!var9_1) continue;
                            }
                            break block10;
                        }
                        if (var2_3[var7_8].size() == 1) {
                            var4_5.addLast(var6_7.node());
                        }
                        var6_7.next();
                    }
                    if (!var9_1) continue;
                }
                ** GOTO lbl48
            }
            while (!var4_5.isEmpty()) {
                var5_11 = var4_5.popNode();
                if (var2_3[var5_11.index()].size() == 0) continue;
                var6_7 = var2_3[var5_11.index()].edges().edge();
                var7_9 = var6_7.opposite(var5_11);
                var1_2[var7_9.index()].splice(var1_2[var5_11.index()]);
                var1_2[var7_9.index()].addLast(var5_11);
                var2_3[var7_9.index()].remove(var6_7);
                if (var2_3[var7_9.index()].size() != 1) continue;
                var4_5.addLast(var7_9);
                if (!var9_1) continue;
            }
            var6_7 = var0.nodes();
            while (var6_7.ok()) {
                v0 = var6_7.node();
lbl48:
                // 2 sources

                var7_8 = v0.index();
                v1 = var1_2[var7_8];
                if (!var9_1) {
                    if (v1.size() > 0) {
                        var1_2[var7_8].addFirst(var6_7.node());
                        var3_4.add(var1_2[var7_8]);
                    }
                    var6_7.next();
                    if (!var9_1) continue;
                }
                break block11;
            }
            v1 = var3_4;
        }
        return (NodeList[])v1.toArray(new NodeList[var3_4.size()]);
    }

    public static boolean isNaryTree(Graph graph, int n2) {
        boolean bl = GraphConnectivity.z;
        if (Trees.isRootedTree(graph)) {
            int n3;
            block4: {
                NodeCursor nodeCursor = graph.nodes();
                while (nodeCursor.ok()) {
                    n3 = nodeCursor.node().outDegree();
                    if (!bl) {
                        if (n3 > n2) {
                            return false;
                        }
                        nodeCursor.next();
                        if (!bl) continue;
                    }
                    break block4;
                }
                n3 = 1;
            }
            return n3 != 0;
        }
        return false;
    }

    public static boolean isRootedTree(Graph graph) {
        int n2;
        boolean bl;
        block9: {
            boolean bl2 = GraphConnectivity.z;
            if (graph.isEmpty()) {
                return true;
            }
            if (graph.N() != graph.E() + 1) {
                return false;
            }
            bl = false;
            NodeCursor nodeCursor = graph.nodes();
            while (nodeCursor.ok()) {
                block11: {
                    Node node;
                    block10: {
                        node = nodeCursor.node();
                        n2 = node.inDegree();
                        if (bl2) break block9;
                        if (n2 != 0) break block10;
                        if (bl) {
                            return false;
                        }
                        bl = true;
                        if (!bl2) break block11;
                    }
                    if (node.inDegree() != 1) {
                        return false;
                    }
                }
                nodeCursor.next();
                if (!bl2) continue;
            }
            n2 = GraphConnectivity.isConnected(graph);
        }
        if (n2 == 0) {
            return false;
        }
        return bl;
    }

    public static boolean isTree(Graph graph) {
        if (graph.isEmpty()) {
            return true;
        }
        if (graph.N() != graph.E() + 1) {
            return false;
        }
        _b _b2 = new _b();
        try {
            _b2.start(graph);
            return true;
        }
        catch (WrongGraphStructure wrongGraphStructure) {
            return false;
        }
    }

    public static boolean isForest(Graph graph) {
        int n2;
        block6: {
            boolean bl = GraphConnectivity.z;
            if (graph.isEmpty()) {
                return true;
            }
            int n3 = 0;
            NodeCursor nodeCursor = graph.nodes();
            while (nodeCursor.ok()) {
                block8: {
                    Node node;
                    block7: {
                        node = nodeCursor.node();
                        n2 = node.inDegree();
                        if (bl) break block6;
                        if (n2 != 0) break block7;
                        n3 = 1;
                        if (!bl) break block8;
                    }
                    if (node.inDegree() != 1) {
                        return false;
                    }
                }
                nodeCursor.next();
                if (!bl) continue;
            }
            n2 = n3;
        }
        return n2 != 0;
    }

    public static NodeList getLeafNodes(Graph graph, boolean bl) {
        boolean bl2 = GraphConnectivity.z;
        NodeList nodeList = new NodeList();
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            if (bl && node.outDegree() == 0 || !bl && node.degree() == 1) {
                nodeList.add(node);
            }
            nodeCursor.next();
            if (!bl2) continue;
        }
        return nodeList;
    }

    public static Node getCenterRoot(Graph graph) {
        if (graph.N() == 1) {
            return graph.firstNode();
        }
        NodeList[] nodeListArray = Bfs.getLayers(graph, Trees.getLeafNodes(graph, false));
        return nodeListArray[nodeListArray.length - 1].firstNode();
    }

    public static Node getRoot(Graph graph) {
        int n2;
        Node node;
        block9: {
            int n3;
            int n4;
            NodeCursor nodeCursor;
            boolean bl;
            block8: {
                bl = GraphConnectivity.z;
                nodeCursor = graph.nodes();
                node = null;
                n4 = 0;
                nodeCursor.toFirst();
                while (nodeCursor.ok()) {
                    n3 = nodeCursor.node().inDegree();
                    if (!bl) {
                        if (n3 == 0) {
                            node = nodeCursor.node();
                            ++n4;
                        }
                        nodeCursor.next();
                        if (!bl) continue;
                    }
                    break block8;
                }
                n3 = n4;
            }
            if (n3 == 1) {
                return node;
            }
            n4 = 0;
            nodeCursor.toFirst();
            while (nodeCursor.ok()) {
                n2 = nodeCursor.node().outDegree();
                if (!bl) {
                    if (n2 == 0) {
                        node = nodeCursor.node();
                        ++n4;
                    }
                    nodeCursor.next();
                    if (!bl) continue;
                }
                break block9;
            }
            n2 = n4;
        }
        if (n2 == 1) {
            return node;
        }
        return Trees.getWeightedCenterNode(graph);
    }

    public static EdgeList directTree(Graph graph) {
        return Trees.directTree(graph, Trees.getRoot(graph));
    }

    public static Node getWeightedCenterNode(Graph graph) {
        int[] nArray = new int[graph.nodeCount()];
        NodeMap nodeMap = Maps.createIndexNodeMap(nArray);
        return Trees.getWeightedCenterNode(graph, nodeMap);
    }

    public static Node getWeightedCenterNode(Graph graph, NodeMap nodeMap) {
        boolean bl = GraphConnectivity.z;
        Node node = graph.firstNode();
        Node[] nodeArray = new Node[1];
        int[] nArray = new int[graph.nodeCount()];
        Arrays.fill(nArray, -1);
        EdgeList edgeList = Trees.directTree(graph, node);
        Trees.b(node, nodeMap, nodeArray, nArray, -1);
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            graph.reverseEdge(edgeCursor.edge());
            edgeCursor.next();
            if (!bl) continue;
        }
        return nodeArray[0];
    }

    private static int b(Node node, NodeMap nodeMap, Node[] nodeArray, int[] nArray, int n2) {
        int n3;
        block8: {
            int n4;
            int n5;
            c c2;
            int n6;
            boolean bl;
            block7: {
                bl = GraphConnectivity.z;
                n6 = 0;
                for (Edge edge = node.firstOutEdge(); edge != null; edge = edge.nextOutEdge()) {
                    int n7;
                    c2 = edge.target();
                    n5 = n7 = Trees.b((Node)c2, nodeMap, nodeArray, nArray, n2);
                    n4 = n2;
                    if (!bl) {
                        if (n5 > n4) {
                            n2 = n7;
                        }
                        n6 += nArray[((Node)c2).index()];
                        if (!bl) continue;
                    }
                    break block7;
                }
                n5 = n6;
                n4 = node.getGraph().N() - 1 - n6;
            }
            n3 = n5 * n4;
            c2 = node.firstOutEdge();
            while (c2 != null) {
                block9: {
                    Node node2 = ((Edge)c2).target();
                    if (bl) break block8;
                    for (Edge edge = ((Edge)c2).nextOutEdge(); edge != null; edge = edge.nextOutEdge()) {
                        Node node3 = edge.target();
                        n3 += nArray[node2.index()] * nArray[node3.index()];
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block9;
                    }
                    c2 = ((Edge)c2).nextOutEdge();
                }
                if (!bl) continue;
            }
            nodeMap.setInt(node, n3);
            nArray[node.index()] = n6 + 1;
        }
        if (n3 > n2) {
            n2 = n3;
            nodeArray[0] = node;
        }
        return n2;
    }

    public static EdgeList directTree(Graph graph, Node node) {
        boolean bl = GraphConnectivity.z;
        final EdgeList edgeList = new EdgeList();
        Dfs dfs = new Dfs(){

            protected void preTraverse(Edge edge, Node node, boolean bl) {
                if (bl && edge.source() == node) {
                    edgeList.push(edge);
                }
            }
        };
        dfs.setDirectedMode(false);
        dfs.start(graph, node);
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            graph.reverseEdge(edgeCursor.edge());
            edgeCursor.next();
            if (!bl) continue;
        }
        return edgeList;
    }

    private static void b(Node node, NodeList nodeList) {
        boolean bl = GraphConnectivity.z;
        NodeCursor nodeCursor = node.successors();
        while (nodeCursor.ok()) {
            Node node2 = nodeCursor.node();
            nodeList.addLast(node2);
            Trees.b(node2, nodeList);
            nodeCursor.next();
            if (!bl) continue;
        }
    }

    public static Node getNearestCommonAncestor(Graph graph, Node node, boolean bl, NodeList nodeList) {
        Node node2;
        NodeCursor nodeCursor;
        int[] nArray;
        boolean bl2;
        block13: {
            bl2 = GraphConnectivity.z;
            if (nodeList.size() == 0) {
                return null;
            }
            nArray = new int[graph.N()];
            nodeCursor = nodeList.nodes();
            node2 = nodeCursor.node();
            if (node2 == node) {
                return node;
            }
            int n2 = 1;
            while (node2 != node) {
                nArray[node2.index()] = n2++;
                node2 = Trees.b(node2, bl);
                if (!bl2) {
                    if (!bl2) continue;
                }
                break block13;
            }
            nArray[node2.index()] = n2;
        }
        Node node3 = Trees.b(nodeCursor.node(), bl);
        nodeCursor.next();
        while (node3 != node && nodeCursor.ok()) {
            block16: {
                block14: {
                    block15: {
                        node2 = nodeCursor.node();
                        if (node2 == node) {
                            return node;
                        }
                        if (nArray[node2.index()] < nArray[node3.index()]) break block15;
                        node3 = Trees.b(node2, bl);
                        if (!bl2) break block16;
                    }
                    while (nArray[node2.index()] == 0) {
                        nArray[node2.index()] = 1;
                        node2 = Trees.b(node2, bl);
                        if (!bl2) {
                            if (!bl2) continue;
                        }
                        break block14;
                    }
                    if (nArray[node2.index()] == 1) break block16;
                }
                if (nArray[node2.index()] > nArray[node3.index()]) {
                    node3 = node2;
                }
            }
            nodeCursor.next();
            if (!bl2) continue;
        }
        return node3;
    }

    private static Node b(Node node, boolean bl) {
        return bl ? node.firstInEdge().source() : node.firstOutEdge().target();
    }

    public static void getSubTreeDepths(Graph graph, NodeMap nodeMap) {
        Node node = Trees.getRoot(graph);
        Trees.c(node, nodeMap);
    }

    public static void getSubTreeSizes(Graph graph, NodeMap nodeMap) {
        Node node = Trees.getRoot(graph);
        Trees.b(node, nodeMap);
    }

    private static int b(Node node, NodeMap nodeMap) {
        int n2;
        block2: {
            boolean bl = GraphConnectivity.z;
            n2 = 1;
            for (Edge edge = node.firstOutEdge(); edge != null; edge = edge.nextOutEdge()) {
                Node node2 = edge.target();
                n2 += Trees.b(node2, nodeMap);
                if (!bl) {
                    if (!bl) continue;
                }
                break block2;
            }
            nodeMap.setInt(node, n2);
        }
        return n2;
    }

    private static int c(Node node, NodeMap nodeMap) {
        int n2;
        block2: {
            boolean bl = GraphConnectivity.z;
            n2 = 0;
            for (Edge edge = node.firstOutEdge(); edge != null; edge = edge.nextOutEdge()) {
                Node node2 = edge.target();
                n2 = Math.max(n2, Trees.c(node2, nodeMap));
                if (!bl) {
                    if (!bl) continue;
                }
                break block2;
            }
            nodeMap.setInt(node, n2 + 1);
        }
        return n2 + 1;
    }

    static class _b
    extends Dfs {
        _b() {
            this.setDirectedMode(false);
        }

        protected void preTraverse(Edge edge, Node node, boolean bl) {
            if (!bl) {
                throw new WrongGraphStructure(null);
            }
        }

        protected void lookFurther(Node node) {
            throw new WrongGraphStructure(null);
        }
    }
}

