/*
 * Decompiled with CFR 0.152.
 */
package y.geom;

import y.geom.AffineLine;
import y.geom.PlaneObject;
import y.geom.YPoint;
import y.geom.YRectangle;
import y.geom.YVector;

public class LineSegment
implements PlaneObject {
    private YPoint nd;
    private YPoint md;
    private double od;
    private double kd;
    private static double id = 1.0E-8;
    private static final byte gd = 1;
    private static final byte jd = 2;
    private static final byte hd = 4;
    private static final byte ld = 8;

    public LineSegment(YPoint yPoint, YPoint yPoint2) {
        block4: {
            block2: {
                boolean bl;
                block3: {
                    bl = YPoint.z;
                    this.nd = yPoint;
                    this.md = yPoint2;
                    if (yPoint2.x != yPoint.x) break block2;
                    if (!(yPoint.y < yPoint2.y)) break block3;
                    this.od = Double.MAX_VALUE;
                    this.kd = Double.NaN;
                    if (!bl) break block4;
                }
                this.od = -1.7976931348623157E308;
                this.kd = Double.NaN;
                if (!bl) break block4;
            }
            this.od = (yPoint2.y - yPoint.y) / (yPoint2.x - yPoint.x);
            this.kd = yPoint.y - yPoint.x * this.od;
        }
    }

    public boolean isVertical() {
        return Math.abs(this.getFirstEndPoint().x - this.getSecondEndPoint().x) < id;
    }

    public boolean isHorizontal() {
        return Math.abs(this.getFirstEndPoint().y - this.getSecondEndPoint().y) < id;
    }

    public YPoint getFirstEndPoint() {
        return this.nd;
    }

    public YPoint getSecondEndPoint() {
        return this.md;
    }

    public boolean isInYIntervall(double d2) {
        if (this.nd.y < this.md.y) {
            return d2 > this.nd.y + id && d2 < this.md.y - id;
        }
        return d2 > this.md.y + id && d2 < this.nd.y - id;
    }

    public boolean isInXIntervall(double d2) {
        if (this.nd.x < this.md.x) {
            return d2 > this.nd.x + id && d2 < this.md.x - id;
        }
        return d2 > this.md.x + id && d2 < this.nd.x - id;
    }

    public double getXOffset() {
        return this.kd;
    }

    public double getScope() {
        return this.od;
    }

    public double length() {
        return this.toYVector().length();
    }

    public YRectangle getBoundingBox() {
        double d2 = this.nd.x < this.md.x ? this.nd.x : this.md.x;
        double d3 = this.nd.x > this.md.x ? this.nd.x : this.md.x;
        double d4 = this.nd.y < this.md.y ? this.nd.y : this.md.y;
        double d5 = this.nd.y > this.md.y ? this.nd.y : this.md.y;
        return new YRectangle(d2, d4, d3 - d2, d5 - d4);
    }

    public boolean intersects(YRectangle yRectangle) {
        return LineSegment.boxIntersectsSegment(yRectangle, this.nd.x, this.nd.y, this.md.x, this.md.y);
    }

    public boolean contains(YPoint yPoint) {
        YRectangle yRectangle = new YRectangle(yPoint.x - id, yPoint.y - id, 2.0 * id, 2.0 * id);
        return LineSegment.boxIntersectsSegment(yRectangle, this.nd.x, this.nd.y, this.md.x, this.md.y);
    }

    public boolean intersects(YPoint yPoint) {
        YRectangle yRectangle = new YRectangle(yPoint.x - 0.01, yPoint.y - 0.01, 0.02, 0.02);
        return LineSegment.boxIntersectsSegment(yRectangle, this.nd.x, this.nd.y, this.md.x, this.md.y);
    }

    public static final boolean boxIntersectsSegment(YRectangle yRectangle, YPoint yPoint, YPoint yPoint2) {
        return LineSegment.boxIntersectsSegment(yRectangle, yPoint.x, yPoint.y, yPoint2.x, yPoint2.y);
    }

    public static final boolean boxIntersectsSegment(YRectangle yRectangle, double d2, double d3, double d4, double d5) {
        int n2;
        block9: {
            double d6;
            double d7;
            double d8;
            boolean bl = YPoint.z;
            double d9 = yRectangle.getX();
            byte by = LineSegment.b(d9, d8 = yRectangle.getY(), d7 = d9 + yRectangle.getWidth(), d6 = d8 + yRectangle.getHeight(), d2, d3);
            if (by == 0) {
                return true;
            }
            byte by2 = LineSegment.b(d9, d8, d7, d6, d4, d5);
            if (by2 == 0) {
                return true;
            }
            while (by != 0) {
                block11: {
                    double d10;
                    block10: {
                        n2 = by & by2;
                        if (bl) break block9;
                        if (n2 != 0) {
                            return false;
                        }
                        if ((by & 3) == 0) break block10;
                        d10 = d9;
                        if ((by & 2) != 0) {
                            d10 = d7;
                        }
                        d3 += (d10 - d2) * (d5 - d3) / (d4 - d2);
                        d2 = d10;
                        if (!bl) break block11;
                    }
                    d10 = d8;
                    if ((by & 8) != 0) {
                        d10 = d6;
                    }
                    d2 += (d10 - d3) * (d4 - d2) / (d5 - d3);
                    d3 = d10;
                }
                by = LineSegment.b(d9, d8, d7, d6, d2, d3);
                if (!bl) continue;
            }
            n2 = 1;
        }
        return n2 != 0;
    }

    private static byte b(double d2, double d3, double d4, double d5, double d6, double d7) {
        byte by;
        block11: {
            block10: {
                boolean bl;
                block9: {
                    block8: {
                        bl = YPoint.z;
                        by = 0;
                        if (!(d6 < d2)) break block8;
                        by = 1;
                        if (!bl) break block9;
                    }
                    if (d6 > d4) {
                        by = 2;
                    }
                }
                if (!(d7 < d3)) break block10;
                by = (byte)(by | 4);
                if (!bl) break block11;
            }
            if (d7 > d5) {
                by = (byte)(by | 8);
            }
        }
        return by;
    }

    public static YPoint getIntersection(LineSegment lineSegment, LineSegment lineSegment2) {
        double d2;
        if (lineSegment2.isVertical()) {
            LineSegment lineSegment3 = lineSegment;
            lineSegment = lineSegment2;
            lineSegment2 = lineSegment3;
        }
        if (lineSegment.isVertical()) {
            if (!lineSegment2.isInXIntervall(lineSegment.getFirstEndPoint().x)) {
                return null;
            }
            double d3 = lineSegment2.getScope();
            if (Double.isInfinite(d3) || Double.isNaN(d3)) {
                return null;
            }
            double d4 = lineSegment2.getXOffset();
            if (Double.isInfinite(d4) || Double.isNaN(d4)) {
                return null;
            }
            double d5 = lineSegment2.getXOffset() + lineSegment2.getScope() * lineSegment.getFirstEndPoint().x;
            if (!lineSegment.isInYIntervall(d5)) {
                return null;
            }
            return new YPoint(lineSegment.getFirstEndPoint().x, d5);
        }
        double d6 = lineSegment.getScope();
        if (d6 == (d2 = lineSegment2.getScope())) {
            return null;
        }
        double d7 = (lineSegment2.getXOffset() - lineSegment.getXOffset()) / (d6 - d2);
        if (lineSegment.isInXIntervall(d7) && lineSegment2.isInXIntervall(d7)) {
            return new YPoint(d7, d7 * d6 + lineSegment.getXOffset());
        }
        return null;
    }

    public YVector toYVector() {
        return new YVector(this.md, this.nd);
    }

    public AffineLine toAffineLine() {
        return new AffineLine(this.md, this.nd);
    }

    public double getDeltaX() {
        return this.md.x - this.nd.x;
    }

    public double getDeltaY() {
        return this.md.y - this.nd.y;
    }

    public String toString() {
        return "SP: " + this.nd.toString() + " TP: " + this.md.toString();
    }
}

