/*
 * Decompiled with CFR 0.152.
 */
package y.geom;

import y.base.Graph;
import y.geom.LineSegment;
import y.geom.PlaneObject;
import y.geom.YDimension;
import y.geom.YInsets;
import y.geom.YPoint;
import y.geom.YRectangle;
import y.geom.YVector;

public class OrientedRectangle
implements PlaneObject {
    private double be;
    private double ae;
    private double yd;
    private double he;
    private double fe;
    private double ee;
    private static final byte zd = 1;
    private static final byte de = 2;
    private static final byte ce = 4;
    private static final byte ge = 8;

    public OrientedRectangle(YRectangle yRectangle) {
        this(yRectangle.x, yRectangle.y + yRectangle.height, yRectangle.width, yRectangle.height);
    }

    public OrientedRectangle(OrientedRectangle orientedRectangle) {
        this(orientedRectangle.getAnchorX(), orientedRectangle.getAnchorY(), orientedRectangle.getWidth(), orientedRectangle.getHeight());
        this.fe = orientedRectangle.getUpX();
        this.ee = orientedRectangle.getUpY();
    }

    public OrientedRectangle(YPoint yPoint, YDimension yDimension) {
        this(yPoint.x, yPoint.y, yDimension.width, yDimension.height);
    }

    public OrientedRectangle(YPoint yPoint, YDimension yDimension, YVector yVector) {
        this(yPoint.x, yPoint.y, yDimension.width, yDimension.height, yVector.getX(), yVector.getY());
    }

    public OrientedRectangle(double d2, double d3, double d4, double d5) {
        this.be = d2;
        this.ae = d3;
        this.yd = d4;
        this.he = d5;
        this.fe = 0.0;
        this.ee = -1.0;
    }

    public OrientedRectangle(double d2, double d3, double d4, double d5, double d6, double d7) {
        this(d2, d3, d4, d5);
        this.d(d6, d7);
    }

    public boolean isEmpty() {
        return this.yd < 0.0 || this.he < 0.0;
    }

    public YPoint getAnchor() {
        return new YPoint(this.be, this.ae);
    }

    public void setAnchor(YPoint yPoint) {
        this.setAnchor(yPoint.getX(), yPoint.getY());
    }

    public void setAnchor(double d2, double d3) {
        this.be = d2;
        this.ae = d3;
    }

    public double getAnchorX() {
        return this.be;
    }

    public double getAnchorY() {
        return this.ae;
    }

    public YDimension getSize() {
        return new YDimension(this.yd, this.he);
    }

    public void setSize(YDimension yDimension) {
        this.setSize(yDimension.width, yDimension.height);
    }

    public void setSize(double d2, double d3) {
        this.yd = d2;
        this.he = d3;
    }

    public double getWidth() {
        return this.yd;
    }

    public double getHeight() {
        return this.he;
    }

    public void setUpVector(double d2, double d3) {
        this.d(d2, d3);
    }

    private void d(double d2, double d3) {
        if (d2 == 0.0) {
            if (d3 == 0.0) {
                throw new IllegalArgumentException("Invalid up vector: (0,0).");
            }
            this.fe = 0.0;
            this.ee = d3 > 0.0 ? 1.0 : -1.0;
        } else if (d3 == 0.0) {
            this.fe = d2 > 0.0 ? 1.0 : -1.0;
            this.ee = 0.0;
        } else {
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            this.fe = d2 / d4;
            this.ee = d3 / d4;
        }
    }

    public double getUpX() {
        return this.fe;
    }

    public double getUpY() {
        return this.ee;
    }

    public double getAngle() {
        return Math.atan2(-this.fe, -this.ee);
    }

    public void setAngle(double d2) {
        this.fe = -Math.sin(d2);
        this.ee = -Math.cos(d2);
    }

    public void moveBy(double d2, double d3) {
        this.be += d2;
        this.ae += d3;
    }

    public YPoint getCenter() {
        double d2 = this.he * 0.5;
        double d3 = this.yd * 0.5;
        double d4 = this.be + this.fe * d2 - this.ee * d3;
        double d5 = this.ae + this.ee * d2 + this.fe * d3;
        return new YPoint(d4, d5);
    }

    public void setCenter(YPoint yPoint) {
        this.setCenter(yPoint.getX(), yPoint.getY());
    }

    public void setCenter(double d2, double d3) {
        double d4 = this.he * 0.5;
        double d5 = this.yd * 0.5;
        this.be = d2 - this.fe * d4 + this.ee * d5;
        this.ae = d3 - this.ee * d4 - this.fe * d5;
    }

    public YRectangle getBoundingBox() {
        YPoint[] yPointArray = OrientedRectangle.calcPoints(this);
        double d2 = Math.min(Math.min(yPointArray[0].x, yPointArray[1].x), Math.min(yPointArray[2].x, yPointArray[3].x));
        double d3 = Math.max(Math.max(yPointArray[0].x, yPointArray[1].x), Math.max(yPointArray[2].x, yPointArray[3].x));
        double d4 = Math.min(Math.min(yPointArray[0].y, yPointArray[1].y), Math.min(yPointArray[2].y, yPointArray[3].y));
        double d5 = Math.max(Math.max(yPointArray[0].y, yPointArray[1].y), Math.max(yPointArray[2].y, yPointArray[3].y));
        return new YRectangle(d2, d4, d3 - d2, d5 - d4);
    }

    public boolean contains(double d2, double d3) {
        return this.contains(d2, d3, false);
    }

    public boolean contains(double d2, double d3, boolean bl) {
        return OrientedRectangle.b(this, d2, d3, 0.0, bl);
    }

    public static YPoint[] calcPoints(OrientedRectangle orientedRectangle) {
        double d2 = orientedRectangle.yd;
        double d3 = orientedRectangle.he;
        double d4 = orientedRectangle.be;
        double d5 = orientedRectangle.ae;
        double d6 = orientedRectangle.fe;
        double d7 = orientedRectangle.ee;
        double d8 = d4 + d6 * d3;
        double d9 = d5 + d7 * d3;
        double d10 = d4 + d6 * d3 - d7 * d2;
        double d11 = d5 + d7 * d3 + d6 * d2;
        double d12 = d4 - d7 * d2;
        double d13 = d5 + d6 * d2;
        return new YPoint[]{new YPoint(d4, d5), new YPoint(d8, d9), new YPoint(d10, d11), new YPoint(d12, d13)};
    }

    private static YRectangle b(YRectangle yRectangle, double d2) {
        return new YRectangle(yRectangle.x - d2, yRectangle.y - d2, yRectangle.width + 2.0 * d2, yRectangle.height + 2.0 * d2);
    }

    private static boolean b(YRectangle yRectangle, double d2, double d3, double d4) {
        YRectangle yRectangle2 = yRectangle;
        if (d4 > 0.0) {
            yRectangle2 = OrientedRectangle.b(yRectangle, d4);
        }
        return yRectangle2.contains(d2, d3);
    }

    private static boolean b(double d2, double d3, double d4, double d5, YRectangle yRectangle, double d6) {
        YRectangle yRectangle2 = yRectangle;
        if (d6 > 0.0) {
            yRectangle2 = OrientedRectangle.b(yRectangle, d6);
        }
        LineSegment lineSegment = new LineSegment(new YPoint(d2, d3), new YPoint(d4, d5));
        return lineSegment.intersects(yRectangle2);
    }

    public static boolean intersects(OrientedRectangle orientedRectangle, YRectangle yRectangle, double d2) {
        if (yRectangle.width < 0.0 || yRectangle.height < 0.0) {
            return false;
        }
        double d3 = orientedRectangle.be;
        double d4 = orientedRectangle.ae;
        double d5 = orientedRectangle.yd;
        double d6 = orientedRectangle.he;
        if (d5 < 0.0 || d6 < 0.0) {
            return false;
        }
        if (OrientedRectangle.b(yRectangle, d3, d4, d2)) {
            return true;
        }
        if (orientedRectangle.rb()) {
            YRectangle yRectangle2 = new YRectangle(d3 - d2, d4 - d6 - d2, d5 + 2.0 * d2, d6 + 2.0 * d2);
            return YRectangle.intersects(yRectangle, yRectangle2);
        }
        YPoint[] yPointArray = OrientedRectangle.calcPoints(orientedRectangle);
        if (OrientedRectangle.b(yPointArray[0].x, yPointArray[0].y, yPointArray[1].x, yPointArray[1].y, yRectangle, d2)) {
            return true;
        }
        if (OrientedRectangle.b(yPointArray[1].x, yPointArray[1].y, yPointArray[2].x, yPointArray[2].y, yRectangle, d2)) {
            return true;
        }
        if (OrientedRectangle.b(yPointArray[2].x, yPointArray[2].y, yPointArray[3].x, yPointArray[3].y, yRectangle, d2)) {
            return true;
        }
        return OrientedRectangle.b(yPointArray[3].x, yPointArray[3].y, yPointArray[0].x, yPointArray[0].y, yRectangle, d2);
    }

    private boolean rb() {
        return this.fe == 0.0 && this.ee == -1.0;
    }

    public static boolean contains(OrientedRectangle orientedRectangle, YPoint yPoint, double d2) {
        return OrientedRectangle.contains(orientedRectangle, yPoint.x, yPoint.y, d2);
    }

    public static boolean contains(OrientedRectangle orientedRectangle, double d2, double d3, double d4) {
        return OrientedRectangle.b(orientedRectangle, d2, d3, d4, false);
    }

    private static boolean b(OrientedRectangle orientedRectangle, double d2, double d3, double d4, boolean bl) {
        double d5 = orientedRectangle.fe;
        double d6 = orientedRectangle.ee;
        if (orientedRectangle.rb()) {
            return YRectangle.contains(orientedRectangle.be - d4, orientedRectangle.ae - orientedRectangle.he - d4, orientedRectangle.yd + 2.0 * d4, orientedRectangle.he + 2.0 * d4, d2, d3, bl);
        }
        double d7 = orientedRectangle.be;
        double d8 = orientedRectangle.ae;
        double d9 = orientedRectangle.yd;
        double d10 = orientedRectangle.he;
        if (d9 < 0.0 || d10 < 0.0) {
            return false;
        }
        double d11 = d2 - d7;
        double d12 = d3 - d8;
        double d13 = d9 + d10 + d4;
        if (d11 < -d13 || d11 > d13 || d12 < -d13 || d12 > d13) {
            return false;
        }
        double d14 = d11 * -d6 + d12 * d5;
        double d15 = d11 * d5 + d12 * d6;
        return YRectangle.contains(0.0 - d4, 0.0 - d4, d9 + 2.0 * d4, d10 + 2.0 * d4, d14, d15, bl);
    }

    public static boolean contains(OrientedRectangle orientedRectangle, OrientedRectangle orientedRectangle2, double d2) {
        YPoint[] yPointArray = OrientedRectangle.calcPoints(orientedRectangle2);
        return OrientedRectangle.contains(orientedRectangle, yPointArray[0], d2) && OrientedRectangle.contains(orientedRectangle, yPointArray[1], d2) && OrientedRectangle.contains(orientedRectangle, yPointArray[2], d2) && OrientedRectangle.contains(orientedRectangle, yPointArray[3], d2);
    }

    public static boolean intersects(OrientedRectangle orientedRectangle, LineSegment lineSegment, double d2) {
        double d3 = orientedRectangle.fe;
        double d4 = orientedRectangle.ee;
        if (orientedRectangle.rb()) {
            YRectangle yRectangle = new YRectangle(orientedRectangle.be - d2, orientedRectangle.ae - orientedRectangle.he - d2, orientedRectangle.yd + 2.0 * d2, orientedRectangle.he + 2.0 * d2);
            return lineSegment.intersects(yRectangle);
        }
        double d5 = orientedRectangle.be;
        double d6 = orientedRectangle.ae;
        double d7 = orientedRectangle.yd;
        double d8 = orientedRectangle.he;
        if (d7 < 0.0 || d8 < 0.0) {
            return false;
        }
        double d9 = lineSegment.getFirstEndPoint().x;
        double d10 = lineSegment.getFirstEndPoint().y;
        double d11 = lineSegment.getSecondEndPoint().x;
        double d12 = lineSegment.getSecondEndPoint().y;
        double d13 = (d9 -= d5) * -d4 + (d10 -= d6) * d3;
        double d14 = d9 * d3 + d10 * d4;
        double d15 = (d11 -= d5) * -d4 + (d12 -= d6) * d3;
        double d16 = d11 * d3 + d12 * d4;
        YRectangle yRectangle = new YRectangle(0.0 - d2, 0.0 - d2, d7 + 2.0 * d2, d8 + 2.0 * d2);
        LineSegment lineSegment2 = new LineSegment(new YPoint(d13, d14), new YPoint(d15, d16));
        return lineSegment2.intersects(yRectangle);
    }

    public static YPoint intersectionPoint(OrientedRectangle orientedRectangle, LineSegment lineSegment, double d2) {
        double d3;
        double d4;
        YPoint yPoint;
        double d5 = orientedRectangle.fe;
        double d6 = orientedRectangle.ee;
        double d7 = lineSegment.getFirstEndPoint().x;
        double d8 = lineSegment.getFirstEndPoint().y;
        double d9 = lineSegment.getSecondEndPoint().x;
        double d10 = lineSegment.getSecondEndPoint().y;
        if (orientedRectangle.rb()) {
            YRectangle yRectangle = new YRectangle(orientedRectangle.be - d2, orientedRectangle.ae - orientedRectangle.he - d2, orientedRectangle.yd + 2.0 * d2, orientedRectangle.he + 2.0 * d2);
            return OrientedRectangle.b(yRectangle, d7, d8, d9, d10);
        }
        double d11 = orientedRectangle.be;
        double d12 = orientedRectangle.ae;
        double d13 = orientedRectangle.yd;
        double d14 = orientedRectangle.he;
        if (d13 < 0.0 || d14 < 0.0) {
            return null;
        }
        YRectangle yRectangle = new YRectangle(0.0 - d2, 0.0 - d2, d13 + 2.0 * d2, d14 + 2.0 * d2);
        double d15 = (d7 -= d11) * -d6 + (d8 -= d12) * d5;
        double d16 = (d9 -= d11) * -d6 + (d10 -= d12) * d5;
        if ((yPoint = OrientedRectangle.b(yRectangle, d15, d4 = d7 * d5 + d8 * d6, d16, d3 = d9 * d5 + d10 * d6)) != null) {
            double d17 = d11 + yPoint.x * -d6 + yPoint.y * d5;
            double d18 = d12 + yPoint.x * d5 + yPoint.y * d6;
            return new YPoint(d17, d18);
        }
        return null;
    }

    private static boolean c(int n2, int n3) {
        return (n2 & n3) != 0;
    }

    private static boolean b(int n2, int n3) {
        return (n2 | n3) == 0;
    }

    private static boolean d(int n2, int n3) {
        return OrientedRectangle.c(n2, n3) || OrientedRectangle.b(n2, n3);
    }

    private static final YPoint b(YRectangle yRectangle, double d2, double d3, double d4, double d5) {
        int n2;
        boolean bl;
        boolean bl2;
        byte by;
        byte by2;
        block11: {
            boolean bl3 = YPoint.z;
            double d6 = yRectangle.getX();
            double d7 = yRectangle.getY();
            double d8 = d6 + yRectangle.getWidth();
            double d9 = d7 + yRectangle.getHeight();
            by2 = OrientedRectangle.c(d6, d7, d8, d9, d2, d3);
            by = OrientedRectangle.c(d6, d7, d8, d9, d4, d5);
            bl2 = false;
            bl = false;
            int n3 = 10;
            while (!OrientedRectangle.d(by2, by)) {
                block16: {
                    double d10;
                    block15: {
                        block12: {
                            block14: {
                                block13: {
                                    n2 = n3--;
                                    if (bl3) break block11;
                                    if (n2 <= 0) break;
                                    if (by2 == 0) break block12;
                                    if ((by2 & 3) == 0) break block13;
                                    d10 = (by2 & 2) != 0 ? d8 : d6;
                                    d3 += (d10 - d2) * (d5 - d3) / (d4 - d2);
                                    d2 = d10;
                                    if (!bl3) break block14;
                                }
                                d10 = (by2 & 8) != 0 ? d9 : d7;
                                d2 += (d10 - d3) * (d4 - d2) / (d5 - d3);
                                d3 = d10;
                            }
                            bl2 = true;
                            by2 = OrientedRectangle.c(d6, d7, d8, d9, d2, d3);
                            if (!bl3) continue;
                        }
                        if ((by & 3) == 0) break block15;
                        d10 = (by & 2) != 0 ? d8 : d6;
                        d5 += (d10 - d4) * (d5 - d3) / (d4 - d2);
                        d4 = d10;
                        if (!bl3) break block16;
                    }
                    d10 = (by & 8) != 0 ? d9 : d7;
                    d4 += (d10 - d5) * (d4 - d2) / (d5 - d3);
                    d5 = d10;
                }
                bl = true;
                by = OrientedRectangle.c(d6, d7, d8, d9, d4, d5);
                if (!bl3) continue;
            }
            n2 = n3;
        }
        if (n2 == 0) {
            return null;
        }
        if (OrientedRectangle.c(by2, by)) {
            return null;
        }
        if (!bl2 && !bl) {
            return null;
        }
        if (bl2) {
            return new YPoint(d2, d3);
        }
        return new YPoint(d4, d5);
    }

    private static byte c(double d2, double d3, double d4, double d5, double d6, double d7) {
        byte by;
        block11: {
            block10: {
                boolean bl;
                block9: {
                    block8: {
                        bl = YPoint.z;
                        by = 0;
                        if (!(d6 < d2)) break block8;
                        by = 1;
                        if (!bl) break block9;
                    }
                    if (d6 > d4) {
                        by = 2;
                    }
                }
                if (!(d7 < d3)) break block10;
                by = (byte)(by | 4);
                if (!bl) break block11;
            }
            if (d7 > d5) {
                by = (byte)(by | 8);
            }
        }
        return by;
    }

    public String toString() {
        return this.getClass().getName() + "[anchorX=" + this.be + ";anchorY=" + this.ae + ";width=" + this.yd + ";height=" + this.he + ";upX=" + this.fe + ";upY=" + this.ee + "]";
    }

    private static int c(double d2, double d3) {
        return YInsets.b(d2, d3);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OrientedRectangle orientedRectangle = (OrientedRectangle)object;
        if (OrientedRectangle.c(orientedRectangle.be, this.be) != 0) {
            return false;
        }
        if (OrientedRectangle.c(orientedRectangle.ae, this.ae) != 0) {
            return false;
        }
        if (OrientedRectangle.c(orientedRectangle.he, this.he) != 0) {
            return false;
        }
        if (OrientedRectangle.c(orientedRectangle.yd, this.yd) != 0) {
            return false;
        }
        if (OrientedRectangle.c(orientedRectangle.fe, this.fe) != 0) {
            return false;
        }
        return OrientedRectangle.c(orientedRectangle.ee, this.ee) == 0;
    }

    public int hashCode() {
        boolean bl = YPoint.z;
        int n2 = super.hashCode();
        long l2 = this.be != 0.0 ? Double.doubleToLongBits(this.be) : 0L;
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = this.ae != 0.0 ? Double.doubleToLongBits(this.ae) : 0L;
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = this.fe != 0.0 ? Double.doubleToLongBits(this.fe) : 0L;
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = this.ee != 0.0 ? Double.doubleToLongBits(this.ee) : 0L;
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = this.yd != 0.0 ? Double.doubleToLongBits(this.yd) : 0L;
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = this.he != 0.0 ? Double.doubleToLongBits(this.he) : 0L;
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        if (Graph.z) {
            YPoint.z = !bl;
        }
        return n2;
    }

    public OrientedRectangle getMovedInstance(double d2, double d3) {
        return new OrientedRectangle(this.be + d2, this.ae + d3, this.yd, this.he, this.fe, this.ee);
    }

    public OrientedRectangle getResizedInstance(double d2, double d3) {
        return new OrientedRectangle(this.be, this.ae, d2, d3, this.fe, this.ee);
    }
}

