/*
 * Decompiled with CFR 0.152.
 */
package y.geom;

import java.util.ArrayList;
import y.base.Graph;
import y.geom.AffineLine;
import y.geom.Angle;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YVector;

public class YCircle
implements Comparable {
    public final YPoint center;
    public final double radius;

    public YCircle(double d2) {
        this.center = YPoint.ORIGIN;
        this.radius = d2;
    }

    public YCircle(YPoint yPoint, YPoint yPoint2, double d2) {
        YVector yVector = new YVector(yPoint2, yPoint);
        yVector.scale(0.5);
        YPoint yPoint3 = YVector.add(yPoint, yVector);
        YVector yVector2 = YVector.orthoNormal(yVector);
        double d3 = yVector.length();
        double d4 = Math.sqrt(d2 * d2 - d3 * d3);
        yVector2.scale(d4);
        this.center = YVector.add(yPoint3, yVector2);
        this.radius = d2;
    }

    public YCircle(YPoint yPoint, YPoint yPoint2, YPoint yPoint3) {
        boolean bl = YPoint.z;
        double d2 = yPoint.getX();
        double d3 = yPoint.getY();
        double d4 = yPoint2.getX();
        double d5 = yPoint2.getY();
        double d6 = yPoint3.getX();
        double d7 = yPoint3.getY();
        double d8 = (d2 * d2 + d3 * d3) * (d5 - d7) + (d4 * d4 + d5 * d5) * (d7 - d3) + (d6 * d6 + d7 * d7) * (d3 - d5);
        double d9 = -(d2 * d2 + d3 * d3) * (d4 - d6) - (d4 * d4 + d5 * d5) * (d6 - d2) - (d6 * d6 + d7 * d7) * (d2 - d4);
        double d10 = 2.0 * ((d4 - d2) * (d7 - d3) - (d6 - d2) * (d5 - d3));
        if (d10 == 0.0) {
            throw new IllegalArgumentException("Points are collinear");
        }
        this.center = new YPoint(d8 / d10, d9 / d10);
        this.radius = YPoint.distance(this.center, yPoint);
        if (bl) {
            Graph.z = !Graph.z;
        }
    }

    public YCircle(YPoint yPoint, double d2) {
        this.center = yPoint;
        this.radius = d2;
    }

    public YPoint getCenter() {
        return this.center;
    }

    public final double getRadius() {
        return this.radius;
    }

    public YPoint[] getXCut(double d2) {
        YPoint[] yPointArray;
        block5: {
            double d3;
            double d4;
            block4: {
                double d5;
                d4 = -2.0 * this.center.getX();
                d3 = d4 * d4 / 4.0 - (d5 = this.center.getX() * this.center.getX() + d2 * d2 - 2.0 * this.center.getY() * d2 + this.center.getY() * this.center.getY() - this.radius * this.radius);
                if (d3 < 0.0) {
                    return null;
                }
                if (d3 != 0.0) break block4;
                yPointArray = new YPoint[]{new YPoint(-d4 / 2.0, d2)};
                if (!YPoint.z) break block5;
            }
            yPointArray = new YPoint[2];
            d3 = Math.sqrt(d3);
            yPointArray[0] = new YPoint(-d4 / 2.0 - d3, d2);
            yPointArray[1] = new YPoint(-d4 / 2.0 + d3, d2);
        }
        return yPointArray;
    }

    public YPoint[] getYCut(double d2) {
        YPoint[] yPointArray;
        block5: {
            double d3;
            double d4;
            block4: {
                double d5;
                d4 = -2.0 * this.center.getY();
                d3 = d4 * d4 / 4.0 - (d5 = this.center.getY() * this.center.getY() + d2 * d2 - 2.0 * this.center.getX() * d2 + this.center.getX() * this.center.getX() - this.radius * this.radius);
                if (d3 < 0.0) {
                    return null;
                }
                if (d3 != 0.0) break block4;
                yPointArray = new YPoint[]{new YPoint(d2, -d4 / 2.0)};
                if (!YPoint.z) break block5;
            }
            yPointArray = new YPoint[2];
            d3 = Math.sqrt(d3);
            yPointArray[0] = new YPoint(d2, -d4 / 2.0 - d3);
            yPointArray[1] = new YPoint(d2, -d4 / 2.0 + d3);
        }
        return yPointArray;
    }

    public YPoint[] getCut(AffineLine affineLine) {
        YPoint[] yPointArray;
        block12: {
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            block11: {
                double d9;
                double d10;
                boolean bl;
                block8: {
                    YPoint[] yPointArray2;
                    block10: {
                        double d11;
                        double d12;
                        double d13;
                        double d14;
                        block9: {
                            bl = YPoint.z;
                            d8 = affineLine.getA();
                            d7 = affineLine.getB();
                            d6 = affineLine.getC();
                            d10 = this.center.getX();
                            d9 = this.center.getY();
                            if (affineLine.getA() != 0.0) break block8;
                            d14 = -d6 / d7;
                            d13 = -2.0 * d10;
                            double d15 = (d6 / d7 + d9) * (d6 / d7 + d9) - this.radius * this.radius + d10 * d10;
                            d12 = d13 * d13 / 4.0 - d15;
                            if (d12 < 0.0) {
                                return null;
                            }
                            if (d12 != 0.0) break block9;
                            yPointArray2 = new YPoint[1];
                            d11 = -d13 / 2.0;
                            yPointArray2[0] = new YPoint(d11, d14);
                            if (!bl) break block10;
                        }
                        yPointArray2 = new YPoint[2];
                        d12 = Math.sqrt(d12);
                        d11 = -d13 / 2.0 - d12;
                        yPointArray2[0] = new YPoint(d11, d14);
                        d11 = -d13 / 2.0 + d12;
                        yPointArray2[1] = new YPoint(d11, d14);
                    }
                    return yPointArray2;
                }
                d5 = ((2.0 * d7 * d6 + 2.0 * d7 * d8 * d10) / (d8 * d8) - 2.0 * d9) / (1.0 + d7 * d7 / (d8 * d8));
                double d16 = (d6 * d6 / (d8 * d8) + 2.0 * d6 * d10 / d8 + d10 * d10 + d9 * d9 - this.radius * this.radius) / (1.0 + d7 * d7 / (d8 * d8));
                d4 = d5 * d5 / 4.0 - d16;
                if (d4 < 0.0) {
                    return null;
                }
                if (d4 != 0.0) break block11;
                yPointArray = new YPoint[1];
                d3 = -d5 / 2.0;
                d2 = (-d7 * d3 - d6) / d8;
                yPointArray[0] = new YPoint(d2, d3);
                if (!bl) break block12;
            }
            yPointArray = new YPoint[2];
            d4 = Math.sqrt(d4);
            d3 = -d5 / 2.0 - d4;
            d2 = (-d7 * d3 - d6) / d8;
            yPointArray[0] = new YPoint(d2, d3);
            d3 = -d5 / 2.0 + d4;
            d2 = (-d7 * d3 - d6) / d8;
            yPointArray[1] = new YPoint(d2, d3);
        }
        return yPointArray;
    }

    public YPoint[] getRectCut(YPoint yPoint, YDimension yDimension) {
        YPoint[] yPointArray;
        block19: {
            YPoint[] yPointArray2;
            block22: {
                ArrayList<Object> arrayList;
                boolean bl;
                block20: {
                    YPoint yPoint2;
                    Object object;
                    block21: {
                        int n2;
                        Object object2;
                        block18: {
                            Object object3;
                            YPoint[] yPointArray3;
                            YPoint[] yPointArray4;
                            ArrayList<YPoint> arrayList2;
                            YPoint[] yPointArray5;
                            bl = YPoint.z;
                            yPointArray2 = null;
                            arrayList = new ArrayList<Object>(2);
                            ArrayList<YPoint> arrayList3 = new ArrayList<YPoint>(4);
                            YPoint[] yPointArray6 = this.getXCut(yPoint.getY());
                            if (yPointArray6 != null) {
                                for (int i2 = 0; i2 < yPointArray6.length; ++i2) {
                                    arrayList3.add(yPointArray6[i2]);
                                    if (!bl) continue;
                                }
                            }
                            if ((yPointArray5 = this.getXCut(yPoint.getY() + yDimension.getHeight())) != null) {
                                for (int i3 = 0; i3 < yPointArray5.length; ++i3) {
                                    arrayList2 = arrayList3;
                                    if (!bl) {
                                        arrayList2.add(yPointArray5[i3]);
                                        if (!bl) continue;
                                    }
                                    break;
                                }
                            } else {
                                arrayList2 = arrayList3;
                            }
                            object2 = arrayList2.iterator();
                            while (object2.hasNext()) {
                                yPointArray4 = (YPoint[])object2.next();
                                if (!(yPointArray4.getX() >= yPoint.getX()) || !(yPointArray4.getX() <= yPoint.getX() + yDimension.getWidth())) continue;
                                arrayList.add(yPointArray4);
                                if (!bl) continue;
                            }
                            object2 = new ArrayList(4);
                            yPointArray4 = this.getYCut(yPoint.getX());
                            if (yPointArray4 != null) {
                                for (int i4 = 0; i4 < yPointArray4.length; ++i4) {
                                    ((ArrayList)object2).add(yPointArray4[i4]);
                                    if (!bl) continue;
                                }
                            }
                            if ((yPointArray3 = this.getYCut(yPoint.getX() + yDimension.getWidth())) != null) {
                                for (int i5 = 0; i5 < yPointArray3.length; ++i5) {
                                    object3 = object2;
                                    if (!bl) {
                                        ((ArrayList)object3).add(yPointArray3[i5]);
                                        if (!bl) continue;
                                    }
                                    break;
                                }
                            } else {
                                object3 = object2;
                            }
                            object = ((ArrayList)object3).iterator();
                            while (object.hasNext()) {
                                yPoint2 = (YPoint)object.next();
                                if (!(yPoint2.getY() >= yPoint.getY())) continue;
                                double d2 = yPoint2.getY() - (yPoint.getY() + yDimension.getHeight());
                                n2 = d2 == 0.0 ? 0 : (d2 < 0.0 ? -1 : 1);
                                if (!bl) {
                                    if (n2 > 0) continue;
                                    arrayList.add(yPoint2);
                                    if (!bl) continue;
                                }
                                break block18;
                            }
                            n2 = arrayList.size();
                        }
                        if (n2 == 0) {
                            return null;
                        }
                        yPointArray2 = new YPoint[((ArrayList)object2).size()];
                        if (arrayList.size() != 2) break block20;
                        object = (YPoint)((ArrayList)object2).get(0);
                        yPoint2 = (YPoint)((ArrayList)object2).get(1);
                        YVector yVector = new YVector(1.0, 0.0);
                        YVector yVector2 = new YVector(yPoint.getX() + yDimension.getWidth() / 2.0, yPoint.getY() + yDimension.getHeight() / 2.0);
                        YVector yVector3 = new YVector(((YPoint)object).getX(), ((YPoint)object).getY());
                        YVector yVector4 = new YVector(yPoint2.getX(), yPoint2.getY());
                        double d3 = YVector.angle(yVector, yVector2);
                        double d4 = YVector.angle(yVector, yVector3);
                        double d5 = YVector.angle(yVector, yVector4);
                        if (!(Angle.addAngle(d4, -d3) < Angle.addAngle(d5, -d3))) break block21;
                        yPointArray2[0] = object;
                        yPointArray2[1] = yPoint2;
                        if (!bl) break block22;
                    }
                    yPointArray2[0] = yPoint2;
                    yPointArray2[1] = object;
                    break block22;
                }
                for (int i6 = 0; i6 < arrayList.size(); ++i6) {
                    yPointArray = yPointArray2;
                    if (!bl) {
                        yPointArray[i6] = (YPoint)arrayList.get(i6);
                        if (!bl) continue;
                    }
                    break block19;
                }
            }
            yPointArray = yPointArray2;
        }
        return yPointArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof YCircle)) {
            return false;
        }
        YCircle yCircle = (YCircle)object;
        return yCircle.radius == this.radius && yCircle.center.equals(this.center);
    }

    public int hashCode() {
        return this.center.hashCode() ^ (int)Double.doubleToLongBits(this.radius);
    }

    public int compareTo(Object object) {
        YCircle yCircle = (YCircle)object;
        if (this.center.x < yCircle.center.x) {
            return -1;
        }
        if (this.center.x > yCircle.center.x) {
            return 1;
        }
        if (this.center.y < yCircle.center.y) {
            return -1;
        }
        if (this.center.y > yCircle.center.y) {
            return 1;
        }
        if (this.radius > yCircle.radius) {
            return 1;
        }
        if (this.radius < yCircle.radius) {
            return -1;
        }
        return 0;
    }
}

