/*
 * Decompiled with CFR 0.152.
 */
package y.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.w3c.dom.Document;
import y.base.Graph;
import y.io.IOHandler;
import y.io.graphml.graph2d.EdgeRealizerSerializer;
import y.io.graphml.graph2d.Graph2DGraphMLHandler;
import y.io.graphml.graph2d.NodeRealizerSerializer;
import y.view.Graph2D;

public class GraphMLIOHandler
extends IOHandler {
    Graph2DGraphMLHandler lb;

    public Graph2DGraphMLHandler getGraphMLHandler() {
        if (this.lb == null) {
            this.lb = this.createGraphMLHandler();
        }
        return this.lb;
    }

    protected Graph2DGraphMLHandler createGraphMLHandler() {
        return new Graph2DGraphMLHandler();
    }

    public void write(Graph2D graph2D, OutputStream outputStream) throws IOException {
        this.getGraphMLHandler().write((Graph)graph2D, outputStream);
    }

    public void write(Graph2D graph2D, Writer writer) throws IOException {
        this.getGraphMLHandler().write((Graph)graph2D, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Graph2D graph2D, InputStream inputStream) throws IOException {
        graph2D.firePreEvent();
        try {
            this.getGraphMLHandler().read((Graph)graph2D, inputStream);
        }
        finally {
            graph2D.firePostEvent();
        }
    }

    public String getFileFormatString() {
        return "GraphML file";
    }

    public String getFileNameExtension() {
        return "graphml";
    }

    public void addNodeRealizerSerializer(NodeRealizerSerializer nodeRealizerSerializer) {
        this.getGraphMLHandler().addNodeRealizerSerializer(nodeRealizerSerializer);
    }

    public void addEdgeRealizerSerializer(EdgeRealizerSerializer edgeRealizerSerializer) {
        this.getGraphMLHandler().addEdgeRealizerSerializer(edgeRealizerSerializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Graph2D graph2D, Document document) throws IOException {
        graph2D.firePreEvent();
        try {
            this.getGraphMLHandler().read((Graph)graph2D, document);
        }
        finally {
            graph2D.firePostEvent();
        }
    }
}

