/*
 * Decompiled with CFR 0.152.
 */
package y.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Node;
import y.base.NodeList;
import y.base.YCursor;
import y.base.c;
import y.util.GraphHider;
import y.view.Graph2D;

public abstract class IOHandler {
    public static int z;

    public abstract void write(Graph2D var1, OutputStream var2) throws IOException;

    public void writeSubset(Graph2D graph2D, DataProvider dataProvider, OutputStream outputStream) throws IOException {
        GraphHider graphHider = new GraphHider(graph2D);
        this.hide(graphHider, dataProvider);
        this.write(graph2D, outputStream);
        graphHider.unhideAll();
    }

    public abstract void read(Graph2D var1, InputStream var2) throws IOException;

    public abstract String getFileFormatString();

    public abstract String getFileNameExtension();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(Graph2D graph2D, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        try {
            this.write(graph2D, fileOutputStream);
            Object var5_4 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fileOutputStream == null) throw throwable;
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
    }

    public void writeSubset(Graph2D graph2D, DataProvider dataProvider, String string2) throws IOException {
        GraphHider graphHider = new GraphHider(graph2D);
        this.hide(graphHider, dataProvider);
        this.write(graph2D, string2);
        graphHider.unhideAll();
    }

    public void read(Graph2D graph2D, String string2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string2);
        URL uRL = graph2D.getURL();
        graph2D.setURL(new File(string2).toURL());
        try {
            this.read(graph2D, fileInputStream);
        }
        catch (IOException iOException) {
            graph2D.setURL(uRL);
            throw iOException;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public void read(Graph2D graph2D, URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        URL uRL2 = graph2D.getURL();
        graph2D.setURL(uRL);
        try {
            this.read(graph2D, inputStream);
        }
        catch (IOException iOException) {
            graph2D.setURL(uRL2);
            throw iOException;
        }
        finally {
            inputStream.close();
        }
    }

    public static ObjectInputStream createObjectInputStream(String string2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string2);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        return new ObjectInputStream(bufferedInputStream);
    }

    public static ObjectOutputStream createObjectOutputStream(String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        return new ObjectOutputStream(fileOutputStream);
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public boolean canWriteSubset() {
        return true;
    }

    protected void hide(GraphHider graphHider, DataProvider dataProvider) {
        block5: {
            c c2;
            int n2 = z;
            EdgeList edgeList = new EdgeList();
            NodeList nodeList = new NodeList();
            YCursor yCursor = graphHider.getGraph().edges();
            while (yCursor.ok()) {
                c2 = yCursor.edge();
                if (!this.shouldSerialize((Edge)c2, dataProvider)) {
                    edgeList.add(c2);
                }
                yCursor.next();
                if (n2 == 0) continue;
            }
            yCursor = graphHider.getGraph().nodes();
            while (yCursor.ok()) {
                c2 = yCursor.node();
                if (n2 == 0) {
                    if (!this.shouldSerialize((Node)c2, dataProvider)) {
                        nodeList.add(c2);
                    }
                    yCursor.next();
                    if (n2 == 0) continue;
                }
                break block5;
            }
            graphHider.hide(edgeList);
            graphHider.hide(nodeList);
        }
    }

    protected boolean shouldSerialize(Node node, DataProvider dataProvider) {
        boolean bl;
        block4: {
            int n2 = z;
            if (dataProvider == null || dataProvider.getBool(node)) {
                return true;
            }
            EdgeCursor edgeCursor = node.edges();
            while (edgeCursor.ok()) {
                Edge edge = edgeCursor.edge();
                bl = this.shouldSerialize(edge, dataProvider);
                if (n2 == 0) {
                    if (bl) {
                        return true;
                    }
                    edgeCursor.next();
                    if (n2 == 0) continue;
                }
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    protected boolean shouldSerialize(Edge edge, DataProvider dataProvider) {
        return dataProvider == null || dataProvider.getBool(edge) || dataProvider.getBool(edge.source()) && dataProvider.getBool(edge.target());
    }
}

