/*
 * Decompiled with CFR 0.152.
 */
package y.io;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import y.io.IOHandler;
import y.view.Graph2D;
import y.view.Graph2DView;
import y.view.GraphicsContext;
import y.view.Util;
import y.view.YRenderingHints;

public abstract class ImageOutputHandler
extends IOHandler {
    private boolean nb;
    private boolean mb;
    private double ob = 10.0;

    protected ImageOutputHandler() {
        this(false);
    }

    protected ImageOutputHandler(boolean bl) {
        this.nb = bl;
        this.mb = true;
    }

    public boolean isSelectionPaintingEnabled() {
        return this.mb;
    }

    public void setSelectionPaintingEnabled(boolean bl) {
        this.mb = bl;
    }

    public boolean canRead() {
        return false;
    }

    public void read(Graph2D graph2D, InputStream inputStream) {
        throw new UnsupportedOperationException("read operation not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Graph2D graph2D, OutputStream outputStream) throws IOException {
        Graph2DView graph2DView = (Graph2DView)graph2D.getCurrentView();
        Graph2DView graph2DView2 = graph2DView;
        if (graph2DView2 == null) {
            graph2DView2 = this.createDefaultGraph2DView(graph2D);
        }
        try {
            this.write(graph2DView2, outputStream);
        }
        finally {
            if (graph2DView == null) {
                graph2D.removeView(graph2DView2);
            }
        }
    }

    public void write(Graph2DView graph2DView, OutputStream outputStream) throws IOException {
        GraphicsContext graphicsContext;
        BufferedImage bufferedImage;
        Dimension dimension = graph2DView.getCanvasSize();
        long l2 = (long)dimension.width * (long)dimension.height;
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Image size of " + dimension.width + "x" + dimension.height + "=" + l2 + "px exceeds maximum size of " + Integer.MAX_VALUE + "px.");
        }
        try {
            bufferedImage = this.createImage(dimension.width, dimension.height);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            int n2 = (int)Math.ceil((double)(dimension.width * dimension.height) / 1048576.0);
            throw new OutOfMemoryError("Not enough memory for temporary image of size " + dimension.width + 'x' + dimension.height + " (" + n2 + "MPixels).  Approximately " + n2 * 4 + "MByte required.");
        }
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        if (!this.isSelectionPaintingEnabled()) {
            graphics2D.setRenderingHint(YRenderingHints.KEY_SELECTION_PAINTING, YRenderingHints.VALUE_SELECTION_PAINTING_OFF);
        }
        if (this.nb) {
            Util.alias(graphics2D);
        }
        if ((graphicsContext = this.createGraphicsContext(graph2DView, graphics2D)) != null) {
            graphics2D.setRenderingHint(YRenderingHints.GRAPHICS_CONTEXT_KEY, graphicsContext);
        }
        graph2DView.paintVisibleContent(graphics2D);
        if (this.nb) {
            Util.unalias(graphics2D);
        }
        try {
            this.encode(bufferedImage, outputStream);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            int n3 = (int)Math.ceil((double)(dimension.width * dimension.height) / 1048576.0);
            throw new OutOfMemoryError("Not enough memory to encode image of size " + bufferedImage.getWidth() + 'x' + bufferedImage.getHeight() + " (" + n3 + "MPixels). Approximately " + n3 * 4 + "MByte required.");
        }
    }

    protected GraphicsContext createGraphicsContext(Graph2DView graph2DView, Graphics2D graphics2D) {
        GraphicsContext graphicsContext = new GraphicsContext();
        graphicsContext.setExportPainting(true);
        graphicsContext.setGraph2DView(graph2DView);
        graphicsContext.setViewTransform(graphics2D.getTransform());
        return graphicsContext;
    }

    protected abstract BufferedImage createImage(int var1, int var2);

    public Graph2DView createDefaultGraph2DView(Graph2D graph2D) {
        Graph2DView graph2DView = new Graph2DView(graph2D);
        Rectangle rectangle = graph2D.getBoundingBox();
        Dimension dimension = new Dimension(rectangle.width, rectangle.height);
        graph2DView.setSize(dimension);
        graph2DView.setPreferredSize(dimension);
        graph2DView.zoomToArea((double)rectangle.x - this.ob, (double)rectangle.y - this.ob, (double)rectangle.width + 2.0 * this.ob, (double)rectangle.height + 2.0 * this.ob);
        graph2DView.setPaintDetailThreshold(0.0);
        return graph2DView;
    }

    protected abstract void encode(BufferedImage var1, OutputStream var2) throws IOException;

    public boolean isAntialiasingEnabled() {
        return this.nb;
    }

    public void setAntialiasingEnabled(boolean bl) {
        this.nb = bl;
    }

    public double getBorder() {
        return this.ob;
    }

    public void setBorder(double d2) {
        this.ob = d2;
    }
}

