/*
 * Decompiled with CFR 0.152.
 */
package y.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import y.base.Edge;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.YCursor;
import y.base.c;
import y.io.BadVersionException;
import y.io.IOHandler;
import y.io.b;
import y.util.D;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.Graph2DNodeRealizer;
import y.view.NodeRealizer;
import y.view.PolyLineEdgeRealizer;
import y.view.ShapeNodeRealizer;
import y.view.hierarchy.HierarchyManager;

public class YGFIOHandler
extends IOHandler {
    private HierarchyManager g;
    private boolean j;
    private boolean i;
    private boolean f;
    private int[] m;
    protected static Map encode2decodeMap = new HashMap();
    protected static Map decode2encodeMap = new HashMap();
    private Map h = new LinkedHashMap();
    static final int l = 305419896;
    boolean d = false;
    private boolean k;
    private byte e;
    static /* synthetic */ Class class$y$view$ShapeNodeRealizer;
    static /* synthetic */ Class class$y$view$ImageNodeRealizer;
    static /* synthetic */ Class class$y$view$Graph2DNodeRealizer;
    static /* synthetic */ Class class$y$view$GenericNodeRealizer;
    static /* synthetic */ Class class$y$view$hierarchy$GenericGroupNodeRealizer;
    static /* synthetic */ Class class$y$view$tabular$TableGroupNodeRealizer;
    static /* synthetic */ Class class$y$view$hierarchy$GroupNodeRealizer;
    static /* synthetic */ Class class$y$view$ProxyShapeNodeRealizer;
    static /* synthetic */ Class class$y$view$hierarchy$ProxyAutoBoundsNodeRealizer;
    static /* synthetic */ Class class$y$view$PolyLineEdgeRealizer;
    static /* synthetic */ Class class$y$view$QuadCurveEdgeRealizer;
    static /* synthetic */ Class class$y$view$GenericEdgeRealizer;
    static /* synthetic */ Class class$y$view$ArcEdgeRealizer;
    static /* synthetic */ Class class$y$view$BezierEdgeRealizer;
    static /* synthetic */ Class class$y$view$SplineEdgeRealizer;
    static /* synthetic */ Class class$y$view$Port;
    static /* synthetic */ Class class$y$view$InterfacePort;
    static /* synthetic */ Class class$y$view$tabular$TableStyle$SimpleStyle;

    public static void addEncoding(String string2, String string3) {
        encode2decodeMap.put(string2, string3);
        decode2encodeMap.put(string3, string2);
    }

    public static String encode(String string2) {
        String string3 = (String)decode2encodeMap.get(string2);
        return string3 != null ? string3 : string2;
    }

    public static String decode(String string2) {
        String string3 = (String)encode2decodeMap.get(string2);
        return string3 != null ? string3 : string2;
    }

    public String getFileFormatString() {
        return "YGF Format";
    }

    public String getFileNameExtension() {
        return "ygf";
    }

    public void write(Graph2D graph2D, OutputStream outputStream) throws IOException {
        D.bug(this, (Object)"writeOS");
        this.g = HierarchyManager.getInstance(graph2D);
        ObjectOutputStream objectOutputStream = this.createObjectOutputStream(outputStream);
        int n2 = 3;
        if (this.h.size() > 0) {
            n2 = 4;
        }
        objectOutputStream.writeByte(n2);
        objectOutputStream.flush();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);
        objectOutputStream = this.createObjectOutputStream(gZIPOutputStream);
        this.write(graph2D, objectOutputStream);
        if (n2 > 3) {
            this.b(graph2D, objectOutputStream);
        }
        objectOutputStream.flush();
        gZIPOutputStream.flush();
        gZIPOutputStream.finish();
    }

    void b(Graph2D graph2D, ObjectOutputStream objectOutputStream) throws IOException {
        int n2 = IOHandler.z;
        objectOutputStream.writeInt(305419896);
        objectOutputStream.writeInt(this.h.size());
        Iterator iterator2 = this.h.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            objectOutputStream.writeObject(entry.getKey());
            this.b(graph2D, (DataHandler)entry.getValue(), objectOutputStream);
            if (n2 == 0) continue;
        }
    }

    void b(Graph2D graph2D, DataHandler dataHandler, ObjectOutputStream objectOutputStream) throws IOException {
        block4: {
            c c2;
            int n2 = IOHandler.z;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(byteArrayOutputStream);
            dataHandler.writeData(graph2D, graph2D, objectOutputStream2);
            HierarchyManager hierarchyManager = graph2D.getHierarchyManager();
            YCursor yCursor = graph2D.nodes();
            while (yCursor.ok()) {
                c2 = yCursor.node();
                dataHandler.writeData(graph2D, c2, objectOutputStream2);
                if (hierarchyManager != null && hierarchyManager.isFolderNode((Node)c2)) {
                    this.b((Graph2D)hierarchyManager.getInnerGraph((Node)c2), dataHandler, objectOutputStream2);
                }
                yCursor.next();
                if (n2 == 0) continue;
            }
            yCursor = graph2D.edges();
            while (yCursor.ok()) {
                c2 = yCursor.edge();
                dataHandler.writeData(graph2D, c2, objectOutputStream2);
                yCursor.next();
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block4;
            }
            objectOutputStream2.flush();
            objectOutputStream2.close();
            byteArrayOutputStream.flush();
            objectOutputStream.writeInt(byteArrayOutputStream.size());
            byteArrayOutputStream.writeTo(objectOutputStream);
        }
    }

    protected void write(Graph2D graph2D, ObjectOutputStream objectOutputStream) throws IOException {
        YCursor yCursor;
        int n2;
        block7: {
            block9: {
                block8: {
                    n2 = IOHandler.z;
                    D.bug(this, (Object)"writeOOS");
                    objectOutputStream.writeByte(2);
                    if (this.g == null) break block8;
                    this.f = this.g.containsGroups();
                    if (n2 == 0) break block9;
                }
                this.f = false;
            }
            boolean bl = this.g != null;
            objectOutputStream.writeBoolean(this.f);
            objectOutputStream.writeBoolean(bl);
            objectOutputStream.writeInt(graph2D.nodeCount());
            yCursor = graph2D.nodes();
            while (yCursor.ok()) {
                this.writeNodeInfo(graph2D, yCursor.node(), objectOutputStream);
                yCursor.next();
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block7;
            }
            objectOutputStream.writeInt(graph2D.edgeCount());
        }
        yCursor = graph2D.edges();
        while (yCursor.ok()) {
            Edge edge = yCursor.edge();
            objectOutputStream.writeInt(edge.source().index());
            objectOutputStream.writeInt(edge.target().index());
            this.writeEdgeInfo(graph2D, edge, objectOutputStream);
            yCursor.next();
            if (n2 == 0) continue;
        }
    }

    protected void writeEdgeInfo(Graph2D graph2D, Edge edge, ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(1);
        this.writeEdgeRealizer(graph2D, edge, objectOutputStream);
        this.writeInterEdgeInfo(graph2D, edge, objectOutputStream);
    }

    protected void writeEdgeRealizer(Graph2D graph2D, Edge edge, ObjectOutputStream objectOutputStream) throws IOException {
        EdgeRealizer edgeRealizer = graph2D.getRealizer(edge);
        objectOutputStream.writeObject(YGFIOHandler.encode(edgeRealizer.getClass().getName()));
        edgeRealizer.write(objectOutputStream);
    }

    protected void writeInterEdgeInfo(Graph2D graph2D, Edge edge, ObjectOutputStream objectOutputStream) throws IOException {
        block21: {
            block17: {
                int n2;
                block20: {
                    block16: {
                        int n3;
                        Object object;
                        block19: {
                            block18: {
                                block15: {
                                    int n4;
                                    n2 = IOHandler.z;
                                    if (this.g == null) {
                                        return;
                                    }
                                    if (!this.g.isInterEdge(edge)) break block17;
                                    objectOutputStream.writeBoolean(true);
                                    Node node = this.g.getRealSource(edge);
                                    if (node == edge.source()) break block18;
                                    objectOutputStream.writeBoolean(true);
                                    object = this.g.getFolderPath(node);
                                    for (n4 = 1; n4 < ((Object[])object).length && object[n4] != edge.source(); ++n4) {
                                        if (n2 == 0) continue;
                                    }
                                    objectOutputStream.writeInt(((Object[])object).length - n4);
                                    ++n4;
                                    while (n4 < ((Object[])object).length) {
                                        objectOutputStream.writeInt(((Node)object[n4]).index());
                                        ++n4;
                                        if (n2 == 0) {
                                            if (n2 == 0) continue;
                                        }
                                        break block15;
                                    }
                                    objectOutputStream.writeInt(node.index());
                                }
                                if (n2 == 0) break block19;
                            }
                            objectOutputStream.writeBoolean(false);
                        }
                        if ((object = this.g.getRealTarget(edge)) == edge.target()) break block20;
                        objectOutputStream.writeBoolean(true);
                        Object[] objectArray = this.g.getFolderPath(object);
                        for (n3 = 1; n3 < objectArray.length && objectArray[n3] != edge.target(); ++n3) {
                            if (n2 == 0) continue;
                        }
                        objectOutputStream.writeInt(objectArray.length - n3);
                        ++n3;
                        while (n3 < objectArray.length) {
                            objectOutputStream.writeInt(((Node)objectArray[n3]).index());
                            ++n3;
                            if (n2 == 0) {
                                if (n2 == 0) continue;
                            }
                            break block16;
                        }
                        objectOutputStream.writeInt(((Node)object).index());
                    }
                    if (n2 == 0) break block21;
                }
                objectOutputStream.writeBoolean(false);
                if (n2 == 0) break block21;
            }
            objectOutputStream.writeBoolean(false);
        }
    }

    protected void writeNodeInfo(Graph2D graph2D, Node node, ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(2);
        this.writeNodeRealizer(graph2D, node, objectOutputStream);
        this.writeFolderNodeInfo(graph2D, node, objectOutputStream);
        this.writeGroupNodeInfo(graph2D, node, objectOutputStream);
    }

    protected void writeNodeRealizer(Graph2D graph2D, Node node, ObjectOutputStream objectOutputStream) throws IOException {
        NodeRealizer nodeRealizer = graph2D.getRealizer(node);
        objectOutputStream.writeObject(YGFIOHandler.encode(nodeRealizer.getClass().getName()));
        nodeRealizer.write(objectOutputStream);
        if (nodeRealizer instanceof Graph2DNodeRealizer && this.g == null) {
            this.write(((Graph2DNodeRealizer)nodeRealizer).getInnerGraph(), objectOutputStream);
        }
    }

    protected void writeFolderNodeInfo(Graph2D graph2D, Node node, ObjectOutputStream objectOutputStream) throws IOException {
        block5: {
            block4: {
                if (this.g == null) {
                    return;
                }
                if (!this.g.isFolderNode(node)) break block4;
                objectOutputStream.writeBoolean(true);
                this.write((Graph2D)this.g.getInnerGraph(node), objectOutputStream);
                if (IOHandler.z == 0) break block5;
            }
            objectOutputStream.writeBoolean(false);
        }
    }

    protected void writeGroupNodeInfo(Graph2D graph2D, Node node, ObjectOutputStream objectOutputStream) throws IOException {
        block5: {
            block4: {
                if (this.g == null || !this.f) {
                    return;
                }
                objectOutputStream.writeBoolean(this.g.isGroupNode(node));
                Node node2 = this.g.getParentNode(node);
                if (node2 == null || !this.g.isGroupNode(node2)) break block4;
                objectOutputStream.writeInt(node2.index());
                if (IOHandler.z == 0) break block5;
            }
            objectOutputStream.writeInt(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Graph2D graph2D, InputStream inputStream) throws IOException {
        graph2D.firePreEvent();
        try {
            this.b(graph2D, inputStream);
        }
        finally {
            graph2D.firePostEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(Graph2D graph2D, InputStream inputStream) throws IOException {
        ObjectInputStream objectInputStream = this.createObjectInputStream(inputStream);
        this.e = objectInputStream.readByte();
        if (this.e > 2) {
            objectInputStream = this.createObjectInputStream(new GZIPInputStream(inputStream));
        }
        this.g = HierarchyManager.getInstance(graph2D);
        try {
            this.k = true;
            this.read(graph2D, objectInputStream);
        }
        finally {
            this.k = false;
        }
        if (this.e > 3) {
            this.b(graph2D, objectInputStream);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void b(Graph2D graph2D, ObjectInputStream objectInputStream) throws IOException {
        int n2 = IOHandler.z;
        Object object = null;
        try {
            int n3 = 0;
            try {
                if (objectInputStream.readInt() != 305419896) {
                    return;
                }
                n3 = objectInputStream.readInt();
            }
            catch (EOFException eOFException) {
                return;
            }
            while (n3-- > 0) {
                try {
                    object = objectInputStream.readObject();
                    if (n2 != 0) return;
                }
                catch (EOFException eOFException) {
                    return;
                }
                DataHandler dataHandler = (DataHandler)this.h.get(object);
                if (dataHandler != null) {
                    this.b(graph2D, dataHandler, objectInputStream);
                    if (n2 == 0) continue;
                }
                try {
                    int n4 = objectInputStream.readInt();
                    objectInputStream.skipBytes(n4);
                }
                catch (IOException iOException) {
                    throw new IOException("Can't skip data registered with key " + object);
                    return;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            IOException iOException = new IOException("Unable to read data." + classNotFoundException.getMessage());
            iOException.initCause(classNotFoundException);
            throw iOException;
        }
    }

    void b(Graph2D graph2D, DataHandler dataHandler, ObjectInputStream objectInputStream) throws IOException {
        block7: {
            c c2;
            ObjectInputStream objectInputStream2;
            int n2;
            block6: {
                int n3;
                n2 = IOHandler.z;
                int n4 = objectInputStream.readInt();
                byte[] byArray = new byte[n4];
                for (int i2 = 0; i2 < byArray.length - 1; i2 += n3) {
                    objectInputStream2 = objectInputStream;
                    if (n2 == 0) {
                        n3 = objectInputStream2.read(byArray, i2, byArray.length - i2);
                        if (n3 >= 0) continue;
                        throw new EOFException("Unexpected end of file");
                    }
                    break block6;
                }
                objectInputStream2 = new ObjectInputStream(new ByteArrayInputStream(byArray));
            }
            ObjectInputStream objectInputStream3 = objectInputStream2;
            dataHandler.readData(graph2D, graph2D, objectInputStream3);
            HierarchyManager hierarchyManager = graph2D.getHierarchyManager();
            YCursor yCursor = graph2D.nodes();
            while (yCursor.ok()) {
                c2 = yCursor.node();
                dataHandler.readData(graph2D, c2, objectInputStream3);
                if (hierarchyManager != null && hierarchyManager.isFolderNode((Node)c2)) {
                    this.b((Graph2D)hierarchyManager.getInnerGraph((Node)c2), dataHandler, objectInputStream3);
                }
                yCursor.next();
                if (n2 == 0) continue;
            }
            yCursor = graph2D.edges();
            while (yCursor.ok()) {
                c2 = yCursor.edge();
                dataHandler.readData(graph2D, c2, objectInputStream3);
                yCursor.next();
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block7;
            }
            objectInputStream3.close();
        }
    }

    protected void read(Graph2D graph2D, ObjectInputStream objectInputStream) throws IOException {
        int n2;
        block23: {
            int n3;
            int n4;
            int[] nArray;
            Node[] nodeArray;
            PolyLineEdgeRealizer polyLineEdgeRealizer;
            block22: {
                ShapeNodeRealizer shapeNodeRealizer;
                block29: {
                    byte by;
                    block31: {
                        block30: {
                            block28: {
                                block27: {
                                    block24: {
                                        block26: {
                                            block25: {
                                                n2 = IOHandler.z;
                                                D.bug(this, (Object)"readOIS");
                                                D.bug(this, (Object)"read Version");
                                                shapeNodeRealizer = new ShapeNodeRealizer();
                                                polyLineEdgeRealizer = new PolyLineEdgeRealizer();
                                                if (!this.k) break block24;
                                                if (this.e <= 2) break block25;
                                                by = objectInputStream.readByte();
                                                if (n2 == 0) break block26;
                                            }
                                            by = this.e;
                                        }
                                        this.k = false;
                                        if (n2 == 0) break block27;
                                    }
                                    by = objectInputStream.readByte();
                                }
                                this.j = false;
                                this.i = false;
                                if (by != 0) break block28;
                                this.j = false;
                                if (n2 == 0) break block29;
                            }
                            if (by != 1) break block30;
                            this.j = objectInputStream.readBoolean();
                            if (n2 == 0) break block29;
                        }
                        if (by != 2) break block31;
                        this.i = objectInputStream.readBoolean();
                        this.j = objectInputStream.readBoolean();
                        if (n2 == 0) break block29;
                    }
                    throw new BadVersionException(by);
                }
                D.bug(this, (Object)"read nodes");
                int n5 = objectInputStream.readInt();
                nodeArray = new Node[n5];
                int[] nArray2 = null;
                nArray = null;
                if (this.g != null || this.i) {
                    nArray2 = new int[n5];
                    nArray = this.m;
                    this.m = nArray2;
                }
                for (n4 = 0; n4 < n5; ++n4) {
                    nodeArray[n4] = graph2D.createNode(shapeNodeRealizer);
                    this.readNodeInfo(graph2D, nodeArray[n4], objectInputStream);
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break block22;
                }
                D.bug(this, (Object)"read edges");
                n4 = objectInputStream.readInt();
            }
            for (n3 = 0; n3 < n4; ++n3) {
                Node node = nodeArray[objectInputStream.readInt()];
                Node node2 = nodeArray[objectInputStream.readInt()];
                Edge edge = graph2D.createEdge(node, node2, polyLineEdgeRealizer);
                this.readEdgeInfo(graph2D, edge, objectInputStream);
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block23;
            }
            if (this.i && this.g != null) {
                for (n3 = 0; n3 < nodeArray.length; ++n3) {
                    int n6 = this.m[nodeArray[n3].index()];
                    if (n2 == 0) {
                        if (n6 < 0) continue;
                        this.g.groupSubgraph(new NodeList(nodeArray[n3]), nodeArray[n6]);
                        if (n2 == 0) continue;
                    }
                    break;
                }
            } else {
                this.m = nArray;
                D.bug(this, (Object)"readOIS done");
            }
        }
        if (Graph.z) {
            IOHandler.z = ++n2;
        }
    }

    protected void readNodeInfo(Graph2D graph2D, Node node, ObjectInputStream objectInputStream) throws IOException {
        block3: {
            byte by;
            block5: {
                int n2;
                block4: {
                    block2: {
                        n2 = IOHandler.z;
                        by = objectInputStream.readByte();
                        if (by != 0) break block2;
                        this.readNodeRealizer(graph2D, node, objectInputStream);
                        if (n2 == 0) break block3;
                    }
                    if (by != 1) break block4;
                    this.readNodeRealizer(graph2D, node, objectInputStream);
                    this.readFolderNodeInfo(graph2D, node, objectInputStream);
                    if (n2 == 0) break block3;
                }
                if (by != 2) break block5;
                this.readNodeRealizer(graph2D, node, objectInputStream);
                this.readFolderNodeInfo(graph2D, node, objectInputStream);
                this.readGroupNodeInfo(graph2D, node, objectInputStream);
                if (n2 == 0) break block3;
            }
            throw new BadVersionException(by);
        }
    }

    protected void readNodeRealizer(Graph2D graph2D, Node node, ObjectInputStream objectInputStream) throws IOException {
        try {
            String string2 = (String)objectInputStream.readObject();
            string2 = YGFIOHandler.decode(string2);
            Class<?> clazz = Class.forName(string2);
            NodeRealizer nodeRealizer = (NodeRealizer)clazz.newInstance();
            graph2D.setRealizer(node, nodeRealizer);
            nodeRealizer.read(objectInputStream);
            if (nodeRealizer instanceof Graph2DNodeRealizer && !this.j) {
                Graph2D graph2D2 = this.createInnerGraph(node);
                this.read(graph2D2, objectInputStream);
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.toString());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    protected Graph2D createInnerGraph(Node node) {
        return new Graph2D();
    }

    protected void readFolderNodeInfo(Graph2D graph2D, Node node, ObjectInputStream objectInputStream) throws IOException {
        block5: {
            Graph2D graph2D2;
            block7: {
                block6: {
                    if (!this.j) {
                        return;
                    }
                    if (!objectInputStream.readBoolean()) break block5;
                    if (this.g == null) break block6;
                    this.g.convertToFolderNode(node);
                    graph2D2 = (Graph2D)this.g.getInnerGraph(node);
                    if (IOHandler.z == 0) break block7;
                }
                graph2D2 = this.createInnerGraph(node);
            }
            if (graph2D.getRealizer(node) instanceof Graph2DNodeRealizer) {
                Graph2DNodeRealizer graph2DNodeRealizer = (Graph2DNodeRealizer)graph2D.getRealizer(node);
                graph2DNodeRealizer.setInnerGraph(graph2D2);
            }
            this.read(graph2D2, objectInputStream);
        }
    }

    protected void readGroupNodeInfo(Graph2D graph2D, Node node, ObjectInputStream objectInputStream) throws IOException {
        if (!this.i) {
            return;
        }
        boolean bl = objectInputStream.readBoolean();
        int n2 = objectInputStream.readInt();
        if (this.g != null) {
            if (bl) {
                this.g.convertToGroupNode(node);
            }
            this.m[node.index()] = n2;
        }
    }

    protected void readEdgeInfo(Graph2D graph2D, Edge edge, ObjectInputStream objectInputStream) throws IOException {
        block3: {
            byte by;
            block4: {
                int n2;
                block2: {
                    n2 = IOHandler.z;
                    by = objectInputStream.readByte();
                    if (by != 0) break block2;
                    this.readEdgeRealizer(graph2D, edge, objectInputStream);
                    if (n2 == 0) break block3;
                }
                if (by != 1) break block4;
                this.readEdgeRealizer(graph2D, edge, objectInputStream);
                this.readInterEdgeInfo(graph2D, edge, objectInputStream);
                if (n2 == 0) break block3;
            }
            throw new BadVersionException(by);
        }
    }

    protected void readEdgeRealizer(Graph2D graph2D, Edge edge, ObjectInputStream objectInputStream) throws IOException {
        try {
            Class<?> clazz = Class.forName(YGFIOHandler.decode((String)objectInputStream.readObject()));
            EdgeRealizer edgeRealizer = (EdgeRealizer)clazz.newInstance();
            graph2D.setRealizer(edge, edgeRealizer);
            edgeRealizer.read(objectInputStream);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.toString());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    protected void readInterEdgeInfo(Graph2D graph2D, Edge edge, ObjectInputStream objectInputStream) throws IOException {
        if (!this.j) {
            return;
        }
        if (objectInputStream.readBoolean()) {
            int n2;
            int n3;
            Graph graph;
            Node node = edge.source();
            Node node2 = edge.target();
            if (objectInputStream.readBoolean()) {
                graph = graph2D;
                n3 = objectInputStream.readInt();
                do {
                    n2 = objectInputStream.readInt();
                    if (this.g == null) continue;
                    graph = this.g.getInnerGraph(node);
                    node = this.b(graph, n2);
                } while (--n3 > 0);
            }
            if (objectInputStream.readBoolean()) {
                graph = graph2D;
                n3 = objectInputStream.readInt();
                do {
                    n2 = objectInputStream.readInt();
                    if (this.g == null) continue;
                    graph = this.g.getInnerGraph(node2);
                    node2 = this.b(graph, n2);
                } while (--n3 > 0);
            }
            if (this.g != null) {
                this.g.convertToInterEdge(edge, node, node2);
            }
        }
    }

    private Node b(Graph graph, int n2) {
        int n3 = IOHandler.z;
        int n4 = 0;
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            if (n4 == n2) {
                return nodeCursor.node();
            }
            nodeCursor.next();
            ++n4;
            if (n3 == 0) continue;
        }
        return null;
    }

    public void addDataHandler(String string2, DataHandler dataHandler) {
        this.h.put(string2, dataHandler);
    }

    public DataHandler getDataHandler(String string2) {
        return (DataHandler)this.h.get(string2);
    }

    public void removeDataHandler(String string2) {
        this.h.remove(string2);
    }

    protected ObjectInputStream createObjectInputStream(InputStream inputStream) throws IOException {
        return new b(inputStream);
    }

    protected ObjectOutputStream createObjectOutputStream(OutputStream outputStream) throws IOException {
        return new ObjectOutputStream(outputStream);
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        StringBuffer stringBuffer = new StringBuffer("y.view.");
        YGFIOHandler.addEncoding(stringBuffer.toString() + "ShapeNodeRealizer", (class$y$view$ShapeNodeRealizer == null ? (class$y$view$ShapeNodeRealizer = YGFIOHandler.class$("y.view.ShapeNodeRealizer")) : class$y$view$ShapeNodeRealizer).getName());
        YGFIOHandler.addEncoding(stringBuffer.toString() + "ImageNodeRealizer", (class$y$view$ImageNodeRealizer == null ? (class$y$view$ImageNodeRealizer = YGFIOHandler.class$("y.view.ImageNodeRealizer")) : class$y$view$ImageNodeRealizer).getName());
        YGFIOHandler.addEncoding(stringBuffer.toString() + "Graph2DNodeRealizer", (class$y$view$Graph2DNodeRealizer == null ? (class$y$view$Graph2DNodeRealizer = YGFIOHandler.class$("y.view.Graph2DNodeRealizer")) : class$y$view$Graph2DNodeRealizer).getName());
        YGFIOHandler.addEncoding(stringBuffer.toString() + "GenericNodeRealizer", (class$y$view$GenericNodeRealizer == null ? (class$y$view$GenericNodeRealizer = YGFIOHandler.class$("y.view.GenericNodeRealizer")) : class$y$view$GenericNodeRealizer).getName());
        YGFIOHandler.addEncoding(stringBuffer.toString() + "GenericGroupNodeRealizer", (class$y$view$hierarchy$GenericGroupNodeRealizer == null ? (class$y$view$hierarchy$GenericGroupNodeRealizer = YGFIOHandler.class$("y.view.hierarchy.GenericGroupNodeRealizer")) : class$y$view$hierarchy$GenericGroupNodeRealizer).getName());
        YGFIOHandler.addEncoding(stringBuffer.toString() + "tabular.TableGroupNodeRealizer", (class$y$view$tabular$TableGroupNodeRealizer == null ? (class$y$view$tabular$TableGroupNodeRealizer = YGFIOHandler.class$("y.view.tabular.TableGroupNodeRealizer")) : class$y$view$tabular$TableGroupNodeRealizer).getName());
        YGFIOHandler.addEncoding(stringBuffer.toString() + "hierarchy.GroupNodeRealizer", (class$y$view$hierarchy$GroupNodeRealizer == null ? (class$y$view$hierarchy$GroupNodeRealizer = YGFIOHandler.class$("y.view.hierarchy.GroupNodeRealizer")) : class$y$view$hierarchy$GroupNodeRealizer).getName());
        YGFIOHandler.addEncoding(stringBuffer.toString() + "ProxyShapeNodeRealizer", (class$y$view$ProxyShapeNodeRealizer == null ? (class$y$view$ProxyShapeNodeRealizer = YGFIOHandler.class$("y.view.ProxyShapeNodeRealizer")) : class$y$view$ProxyShapeNodeRealizer).getName());
        YGFIOHandler.addEncoding(stringBuffer.toString() + "hierarchy.ProxyAutoBoundsNodeRealizer", (class$y$view$hierarchy$ProxyAutoBoundsNodeRealizer == null ? (class$y$view$hierarchy$ProxyAutoBoundsNodeRealizer = YGFIOHandler.class$("y.view.hierarchy.ProxyAutoBoundsNodeRealizer")) : class$y$view$hierarchy$ProxyAutoBoundsNodeRealizer).getName());
        YGFIOHandler.addEncoding(stringBuffer.toString() + "PolyLineEdgeRealizer", (class$y$view$PolyLineEdgeRealizer == null ? (class$y$view$PolyLineEdgeRealizer = YGFIOHandler.class$("y.view.PolyLineEdgeRealizer")) : class$y$view$PolyLineEdgeRealizer).getName());
        YGFIOHandler.addEncoding(stringBuffer.toString() + "QuadCurveEdgeRealizer", (class$y$view$QuadCurveEdgeRealizer == null ? (class$y$view$QuadCurveEdgeRealizer = YGFIOHandler.class$("y.view.QuadCurveEdgeRealizer")) : class$y$view$QuadCurveEdgeRealizer).getName());
        YGFIOHandler.addEncoding(stringBuffer.toString() + "GenericEdgeRealizer", (class$y$view$GenericEdgeRealizer == null ? (class$y$view$GenericEdgeRealizer = YGFIOHandler.class$("y.view.GenericEdgeRealizer")) : class$y$view$GenericEdgeRealizer).getName());
        YGFIOHandler.addEncoding(stringBuffer.toString() + "ArcEdgeRealizer", (class$y$view$ArcEdgeRealizer == null ? (class$y$view$ArcEdgeRealizer = YGFIOHandler.class$("y.view.ArcEdgeRealizer")) : class$y$view$ArcEdgeRealizer).getName());
        YGFIOHandler.addEncoding(stringBuffer.toString() + "BezierEdgeRealizer", (class$y$view$BezierEdgeRealizer == null ? (class$y$view$BezierEdgeRealizer = YGFIOHandler.class$("y.view.BezierEdgeRealizer")) : class$y$view$BezierEdgeRealizer).getName());
        YGFIOHandler.addEncoding(stringBuffer.toString() + "SplineEdgeRealizer", (class$y$view$SplineEdgeRealizer == null ? (class$y$view$SplineEdgeRealizer = YGFIOHandler.class$("y.view.SplineEdgeRealizer")) : class$y$view$SplineEdgeRealizer).getName());
        YGFIOHandler.addEncoding(stringBuffer.toString() + "Port", (class$y$view$Port == null ? (class$y$view$Port = YGFIOHandler.class$("y.view.Port")) : class$y$view$Port).getName());
        YGFIOHandler.addEncoding(stringBuffer.toString() + "InterfacePort", (class$y$view$InterfacePort == null ? (class$y$view$InterfacePort = YGFIOHandler.class$("y.view.InterfacePort")) : class$y$view$InterfacePort).getName());
        YGFIOHandler.addEncoding(stringBuffer.toString() + "tabular.TableStyle.SimpleStyle", (class$y$view$tabular$TableStyle$SimpleStyle == null ? (class$y$view$tabular$TableStyle$SimpleStyle = YGFIOHandler.class$("y.view.tabular.TableStyle$SimpleStyle")) : class$y$view$tabular$TableStyle$SimpleStyle).getName());
        stringBuffer.setLength(0);
        stringBuffer.append("demo.uml.");
        YGFIOHandler.addEncoding(stringBuffer.toString() + "ClassNodeRealizer", "demo.uml.ClassNodeRealizer");
        YGFIOHandler.addEncoding(stringBuffer.toString() + "NoteNodeRealizer", "demo.uml.NoteNodeRealizer");
        encode2decodeMap.put(stringBuffer.toString() + "UMLClassNodeRealizer", "demo.uml.ClassNodeRealizer");
        encode2decodeMap.put(stringBuffer.toString() + "UMLNoteNodeRealizer", "demo.uml.NoteNodeRealizer");
    }

    public static interface DataHandler {
        public void readData(Graph2D var1, Object var2, ObjectInputStream var3) throws IOException;

        public void writeData(Graph2D var1, Object var2, ObjectOutputStream var3) throws IOException;
    }
}

