/*
 * Decompiled with CFR 0.152.
 */
package y.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import y.io.GraphMLIOHandler;
import y.view.Graph2D;

public class ZipGraphMLIOHandler
extends GraphMLIOHandler {
    public String getFileFormatString() {
        return "Zipped GraphML file";
    }

    public String getFileNameExtension() {
        return "graphmlz";
    }

    public void read(Graph2D graph2D, InputStream inputStream) throws IOException {
        GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
        super.read(graph2D, gZIPInputStream);
    }

    public void write(Graph2D graph2D, OutputStream outputStream) throws IOException {
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);
        super.write(graph2D, gZIPOutputStream);
        gZIPOutputStream.finish();
    }
}

