/*
 * Decompiled with CFR 0.152.
 */
package y.io.gml;

import java.io.IOException;
import y.base.Edge;
import y.io.gml.GMLEncoder;
import y.io.gml.ItemParser;
import y.io.gml.ObjectEncoder;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.NodeRealizer;
import y.view.Port;

public class EdgeObjectEncoder
implements ObjectEncoder {
    private ObjectEncoder g;
    private ObjectEncoder h;

    public EdgeObjectEncoder() {
        this(null, null);
    }

    public EdgeObjectEncoder(ObjectEncoder objectEncoder, ObjectEncoder objectEncoder2) {
        this.g = objectEncoder;
        this.h = objectEncoder2;
    }

    public void encode(Object object, GMLEncoder gMLEncoder) throws IOException {
        Port port;
        int n2 = ItemParser.z;
        Edge edge = (Edge)object;
        Graph2D graph2D = (Graph2D)edge.getGraph();
        EdgeRealizer edgeRealizer = graph2D.getRealizer(edge);
        gMLEncoder.addAttribute("source", edge.source().index());
        gMLEncoder.addAttribute("target", edge.target().index());
        if (edgeRealizer.labelCount() > 0) {
            gMLEncoder.addAttribute("label", edgeRealizer.getLabel(0).getText());
        }
        if (this.g != null) {
            gMLEncoder.beginSection("graphics");
            this.g.encode(edgeRealizer, gMLEncoder);
            gMLEncoder.endSection();
        }
        boolean bl = (port = edgeRealizer.getTargetPort()).getOffsetX() != 0.0 || port.getOffsetY() != 0.0;
        port = edgeRealizer.getSourcePort();
        if (bl |= port.getOffsetX() != 0.0 || port.getOffsetY() != 0.0) {
            NodeRealizer nodeRealizer = graph2D.getRealizer(edge.source());
            NodeRealizer nodeRealizer2 = graph2D.getRealizer(edge.target());
            gMLEncoder.beginSection("edgeAnchor");
            if (port.getOffsetX() != 0.0 && nodeRealizer.getWidth() > 0.0) {
                gMLEncoder.addAttribute("xSource", 2.0 * port.getOffsetX() / nodeRealizer.getWidth());
            }
            if (port.getOffsetY() != 0.0 && nodeRealizer.getHeight() > 0.0) {
                gMLEncoder.addAttribute("ySource", 2.0 * port.getOffsetY() / nodeRealizer.getHeight());
            }
            if ((port = edgeRealizer.getTargetPort()).getOffsetX() != 0.0 && nodeRealizer2.getWidth() > 0.0) {
                gMLEncoder.addAttribute("xTarget", 2.0 * port.getOffsetX() / nodeRealizer2.getWidth());
            }
            if (port.getOffsetY() != 0.0 && nodeRealizer2.getHeight() > 0.0) {
                gMLEncoder.addAttribute("yTarget", 2.0 * port.getOffsetY() / nodeRealizer2.getHeight());
            }
            gMLEncoder.endSection();
        }
        if (edgeRealizer.labelCount() > 0 && this.h != null) {
            for (int i2 = 0; i2 < edgeRealizer.labelCount(); ++i2) {
                gMLEncoder.beginSection("LabelGraphics");
                this.h.encode(edgeRealizer.getLabel(i2), gMLEncoder);
                gMLEncoder.endSection();
                if (n2 == 0) continue;
            }
        }
    }

    public ObjectEncoder getLabelEncoder() {
        return this.h;
    }

    public void setLabelEncoder(ObjectEncoder objectEncoder) {
        this.h = objectEncoder;
    }

    public ObjectEncoder getRealizerEncoder() {
        return this.g;
    }

    public void setRealizerEncoder(ObjectEncoder objectEncoder) {
        this.g = objectEncoder;
    }
}

