/*
 * Decompiled with CFR 0.152.
 */
package y.io.gml;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import y.io.gml.GMLEncoder;
import y.io.gml.ItemParser;
import y.util.D;

public class GMLTokenizer {
    private Callback b;
    protected static final int OPEN = 0;
    protected static final int CLOSE = 1;
    protected static final int AMPERSAND = 2;
    protected static final int QUOTE = 3;
    protected static final int WHITESPACE = 4;
    protected static final int LETTER = 5;
    protected static final int DIGIT = 6;
    protected static final int EOF = 7;
    protected static final int NEWLINE = 8;
    protected static final int COMMENT = 9;
    protected static final int UNKNOWN = -1;

    public GMLTokenizer() {
        this(null);
    }

    public GMLTokenizer(Callback callback) {
        this.setCallback(callback);
    }

    public void parse(Reader reader) throws IOException {
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        PushbackReader pushbackReader = new PushbackReader(lineNumberReader);
        try {
            this.parse(pushbackReader);
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("Parse error at line " + (lineNumberReader.getLineNumber() + 1) + ": " + iOException.getMessage());
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    protected int lookAhead(PushbackReader pushbackReader) throws IOException {
        int n2 = pushbackReader.read();
        if (n2 == -1) {
            return 7;
        }
        pushbackReader.unread(n2);
        return this.classify((char)n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void parse(PushbackReader pushbackReader) throws IOException {
        int n2;
        block11: {
            int n3 = ItemParser.z;
            n2 = this.lookAhead(pushbackReader);
            while (n2 == 9) {
                this.parseComment(pushbackReader);
                n2 = this.lookAhead(pushbackReader);
                if (n3 != 0) return;
                if (n3 == 0) continue;
            }
            block1: while (n2 != 7) {
                n2 = this.lookAhead(pushbackReader);
                if (n2 == 4) {
                    this.parseWhiteSpace(pushbackReader);
                    if (n3 == 0) continue;
                }
                if (n2 == 8) {
                    this.parseWhiteSpace(pushbackReader);
                    n2 = this.lookAhead(pushbackReader);
                    do {
                        if (n2 != 9) continue block1;
                        this.parseComment(pushbackReader);
                        n2 = this.lookAhead(pushbackReader);
                        if (n3 != 0) return;
                    } while (n3 == 0);
                }
                if (n2 == 5) {
                    Object object;
                    String string2 = this.parseKey(pushbackReader);
                    this.parseWhiteSpace(pushbackReader);
                    n2 = this.lookAhead(pushbackReader);
                    if (n2 == 0) {
                        this.b.beginScope(string2);
                        pushbackReader.read();
                        this.parse(pushbackReader);
                        this.b.endScope(string2);
                        if (n3 == 0) continue;
                    }
                    if ((object = this.parseValue(pushbackReader)) instanceof String) {
                        this.b.attribute(string2, (String)object);
                        if (n3 == 0) continue;
                    }
                    if (!(object instanceof Number)) continue;
                    this.b.attribute(string2, (Number)object);
                    if (n3 == 0) {
                        continue;
                    }
                }
                break block11;
            }
            return;
        }
        if (n2 == 1) {
            pushbackReader.read();
            return;
        }
        if (n2 == -1) {
            throw new IOException("ParseException, did not find LETTER, EOF or ] but '" + (char)pushbackReader.read() + '\'');
        }
        if (n2 != 7) throw new IOException("Malformed GML! Did not find LETTER, EOF or ] but '" + (char)pushbackReader.read() + '\'');
    }

    protected int classify(char c2) {
        switch (c2) {
            case '[': {
                return 0;
            }
            case ']': {
                return 1;
            }
            case '&': {
                return 2;
            }
            case '\"': {
                return 3;
            }
            case '#': {
                return 9;
            }
            case '+': 
            case '-': 
            case '.': {
                return 6;
            }
            case '\n': 
            case '\f': 
            case '\r': {
                return 8;
            }
        }
        if (Character.isWhitespace(c2)) {
            return 4;
        }
        if (Character.isDigit(c2)) {
            return 6;
        }
        if (Character.isLetter(c2)) {
            return 5;
        }
        return -1;
    }

    protected void parseWhiteSpace(PushbackReader pushbackReader) throws IOException {
        int n2 = ItemParser.z;
        int n3 = pushbackReader.read();
        while (n3 != -1) {
            int n4;
            block7: {
                n4 = this.classify((char)n3);
                if (n4 == 4) {
                    n3 = pushbackReader.read();
                    if (n2 == 0) continue;
                }
                if (n4 == 8) {
                    while (n4 == 8) {
                        n3 = pushbackReader.read();
                        n4 = this.classify((char)n3);
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                        }
                        break block7;
                    }
                    if (n4 == 9) {
                        pushbackReader.unread(n3);
                        this.parseComment(pushbackReader);
                        n3 = pushbackReader.read();
                        if (n2 == 0) continue;
                    }
                }
            }
            if (n4 == 4) continue;
        }
        if (n3 != -1) {
            pushbackReader.unread(n3);
        }
    }

    protected void parseComment(PushbackReader pushbackReader) throws IOException {
        int n2 = ItemParser.z;
        int n3 = pushbackReader.read();
        if ((char)n3 != '#') {
            throw new IOException("ParseException: expected # but found: " + n3);
        }
        n3 = pushbackReader.read();
        int n4 = this.classify((char)n3);
        while (n4 != 8 && n4 != 7) {
            n3 = pushbackReader.read();
            n4 = this.classify((char)n3);
            if (n2 == 0) continue;
        }
        pushbackReader.unread(n3);
    }

    protected String parseKey(PushbackReader pushbackReader) throws IOException {
        int n2;
        int n3;
        StringBuffer stringBuffer;
        block3: {
            int n4 = ItemParser.z;
            stringBuffer = new StringBuffer(20);
            n3 = pushbackReader.read();
            while (n3 != -1) {
                n2 = Character.isWhitespace((char)n3) ? 1 : 0;
                if (n4 == 0) {
                    if (n2 != 0) break;
                    stringBuffer.append((char)n3);
                    n3 = pushbackReader.read();
                    if (n4 == 0) continue;
                }
                break block3;
            }
            n2 = n3;
        }
        if (n2 != -1) {
            pushbackReader.unread(n3);
        }
        return stringBuffer.toString();
    }

    protected Object parseValue(PushbackReader pushbackReader) throws IOException {
        int n2 = this.lookAhead(pushbackReader);
        if (n2 == 3) {
            return this.parseString(pushbackReader);
        }
        if (n2 == 0) {
            return this.parseList(pushbackReader);
        }
        if (n2 == 6) {
            return this.parseNumber(pushbackReader);
        }
        throw new IOException("ParseException, did not find QUOTE, OPEN or DIGIT but '" + Character.toString((char)pushbackReader.read()) + "'");
    }

    protected Number parseNumber(PushbackReader pushbackReader) throws IOException {
        boolean bl;
        StringBuffer stringBuffer;
        block7: {
            int n2 = ItemParser.z;
            stringBuffer = new StringBuffer(10);
            int n3 = pushbackReader.read();
            boolean bl2 = true;
            while (!Character.isWhitespace((char)n3)) {
                bl = bl2;
                if (n2 == 0) {
                    if (bl) {
                        switch (n3) {
                            case 43: 
                            case 46: 
                            case 69: 
                            case 101: {
                                bl2 = false;
                            }
                        }
                    }
                    stringBuffer.append((char)n3);
                    n3 = pushbackReader.read();
                    if (n2 == 0) continue;
                }
                break block7;
            }
            pushbackReader.unread(n3);
            bl = bl2;
        }
        if (bl) {
            return new Integer(stringBuffer.toString());
        }
        return new Double(stringBuffer.toString());
    }

    protected String parseString(PushbackReader pushbackReader) throws IOException {
        int n2 = pushbackReader.read();
        if ((char)n2 != '\"') {
            throw new IOException("Expected \" but found " + n2);
        }
        String string2 = this.parseInString(pushbackReader);
        n2 = pushbackReader.read();
        if ((char)n2 != '\"') {
            throw new IOException("Expected \" but found " + n2);
        }
        return string2;
    }

    protected String parseInString(PushbackReader pushbackReader) throws IOException {
        int n2 = ItemParser.z;
        StringBuffer stringBuffer = new StringBuffer(20);
        int n3 = pushbackReader.read();
        while ((char)n3 != '\"' && n3 != -1) {
            if ((char)n3 == '&') {
                pushbackReader.unread(n3);
                n3 = this.parseEntity(pushbackReader);
            }
            stringBuffer.append((char)n3);
            n3 = pushbackReader.read();
            if (n2 == 0) continue;
        }
        pushbackReader.unread(n3);
        return stringBuffer.toString();
    }

    protected char parseEntity(PushbackReader pushbackReader) throws IOException {
        int n2 = ItemParser.z;
        int n3 = pushbackReader.read();
        if ((char)n3 != '&') {
            throw new IOException("Expected & but found " + n3);
        }
        n3 = pushbackReader.read();
        StringBuffer stringBuffer = new StringBuffer(20);
        while ((char)n3 != ';' && n3 != -1) {
            if (Character.isLetterOrDigit((char)n3) || (char)n3 == '#') {
                stringBuffer.append((char)n3);
                n3 = pushbackReader.read();
                if (n2 == 0) continue;
            }
            throw new IOException("Expected #, letter, digit or ; but found '" + (char)n3 + "'");
        }
        String string2 = stringBuffer.toString();
        if (string2.equals("#13")) {
            return '\n';
        }
        if (string2.equals("para")) {
            return '\n';
        }
        if (string2.equals("amp")) {
            return '&';
        }
        if (string2.equals("quot")) {
            return '\"';
        }
        if (string2.startsWith("#x")) {
            String string3 = string2.substring(2);
            return (char)Integer.parseInt(string3, 16);
        }
        if (string2.startsWith("#0x")) {
            String string4 = string2.substring(3);
            return (char)Integer.parseInt(string4, 16);
        }
        if (string2.startsWith("#")) {
            String string5 = string2.substring(1);
            return (char)Integer.parseInt(string5);
        }
        return '?';
    }

    protected List parseList(PushbackReader pushbackReader) throws IOException {
        return new ArrayList(0);
    }

    public Callback getCallback() {
        return this.b;
    }

    public void setCallback(Callback callback) {
        this.b = callback;
    }

    public static final class EncoderCallback
    implements Callback {
        private GMLEncoder b;

        public EncoderCallback(GMLEncoder gMLEncoder) {
            this.b = gMLEncoder;
        }

        public void beginScope(String string2) {
            try {
                this.b.beginSection(string2);
            }
            catch (IOException iOException) {
                D.trace(iOException);
            }
        }

        public void endScope(String string2) {
            try {
                this.b.endSection();
            }
            catch (IOException iOException) {
                D.trace(iOException);
            }
        }

        public void attribute(String string2, String string3) {
            try {
                this.b.addAttribute(string2, string3);
            }
            catch (IOException iOException) {
                D.trace(iOException);
            }
        }

        public void attribute(String string2, Number number) {
            try {
                this.b.addAttribute(string2, number);
            }
            catch (IOException iOException) {
                D.trace(iOException);
            }
        }
    }

    public static final class DebugCallback
    implements Callback {
        public void beginScope(String string2) {
            System.out.println("begin scope " + string2);
        }

        public void endScope(String string2) {
            System.out.println("end scope " + string2);
        }

        public void attribute(String string2, String string3) {
            System.out.println("string attribute " + string2 + " => " + string3);
        }

        public void attribute(String string2, Number number) {
            System.out.println("Number attribute " + string2 + " => " + number);
        }
    }

    public static interface Callback {
        public void beginScope(String var1);

        public void endScope(String var1);

        public void attribute(String var1, String var2);

        public void attribute(String var1, Number var2);
    }
}

