/*
 * Decompiled with CFR 0.152.
 */
package y.io.gml;

import java.awt.Color;
import java.io.IOException;
import y.io.GMLIOHandler;
import y.io.gml.GMLEncoder;
import y.io.gml.NodeLabelGraphicsEncoder;
import y.io.gml.ObjectEncoder;
import y.util.D;
import y.util.ObjectStringConversion;
import y.view.YLabel;

public class LabelGraphicsEncoder
implements ObjectEncoder {
    public void encode(Object object, GMLEncoder gMLEncoder) throws IOException {
        YLabel yLabel = (YLabel)object;
        if (yLabel.getText() != null && !yLabel.getText().equals("")) {
            Object object2;
            gMLEncoder.addAttribute("text", yLabel.getText());
            if (yLabel.getLineColor() != null) {
                gMLEncoder.addAttribute("outline", GMLIOHandler.convertColor(yLabel.getLineColor()));
            }
            if (yLabel.getBackgroundColor() != null) {
                gMLEncoder.addAttribute("fill", GMLIOHandler.convertColor(yLabel.getBackgroundColor()));
            }
            if (yLabel.getTextColor() != null && !yLabel.getTextColor().equals(Color.black)) {
                gMLEncoder.addAttribute("color", GMLIOHandler.convertColor(yLabel.getTextColor()));
            }
            gMLEncoder.addAttribute("fontSize", yLabel.getFontSize());
            if (yLabel.getFontStyle() != 0) {
                gMLEncoder.addAttribute("fontStyle", LabelGraphicsEncoder.encodeFontStyle(yLabel.getFontStyle()));
            }
            gMLEncoder.addAttribute("fontName", yLabel.getFontName());
            if (yLabel.getAlignment() != 1) {
                gMLEncoder.addAttribute("alignment", LabelGraphicsEncoder.encodeAlignment(yLabel.getAlignment()));
            }
            if (yLabel.getRotationAngle() != 0.0) {
                double d2 = yLabel.getRotationAngle();
                gMLEncoder.addAttribute("rotationAngle", d2);
            }
            if (yLabel.getConfiguration() != null && !"default".equals(yLabel.getConfiguration())) {
                gMLEncoder.addAttribute("configuration", yLabel.getConfiguration());
            }
            if (yLabel.getConfiguration() != null || yLabel.getAutoSizePolicy() == 4) {
                gMLEncoder.addAttribute("contentWidth", yLabel.getContentWidth());
                gMLEncoder.addAttribute("contentHeight", yLabel.getContentHeight());
            }
            if (yLabel.getAutoSizePolicy() != 0) {
                gMLEncoder.addAttribute("autoSizePolicy", NodeLabelGraphicsEncoder.encodeAutoSizePolicy(yLabel.getAutoSizePolicy()));
            }
            if ((object2 = yLabel.getUserData()) != null) {
                try {
                    String string2 = ObjectStringConversion.getInstance().convertToString(yLabel.getUserData(), yLabel.getUserData().getClass());
                    gMLEncoder.addAttribute("userdataclass", yLabel.getUserData().getClass().getName());
                    gMLEncoder.addAttribute("userdata", string2);
                }
                catch (Exception exception) {
                    D.bug("Could not write userdata " + yLabel.getUserData() + " " + exception);
                }
            }
            if (yLabel.isUnderlinedTextEnabled()) {
                gMLEncoder.addAttribute("underlineText", true);
            }
            if (!yLabel.isVisible()) {
                gMLEncoder.addAttribute("visible", false);
            }
        }
    }

    public static String encodeFontStyle(int n2) {
        if (n2 == 3) {
            return "bolditalic";
        }
        switch (n2) {
            case 0: {
                return "plain";
            }
            case 2: {
                return "italic";
            }
            case 1: {
                return "bold";
            }
        }
        return "plain";
    }

    public static String encodeAlignment(byte by) {
        switch (by) {
            case 0: {
                return "left";
            }
            case 2: {
                return "right";
            }
        }
        return "center";
    }
}

