/*
 * Decompiled with CFR 0.152.
 */
package y.io.graphml.graph2d;

import java.awt.geom.Point2D;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import y.base.Edge;
import y.base.Graph;
import y.geom.OrientedRectangle;
import y.io.gml.LabelGraphicsParser;
import y.io.graphml.graph2d.AbstractEdgeRealizerSerializer;
import y.io.graphml.graph2d.AbstractNodeRealizerSerializer;
import y.io.graphml.graph2d.GraphicsSerializationToolkit;
import y.io.graphml.input.DeserializationEvent;
import y.io.graphml.input.DeserializationHandler;
import y.io.graphml.input.GraphMLParseContext;
import y.io.graphml.input.GraphMLParseException;
import y.io.graphml.input.XPathUtils;
import y.layout.EdgeLabelModel;
import y.layout.PreferredPlacementDescriptor;
import y.layout.RotatedDiscreteEdgeLabelModel;
import y.layout.RotatedSliderEdgeLabelModel;
import y.view.EdgeLabel;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.SmartEdgeLabelModel;
import y.view.YLabel;

public class EdgeLabelDeserializer
implements DeserializationHandler {
    static final Map eb = LabelGraphicsParser.edgeLabelPosMap;
    static final Map fb = LabelGraphicsParser.edgeLabelModelMap;
    static final Map gb = LabelGraphicsParser.edgeLabelPrefMap;
    static /* synthetic */ Class class$y$io$graphml$graph2d$EdgeLabelDeserializer$ConfigurationFactory;

    protected void parseEdgeLabel(GraphMLParseContext graphMLParseContext, Node node, EdgeLabel edgeLabel) throws GraphMLParseException {
        GraphicsSerializationToolkit.b(node, edgeLabel, new _b(), graphMLParseContext);
        this.parseLabelModel(graphMLParseContext, node, edgeLabel);
        this.b(graphMLParseContext, node, edgeLabel);
        this.parsePreferredPlacementDescriptor(graphMLParseContext, node, edgeLabel);
    }

    protected void parsePreferredPlacementDescriptor(GraphMLParseContext graphMLParseContext, Node node, EdgeLabel edgeLabel) throws GraphMLParseException {
        Node node2 = XPathUtils.selectFirstChildElement(node, "PreferredPlacementDescriptor", "http://www.yworks.com/xml/graphml");
        Object object = null;
        if (node2 != null) {
            object = graphMLParseContext.deserialize(node2);
        }
        if (object != null) {
            edgeLabel.setPreferredPlacementDescriptor((PreferredPlacementDescriptor)object);
        }
    }

    protected void parseLabelModel(GraphMLParseContext graphMLParseContext, Node node, EdgeLabel edgeLabel) throws GraphMLParseException {
        block12: {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string2;
            Node node2;
            NamedNodeMap namedNodeMap;
            block13: {
                namedNodeMap = node.getAttributes();
                node2 = namedNodeMap.getNamedItem("modelName");
                if (node2 == null) break block12;
                string2 = node2.getNodeValue();
                if (!"custom".equals(string2)) break block13;
                object4 = XPathUtils.selectFirstChildElement(node, "LabelModel", "http://www.yworks.com/xml/graphml");
                object3 = null;
                if (object4 != null) {
                    object3 = graphMLParseContext.deserialize(XPathUtils.selectFirstSignificantChild(object4));
                }
                object2 = XPathUtils.selectFirstChildElement(node, "ModelParameter", "http://www.yworks.com/xml/graphml");
                object = null;
                if (object2 != null) {
                    object = graphMLParseContext.deserialize(XPathUtils.selectFirstSignificantChild((Node)object2));
                }
                if (!(object3 instanceof EdgeLabelModel)) break block12;
                edgeLabel.setLabelModel((EdgeLabelModel)object3, object);
                if (AbstractNodeRealizerSerializer.z == 0) break block12;
            }
            if ((object4 = fb.get(string2)) instanceof Byte) {
                edgeLabel.setModel((Byte)object4);
            }
            if ((node2 = namedNodeMap.getNamedItem("distance")) != null) {
                edgeLabel.setDistance(Double.parseDouble(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("ratio")) != null) {
                edgeLabel.setRatio(Double.parseDouble(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("modelPosition")) != null && (object4 = eb.get(node2.getNodeValue())) instanceof Byte) {
                edgeLabel.setPosition((Byte)object4);
            }
            if ((node2 = namedNodeMap.getNamedItem("preferredPlacement")) != null && (object4 = gb.get(node2.getNodeValue())) instanceof Byte) {
                edgeLabel.setPreferredPlacement((Byte)object4);
            }
            if (edgeLabel.getModel() == 6 || edgeLabel.getModel() == 5) {
                double d2;
                double d3;
                Object object5;
                object4 = namedNodeMap.getNamedItem("x");
                object3 = namedNodeMap.getNamedItem("y");
                if (object4 != null && object3 != null && (object2 = edgeLabel.getOwner()) != null && (object5 = edgeLabel.getBestModelParameterForLocation(d3 = ((Point2D)(object = ((EdgeRealizer)object2).getSourceIntersection())).getX() + Double.parseDouble(object4.getNodeValue()), d2 = ((Point2D)object).getY() + Double.parseDouble(object3.getNodeValue()))) != null) {
                    edgeLabel.setModelParameter(object5);
                }
            }
        }
    }

    private void b(GraphMLParseContext graphMLParseContext, Node node, EdgeLabel edgeLabel) {
        Point2D point2D;
        OrientedRectangle orientedRectangle;
        EdgeRealizer edgeRealizer;
        if (edgeLabel.getModel() == 4 && (edgeRealizer = edgeLabel.getOwner()) != null && (orientedRectangle = GraphicsSerializationToolkit.b(node, (point2D = edgeRealizer.getSourceIntersection()).getX(), point2D.getY())) != null) {
            edgeLabel.setModelParameter(edgeLabel.getLabelModel().createModelParameter(orientedRectangle, edgeRealizer, edgeRealizer.getSourceRealizer(), edgeRealizer.getTargetRealizer()));
        }
    }

    protected EdgeLabel createLabel(GraphMLParseContext graphMLParseContext, Node node) {
        Object object;
        Object object2 = graphMLParseContext.getCurrentObject();
        Graph graph = graphMLParseContext.getGraph();
        if (object2 instanceof Edge && graph instanceof Graph2D && (object = graphMLParseContext.getDeserializationProperty(AbstractEdgeRealizerSerializer.c)) instanceof EdgeRealizer) {
            EdgeRealizer edgeRealizer = (EdgeRealizer)object;
            EdgeLabel edgeLabel = edgeRealizer.createEdgeLabel();
            if (edgeLabel != null) {
                edgeRealizer.addLabel(edgeLabel);
            }
            return edgeLabel;
        }
        return new EdgeLabel();
    }

    public void onHandleDeserialization(DeserializationEvent deserializationEvent) throws GraphMLParseException {
        Node node = deserializationEvent.getXmlNode();
        if (node.getNodeType() == 1 && "EdgeLabel".equals(node.getLocalName()) && "http://www.yworks.com/xml/graphml".equals(node.getNamespaceURI())) {
            EdgeLabel edgeLabel = this.createLabel(deserializationEvent.getContext(), node);
            this.parseEdgeLabel(deserializationEvent.getContext(), node, edgeLabel);
            deserializationEvent.setResult(edgeLabel);
        }
    }

    private static byte j(String string2) {
        String string3 = string2.toLowerCase();
        if ("center".equals(string3)) {
            return 0;
        }
        if ("left".equals(string3)) {
            return 2;
        }
        if ("right".equals(string3)) {
            return 1;
        }
        try {
            return Byte.parseByte(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class _b
    implements GraphicsSerializationToolkit._b {
        private _b() {
        }

        public boolean b(YLabel yLabel, Node node, GraphMLParseContext graphMLParseContext) {
            EdgeLabel edgeLabel = (EdgeLabel)yLabel;
            ConfigurationFactory configurationFactory = (ConfigurationFactory)graphMLParseContext.lookup(class$y$io$graphml$graph2d$EdgeLabelDeserializer$ConfigurationFactory == null ? (class$y$io$graphml$graph2d$EdgeLabelDeserializer$ConfigurationFactory = EdgeLabelDeserializer.class$("y.io.graphml.graph2d.EdgeLabelDeserializer$ConfigurationFactory")) : class$y$io$graphml$graph2d$EdgeLabelDeserializer$ConfigurationFactory);
            if (configurationFactory != null) {
                configurationFactory.createConfiguration(edgeLabel, node, graphMLParseContext);
                return true;
            }
            return false;
        }
    }

    public static class PreferredPlacementDescriptorDeserializer
    implements DeserializationHandler {
        private static final String db = "|";

        public void onHandleDeserialization(DeserializationEvent deserializationEvent) throws GraphMLParseException {
            String string2;
            Node node = deserializationEvent.getXmlNode();
            if (node.getNodeType() == 1 && "http://www.yworks.com/xml/graphml".equals(node.getNamespaceURI()) && "PreferredPlacementDescriptor".equals(string2 = node.getLocalName())) {
                deserializationEvent.setResult(this.createPreferredPlacementDescriptor(node, deserializationEvent.getContext()));
            }
        }

        protected Object createPreferredPlacementDescriptor(Node node, GraphMLParseContext graphMLParseContext) {
            byte by;
            byte by2;
            byte by3;
            PreferredPlacementDescriptor preferredPlacementDescriptor;
            PreferredPlacementDescriptor preferredPlacementDescriptor2 = new PreferredPlacementDescriptor();
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("placement");
            if (node2 != null) {
                preferredPlacementDescriptor2.setPlaceAlongEdge(PreferredPlacementDescriptorDeserializer.f(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("side")) != null) {
                preferredPlacementDescriptor2.setSideOfEdge(PreferredPlacementDescriptorDeserializer.e(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("sideReference")) != null) {
                preferredPlacementDescriptor2.setSideReference(PreferredPlacementDescriptorDeserializer.h(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("angle")) != null) {
                try {
                    preferredPlacementDescriptor2.setAngle(Double.parseDouble(node2.getNodeValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((node2 = namedNodeMap.getNamedItem("angleReference")) != null) {
                preferredPlacementDescriptor2.setAngleReference(PreferredPlacementDescriptorDeserializer.i(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("angleRotationOnRightSide")) != null) {
                preferredPlacementDescriptor2.setAngleRotationOnRightSide(PreferredPlacementDescriptorDeserializer.d(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("angleOffsetOnRightSide")) != null) {
                preferredPlacementDescriptor2.setAngleOffsetOnRightSide(PreferredPlacementDescriptorDeserializer.g(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("distance")) != null) {
                try {
                    preferredPlacementDescriptor2.setDistanceToEdge(Double.parseDouble(node2.getNodeValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((node2 = namedNodeMap.getNamedItem("frozen")) != null && "true".equalsIgnoreCase(node2.getNodeValue())) {
                preferredPlacementDescriptor2.freeze();
            }
            if (preferredPlacementDescriptor2.isFrozen() && preferredPlacementDescriptor2.equals(preferredPlacementDescriptor = PreferredPlacementDescriptor.newSharedInstance(by3 = (byte)((by2 = preferredPlacementDescriptor2.getPlaceAlongEdge()) | (by = preferredPlacementDescriptor2.getSideOfEdge()))))) {
                return preferredPlacementDescriptor;
            }
            return preferredPlacementDescriptor2;
        }

        private static byte f(String string2) {
            byte by;
            block5: {
                int n2 = AbstractNodeRealizerSerializer.z;
                String string3 = string2.toLowerCase();
                if ("anywhere".equals(string3)) {
                    return 0;
                }
                byte by2 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, db);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if ("source".equals(string4)) {
                        by2 = (byte)(by2 | 1);
                        if (n2 == 0) continue;
                    }
                    if ("center".equals(string4)) {
                        by2 = (byte)(by2 | 4);
                        if (n2 == 0) continue;
                    }
                    if (!"target".equals(string4)) continue;
                    by = (byte)(by2 | 2);
                    if (n2 == 0) {
                        by2 = by;
                        if (n2 == 0) continue;
                    }
                    break block5;
                }
                by = by2;
            }
            return by;
        }

        private static byte e(String string2) {
            byte by;
            block5: {
                int n2 = AbstractNodeRealizerSerializer.z;
                String string3 = string2.toLowerCase();
                if ("anywhere".equals(string3)) {
                    return 0;
                }
                byte by2 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, db);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if ("left".equals(string4)) {
                        by2 = (byte)(by2 | 0x10);
                        if (n2 == 0) continue;
                    }
                    if ("on_edge".equals(string4)) {
                        by2 = (byte)(by2 | 8);
                        if (n2 == 0) continue;
                    }
                    if (!"right".equals(string4)) continue;
                    by = (byte)(by2 | 0x20);
                    if (n2 == 0) {
                        by2 = by;
                        if (n2 == 0) continue;
                    }
                    break block5;
                }
                by = by2;
            }
            return by;
        }

        private static byte h(String string2) {
            byte by;
            block4: {
                int n2 = AbstractNodeRealizerSerializer.z;
                byte by2 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string2.toLowerCase(), db);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if ("absolute_left_in_north".equals(string3)) {
                        by2 = (byte)(by2 | 2);
                        if (n2 == 0) continue;
                    }
                    if ("absolute_right_in_north".equals(string3)) {
                        by2 = (byte)(by2 | 4);
                        if (n2 == 0) continue;
                    }
                    if (!"relative_to_edge_flow".equals(string3)) continue;
                    by = (byte)(by2 | 1);
                    if (n2 == 0) {
                        by2 = by;
                        if (n2 == 0) continue;
                    }
                    break block4;
                }
                by = by2;
            }
            return by;
        }

        private static byte i(String string2) {
            byte by;
            block3: {
                int n2 = AbstractNodeRealizerSerializer.z;
                byte by2 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string2.toLowerCase(), db);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if ("absolute".equals(string3)) {
                        by2 = (byte)(by2 | 1);
                        if (n2 == 0) continue;
                    }
                    if (!"relative_to_edge_flow".equals(string3)) continue;
                    by = (byte)(by2 | 2);
                    if (n2 == 0) {
                        by2 = by;
                        if (n2 == 0) continue;
                    }
                    break block3;
                }
                by = by2;
            }
            return by;
        }

        private static byte d(String string2) {
            byte by;
            block3: {
                int n2 = AbstractNodeRealizerSerializer.z;
                byte by2 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string2.toLowerCase(), db);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if ("co".equals(string3)) {
                        by2 = (byte)(by2 | 1);
                        if (n2 == 0) continue;
                    }
                    if (!"counter".equals(string3)) continue;
                    by = (byte)(by2 | 2);
                    if (n2 == 0) {
                        by2 = by;
                        if (n2 == 0) continue;
                    }
                    break block3;
                }
                by = by2;
            }
            return by;
        }

        private static byte g(String string2) {
            byte by;
            block3: {
                int n2 = AbstractNodeRealizerSerializer.z;
                byte by2 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string2.toLowerCase(), db);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if ("0".equals(string3)) {
                        by2 = (byte)(by2 | 1);
                        if (n2 == 0) continue;
                    }
                    if (!"180".equals(string3)) continue;
                    by = (byte)(by2 | 2);
                    if (n2 == 0) {
                        by2 = by;
                        if (n2 == 0) continue;
                    }
                    break block3;
                }
                by = by2;
            }
            return by;
        }
    }

    public static class SmartEdgeLabelModelDeserializer
    implements DeserializationHandler {
        public void onHandleDeserialization(DeserializationEvent deserializationEvent) throws GraphMLParseException {
            block4: {
                String string2;
                Node node;
                block5: {
                    node = deserializationEvent.getXmlNode();
                    if (node.getNodeType() != 1 || !"http://www.yworks.com/xml/graphml".equals(node.getNamespaceURI())) break block4;
                    string2 = node.getLocalName();
                    if (!"SmartEdgeLabelModel".equals(string2)) break block5;
                    deserializationEvent.setResult(this.createModel(node, deserializationEvent.getContext()));
                    if (AbstractNodeRealizerSerializer.z == 0) break block4;
                }
                if ("SmartEdgeLabelModelParameter".equals(string2)) {
                    deserializationEvent.setResult(this.createParameter(node, deserializationEvent.getContext()));
                }
            }
        }

        protected Object createParameter(Node node, GraphMLParseContext graphMLParseContext) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("segment");
            int n2 = 0;
            if (node2 != null) {
                try {
                    n2 = Integer.parseInt(node2.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 0;
                }
            }
            node2 = namedNodeMap.getNamedItem("ratio");
            double d2 = 0.0;
            if (node2 != null) {
                try {
                    d2 = Double.parseDouble(node2.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    d2 = 0.0;
                }
            }
            node2 = namedNodeMap.getNamedItem("distance");
            double d3 = 0.0;
            if (node2 != null) {
                try {
                    d3 = Double.parseDouble(node2.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    d3 = 0.0;
                }
            }
            node2 = namedNodeMap.getNamedItem("distanceToCenter");
            boolean bl = false;
            if (node2 != null) {
                bl = Boolean.valueOf(node2.getNodeValue());
            }
            node2 = namedNodeMap.getNamedItem("position");
            byte by = 0;
            if (node2 != null) {
                by = EdgeLabelDeserializer.j(node2.getNodeValue());
            }
            node2 = namedNodeMap.getNamedItem("angle");
            double d4 = 0.0;
            if (node2 != null) {
                try {
                    d4 = Double.parseDouble(node2.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    d4 = 0.0;
                }
            }
            return new SmartEdgeLabelModel.ModelParameter(n2, d2, d3, bl, by, d4);
        }

        protected Object createModel(Node node, GraphMLParseContext graphMLParseContext) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            SmartEdgeLabelModel smartEdgeLabelModel = new SmartEdgeLabelModel();
            Node node2 = namedNodeMap.getNamedItem("defaultAngle");
            double d2 = 0.0;
            if (node2 != null) {
                try {
                    d2 = Double.parseDouble(node2.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    d2 = 0.0;
                }
            }
            smartEdgeLabelModel.setDefaultAngle(d2);
            node2 = namedNodeMap.getNamedItem("defaultDistance");
            double d3 = 10.0;
            if (node2 != null) {
                try {
                    d3 = Double.parseDouble(node2.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    d3 = 10.0;
                }
            }
            smartEdgeLabelModel.setDefaultDistance(d3);
            node2 = namedNodeMap.getNamedItem("autoRotationEnabled");
            boolean bl = false;
            if (node2 != null) {
                bl = Boolean.valueOf(node2.getNodeValue());
            }
            smartEdgeLabelModel.setAutoRotationEnabled(bl);
            node2 = namedNodeMap.getNamedItem("autoFlippingEnabled");
            boolean bl2 = false;
            if (node2 != null) {
                bl2 = Boolean.valueOf(node2.getNodeValue());
            }
            smartEdgeLabelModel.setAutoFlippingEnabled(bl2);
            return smartEdgeLabelModel;
        }
    }

    public static class RotatedSliderEdgeLabelModelDeserializer
    implements DeserializationHandler {
        public void onHandleDeserialization(DeserializationEvent deserializationEvent) throws GraphMLParseException {
            block4: {
                String string2;
                Node node;
                block5: {
                    node = deserializationEvent.getXmlNode();
                    if (node.getNodeType() != 1 || !"http://www.yworks.com/xml/graphml".equals(node.getNamespaceURI())) break block4;
                    string2 = node.getLocalName();
                    if (!"RotatedSliderEdgeLabelModel".equals(string2)) break block5;
                    deserializationEvent.setResult(this.createModel(node, deserializationEvent.getContext()));
                    if (AbstractNodeRealizerSerializer.z == 0) break block4;
                }
                if ("RotatedSliderEdgeLabelModelParameter".equals(string2)) {
                    deserializationEvent.setResult(this.createParameter(node, deserializationEvent.getContext()));
                }
            }
        }

        protected Object createParameter(Node node, GraphMLParseContext graphMLParseContext) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("ratio");
            double d2 = 0.0;
            if (node2 != null) {
                try {
                    d2 = Double.parseDouble(node2.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    d2 = 0.0;
                }
            }
            node2 = namedNodeMap.getNamedItem("segment");
            int n2 = 0;
            if (node2 != null) {
                try {
                    n2 = Integer.parseInt(node2.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 0;
                }
            }
            node2 = namedNodeMap.getNamedItem("invertingSign");
            boolean bl = false;
            if (node2 != null) {
                bl = Boolean.valueOf(node2.getNodeValue());
            }
            return new RotatedSliderEdgeLabelModel.ModelParameter(n2, d2, bl);
        }

        protected Object createModel(Node node, GraphMLParseContext graphMLParseContext) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("mode");
            byte by = 0;
            if (node2 != null) {
                by = RotatedSliderEdgeLabelModelDeserializer.c(node2.getNodeValue());
            }
            RotatedSliderEdgeLabelModel rotatedSliderEdgeLabelModel = new RotatedSliderEdgeLabelModel(by);
            node2 = namedNodeMap.getNamedItem("distance");
            double d2 = 0.0;
            if (node2 != null) {
                try {
                    d2 = Double.parseDouble(node2.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    d2 = 0.0;
                }
            }
            rotatedSliderEdgeLabelModel.setDistance(d2);
            node2 = namedNodeMap.getNamedItem("autoRotationEnabled");
            boolean bl = false;
            if (node2 != null) {
                bl = Boolean.valueOf(node2.getNodeValue());
            }
            rotatedSliderEdgeLabelModel.setAutoRotationEnabled(bl);
            node2 = namedNodeMap.getNamedItem("autoFlippingEnabled");
            boolean bl2 = false;
            if (node2 != null) {
                bl2 = Boolean.valueOf(node2.getNodeValue());
            }
            rotatedSliderEdgeLabelModel.setAutoFlippingEnabled(bl2);
            node2 = namedNodeMap.getNamedItem("angle");
            double d3 = 0.0;
            if (node2 != null) {
                try {
                    d3 = Double.parseDouble(node2.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    d3 = 0.0;
                }
            }
            rotatedSliderEdgeLabelModel.setAngle(d3);
            node2 = namedNodeMap.getNamedItem("distanceRelativeToEdge");
            boolean bl3 = false;
            if (node2 != null) {
                bl3 = Boolean.valueOf(node2.getNodeValue());
            }
            rotatedSliderEdgeLabelModel.setDistanceRelativeToEdge(bl3);
            return rotatedSliderEdgeLabelModel;
        }

        private static byte c(String string2) {
            String string3 = string2.toLowerCase();
            if ("center_slider".equals(string3)) {
                return 0;
            }
            if ("side_slider".equals(string3)) {
                return 1;
            }
            if ("single_side_slider".equals(string3)) {
                return 2;
            }
            try {
                return Byte.parseByte(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
    }

    public static class RotatedDiscreteEdgeLabelModelDeserializer
    implements DeserializationHandler {
        public void onHandleDeserialization(DeserializationEvent deserializationEvent) throws GraphMLParseException {
            block4: {
                String string2;
                Node node;
                block5: {
                    node = deserializationEvent.getXmlNode();
                    if (node.getNodeType() != 1 || !"http://www.yworks.com/xml/graphml".equals(node.getNamespaceURI())) break block4;
                    string2 = node.getLocalName();
                    if (!"RotatedDiscreteEdgeLabelModel".equals(string2)) break block5;
                    deserializationEvent.setResult(this.createModel(node, deserializationEvent.getContext()));
                    if (AbstractNodeRealizerSerializer.z == 0) break block4;
                }
                if ("RotatedDiscreteEdgeLabelModelParameter".equals(string2)) {
                    deserializationEvent.setResult(this.createParameter(node, deserializationEvent.getContext()));
                }
            }
        }

        protected Object createParameter(Node node, GraphMLParseContext graphMLParseContext) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("position");
            int n2 = 128;
            if (node2 != null) {
                n2 = RotatedDiscreteEdgeLabelModelDeserializer.b(node2.getNodeValue());
            }
            return new RotatedDiscreteEdgeLabelModel.ModelParameter(n2);
        }

        private static int b(String string2) {
            String string3 = string2.toLowerCase();
            if ("shead".equals(string3)) {
                return 1;
            }
            if ("head".equals(string3)) {
                return 2;
            }
            if ("thead".equals(string3)) {
                return 4;
            }
            if ("stail".equals(string3)) {
                return 8;
            }
            if ("tail".equals(string3)) {
                return 16;
            }
            if ("ttail".equals(string3)) {
                return 32;
            }
            if ("scenter".equals(string3)) {
                return 64;
            }
            if ("center".equals(string3)) {
                return 128;
            }
            if ("tcenter".equals(string3)) {
                return 256;
            }
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return 128;
            }
        }

        protected Object createModel(Node node, GraphMLParseContext graphMLParseContext) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("candidateMask");
            int n2 = 63;
            if (node2 != null) {
                try {
                    n2 = Integer.parseInt(node2.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 63;
                }
            }
            RotatedDiscreteEdgeLabelModel rotatedDiscreteEdgeLabelModel = new RotatedDiscreteEdgeLabelModel(n2);
            node2 = namedNodeMap.getNamedItem("autoRotationEnabled");
            boolean bl = false;
            if (node2 != null) {
                bl = Boolean.valueOf(node2.getNodeValue());
            }
            rotatedDiscreteEdgeLabelModel.setAutoRotationEnabled(bl);
            node2 = namedNodeMap.getNamedItem("autoFlippingEnabled");
            boolean bl2 = false;
            if (node2 != null) {
                bl2 = Boolean.valueOf(node2.getNodeValue());
            }
            rotatedDiscreteEdgeLabelModel.setAutoFlippingEnabled(bl2);
            node2 = namedNodeMap.getNamedItem("angle");
            double d2 = 0.0;
            if (node2 != null) {
                try {
                    d2 = Double.parseDouble(node2.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    d2 = 0.0;
                }
            }
            rotatedDiscreteEdgeLabelModel.setAngle(d2);
            node2 = namedNodeMap.getNamedItem("distance");
            double d3 = 2.0;
            if (node2 != null) {
                try {
                    d3 = Double.parseDouble(node2.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    d3 = 2.0;
                }
            }
            rotatedDiscreteEdgeLabelModel.setDistance(d3);
            node2 = namedNodeMap.getNamedItem("positionRelativeToSegment");
            boolean bl3 = false;
            if (node2 != null) {
                bl3 = Boolean.valueOf(node2.getNodeValue());
            }
            rotatedDiscreteEdgeLabelModel.setPositionRelativeToSegment(bl3);
            return rotatedDiscreteEdgeLabelModel;
        }
    }

    public static interface ConfigurationFactory {
        public void createConfiguration(EdgeLabel var1, Node var2, GraphMLParseContext var3);
    }
}

