/*
 * Decompiled with CFR 0.152.
 */
package y.io.graphml.graph2d;

import org.w3c.dom.Node;
import y.base.Graph;
import y.io.graphml.graph2d.AbstractNodeRealizerSerializer;
import y.io.graphml.graph2d.GraphicsSerializationToolkit;
import y.io.graphml.input.GraphMLParseContext;
import y.io.graphml.input.GraphMLParseException;
import y.io.graphml.output.GraphMLWriteContext;
import y.io.graphml.output.GraphMLWriteException;
import y.io.graphml.output.XmlWriter;
import y.util.D;
import y.view.Graph2D;
import y.view.NodeRealizer;

public final class FallbackNodeRealizerSerializer
extends AbstractNodeRealizerSerializer {
    private static final FallbackNodeRealizerSerializer e = new FallbackNodeRealizerSerializer();

    private FallbackNodeRealizerSerializer() {
    }

    public static FallbackNodeRealizerSerializer getInstance() {
        return e;
    }

    public String getName() {
        return "FallbackNodeRealizer";
    }

    public String getNamespaceURI() {
        return "http://www.yworks.com/xml/graphml";
    }

    public Class getRealizerClass() {
        return null;
    }

    public void parse(NodeRealizer nodeRealizer, Node node, GraphMLParseContext graphMLParseContext) throws GraphMLParseException {
        D.bug("Using FallbackNodeRealizerSerializer for unknown element " + node.getNamespaceURI() + ":" + node.getLocalName());
        super.parse(nodeRealizer, node, graphMLParseContext);
    }

    public void write(NodeRealizer nodeRealizer, XmlWriter xmlWriter, GraphMLWriteContext graphMLWriteContext) throws GraphMLWriteException {
        super.write(nodeRealizer, xmlWriter, graphMLWriteContext);
        xmlWriter.writeComment("FallbackNodeRealizerSerializer for unknown NodeRealizer " + nodeRealizer.getClass());
        D.bug("Using FallbackNodeRealizerSerializer for unknown NodeRealizer " + nodeRealizer.getClass());
    }

    public boolean canHandle(NodeRealizer nodeRealizer, GraphMLWriteContext graphMLWriteContext) {
        return GraphicsSerializationToolkit.getBooleanSerializationProperty(graphMLWriteContext, "y.io.graphml.output.SerializationProperties.IGNORE_UNKNOWN_REALIZERS");
    }

    public NodeRealizer createRealizerInstance(Node node, GraphMLParseContext graphMLParseContext) throws GraphMLParseException {
        Graph graph = graphMLParseContext.getGraph();
        if (graph instanceof Graph2D) {
            return ((Graph2D)graph).getDefaultNodeRealizer().createCopy();
        }
        return super.createRealizerInstance(node, graphMLParseContext);
    }
}

