/*
 * Decompiled with CFR 0.152.
 */
package y.io.graphml.graph2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import y.base.Edge;
import y.base.Graph;
import y.base.Node;
import y.io.YGFIOHandler;
import y.io.graphml.Base64;
import y.io.graphml.GraphMLHandler;
import y.io.graphml.KeyScope;
import y.io.graphml.NameMapper;
import y.io.graphml.graph2d.AbstractEdgeRealizerSerializer;
import y.io.graphml.graph2d.AbstractNodeRealizerSerializer;
import y.io.graphml.graph2d.ArcEdgeRealizerSerializer;
import y.io.graphml.graph2d.BezierEdgeRealizerSerializer;
import y.io.graphml.graph2d.EdgeLabelDeserializer;
import y.io.graphml.graph2d.EdgeLabelSerializer;
import y.io.graphml.graph2d.EdgeRealizerSerializer;
import y.io.graphml.graph2d.FallbackEdgeRealizerSerializer;
import y.io.graphml.graph2d.FallbackNodeRealizerSerializer;
import y.io.graphml.graph2d.GenericEdgeRealizerSerializer;
import y.io.graphml.graph2d.GenericGroupNodeRealizerSerializer;
import y.io.graphml.graph2d.GenericNodeRealizerSerializer;
import y.io.graphml.graph2d.Graph2DElementFactory;
import y.io.graphml.graph2d.GraphicsSerializationToolkit;
import y.io.graphml.graph2d.GroupNodeRealizerSerializer;
import y.io.graphml.graph2d.HierarchyManagerBasedGraphElementFactory;
import y.io.graphml.graph2d.HierarchyManagerBasedHierarchySupport;
import y.io.graphml.graph2d.ImageNodeRealizerSerializer;
import y.io.graphml.graph2d.NodeLabelDeserializer;
import y.io.graphml.graph2d.NodeLabelSerializer;
import y.io.graphml.graph2d.NodePortGeometryReader;
import y.io.graphml.graph2d.NodePortGeometryWriter;
import y.io.graphml.graph2d.NodePortGraphicsReader;
import y.io.graphml.graph2d.NodePortGraphicsWriter;
import y.io.graphml.graph2d.NodePortProvider;
import y.io.graphml.graph2d.NodePortUserDataReader;
import y.io.graphml.graph2d.NodePortUserDataWriter;
import y.io.graphml.graph2d.NodeRealizerSerializer;
import y.io.graphml.graph2d.PolyLineEdgeRealizerSerializer;
import y.io.graphml.graph2d.PostprocessorInputHandler;
import y.io.graphml.graph2d.ProxyAutoBoundsNodeRealizerSerializer;
import y.io.graphml.graph2d.ProxyShapeNodeRealizerSerializer;
import y.io.graphml.graph2d.QuadCurveEdgeRealizerSerializer;
import y.io.graphml.graph2d.ReadEdgeRealizerHandler;
import y.io.graphml.graph2d.ReadNodeRealizerHandler;
import y.io.graphml.graph2d.ResourceDescriptor;
import y.io.graphml.graph2d.ResourceDeserializationHandler;
import y.io.graphml.graph2d.ResourceSerializationHandler;
import y.io.graphml.graph2d.ShapeNodeRealizerSerializer;
import y.io.graphml.graph2d.SplineEdgeRealizerSerializer;
import y.io.graphml.graph2d.TableGroupNodeRealizerSerializer;
import y.io.graphml.graph2d.WriteEdgeRealizerHandler;
import y.io.graphml.graph2d.WriteNodeRealizerHandler;
import y.io.graphml.input.ChildParseContext;
import y.io.graphml.input.CreationProperties;
import y.io.graphml.input.DeserializationEvent;
import y.io.graphml.input.DeserializationHandler;
import y.io.graphml.input.GraphElementFactory;
import y.io.graphml.input.GraphMLParseContext;
import y.io.graphml.input.GraphMLParseException;
import y.io.graphml.input.GraphMLParser;
import y.io.graphml.input.InputHandler;
import y.io.graphml.input.InputHandlerProvider;
import y.io.graphml.input.ParseEvent;
import y.io.graphml.input.ParseEventListenerAdapter;
import y.io.graphml.input.ParsePrecedence;
import y.io.graphml.input.QueryInputHandlersEvent;
import y.io.graphml.input.XPathUtils;
import y.io.graphml.output.GraphMLWriteContext;
import y.io.graphml.output.GraphMLWriteException;
import y.io.graphml.output.GraphMLWriter;
import y.io.graphml.output.GraphMLXmlAttribute;
import y.io.graphml.output.HierarchySupport;
import y.io.graphml.output.OutputHandler;
import y.io.graphml.output.OutputHandlerProvider;
import y.io.graphml.output.QueryOutputHandlersEvent;
import y.io.graphml.output.SerializationEvent;
import y.io.graphml.output.SerializationHandler;
import y.io.graphml.output.SerializationNotSupportedException;
import y.io.graphml.output.WriteEvent;
import y.io.graphml.output.WriteEventListenerAdapter;
import y.io.graphml.output.WritePrecedence;
import y.io.graphml.output.XmlWriter;
import y.util.D;
import y.view.AutoRotationSliderEdgeLabelModel;
import y.view.EdgeLabel;
import y.view.EdgeRealizer;
import y.view.GenericEdgeRealizer;
import y.view.GenericNodeRealizer;
import y.view.Graph2D;
import y.view.NodeLabel;
import y.view.NodePort;
import y.view.NodeRealizer;
import y.view.NodeScaledPortLocationModel;
import y.view.PortLabelModel;
import y.view.YLabel;
import y.view.hierarchy.HierarchyManager;
import y.view.tabular.TableStyle;

public class Graph2DGraphMLHandler
extends GraphMLHandler {
    static final String n = "y.io.graphml.graph2d.Graph2DConstants.YFILES_EXT_NS";
    private List p = new LinkedList();
    private List o = new LinkedList();
    static /* synthetic */ Class class$y$io$graphml$output$HierarchySupport;
    static /* synthetic */ Class class$y$io$graphml$graph2d$ResourceSerializationHandler;
    static /* synthetic */ Class class$y$io$graphml$NameMapper;
    static /* synthetic */ Class class$y$view$NodeRealizer;
    static /* synthetic */ Class class$y$view$EdgeRealizer;
    static /* synthetic */ Class class$y$io$graphml$graph2d$ResourceDeserializationHandler;
    static /* synthetic */ Class class$y$io$graphml$graph2d$GenericNodeRealizerSerializer$ConfigurationFactory;
    static /* synthetic */ Class class$y$io$graphml$graph2d$GenericEdgeRealizerSerializer$ConfigurationFactory;
    static /* synthetic */ Class class$y$io$graphml$graph2d$NodePortGraphicsReader$ConfigurationFactory;
    static /* synthetic */ Class class$y$io$graphml$graph2d$EdgeLabelDeserializer$ConfigurationFactory;
    static /* synthetic */ Class class$y$io$graphml$graph2d$NodeLabelDeserializer$ConfigurationFactory;
    static /* synthetic */ Class class$y$io$graphml$output$PortProvider;
    static /* synthetic */ Class class$y$io$graphml$input$CreationProperties;

    protected void configureLookup(Graph graph, GraphMLWriter graphMLWriter) {
        super.configureLookup(graph, graphMLWriter);
        HierarchySupport hierarchySupport = this.createHierarchySupport(graph, graphMLWriter);
        if (hierarchySupport != null) {
            graphMLWriter.setLookup(class$y$io$graphml$output$HierarchySupport == null ? (class$y$io$graphml$output$HierarchySupport = Graph2DGraphMLHandler.class$("y.io.graphml.output.HierarchySupport")) : class$y$io$graphml$output$HierarchySupport, hierarchySupport);
        }
        graphMLWriter.setLookup(class$y$io$graphml$graph2d$ResourceSerializationHandler == null ? (class$y$io$graphml$graph2d$ResourceSerializationHandler = Graph2DGraphMLHandler.class$("y.io.graphml.graph2d.ResourceSerializationHandler")) : class$y$io$graphml$graph2d$ResourceSerializationHandler, new _b());
        graphMLWriter.setLookup(class$y$io$graphml$NameMapper == null ? (class$y$io$graphml$NameMapper = Graph2DGraphMLHandler.class$("y.io.graphml.NameMapper")) : class$y$io$graphml$NameMapper, new _f());
    }

    protected HierarchySupport createHierarchySupport(Graph graph, GraphMLWriter graphMLWriter) {
        HierarchyManager hierarchyManager;
        if (graph instanceof Graph2D && (hierarchyManager = HierarchyManager.getInstance(graph)) != null) {
            return new HierarchyManagerBasedHierarchySupport(hierarchyManager, graph);
        }
        return null;
    }

    public Graph2DGraphMLHandler() {
        this.configureDefaultRealizerSerializers();
        this.b();
        this.c();
    }

    protected void configureInputHandlers(Graph graph, GraphMLParser graphMLParser) {
        super.configureInputHandlers(graph, graphMLParser);
        if (graph instanceof Graph2D) {
            graphMLParser.addInputHandlerProvider(this.createPostprocessorInputHandlerProvider());
            graphMLParser.addInputHandlerProvider(this.createReadEdgeRealizerHandlerProvider());
            graphMLParser.addInputHandlerProvider(this.createReadNodeRealizerHandlerProvider());
            graphMLParser.addInputHandlerProvider(this.createNodePortReaderProvider());
        }
        graphMLParser.addInputHandlerProvider(this.createResourceInputHandlerProvider());
    }

    protected InputHandlerProvider createNodePortReaderProvider() {
        return new InputHandlerProvider(){

            public void onQueryInputHandler(QueryInputHandlersEvent queryInputHandlersEvent) {
                NodePortGraphicsReader nodePortGraphicsReader = new NodePortGraphicsReader();
                if (!queryInputHandlersEvent.isHandled() && nodePortGraphicsReader.acceptKey(queryInputHandlersEvent.getKeyDefinition())) {
                    queryInputHandlersEvent.addInputHandler(nodePortGraphicsReader);
                }
                NodePortGeometryReader nodePortGeometryReader = new NodePortGeometryReader();
                if (!queryInputHandlersEvent.isHandled() && nodePortGeometryReader.acceptKey(queryInputHandlersEvent.getKeyDefinition())) {
                    queryInputHandlersEvent.addInputHandler(nodePortGeometryReader);
                }
                NodePortUserDataReader nodePortUserDataReader = new NodePortUserDataReader();
                if (!queryInputHandlersEvent.isHandled() && nodePortUserDataReader.acceptKey(queryInputHandlersEvent.getKeyDefinition())) {
                    queryInputHandlersEvent.addInputHandler(nodePortUserDataReader);
                }
            }
        };
    }

    protected InputHandlerProvider createPostprocessorInputHandlerProvider() {
        return new InputHandlerProvider(){

            public void onQueryInputHandler(QueryInputHandlersEvent queryInputHandlersEvent) {
                Element element = queryInputHandlersEvent.getKeyDefinition();
                PostprocessorInputHandler postprocessorInputHandler = new PostprocessorInputHandler();
                if (!queryInputHandlersEvent.isHandled() && GraphMLHandler.matchesScope(element, KeyScope.GRAPH) && postprocessorInputHandler.acceptKey(element.getAttributes())) {
                    queryInputHandlersEvent.addInputHandler(postprocessorInputHandler);
                }
            }
        };
    }

    protected InputHandlerProvider createReadEdgeRealizerHandlerProvider() {
        return new InputHandlerProvider(){

            public void onQueryInputHandler(QueryInputHandlersEvent queryInputHandlersEvent) {
                Element element = queryInputHandlersEvent.getKeyDefinition();
                ReadEdgeRealizerHandler readEdgeRealizerHandler = new ReadEdgeRealizerHandler();
                if (!queryInputHandlersEvent.isHandled() && readEdgeRealizerHandler.acceptKey(element)) {
                    queryInputHandlersEvent.addInputHandler(readEdgeRealizerHandler);
                }
            }
        };
    }

    protected InputHandlerProvider createReadNodeRealizerHandlerProvider() {
        return new InputHandlerProvider(){

            public void onQueryInputHandler(QueryInputHandlersEvent queryInputHandlersEvent) {
                Element element = queryInputHandlersEvent.getKeyDefinition();
                ReadNodeRealizerHandler readNodeRealizerHandler = new ReadNodeRealizerHandler();
                if (!queryInputHandlersEvent.isHandled() && readNodeRealizerHandler.acceptKey(element)) {
                    queryInputHandlersEvent.addInputHandler(readNodeRealizerHandler);
                }
            }
        };
    }

    protected InputHandlerProvider createResourceInputHandlerProvider() {
        return new InputHandlerProvider(){

            public void onQueryInputHandler(QueryInputHandlersEvent queryInputHandlersEvent) {
                Element element = queryInputHandlersEvent.getKeyDefinition();
                _e _e2 = new _e();
                if (!queryInputHandlersEvent.isHandled() && _e2.b(element)) {
                    queryInputHandlersEvent.addInputHandler(_e2);
                }
            }
        };
    }

    protected void configureOutputHandlers(Graph graph, GraphMLWriter graphMLWriter) {
        super.configureOutputHandlers(graph, graphMLWriter);
        if (graph instanceof Graph2D) {
            graphMLWriter.addOutputHandlerProvider(this.createWriteNodeRealizerHandlerProvider());
            graphMLWriter.addOutputHandlerProvider(this.createWriteEdgeRealizerHandlerProvider());
            graphMLWriter.addOutputHandlerProvider(this.createNodePortWriterHandlerProvider());
        }
        graphMLWriter.addOutputHandlerProvider(this.createResourceOutputHandlerProvider());
    }

    protected OutputHandlerProvider createResourceOutputHandlerProvider() {
        return new OutputHandlerProvider(){

            public void onQueryOutputHandler(QueryOutputHandlersEvent queryOutputHandlersEvent) {
                if (queryOutputHandlersEvent.getContext().lookup(class$y$io$graphml$graph2d$ResourceSerializationHandler == null ? (class$y$io$graphml$graph2d$ResourceSerializationHandler = Graph2DGraphMLHandler.class$("y.io.graphml.graph2d.ResourceSerializationHandler")) : class$y$io$graphml$graph2d$ResourceSerializationHandler) != null) {
                    queryOutputHandlersEvent.addOutputHandler(new _g(), KeyScope.GRAPHML);
                }
            }
        };
    }

    protected OutputHandlerProvider createNodePortWriterHandlerProvider() {
        return new OutputHandlerProvider(){

            public void onQueryOutputHandler(QueryOutputHandlersEvent queryOutputHandlersEvent) {
                queryOutputHandlersEvent.addOutputHandler(new NodePortGraphicsWriter(), KeyScope.PORT);
                queryOutputHandlersEvent.addOutputHandler(new NodePortGeometryWriter(), KeyScope.PORT);
                queryOutputHandlersEvent.addOutputHandler(new NodePortUserDataWriter(), KeyScope.PORT);
            }
        };
    }

    protected OutputHandlerProvider createWriteEdgeRealizerHandlerProvider() {
        return new OutputHandlerProvider(){

            public void onQueryOutputHandler(QueryOutputHandlersEvent queryOutputHandlersEvent) {
                queryOutputHandlersEvent.addOutputHandler(new WriteEdgeRealizerHandler(), KeyScope.EDGE);
            }
        };
    }

    protected OutputHandlerProvider createWriteNodeRealizerHandlerProvider() {
        return new OutputHandlerProvider(){

            public void onQueryOutputHandler(QueryOutputHandlersEvent queryOutputHandlersEvent) {
                queryOutputHandlersEvent.addOutputHandler(new WriteNodeRealizerHandler(), KeyScope.NODE);
            }
        };
    }

    private void c() {
        super.addDeserializationHandler(new NodeScaledPortLocationModel.Handler());
        super.addDeserializationHandler(new NodeLabelDeserializer());
        super.addDeserializationHandler(new NodeLabelDeserializer.SmartNodeLabelModelDeserializer());
        super.addDeserializationHandler(new EdgeLabelDeserializer());
        super.addDeserializationHandler(new EdgeLabelDeserializer.RotatedDiscreteEdgeLabelModelDeserializer());
        super.addDeserializationHandler(new EdgeLabelDeserializer.RotatedSliderEdgeLabelModelDeserializer());
        super.addDeserializationHandler(new EdgeLabelDeserializer.SmartEdgeLabelModelDeserializer());
        super.addDeserializationHandler(new EdgeLabelDeserializer.PreferredPlacementDescriptorDeserializer());
        super.addDeserializationHandler(new TableStyle.SimpleStyleDeserializer());
        super.addDeserializationHandler(new PortLabelModel.Handler());
        super.addDeserializationHandler(new AutoRotationSliderEdgeLabelModel.Handler());
        super.addDeserializationHandler(new DeserializationHandler(){

            public void onHandleDeserialization(DeserializationEvent deserializationEvent) throws GraphMLParseException {
                GraphMLParseContext graphMLParseContext = deserializationEvent.getContext();
                org.w3c.dom.Node node = deserializationEvent.getXmlNode();
                ChildParseContext childParseContext = new ChildParseContext(graphMLParseContext);
                FallbackNodeRealizerSerializer fallbackNodeRealizerSerializer = FallbackNodeRealizerSerializer.getInstance();
                if (deserializationEvent.getTargetType() == (class$y$view$NodeRealizer == null ? (class$y$view$NodeRealizer = Graph2DGraphMLHandler.class$("y.view.NodeRealizer")) : class$y$view$NodeRealizer) && GraphicsSerializationToolkit.getBooleanDeserializationProperty(graphMLParseContext, "y.io.graphml.input.DeserializationProperties.IGNORE_UNKNOWN_REALIZERS") || fallbackNodeRealizerSerializer.canHandle(node, childParseContext)) {
                    NodeRealizer nodeRealizer = fallbackNodeRealizerSerializer.createRealizerInstance(node, childParseContext);
                    Object object = graphMLParseContext.getCurrentObject();
                    Graph graph = graphMLParseContext.getGraph();
                    if (!GraphicsSerializationToolkit.getBooleanDeserializationProperty(childParseContext, AbstractNodeRealizerSerializer.b) && object instanceof Node && graph instanceof Graph2D) {
                        Node node2 = (Node)object;
                        Graph2D graph2D = (Graph2D)graph;
                        graph2D.setRealizer(node2, nodeRealizer);
                    }
                    fallbackNodeRealizerSerializer.parse(nodeRealizer, node, childParseContext);
                    deserializationEvent.setResult(nodeRealizer);
                }
            }
        });
        super.addDeserializationHandler(new DeserializationHandler(){

            public void onHandleDeserialization(DeserializationEvent deserializationEvent) throws GraphMLParseException {
                GraphMLParseContext graphMLParseContext = deserializationEvent.getContext();
                org.w3c.dom.Node node = deserializationEvent.getXmlNode();
                ChildParseContext childParseContext = new ChildParseContext(graphMLParseContext);
                FallbackEdgeRealizerSerializer fallbackEdgeRealizerSerializer = FallbackEdgeRealizerSerializer.getInstance();
                if (deserializationEvent.getTargetType() == (class$y$view$EdgeRealizer == null ? (class$y$view$EdgeRealizer = Graph2DGraphMLHandler.class$("y.view.EdgeRealizer")) : class$y$view$EdgeRealizer) && GraphicsSerializationToolkit.getBooleanDeserializationProperty(graphMLParseContext, "y.io.graphml.input.DeserializationProperties.IGNORE_UNKNOWN_REALIZERS") || fallbackEdgeRealizerSerializer.canHandle(node, childParseContext)) {
                    EdgeRealizer edgeRealizer = fallbackEdgeRealizerSerializer.createRealizerInstance(node, childParseContext);
                    Object object = graphMLParseContext.getCurrentObject();
                    Graph graph = graphMLParseContext.getGraph();
                    if (!GraphicsSerializationToolkit.getBooleanDeserializationProperty(childParseContext, AbstractEdgeRealizerSerializer.b) && object instanceof Edge && graph instanceof Graph2D) {
                        Edge edge = (Edge)object;
                        Graph2D graph2D = (Graph2D)graph;
                        graph2D.setRealizer(edge, edgeRealizer);
                    }
                    fallbackEdgeRealizerSerializer.parse(edgeRealizer, node, childParseContext);
                    deserializationEvent.setResult(edgeRealizer);
                }
            }
        });
        super.addDeserializationHandler(new DeserializationHandler(){

            public void onHandleDeserialization(DeserializationEvent deserializationEvent) throws GraphMLParseException {
                GraphMLParseContext graphMLParseContext = deserializationEvent.getContext();
                org.w3c.dom.Node node = deserializationEvent.getXmlNode();
                ChildParseContext childParseContext = new ChildParseContext(graphMLParseContext);
                Iterator iterator2 = Graph2DGraphMLHandler.this.p.iterator();
                while (iterator2.hasNext()) {
                    NodeRealizerSerializer nodeRealizerSerializer = (NodeRealizerSerializer)iterator2.next();
                    if (!nodeRealizerSerializer.canHandle(node, childParseContext)) continue;
                    NodeRealizer nodeRealizer = nodeRealizerSerializer.createRealizerInstance(node, childParseContext);
                    Object object = graphMLParseContext.getCurrentObject();
                    Graph graph = graphMLParseContext.getGraph();
                    if (!GraphicsSerializationToolkit.getBooleanDeserializationProperty(childParseContext, AbstractNodeRealizerSerializer.b) && object instanceof Node && graph instanceof Graph2D) {
                        Node node2 = (Node)object;
                        Graph2D graph2D = (Graph2D)graph;
                        graph2D.setRealizer(node2, nodeRealizer);
                    }
                    nodeRealizerSerializer.parse(nodeRealizer, node, childParseContext);
                    deserializationEvent.setResult(nodeRealizer);
                    break;
                }
            }
        });
        super.addDeserializationHandler(new DeserializationHandler(){

            public void onHandleDeserialization(DeserializationEvent deserializationEvent) throws GraphMLParseException {
                GraphMLParseContext graphMLParseContext = deserializationEvent.getContext();
                org.w3c.dom.Node node = deserializationEvent.getXmlNode();
                ChildParseContext childParseContext = new ChildParseContext(graphMLParseContext);
                Iterator iterator2 = Graph2DGraphMLHandler.this.o.iterator();
                while (iterator2.hasNext()) {
                    EdgeRealizerSerializer edgeRealizerSerializer = (EdgeRealizerSerializer)iterator2.next();
                    if (!edgeRealizerSerializer.canHandle(node, childParseContext)) continue;
                    EdgeRealizer edgeRealizer = edgeRealizerSerializer.createRealizerInstance(node, childParseContext);
                    Object object = graphMLParseContext.getCurrentObject();
                    Graph graph = graphMLParseContext.getGraph();
                    if (!GraphicsSerializationToolkit.getBooleanDeserializationProperty(childParseContext, AbstractNodeRealizerSerializer.b) && object instanceof Edge && graph instanceof Graph2D) {
                        Edge edge = (Edge)object;
                        Graph2D graph2D = (Graph2D)graph;
                        graph2D.setRealizer(edge, edgeRealizer);
                    }
                    edgeRealizerSerializer.parse(edgeRealizer, node, childParseContext);
                    deserializationEvent.setResult(edgeRealizer);
                    break;
                }
            }
        });
    }

    private void b() {
        super.addSerializationHandler(new NodeScaledPortLocationModel.Handler());
        super.addSerializationHandler(new NodeLabelSerializer());
        super.addSerializationHandler(new NodeLabelSerializer.SmartNodeLabelModelSerializer());
        super.addSerializationHandler(new EdgeLabelSerializer());
        super.addSerializationHandler(new EdgeLabelSerializer.RotatedDiscreteEdgeLabelModelSerializer());
        super.addSerializationHandler(new EdgeLabelSerializer.RotatedSliderEdgeLabelModelSerializer());
        super.addSerializationHandler(new EdgeLabelSerializer.SmartEdgeLabelModelSerializer());
        super.addSerializationHandler(new EdgeLabelSerializer.PreferredPlacementDescriptorSerializer());
        super.addSerializationHandler(new TableStyle.SimpleStyleSerializer());
        super.addSerializationHandler(new PortLabelModel.Handler());
        super.addSerializationHandler(new AutoRotationSliderEdgeLabelModel.Handler());
        super.addSerializationHandler(new SerializationHandler(){

            public void onHandleSerialization(SerializationEvent serializationEvent) throws GraphMLWriteException {
                GraphMLWriteContext graphMLWriteContext = serializationEvent.getContext();
                Object object = serializationEvent.getItem();
                if (object instanceof NodeRealizer) {
                    NodeRealizer nodeRealizer = (NodeRealizer)object;
                    XmlWriter xmlWriter = graphMLWriteContext.getWriter();
                    FallbackNodeRealizerSerializer fallbackNodeRealizerSerializer = FallbackNodeRealizerSerializer.getInstance();
                    if (fallbackNodeRealizerSerializer.canHandle(nodeRealizer, graphMLWriteContext)) {
                        xmlWriter.writeStartElement(fallbackNodeRealizerSerializer.getNamespacePrefix(), fallbackNodeRealizerSerializer.getName(), fallbackNodeRealizerSerializer.getNamespaceURI());
                        fallbackNodeRealizerSerializer.writeAttributes(nodeRealizer, xmlWriter, graphMLWriteContext);
                        fallbackNodeRealizerSerializer.write(nodeRealizer, xmlWriter, graphMLWriteContext);
                        xmlWriter.writeEndElement();
                        serializationEvent.setHandled(true);
                    }
                }
            }
        });
        super.addSerializationHandler(new SerializationHandler(){

            public void onHandleSerialization(SerializationEvent serializationEvent) throws GraphMLWriteException {
                GraphMLWriteContext graphMLWriteContext = serializationEvent.getContext();
                Object object = serializationEvent.getItem();
                if (object instanceof EdgeRealizer) {
                    EdgeRealizer edgeRealizer = (EdgeRealizer)object;
                    XmlWriter xmlWriter = graphMLWriteContext.getWriter();
                    FallbackEdgeRealizerSerializer fallbackEdgeRealizerSerializer = FallbackEdgeRealizerSerializer.getInstance();
                    if (fallbackEdgeRealizerSerializer.canHandle(edgeRealizer, graphMLWriteContext)) {
                        xmlWriter.writeStartElement(fallbackEdgeRealizerSerializer.getNamespacePrefix(), fallbackEdgeRealizerSerializer.getName(), fallbackEdgeRealizerSerializer.getNamespaceURI());
                        fallbackEdgeRealizerSerializer.writeAttributes(edgeRealizer, xmlWriter, graphMLWriteContext);
                        fallbackEdgeRealizerSerializer.write(edgeRealizer, xmlWriter, graphMLWriteContext);
                        xmlWriter.writeEndElement();
                        serializationEvent.setHandled(true);
                    }
                }
            }
        });
        super.addSerializationHandler(new SerializationHandler(){

            public void onHandleSerialization(SerializationEvent serializationEvent) throws GraphMLWriteException {
                GraphMLWriteContext graphMLWriteContext = serializationEvent.getContext();
                Object object = serializationEvent.getItem();
                if (object instanceof NodeRealizer) {
                    NodeRealizer nodeRealizer = (NodeRealizer)object;
                    XmlWriter xmlWriter = graphMLWriteContext.getWriter();
                    Iterator iterator2 = Graph2DGraphMLHandler.this.p.iterator();
                    while (iterator2.hasNext()) {
                        NodeRealizerSerializer nodeRealizerSerializer = (NodeRealizerSerializer)iterator2.next();
                        if (!nodeRealizerSerializer.canHandle(nodeRealizer, graphMLWriteContext)) continue;
                        xmlWriter.writeStartElement(nodeRealizerSerializer.getNamespacePrefix(), nodeRealizerSerializer.getName(), nodeRealizerSerializer.getNamespaceURI());
                        nodeRealizerSerializer.writeAttributes(nodeRealizer, xmlWriter, graphMLWriteContext);
                        nodeRealizerSerializer.write(nodeRealizer, xmlWriter, graphMLWriteContext);
                        xmlWriter.writeEndElement();
                        serializationEvent.setHandled(true);
                        break;
                    }
                }
            }
        });
        super.addSerializationHandler(new SerializationHandler(){

            public void onHandleSerialization(SerializationEvent serializationEvent) throws GraphMLWriteException {
                GraphMLWriteContext graphMLWriteContext = serializationEvent.getContext();
                Object object = serializationEvent.getItem();
                if (object instanceof EdgeRealizer) {
                    EdgeRealizer edgeRealizer = (EdgeRealizer)object;
                    XmlWriter xmlWriter = graphMLWriteContext.getWriter();
                    Iterator iterator2 = Graph2DGraphMLHandler.this.o.iterator();
                    while (iterator2.hasNext()) {
                        EdgeRealizerSerializer edgeRealizerSerializer = (EdgeRealizerSerializer)iterator2.next();
                        if (!edgeRealizerSerializer.canHandle(edgeRealizer, graphMLWriteContext)) continue;
                        xmlWriter.writeStartElement(edgeRealizerSerializer.getNamespacePrefix(), edgeRealizerSerializer.getName(), edgeRealizerSerializer.getNamespaceURI());
                        edgeRealizerSerializer.writeAttributes(edgeRealizer, xmlWriter, graphMLWriteContext);
                        edgeRealizerSerializer.write(edgeRealizer, xmlWriter, graphMLWriteContext);
                        xmlWriter.writeEndElement();
                        serializationEvent.setHandled(true);
                        break;
                    }
                }
            }
        });
    }

    protected void configureLookup(Graph graph, GraphMLParser graphMLParser) {
        super.configureLookup(graph, graphMLParser);
        graphMLParser.setLookup(class$y$io$graphml$graph2d$ResourceDeserializationHandler == null ? (class$y$io$graphml$graph2d$ResourceDeserializationHandler = Graph2DGraphMLHandler.class$("y.io.graphml.graph2d.ResourceDeserializationHandler")) : class$y$io$graphml$graph2d$ResourceDeserializationHandler, new _d());
        graphMLParser.setLookup(class$y$io$graphml$graph2d$GenericNodeRealizerSerializer$ConfigurationFactory == null ? (class$y$io$graphml$graph2d$GenericNodeRealizerSerializer$ConfigurationFactory = Graph2DGraphMLHandler.class$("y.io.graphml.graph2d.GenericNodeRealizerSerializer$ConfigurationFactory")) : class$y$io$graphml$graph2d$GenericNodeRealizerSerializer$ConfigurationFactory, new GenericNodeRealizerSerializer.ConfigurationFactory(){

            public void createConfiguration(org.w3c.dom.Node node, GenericNodeRealizer genericNodeRealizer, GraphMLParseContext graphMLParseContext) {
                GenericNodeRealizer.Factory factory2;
                String string2;
                if (node.getNodeType() == 1 && (string2 = ((Element)node).getAttribute("configuration")).length() > 0 && !(factory2 = GenericNodeRealizer.getFactory()).getAvailableConfigurations().contains(string2)) {
                    D.bug("Configuration " + string2 + " not found, substituting default configuration");
                    factory2.addConfiguration(string2, factory2.createDefaultConfigurationMap());
                    genericNodeRealizer.setConfiguration(string2);
                }
            }
        });
        graphMLParser.setLookup(class$y$io$graphml$graph2d$GenericEdgeRealizerSerializer$ConfigurationFactory == null ? (class$y$io$graphml$graph2d$GenericEdgeRealizerSerializer$ConfigurationFactory = Graph2DGraphMLHandler.class$("y.io.graphml.graph2d.GenericEdgeRealizerSerializer$ConfigurationFactory")) : class$y$io$graphml$graph2d$GenericEdgeRealizerSerializer$ConfigurationFactory, new GenericEdgeRealizerSerializer.ConfigurationFactory(){

            public void createConfiguration(org.w3c.dom.Node node, GenericEdgeRealizer genericEdgeRealizer, GraphMLParseContext graphMLParseContext) {
                GenericEdgeRealizer.Factory factory2;
                String string2;
                if (node.getNodeType() == 1 && (string2 = ((Element)node).getAttribute("configuration")).length() > 0 && !(factory2 = GenericEdgeRealizer.getFactory()).getAvailableConfigurations().contains(string2)) {
                    D.bug("Configuration " + string2 + " not found, substituting default configuration");
                    factory2.addConfiguration(string2, factory2.createDefaultConfigurationMap());
                    genericEdgeRealizer.setConfiguration(string2);
                }
            }
        });
        graphMLParser.setLookup(class$y$io$graphml$graph2d$NodePortGraphicsReader$ConfigurationFactory == null ? (class$y$io$graphml$graph2d$NodePortGraphicsReader$ConfigurationFactory = Graph2DGraphMLHandler.class$("y.io.graphml.graph2d.NodePortGraphicsReader$ConfigurationFactory")) : class$y$io$graphml$graph2d$NodePortGraphicsReader$ConfigurationFactory, new NodePortGraphicsReader.ConfigurationFactory(){

            public void createConfiguration(NodePort nodePort, org.w3c.dom.Node node, GraphMLParseContext graphMLParseContext) {
                NodePort.Factory factory2;
                String string2;
                if (node.getNodeType() == 1 && (string2 = ((Element)node).getAttribute("configuration")).length() > 0 && !(factory2 = NodePort.getFactory()).getAvailableConfigurations().contains(string2)) {
                    D.bug("Configuration " + string2 + " not found, substituting default configuration");
                    factory2.addConfiguration(string2, factory2.createDefaultConfigurationMap());
                    nodePort.setConfiguration(string2);
                }
            }
        });
        graphMLParser.setLookup(class$y$io$graphml$graph2d$EdgeLabelDeserializer$ConfigurationFactory == null ? (class$y$io$graphml$graph2d$EdgeLabelDeserializer$ConfigurationFactory = Graph2DGraphMLHandler.class$("y.io.graphml.graph2d.EdgeLabelDeserializer$ConfigurationFactory")) : class$y$io$graphml$graph2d$EdgeLabelDeserializer$ConfigurationFactory, new EdgeLabelDeserializer.ConfigurationFactory(){

            public void createConfiguration(EdgeLabel edgeLabel, org.w3c.dom.Node node, GraphMLParseContext graphMLParseContext) {
                YLabel.Factory factory2;
                String string2;
                if (node.getNodeType() == 1 && (string2 = ((Element)node).getAttribute("configuration")).length() > 0 && !(factory2 = EdgeLabel.getFactory()).getAvailableConfigurations().contains(string2)) {
                    D.bug("Configuration " + string2 + " not found, substituting default configuration");
                    factory2.addConfiguration(string2, factory2.createDefaultConfigurationMap());
                    edgeLabel.setConfiguration(string2);
                }
            }
        });
        graphMLParser.setLookup(class$y$io$graphml$graph2d$NodeLabelDeserializer$ConfigurationFactory == null ? (class$y$io$graphml$graph2d$NodeLabelDeserializer$ConfigurationFactory = Graph2DGraphMLHandler.class$("y.io.graphml.graph2d.NodeLabelDeserializer$ConfigurationFactory")) : class$y$io$graphml$graph2d$NodeLabelDeserializer$ConfigurationFactory, new NodeLabelDeserializer.ConfigurationFactory(){

            public void createConfiguration(NodeLabel nodeLabel, org.w3c.dom.Node node, GraphMLParseContext graphMLParseContext) {
                YLabel.Factory factory2;
                String string2;
                if (node.getNodeType() == 1 && (string2 = ((Element)node).getAttribute("configuration")).length() > 0 && !(factory2 = NodeLabel.getFactory()).getAvailableConfigurations().contains(string2)) {
                    D.bug("Configuration " + string2 + " not found, substituting default configuration");
                    factory2.addConfiguration(string2, factory2.createDefaultConfigurationMap());
                    nodeLabel.setConfiguration(string2);
                }
            }
        });
        graphMLParser.setLookup(class$y$io$graphml$NameMapper == null ? (class$y$io$graphml$NameMapper = Graph2DGraphMLHandler.class$("y.io.graphml.NameMapper")) : class$y$io$graphml$NameMapper, new _f());
    }

    protected void configureGraphMLWriter(Graph graph, GraphMLWriter graphMLWriter) {
        super.configureGraphMLWriter(graph, graphMLWriter);
        graphMLWriter.getWriteEventHandler().addWriteEventListener(new WriteEventListenerAdapter(){

            public void onNodeWriting(WriteEvent writeEvent) {
                block4: {
                    Node node;
                    HierarchyManager hierarchyManager;
                    block5: {
                        Object object;
                        Graph graph = writeEvent.getContext().getGraph();
                        hierarchyManager = HierarchyManager.getInstance(graph);
                        if (hierarchyManager == null || !((object = writeEvent.getContext().getCurrentObject()) instanceof Node)) break block4;
                        node = (Node)object;
                        if (!hierarchyManager.isFolderNode(node)) break block5;
                        writeEvent.getContext().getWriter().writeAttribute("yfiles.foldertype", "folder");
                        if (AbstractNodeRealizerSerializer.z == 0) break block4;
                    }
                    if (hierarchyManager.isGroupNode(node)) {
                        writeEvent.getContext().getWriter().writeAttribute("yfiles.foldertype", "group");
                    }
                }
            }
        });
        graphMLWriter.setLookup(class$y$io$graphml$output$PortProvider == null ? (class$y$io$graphml$output$PortProvider = Graph2DGraphMLHandler.class$("y.io.graphml.output.PortProvider")) : class$y$io$graphml$output$PortProvider, new NodePortProvider());
    }

    protected void configureGraphMLParser(Graph graph, GraphMLParser graphMLParser) {
        super.configureGraphMLParser(graph, graphMLParser);
        graphMLParser.getParseEventHandler().addParseEventListener(new ParseEventListenerAdapter(){

            public void onNodeParsing(ParseEvent parseEvent) {
                block4: {
                    String string2;
                    CreationProperties creationProperties;
                    block5: {
                        creationProperties = (CreationProperties)parseEvent.getContext().lookup(class$y$io$graphml$input$CreationProperties == null ? (class$y$io$graphml$input$CreationProperties = Graph2DGraphMLHandler.class$("y.io.graphml.input.CreationProperties")) : class$y$io$graphml$input$CreationProperties);
                        if (creationProperties == null) break block4;
                        Element element = parseEvent.getElement();
                        string2 = element.getAttribute("yfiles.foldertype");
                        if (!"folder".equals(string2)) break block5;
                        creationProperties.put("y.io.graphml.input.CreationPropertyKeys.IS_FOLDER_NODE", Boolean.TRUE);
                        if (AbstractNodeRealizerSerializer.z == 0) break block4;
                    }
                    if ("group".equals(string2)) {
                        creationProperties.put("y.io.graphml.input.CreationPropertyKeys.IS_GROUP_NODE", Boolean.TRUE);
                    }
                }
            }

            public void onNodeParsed(ParseEvent parseEvent) {
                Collection collection;
                Object v2;
                CreationProperties creationProperties;
                int n2 = AbstractNodeRealizerSerializer.z;
                GraphMLParseContext graphMLParseContext = parseEvent.getContext();
                if (graphMLParseContext.getGraph() instanceof Graph2D && (creationProperties = (CreationProperties)graphMLParseContext.lookup(class$y$io$graphml$input$CreationProperties == null ? (class$y$io$graphml$input$CreationProperties = Graph2DGraphMLHandler.class$("y.io.graphml.input.CreationProperties")) : class$y$io$graphml$input$CreationProperties)) != null && (v2 = creationProperties.get("y.io.graphml.input.CreationPropertyKeys.NODE_PORTS")) instanceof Collection && !(collection = (Collection)v2).isEmpty()) {
                    Graph2D graph2D = (Graph2D)graphMLParseContext.getGraph();
                    Node node = (Node)graphMLParseContext.getCurrentObject();
                    Iterator iterator2 = collection.iterator();
                    while (iterator2.hasNext()) {
                        NodePort nodePort = (NodePort)iterator2.next();
                        if (nodePort.getRealizer() != null) continue;
                        graph2D.getRealizer(node).addPort(nodePort);
                        if (n2 == 0) continue;
                    }
                }
            }

            public void onEdgeParsed(ParseEvent parseEvent) {
                block8: {
                    HashMap hashMap;
                    Object v2;
                    HierarchyManager hierarchyManager;
                    Edge edge;
                    block11: {
                        Graph2D graph2D;
                        CreationProperties creationProperties;
                        int n2;
                        block9: {
                            HashMap hashMap2;
                            Object v3;
                            block10: {
                                n2 = AbstractNodeRealizerSerializer.z;
                                GraphMLParseContext graphMLParseContext = parseEvent.getContext();
                                if (!(graphMLParseContext.getGraph() instanceof Graph2D) || (creationProperties = (CreationProperties)graphMLParseContext.lookup(class$y$io$graphml$input$CreationProperties == null ? (class$y$io$graphml$input$CreationProperties = Graph2DGraphMLHandler.class$("y.io.graphml.input.CreationProperties")) : class$y$io$graphml$input$CreationProperties)) == null) break block8;
                                graph2D = (Graph2D)graphMLParseContext.getGraph();
                                edge = (Edge)graphMLParseContext.getCurrentObject();
                                hierarchyManager = graph2D.getHierarchyManager();
                                v3 = creationProperties.get("y.io.graphml.input.CreationPropertyKeys.SOURCE_PORT");
                                if (!(v3 instanceof NodePort)) break block9;
                                if (hierarchyManager != null && hierarchyManager.isInterEdge(edge) && hierarchyManager.getRealSource(edge) != edge.source()) break block10;
                                ((NodePort)v3).bindSourcePort(graph2D.getRealizer(edge));
                                if (n2 == 0) break block9;
                            }
                            if ((hashMap2 = (HashMap)hierarchyManager.getInterEdgeData(edge).get("HierarchyManager.InterEdgeData.SOURCE_PORT")) == null) {
                                hashMap2 = new HashMap();
                                hierarchyManager.getInterEdgeData(edge).put("HierarchyManager.InterEdgeData.SOURCE_PORT", hashMap2);
                            }
                            hashMap2.put(hierarchyManager.getRealSource(edge), v3);
                        }
                        if (!((v2 = creationProperties.get("y.io.graphml.input.CreationPropertyKeys.TARGET_PORT")) instanceof NodePort)) break block8;
                        if (hierarchyManager != null && hierarchyManager.isInterEdge(edge) && hierarchyManager.getRealTarget(edge) != edge.target()) break block11;
                        ((NodePort)v2).bindTargetPort(graph2D.getRealizer(edge));
                        if (n2 == 0) break block8;
                    }
                    if ((hashMap = (HashMap)hierarchyManager.getInterEdgeData(edge).get("HierarchyManager.InterEdgeData.TARGET_PORT")) == null) {
                        hashMap = new HashMap();
                        hierarchyManager.getInterEdgeData(edge).put("HierarchyManager.InterEdgeData.TARGET_PORT", hashMap);
                    }
                    hashMap.put(hierarchyManager.getRealTarget(edge), v2);
                }
            }
        });
    }

    protected GraphElementFactory createGraphElementFactory(GraphMLParser graphMLParser, Graph graph) {
        if (graph instanceof Graph2D) {
            if (HierarchyManager.getInstance(graph) != null) {
                return new HierarchyManagerBasedGraphElementFactory();
            }
            return new Graph2DElementFactory();
        }
        return super.createGraphElementFactory(graphMLParser, graph);
    }

    protected void configureDefaultRealizerSerializers() {
        this.addNodeRealizerSerializer(new TableGroupNodeRealizerSerializer());
        this.addNodeRealizerSerializer(new GenericGroupNodeRealizerSerializer());
        this.addNodeRealizerSerializer(new GroupNodeRealizerSerializer());
        this.addNodeRealizerSerializer(new GenericNodeRealizerSerializer());
        this.addNodeRealizerSerializer(new ProxyShapeNodeRealizerSerializer());
        this.addNodeRealizerSerializer(new ProxyAutoBoundsNodeRealizerSerializer());
        this.addNodeRealizerSerializer(new ImageNodeRealizerSerializer());
        this.addNodeRealizerSerializer(new ShapeNodeRealizerSerializer());
        this.addEdgeRealizerSerializer(new ArcEdgeRealizerSerializer());
        this.addEdgeRealizerSerializer(new BezierEdgeRealizerSerializer());
        this.addEdgeRealizerSerializer(new SplineEdgeRealizerSerializer());
        this.addEdgeRealizerSerializer(new QuadCurveEdgeRealizerSerializer());
        this.addEdgeRealizerSerializer(new GenericEdgeRealizerSerializer());
        this.addEdgeRealizerSerializer(new PolyLineEdgeRealizerSerializer());
    }

    protected void configureSerializationProperties(Graph graph, GraphMLWriter graphMLWriter) {
        super.configureSerializationProperties(graph, graphMLWriter);
        graphMLWriter.setSerializationProperty("y.io.graphml.output.SerializationProperties.IGNORE_UNKNOWN_REALIZERS", Boolean.TRUE);
    }

    protected void configureDeserializationProperties(Graph graph, GraphMLParser graphMLParser) {
        super.configureDeserializationProperties(graph, graphMLParser);
        graphMLParser.setDeserializationProperty("y.io.graphml.input.DeserializationProperties.IGNORE_UNKNOWN_REALIZERS", Boolean.TRUE);
        graphMLParser.setDeserializationProperty("y.io.graphml.input.DeserializationProperties.IGNORE_RESOURCE_ERRORS", Boolean.TRUE);
        graphMLParser.setDeserializationProperty("y.io.graphml.graph2d.PostprocessorInputHandler.IGNORE_POSTPROCESSOR_ERRORS", Boolean.TRUE);
    }

    public void addNodeRealizerSerializer(NodeRealizerSerializer nodeRealizerSerializer) {
        if (nodeRealizerSerializer == null) {
            throw new IllegalArgumentException("serializer may not be null");
        }
        this.p.add(0, nodeRealizerSerializer);
    }

    public void addEdgeRealizerSerializer(EdgeRealizerSerializer edgeRealizerSerializer) {
        if (edgeRealizerSerializer == null) {
            throw new IllegalArgumentException("serializer may not be null");
        }
        this.o.add(0, edgeRealizerSerializer);
    }

    public void removeNodeRealizerSerializer(NodeRealizerSerializer nodeRealizerSerializer) {
        this.p.remove(nodeRealizerSerializer);
    }

    public void removeEdgeRealizerSerializer(EdgeRealizerSerializer edgeRealizerSerializer) {
        this.o.remove(edgeRealizerSerializer);
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class _f
    implements NameMapper {
        private _f() {
        }

        public String encodeType(String string2, GraphMLWriteContext graphMLWriteContext) {
            return YGFIOHandler.encode(string2);
        }

        public String decodeType(String string2, GraphMLParseContext graphMLParseContext) {
            return YGFIOHandler.decode(string2);
        }
    }

    static final class _c
    implements DeserializationHandler {
        private static final _c hb = new _c();
        private GraphicsEnvironment ib;
        private GraphicsConfiguration jb;

        private _c() {
        }

        public static _c c() {
            return hb;
        }

        /*
         * Loose catch block
         */
        protected Object b(org.w3c.dom.Node node, GraphMLParseContext graphMLParseContext) throws GraphMLParseException {
            Image image;
            BufferedImage bufferedImage;
            ByteArrayInputStream byteArrayInputStream;
            block18: {
                block16: {
                    BufferedImage bufferedImage2;
                    block17: {
                        if (node == null) {
                            return null;
                        }
                        String string2 = node.getNodeValue();
                        byte[] byArray = Base64.decode(string2);
                        byteArrayInputStream = null;
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        bufferedImage = ImageIO.read(byteArrayInputStream);
                        if (!GraphicsEnvironment.isHeadless()) break block16;
                        bufferedImage2 = bufferedImage;
                        Object var11_12 = null;
                        if (byteArrayInputStream == null) break block17;
                        try {
                            byteArrayInputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return bufferedImage2;
                }
                int n2 = bufferedImage.getWidth(null);
                int n3 = bufferedImage.getHeight(null);
                image = this.b(n2, n3, bufferedImage);
                Object var11_13 = null;
                if (byteArrayInputStream == null) break block18;
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return image;
            {
                catch (Exception exception) {
                    BufferedImage bufferedImage3;
                    block19: {
                        D.bug("Creating optimized image failed, returning raw image IO image: " + exception.getMessage());
                        bufferedImage3 = bufferedImage;
                        Object var11_14 = null;
                        if (byteArrayInputStream == null) break block19;
                        try {
                            byteArrayInputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return bufferedImage3;
                    catch (IOException iOException) {
                        String string3;
                        block20: {
                            Object var8_24;
                            block21: {
                                try {
                                    string3 = "Cannot load image from embedded location: " + iOException.getMessage();
                                    if (!GraphicsSerializationToolkit.getBooleanDeserializationProperty(graphMLParseContext, "y.io.graphml.input.DeserializationProperties.IGNORE_RESOURCE_ERRORS")) break block20;
                                    D.bug(string3 + ", ignoring");
                                    var8_24 = null;
                                    Object var11_15 = null;
                                    if (byteArrayInputStream == null) break block21;
                                }
                                catch (Throwable throwable) {
                                    block22: {
                                        Object var11_16 = null;
                                        if (byteArrayInputStream == null) break block22;
                                        try {
                                            byteArrayInputStream.close();
                                        }
                                        catch (IOException iOException2) {}
                                    }
                                    throw throwable;
                                }
                                try {
                                    byteArrayInputStream.close();
                                }
                                catch (IOException iOException3) {
                                    // empty catch block
                                }
                            }
                            return var8_24;
                        }
                        throw new GraphMLParseException(string3, iOException);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Image b(int n2, int n3, BufferedImage bufferedImage) {
            Object object;
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (this.ib != graphicsEnvironment || this.jb == null) {
                this.ib = graphicsEnvironment;
                object = this.ib.getDefaultScreenDevice();
                this.jb = ((GraphicsDevice)object).getDefaultConfiguration();
            }
            object = this.jb.createCompatibleImage(n2, n3, bufferedImage.getColorModel().getTransparency());
            Graphics2D graphics2D = (Graphics2D)((BufferedImage)object).getGraphics();
            try {
                graphics2D.setBackground(new Color(255, 255, 255, 0));
                graphics2D.clearRect(0, 0, n2, n3);
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            }
            finally {
                graphics2D.dispose();
            }
            return object;
        }

        public void onHandleDeserialization(DeserializationEvent deserializationEvent) throws GraphMLParseException {
            org.w3c.dom.Node node = deserializationEvent.getXmlNode();
            if (node.getNodeType() == 3) {
                deserializationEvent.setResult(this.b(node, deserializationEvent.getContext()));
            }
        }
    }

    static final class _h
    implements SerializationHandler {
        private static final _h v = new _h();

        private _h() {
        }

        public static _h b() {
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        protected void b(Image image, XmlWriter xmlWriter, GraphMLWriteContext graphMLWriteContext) throws SerializationNotSupportedException {
            String string2;
            block14: {
                string2 = null;
                String string3 = "png";
                ImageWriter imageWriter = ImageIO.getImageWritersBySuffix(string3).next();
                if (imageWriter != null) {
                    BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.drawImage(image, 0, 0, null);
                    graphics2D.dispose();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ImageOutputStream imageOutputStream = null;
                    imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
                    imageWriter.setOutput(imageOutputStream);
                    imageWriter.write(bufferedImage);
                    string2 = Base64.encode(byteArrayOutputStream.toByteArray());
                    Object var13_11 = null;
                    try {
                        if (imageOutputStream != null) {
                            imageOutputStream.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {}
                    break block14;
                    {
                        catch (IOException iOException) {
                            if (!GraphicsSerializationToolkit.getBooleanSerializationProperty(graphMLWriteContext, "y.io.graphml.output.SerializationProperties.IGNORE_UNKNOWN_REALIZERS")) {
                                throw new SerializationNotSupportedException("Error serializing image content", iOException);
                            }
                            D.bug("Unable to encode image resource: " + iOException.getMessage());
                            string2 = null;
                            Object var13_12 = null;
                            try {
                                if (imageOutputStream != null) {
                                    imageOutputStream.close();
                                }
                                break block14;
                            }
                            catch (IOException iOException2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_13 = null;
                        try {
                            if (imageOutputStream != null) {
                                imageOutputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            if (string2 != null) {
                xmlWriter.writeText(string2);
            }
        }

        public void onHandleSerialization(SerializationEvent serializationEvent) throws SerializationNotSupportedException {
            Object object = serializationEvent.getItem();
            if (object instanceof Image) {
                this.b((Image)object, serializationEvent.getWriter(), serializationEvent.getContext());
                serializationEvent.setHandled(true);
            }
        }
    }

    private static class _e
    implements InputHandler {
        public static final String c = "useEmbeddedResources";

        private _e() {
        }

        public boolean b(Element element) {
            boolean bl;
            block3: {
                int n2 = AbstractNodeRealizerSerializer.z;
                NamedNodeMap namedNodeMap = element.getAttributes();
                String string2 = null;
                for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                    org.w3c.dom.Node node = namedNodeMap.item(i2);
                    bl = "yfiles.type".equals(node.getNodeName().toLowerCase());
                    if (n2 == 0) {
                        if (!bl) continue;
                        string2 = node.getNodeValue();
                        if (n2 == 0) continue;
                    }
                    break block3;
                }
                if (string2 != null && "resources".equals(string2)) {
                    return true;
                }
                bl = false;
            }
            return bl;
        }

        public ParsePrecedence getPrecedence() {
            return ParsePrecedence.BEFORE_CHILDREN;
        }

        public void parseData(GraphMLParseContext graphMLParseContext, org.w3c.dom.Node node) {
            block5: {
                int n2 = AbstractNodeRealizerSerializer.z;
                ResourceDeserializationHandler resourceDeserializationHandler = (ResourceDeserializationHandler)graphMLParseContext.lookup(class$y$io$graphml$graph2d$ResourceDeserializationHandler == null ? (class$y$io$graphml$graph2d$ResourceDeserializationHandler = Graph2DGraphMLHandler.class$("y.io.graphml.graph2d.ResourceDeserializationHandler")) : class$y$io$graphml$graph2d$ResourceDeserializationHandler);
                if (resourceDeserializationHandler != null) {
                    org.w3c.dom.Node node2 = null;
                    for (int i2 = 0; i2 < node.getChildNodes().getLength(); ++i2) {
                        org.w3c.dom.Node node3 = node.getChildNodes().item(i2);
                        if (n2 == 0) {
                            if (node3.getNodeType() != 1 || !"Resources".equals(node3.getLocalName()) || !"http://www.yworks.com/xml/graphml".equals(node3.getNamespaceURI())) continue;
                            node2 = node3;
                            break;
                        }
                        break block5;
                    }
                    NodeList nodeList = null;
                    if (node2 != null) {
                        nodeList = node2.getChildNodes();
                        for (int i3 = 0; i3 < nodeList.getLength(); ++i3) {
                            org.w3c.dom.Node node4 = nodeList.item(i3);
                            if (node4.getNodeType() != 1 || !"Resource".equals(node4.getLocalName()) || !"http://www.yworks.com/xml/graphml".equals(node4.getNamespaceURI())) continue;
                            NamedNodeMap namedNodeMap = node4.getAttributes();
                            String string2 = namedNodeMap.getNamedItem("id").getNodeValue();
                            resourceDeserializationHandler.registerResourceNode(string2, node4);
                            if (n2 == 0) continue;
                        }
                    }
                }
            }
        }

        public void applyDefault(GraphMLParseContext graphMLParseContext) {
        }
    }

    private static class _g
    implements OutputHandler {
        private _g() {
        }

        public WritePrecedence getPrecedence() {
            return WritePrecedence.AFTER_CHILDREN;
        }

        public Collection getKeyDefinitionAttributes() {
            ArrayList<GraphMLXmlAttribute> arrayList = new ArrayList<GraphMLXmlAttribute>();
            arrayList.add(new GraphMLXmlAttribute("yfiles.type", null, "resources"));
            arrayList.add(new GraphMLXmlAttribute("for", null, "graphml"));
            return arrayList;
        }

        public Collection getDataTagAttributes() {
            return new ArrayList();
        }

        public boolean isDefaultValue(GraphMLWriteContext graphMLWriteContext) {
            return false;
        }

        public void writeValue(GraphMLWriteContext graphMLWriteContext) throws GraphMLWriteException {
            XmlWriter xmlWriter = graphMLWriteContext.getWriter();
            xmlWriter.writeStartElement("Resources", "http://www.yworks.com/xml/graphml");
            ResourceSerializationHandler resourceSerializationHandler = (ResourceSerializationHandler)graphMLWriteContext.lookup(class$y$io$graphml$graph2d$ResourceSerializationHandler == null ? (class$y$io$graphml$graph2d$ResourceSerializationHandler = Graph2DGraphMLHandler.class$("y.io.graphml.graph2d.ResourceSerializationHandler")) : class$y$io$graphml$graph2d$ResourceSerializationHandler);
            if (resourceSerializationHandler != null) {
                resourceSerializationHandler.writeResources(graphMLWriteContext, xmlWriter);
            }
            xmlWriter.writeEndElement();
        }

        public void writeKeyDefinitionContent(GraphMLWriteContext graphMLWriteContext) {
        }
    }

    private static class _d
    implements ResourceDeserializationHandler {
        private HashMap b = new HashMap();

        private _d() {
        }

        public Object getResourceForID(String string2, DeserializationHandler deserializationHandler, Class clazz, GraphMLParseContext graphMLParseContext) throws GraphMLParseException {
            _b _b2;
            block5: {
                block7: {
                    org.w3c.dom.Node node;
                    block6: {
                        _b2 = (_b)this.b.get(string2);
                        if (_b2 == null) {
                            return null;
                        }
                        if (_b2.d) break block5;
                        node = XPathUtils.selectFirstSignificantChild(_b2.c);
                        if (node == null) {
                            _b2.b = null;
                            return null;
                        }
                        if (deserializationHandler == null) break block6;
                        DeserializationEvent deserializationEvent = new DeserializationEvent(this, graphMLParseContext, node, clazz);
                        deserializationHandler.onHandleDeserialization(deserializationEvent);
                        if (!deserializationEvent.isHandled()) break block7;
                        _b2.b = deserializationEvent.getResult();
                        if (AbstractNodeRealizerSerializer.z == 0) break block7;
                    }
                    _b2.b = graphMLParseContext.deserialize(graphMLParseContext, node, clazz);
                }
                _b2.d = true;
            }
            return _b2.b;
        }

        public void registerResourceNode(String string2, org.w3c.dom.Node node) {
            _b _b2 = new _b();
            _b2.c = node;
            this.b.put(string2, _b2);
        }

        private static class _b {
            private Object b;
            private org.w3c.dom.Node c;
            private boolean d;

            private _b() {
            }
        }
    }

    private static class y.io.graphml.graph2d.Graph2DGraphMLHandler$_b
    implements ResourceSerializationHandler {
        private int c;
        private HashMap d = new HashMap();
        private List b = new LinkedList();

        private y.io.graphml.graph2d.Graph2DGraphMLHandler$_b() {
        }

        public ResourceDescriptor registerResource(Object object, SerializationHandler serializationHandler) {
            return this.registerResource(object, serializationHandler, null);
        }

        public ResourceDescriptor registerResource(Object object, SerializationHandler serializationHandler, String string2) {
            if (this.isRegistered(object)) {
                return (ResourceDescriptor)this.d.get(object);
            }
            ++this.c;
            String string3 = String.valueOf(this.c);
            _b _b2 = new _b(string3, string2, serializationHandler, object);
            this.d.put(object, _b2);
            this.b.add(_b2);
            return _b2;
        }

        public Collection getDescriptors() {
            return this.b;
        }

        public boolean isRegistered(Object object) {
            return this.d.containsKey(object);
        }

        public void writeResources(GraphMLWriteContext graphMLWriteContext, XmlWriter xmlWriter) throws GraphMLWriteException {
            int n2 = AbstractNodeRealizerSerializer.z;
            int n3 = 0;
            block0: while (n3 < this.b.size()) {
                LinkedList linkedList = new LinkedList(this.b);
                ListIterator listIterator = linkedList.listIterator(n3);
                while (listIterator.hasNext()) {
                    block7: {
                        ResourceDescriptor resourceDescriptor;
                        block6: {
                            resourceDescriptor = (ResourceDescriptor)listIterator.next();
                            SerializationHandler serializationHandler = resourceDescriptor.getEncoder();
                            xmlWriter.writeStartElement("Resource", "http://www.yworks.com/xml/graphml");
                            xmlWriter.writeAttribute("id", resourceDescriptor.getId());
                            String string2 = resourceDescriptor.getClassName();
                            if (n2 != 0) break block0;
                            if (string2 != null && string2.length() > 0) {
                                xmlWriter.writeAttribute("type", string2);
                            }
                            if (serializationHandler == null) break block6;
                            serializationHandler.onHandleSerialization(new SerializationEvent(this, graphMLWriteContext, resourceDescriptor.getResource()));
                            if (n2 == 0) break block7;
                        }
                        graphMLWriteContext.serialize(resourceDescriptor.getResource());
                    }
                    xmlWriter.writeEndElement();
                    ++n3;
                    if (n2 == 0) continue;
                }
            }
        }

        private static class _b
        implements ResourceDescriptor {
            private String e;
            private SerializationHandler c;
            private String b;
            private Object d;

            public String getClassName() {
                return this.b;
            }

            public _b(String string2, String string3, SerializationHandler serializationHandler, Object object) {
                this.d = object;
                this.e = string2;
                this.c = serializationHandler;
                this.b = string3;
            }

            public String getId() {
                return this.e;
            }

            public SerializationHandler getEncoder() {
                return this.c;
            }

            public Object getResource() {
                return this.d;
            }
        }
    }
}

