/*
 * Decompiled with CFR 0.152.
 */
package y.io.graphml.graph2d;

import java.util.Iterator;
import y.base.Edge;
import y.base.EdgeList;
import y.base.Graph;
import y.base.Node;
import y.base.NodeList;
import y.io.graphml.output.GraphMLWriteContext;
import y.io.graphml.output.HierarchySupport;
import y.view.hierarchy.HierarchyManager;

public class HierarchyManagerBasedHierarchySupport
implements HierarchySupport {
    private HierarchyManager c;
    private Graph b;

    public HierarchyManagerBasedHierarchySupport(HierarchyManager hierarchyManager) {
        this(hierarchyManager, hierarchyManager.getRootGraph());
    }

    public HierarchyManagerBasedHierarchySupport(HierarchyManager hierarchyManager, Graph graph) {
        this.c = hierarchyManager;
        this.b = graph;
    }

    public boolean isLeafNode(GraphMLWriteContext graphMLWriteContext, Node node) {
        return this.c.isNormalNode(node);
    }

    public NodeList getChildren(GraphMLWriteContext graphMLWriteContext, Node node) {
        return new NodeList(this.c.getChildren(node));
    }

    public Node getRoot(GraphMLWriteContext graphMLWriteContext) {
        return this.c.getAnchorNode(this.b);
    }

    public Node getParent(GraphMLWriteContext graphMLWriteContext, Node node) {
        return this.c.getParentNode(node);
    }

    public Node getNearestCommonAncestor(GraphMLWriteContext graphMLWriteContext, Node node, Node node2) {
        NodeList nodeList = new NodeList();
        nodeList.add(node);
        nodeList.add(node2);
        return this.c.getNearestCommonAncestor(nodeList);
    }

    public EdgeList getSubgraphEdges(GraphMLWriteContext graphMLWriteContext, Graph graph) {
        HierarchyManager hierarchyManager = HierarchyManager.getInstance(graph);
        if (graphMLWriteContext.getObjectStack().size() > 2) {
            Iterator iterator2 = graphMLWriteContext.getObjectStack().iterator();
            iterator2.next();
            Node node = (Node)iterator2.next();
            if (hierarchyManager.isFolderNode(node)) {
                return new EdgeList(graph.edges());
            }
            return new EdgeList();
        }
        return new EdgeList(graphMLWriteContext.getGraph().edges());
    }

    public Graph getSubgraph(GraphMLWriteContext graphMLWriteContext, Node node) {
        if (this.c.isFolderNode(node)) {
            return this.c.getInnerGraph(node);
        }
        return graphMLWriteContext.getGraph();
    }

    public Node getSourceNode(GraphMLWriteContext graphMLWriteContext, Edge edge) {
        if (this.c.isInterEdge(edge)) {
            return this.c.getRealSource(edge);
        }
        return edge.source();
    }

    public Node getTargetNode(GraphMLWriteContext graphMLWriteContext, Edge edge) {
        if (this.c.isInterEdge(edge)) {
            return this.c.getRealTarget(edge);
        }
        return edge.target();
    }
}

