/*
 * Decompiled with CFR 0.152.
 */
package y.io.graphml.output;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import y.io.graphml.KeyScope;
import y.io.graphml.KeyType;
import y.io.graphml.output.GraphMLWriteContext;
import y.io.graphml.output.GraphMLWriteException;
import y.io.graphml.output.GraphMLXmlAttribute;
import y.io.graphml.output.OutputHandler;
import y.io.graphml.output.OutputHandlerProvider;
import y.io.graphml.output.QueryOutputHandlersEvent;
import y.io.graphml.output.WritePrecedence;

public abstract class AbstractOutputHandler
implements OutputHandler,
OutputHandlerProvider {
    private Object d;
    private boolean e;
    private WritePrecedence c = WritePrecedence.DEFAULT;
    private final Collection j = new ArrayList();
    private final Collection h = new ArrayList();
    private boolean g = true;
    private KeyScope f;
    private Set i;

    public KeyScope getScope() {
        return this.f;
    }

    public void setScope(KeyScope keyScope) {
        this.f = keyScope;
        this.addScopeToKeyDefinition(keyScope);
    }

    protected AbstractOutputHandler() {
    }

    protected AbstractOutputHandler(String string2, KeyScope keyScope, KeyType keyType) {
        this.addTypeToKeyDefinition(keyType);
        this.addNameToKeyDefinition(string2);
        this.addScopeToKeyDefinition(keyScope);
        this.f = keyScope;
        if (keyScope == KeyScope.GRAPHML) {
            this.i = new HashSet();
            this.i.add(KeyScope.GRAPHML);
        }
    }

    public void onQueryOutputHandler(QueryOutputHandlersEvent queryOutputHandlersEvent) throws GraphMLWriteException {
        if (this.f != null) {
            queryOutputHandlersEvent.addOutputHandler(this, this.f);
        }
    }

    public void addNameToKeyDefinition(String string2) {
        if (string2 != null && string2.length() > 0) {
            this.j.add(new GraphMLXmlAttribute("attr.name", null, string2));
        }
    }

    public void addUriToKeyDefinition(String string2) {
        if (string2 != null && string2.length() > 0) {
            this.j.add(new GraphMLXmlAttribute("attr.uri", "http://www.yworks.com/xml/yfiles-common/2.0", string2));
        }
    }

    public void addTypeToKeyDefinition(KeyType keyType) {
        if (keyType != KeyType.COMPLEX) {
            this.j.add(new GraphMLXmlAttribute("attr.type", null, keyType.toString().toLowerCase(Locale.US)));
        }
    }

    public void addScopeToKeyDefinition(KeyScope keyScope) {
        if (keyScope != KeyScope.GRAPHML) {
            this.j.add(new GraphMLXmlAttribute("for", null, keyScope.toString().toLowerCase(Locale.US)));
        }
    }

    public Object getDefaultValue() {
        return this.d;
    }

    public void setDefaultValue(Object object) {
        this.e = true;
        this.d = object;
    }

    public boolean hasDefaultValueAssigned() {
        return this.e;
    }

    protected void setDefaultValueAssigned(boolean bl) {
        this.e = bl;
    }

    public WritePrecedence getPrecedence() {
        return this.c;
    }

    public void setPrecedence(WritePrecedence writePrecedence) {
        this.c = writePrecedence;
    }

    public Collection getKeyDefinitionAttributes() {
        return this.j;
    }

    public Collection getDataTagAttributes() {
        return this.h;
    }

    public boolean isDefaultValue(GraphMLWriteContext graphMLWriteContext) throws GraphMLWriteException {
        if (!this.isValidScope(graphMLWriteContext)) {
            return true;
        }
        if (!this.hasDefaultValueAssigned()) {
            return false;
        }
        Object object = graphMLWriteContext.getCurrentObject();
        Object object2 = this.getDefaultValue();
        Object object3 = this.getValue(graphMLWriteContext, object);
        if (object3 == null) {
            return object2 == null;
        }
        return object3.equals(object2);
    }

    protected boolean isValidScope(GraphMLWriteContext graphMLWriteContext) {
        if (this.i == null || this.i.contains(KeyScope.ALL)) {
            return true;
        }
        KeyScope keyScope = (KeyScope)graphMLWriteContext.getSerializationProperty("y.io.graphml.output.SerializationProperties.CURRENT_KEY_SCOPE");
        return this.i.contains(keyScope);
    }

    public Set getValidScopes() {
        if (this.i == null) {
            this.i = new HashSet();
            this.i.add(KeyScope.ALL);
        }
        return this.i;
    }

    public void setValidScopes(Set set2) {
        if (set2 == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        this.i = set2;
    }

    public void writeValue(GraphMLWriteContext graphMLWriteContext) throws GraphMLWriteException {
        Object object = graphMLWriteContext.getCurrentObject();
        Object object2 = this.getValue(graphMLWriteContext, object);
        this.writeValueCore(graphMLWriteContext, object2);
    }

    public void writeKeyDefinitionContent(GraphMLWriteContext graphMLWriteContext) throws GraphMLWriteException {
        if (this.hasDefaultValueAssigned() && this.isWriteKeyDefault()) {
            graphMLWriteContext.getWriter().writeStartElement("default", "http://graphml.graphdrawing.org/xmlns");
            this.writeValueCore(graphMLWriteContext, this.getDefaultValue());
            graphMLWriteContext.getWriter().writeEndElement();
        }
    }

    public void setWriteKeyDefault(boolean bl) {
        this.g = bl;
    }

    public boolean isWriteKeyDefault() {
        return this.g;
    }

    protected abstract void writeValueCore(GraphMLWriteContext var1, Object var2) throws GraphMLWriteException;

    protected abstract Object getValue(GraphMLWriteContext var1, Object var2) throws GraphMLWriteException;
}

