/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.util.HashMap;
import java.util.Map;
import y.base.DataProvider;
import y.base.Edge;
import y.base.Node;
import y.base.NodeList;
import y.base.YList;
import y.base.c;
import y.geom.YPoint;
import y.layout.EdgeLayout;
import y.layout.LayoutGraph;
import y.layout.LayoutStage;
import y.layout.Layouter;
import y.layout.NodeLayout;
import y.layout.PortConstraintKeys;
import y.util.DataProviderAdapter;

public class BendConverter
implements LayoutStage {
    public static final Object SCOPE_DPKEY = "y.layout.BendConverter#SCOPE_DPKEY";
    private Layouter dlb;
    private double olb;
    private DataProvider ilb;
    private DataProvider llb;
    private DataProvider mlb;
    private DataProvider clb;
    private DataProvider nlb;
    private Map glb;
    private Map flb;
    private boolean klb;
    private boolean hlb;
    private boolean elb;
    Object jlb;

    public BendConverter() {
        this(1.0);
    }

    public BendConverter(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Size must be non-negative");
        }
        this.olb = d2;
        this.klb = true;
        this.hlb = true;
        this.elb = true;
        this.jlb = Layouter.SELECTED_EDGES;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        return this.dlb == null || this.dlb.canLayout(layoutGraph);
    }

    public void doLayout(LayoutGraph layoutGraph) {
        if (this.dlb != null) {
            this.prepare(layoutGraph);
            this.dlb.doLayout(layoutGraph);
            this.unprepare(layoutGraph);
        }
    }

    protected void prepare(LayoutGraph layoutGraph) {
        DataProvider dataProvider;
        Object object;
        Object object2;
        block9: {
            int n2 = LayoutGraph.z;
            this.flb = new HashMap();
            this.glb = new HashMap();
            DataProvider dataProvider2 = layoutGraph.getDataProvider(SCOPE_DPKEY);
            object2 = layoutGraph.edges();
            while (object2.ok()) {
                block10: {
                    EdgeLayout edgeLayout;
                    object = object2.edge();
                    dataProvider = dataProvider2;
                    if (n2 != 0) break block9;
                    if ((dataProvider == null || dataProvider2.getBool(object)) && (edgeLayout = layoutGraph.getEdgeLayout(object)).pointCount() > 0) {
                        Object object3;
                        c c2;
                        Object object4;
                        NodeList nodeList = new NodeList();
                        this.flb.put(object, nodeList);
                        Node node = ((Edge)object).source();
                        for (int i2 = 0; i2 < edgeLayout.pointCount(); ++i2) {
                            object4 = edgeLayout.getPoint(i2);
                            c2 = layoutGraph.createNode();
                            object3 = layoutGraph.getNodeLayout(c2);
                            nodeList.add(c2);
                            object3.setSize(this.olb, this.olb);
                            object3.setLocation(((YPoint)object4).x - this.olb * 0.5, ((YPoint)object4).y - this.olb * 0.5);
                            Edge edge = layoutGraph.createEdge(node, (Node)c2);
                            this.glb.put(edge, object);
                            node = c2;
                            if (n2 == 0) {
                                if (n2 == 0) continue;
                            }
                            break block10;
                        }
                        Edge edge = layoutGraph.createEdge(node, ((Edge)object).target());
                        this.glb.put(edge, object);
                        object4 = layoutGraph.getEdgeLayout(edge);
                        object4.setTargetPoint(edgeLayout.getTargetPoint());
                        c2 = nodeList.firstNode().firstInEdge();
                        object3 = layoutGraph.getEdgeLayout(c2);
                        object3.setSourcePoint(edgeLayout.getSourcePoint());
                        this.addedPathForEdge(layoutGraph, (Edge)object, nodeList);
                        layoutGraph.hide((Edge)object);
                    }
                    object2.next();
                }
                if (n2 == 0) continue;
            }
            dataProvider = this.ilb = layoutGraph.getDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY);
        }
        if (dataProvider != null && this.isAdoptPortConstraintsEnabled()) {
            object2 = new DataProviderAdapter(){

                public Object get(Object object) {
                    Object v2 = BendConverter.this.glb.get(object);
                    if (v2 == null) {
                        return BendConverter.this.ilb.get(object);
                    }
                    Edge edge = (Edge)object;
                    if (BendConverter.this.b(edge, BendConverter.this.glb)) {
                        return BendConverter.this.ilb.get(v2);
                    }
                    return null;
                }
            };
            layoutGraph.addDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY, (DataProvider)object2);
        }
        this.llb = layoutGraph.getDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY);
        if (this.llb != null && this.isAdoptPortConstraintsEnabled()) {
            object2 = new DataProviderAdapter(){

                public Object get(Object object) {
                    Object v2 = BendConverter.this.glb.get(object);
                    if (v2 == null) {
                        return BendConverter.this.llb.get(object);
                    }
                    Edge edge = (Edge)object;
                    if (BendConverter.this.c(edge, BendConverter.this.glb)) {
                        return BendConverter.this.llb.get(v2);
                    }
                    return null;
                }
            };
            layoutGraph.addDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY, (DataProvider)object2);
        }
        this.clb = layoutGraph.getDataProvider(PortConstraintKeys.SOURCE_GROUPID_KEY);
        if (this.clb != null && this.isAdoptEdgeGroupsEnabled()) {
            object2 = new DataProviderAdapter(){

                public Object get(Object object) {
                    Object v2 = BendConverter.this.glb.get(object);
                    if (v2 == null) {
                        return BendConverter.this.clb.get(object);
                    }
                    Edge edge = (Edge)object;
                    if (BendConverter.this.b(edge, BendConverter.this.glb)) {
                        return BendConverter.this.clb.get(v2);
                    }
                    return null;
                }
            };
            layoutGraph.addDataProvider(PortConstraintKeys.SOURCE_GROUPID_KEY, (DataProvider)object2);
        }
        this.mlb = layoutGraph.getDataProvider(PortConstraintKeys.TARGET_GROUPID_KEY);
        if (this.mlb != null && this.isAdoptEdgeGroupsEnabled()) {
            object2 = new DataProviderAdapter(){

                public Object get(Object object) {
                    Object v2 = BendConverter.this.glb.get(object);
                    if (v2 == null) {
                        return BendConverter.this.mlb.get(object);
                    }
                    Edge edge = (Edge)object;
                    if (BendConverter.this.c(edge, BendConverter.this.glb)) {
                        return BendConverter.this.mlb.get(v2);
                    }
                    return null;
                }
            };
            layoutGraph.addDataProvider(PortConstraintKeys.TARGET_GROUPID_KEY, (DataProvider)object2);
        }
        object2 = this.getSelectedEdgesDpKey();
        this.nlb = layoutGraph.getDataProvider(object2);
        if (this.nlb != null && this.isAdoptSelectionEnabled()) {
            object = new DataProviderAdapter(){

                public boolean getBool(Object object) {
                    Object v2 = BendConverter.this.glb.get(object);
                    return v2 != null ? BendConverter.this.nlb.getBool(v2) : BendConverter.this.nlb.getBool(object);
                }
            };
            layoutGraph.addDataProvider(this.getSelectedEdgesDpKey(), (DataProvider)object);
        }
    }

    protected void unprepare(LayoutGraph layoutGraph) {
        Object object;
        Object object2;
        block8: {
            int n2 = LayoutGraph.z;
            object2 = this.flb.entrySet().iterator();
            while (object2.hasNext()) {
                block9: {
                    Map.Entry entry = object2.next();
                    Edge edge = (Edge)entry.getKey();
                    layoutGraph.unhide(edge);
                    EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(entry.getKey());
                    NodeList nodeList = (NodeList)entry.getValue();
                    YList yList = new YList();
                    Node node = nodeList.firstNode();
                    Node node2 = nodeList.lastNode();
                    Edge edge2 = node.firstInEdge();
                    YPoint yPoint = layoutGraph.getEdgeLayout(node2.firstOutEdge()).getTargetPoint();
                    YPoint yPoint2 = layoutGraph.getEdgeLayout(node.firstInEdge()).getSourcePoint();
                    yList.splice(layoutGraph.getPointList(edge2));
                    object = nodeList.nodes();
                    if (n2 != 0) break block8;
                    Object object3 = object;
                    while (object3.ok()) {
                        Node node3 = object3.node();
                        NodeLayout nodeLayout = layoutGraph.getNodeLayout(node3);
                        yList.add(new YPoint(nodeLayout.getX() + 0.5 * nodeLayout.getWidth(), nodeLayout.getY() + 0.5 * nodeLayout.getHeight()));
                        edge2 = node3.firstOutEdge();
                        yList.splice(layoutGraph.getPointList(edge2));
                        layoutGraph.removeNode(node3);
                        object3.next();
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                        }
                        break block9;
                    }
                    edgeLayout.setSourcePoint(yPoint2);
                    edgeLayout.setTargetPoint(yPoint);
                    layoutGraph.setPoints(edge, yList);
                }
                if (n2 == 0) continue;
            }
            object = this.getSelectedEdgesDpKey();
        }
        object2 = object;
        layoutGraph.removeDataProvider(object2);
        if (this.nlb != null) {
            layoutGraph.addDataProvider(object2, this.nlb);
        }
        this.nlb = null;
        layoutGraph.removeDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY);
        if (this.ilb != null) {
            layoutGraph.addDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY, this.ilb);
        }
        this.ilb = null;
        layoutGraph.removeDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY);
        if (this.llb != null) {
            layoutGraph.addDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY, this.llb);
        }
        this.llb = null;
        layoutGraph.removeDataProvider(PortConstraintKeys.SOURCE_GROUPID_KEY);
        if (this.clb != null) {
            layoutGraph.addDataProvider(PortConstraintKeys.SOURCE_GROUPID_KEY, this.clb);
        }
        this.clb = null;
        layoutGraph.removeDataProvider(PortConstraintKeys.TARGET_GROUPID_KEY);
        if (this.mlb != null) {
            layoutGraph.addDataProvider(PortConstraintKeys.TARGET_GROUPID_KEY, this.mlb);
        }
        this.mlb = null;
        this.glb = null;
        this.flb = null;
    }

    private boolean b(Edge edge, Map map2) {
        return edge.source().inDegree() != 1 || map2.get(edge.source().firstInEdge()) == null;
    }

    private boolean c(Edge edge, Map map2) {
        return edge.target().inDegree() != 1 || map2.get(edge.target().firstOutEdge()) == null;
    }

    public Layouter getCoreLayouter() {
        return this.dlb;
    }

    public void setCoreLayouter(Layouter layouter) {
        this.dlb = layouter;
    }

    public boolean isAdoptEdgeGroupsEnabled() {
        return this.elb;
    }

    public void setAdoptEdgeGroupsEnabled(boolean bl) {
        this.elb = bl;
    }

    public boolean isAdoptPortConstraintsEnabled() {
        return this.hlb;
    }

    public void setAdoptPortConstraintsEnabled(boolean bl) {
        this.hlb = bl;
    }

    public boolean isAdoptSelectionEnabled() {
        return this.klb;
    }

    public void setAdoptSelectionEnabled(boolean bl) {
        this.klb = bl;
    }

    protected void addedPathForEdge(LayoutGraph layoutGraph, Edge edge, NodeList nodeList) {
    }

    public Object getSelectedEdgesDpKey() {
        return this.jlb;
    }

    public void setSelectedEdgesDpKey(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null");
        }
        this.jlb = object;
    }
}

