/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import y.base.DataProvider;
import y.base.Graph;
import y.base.GraphInterface;
import y.layout.BufferedLayouter;
import y.layout.ComponentLayouter;
import y.layout.GraphLayout;
import y.layout.LayoutGraph;
import y.layout.LayoutStage;
import y.layout.Layouter;
import y.layout.NodeLayout;
import y.layout.OrientationLayouter;
import y.layout.ParallelEdgeLayouter;
import y.layout.SelfLoopLayouter;
import y.layout.SubgraphLayouter;
import y.layout.grouping.GroupNodeHider;
import y.layout.grouping.GroupingKeys;
import y.layout.labeling.GreedyMISLabeling;
import y.util.DataProviders;

public abstract class CanonicMultiStageLayouter
implements Layouter {
    private static final String cm = "y.layout.CANONIC_MULTI_STAGE_LAYOUTER_NODE_SIZE_CHECKED_DPKEY";
    private LayoutStage zl;
    private LayoutStage hm;
    private LayoutStage im;
    private LayoutStage em;
    private LayoutStage lm;
    private LayoutStage gm;
    private LayoutStage dm;
    boolean nm = true;
    boolean jm = true;
    boolean om = true;
    boolean km = false;
    boolean bm = true;
    boolean am = false;
    boolean mm = true;
    List fm = new ArrayList(5);
    List yl = new ArrayList(5);

    public CanonicMultiStageLayouter() {
        this.zl = new SelfLoopLayouter();
        this.hm = new ParallelEdgeLayouter();
        this.im = new ComponentLayouter();
        this.em = new SubgraphLayouter();
        this.lm = new OrientationLayouter();
        this.gm = new GreedyMISLabeling();
        this.dm = new GroupNodeHider();
    }

    protected abstract void doLayoutCore(LayoutGraph var1);

    protected abstract boolean canLayoutCore(LayoutGraph var1);

    private void n(LayoutGraph layoutGraph) {
        this.b(layoutGraph, layoutGraph);
    }

    private void b(GraphInterface graphInterface, GraphLayout graphLayout) {
        int n2 = LayoutGraph.z;
        DataProvider dataProvider = graphInterface.getDataProvider(GroupingKeys.GROUP_DPKEY);
        if (dataProvider == null) {
            dataProvider = DataProviders.createConstantDataProvider(Boolean.FALSE);
        }
        Iterator iterator2 = graphInterface.nodeObjects();
        while (iterator2.hasNext()) {
            Object e2 = iterator2.next();
            if (!dataProvider.getBool(e2)) {
                this.checkNodeSize(graphLayout, e2);
                if (n2 == 0) continue;
            }
            this.checkGroupNodeSize(graphLayout, e2);
            if (n2 == 0) continue;
        }
    }

    protected void checkNodeSize(GraphLayout graphLayout, Object object) throws IllegalArgumentException {
        NodeLayout nodeLayout = graphLayout.getNodeLayout(object);
        if (nodeLayout.getWidth() == 0.0 || nodeLayout.getHeight() == 0.0) {
            throw new IllegalArgumentException("Graph contains nodes with zero width/height. Please enlarge those nodes manually or by using LayoutStage y.layout.MinNodeSizeStage.");
        }
    }

    protected void checkGroupNodeSize(GraphLayout graphLayout, Object object) throws IllegalArgumentException {
        NodeLayout nodeLayout = graphLayout.getNodeLayout(object);
        if (nodeLayout.getWidth() == 0.0 || nodeLayout.getHeight() == 0.0) {
            throw new IllegalArgumentException("Graph contains group nodes with zero width/height. Please enlarge those nodes manually or by using LayoutStage y.layout.MinNodeSizeStage.");
        }
    }

    public void prependStage(LayoutStage layoutStage) {
        this.fm.add(layoutStage);
    }

    public void appendStage(LayoutStage layoutStage) {
        this.yl.add(layoutStage);
    }

    public void removeStage(LayoutStage layoutStage) {
        int n2 = this.fm.indexOf(layoutStage);
        if (n2 >= 0) {
            this.fm.remove(n2);
        }
        if ((n2 = this.yl.indexOf(layoutStage)) >= 0) {
            this.yl.remove(n2);
        }
    }

    public LayoutStage getLabelLayouter() {
        return this.gm;
    }

    public void setLabelLayouter(LayoutStage layoutStage) {
        this.gm = layoutStage;
    }

    public LayoutStage getSelfLoopLayouter() {
        return this.zl;
    }

    public void setSelfLoopLayouter(LayoutStage layoutStage) {
        this.zl = layoutStage;
    }

    public LayoutStage getParallelEdgeLayouter() {
        return this.hm;
    }

    public void setParallelEdgeLayouter(LayoutStage layoutStage) {
        this.hm = layoutStage;
    }

    public LayoutStage getComponentLayouter() {
        return this.im;
    }

    public void setComponentLayouter(LayoutStage layoutStage) {
        this.im = layoutStage;
    }

    public LayoutStage getSubgraphLayouter() {
        return this.em;
    }

    public void setSubgraphLayouter(LayoutStage layoutStage) {
        this.em = layoutStage;
    }

    public LayoutStage getGroupNodeHider() {
        return this.dm;
    }

    public void setGroupNodeHider(LayoutStage layoutStage) {
        this.dm = layoutStage;
    }

    public LayoutStage getOrientationLayouter() {
        return this.lm;
    }

    public void setOrientationLayouter(LayoutStage layoutStage) {
        this.lm = layoutStage;
    }

    public void setOrientationLayouterEnabled(boolean bl) {
        this.bm = bl;
    }

    public void setLayoutOrientation(byte by) {
        if (this.lm instanceof OrientationLayouter) {
            ((OrientationLayouter)this.lm).setOrientation(by);
        }
    }

    public byte getLayoutOrientation() {
        if (this.lm instanceof OrientationLayouter) {
            return ((OrientationLayouter)this.lm).getOrientation();
        }
        return 0;
    }

    public boolean isOrientationLayouterEnabled() {
        return this.bm;
    }

    public void setSelfLoopLayouterEnabled(boolean bl) {
        this.jm = bl;
    }

    public boolean isSelfLoopLayouterEnabled() {
        return this.jm;
    }

    public void setLabelLayouterEnabled(boolean bl) {
        this.am = bl;
    }

    public boolean isLabelLayouterEnabled() {
        return this.am;
    }

    public boolean isGroupNodeHidingEnabled() {
        return this.mm;
    }

    public void setGroupNodeHidingEnabled(boolean bl) {
        this.mm = bl;
    }

    public void setComponentLayouterEnabled(boolean bl) {
        this.om = bl;
    }

    public boolean isComponentLayouterEnabled() {
        return this.om;
    }

    public void setParallelEdgeLayouterEnabled(boolean bl) {
        this.nm = bl;
    }

    public boolean isParallelEdgeLayouterEnabled() {
        return this.nm;
    }

    public void setSubgraphLayouterEnabled(boolean bl) {
        this.km = bl;
    }

    public boolean isSubgraphLayouterEnabled() {
        return this.km;
    }

    public void enableOnlyCore() {
        this.km = false;
        this.nm = false;
        this.am = false;
        this.jm = false;
        this.om = false;
        this.bm = false;
        this.mm = false;
    }

    private Layouter lc() {
        Layouter layouter;
        block12: {
            LayoutStage layoutStage;
            int n2;
            Layouter layouter2;
            int n3;
            block11: {
                n3 = LayoutGraph.z;
                layouter2 = new _b();
                for (n2 = this.yl.size() - 1; n2 >= 0; --n2) {
                    layoutStage = (LayoutStage)this.yl.get(n2);
                    layoutStage.setCoreLayouter(layouter2);
                    layouter2 = layoutStage;
                    if (n3 == 0) {
                        if (n3 == 0) continue;
                    }
                    break block11;
                }
                if (this.nm) {
                    this.hm.setCoreLayouter(layouter2);
                    layouter2 = this.hm;
                }
            }
            if (this.jm) {
                this.zl.setCoreLayouter(layouter2);
                layouter2 = this.zl;
            }
            if (this.bm) {
                this.lm.setCoreLayouter(layouter2);
                layouter2 = this.lm;
            }
            if (this.am) {
                this.gm.setCoreLayouter(layouter2);
                layouter2 = this.gm;
            }
            if (this.om) {
                this.im.setCoreLayouter(layouter2);
                layouter2 = this.im;
            }
            if (this.km) {
                this.em.setCoreLayouter(layouter2);
                layouter2 = this.em;
            }
            if (this.mm) {
                this.dm.setCoreLayouter(layouter2);
                layouter2 = this.dm;
            }
            for (n2 = 0; n2 < this.fm.size(); ++n2) {
                layoutStage = (LayoutStage)this.fm.get(n2);
                layoutStage.setCoreLayouter(layouter2);
                layouter = layoutStage;
                if (n3 == 0) {
                    layouter2 = layouter;
                    if (n3 == 0) continue;
                }
                break block12;
            }
            layouter = layouter2;
        }
        return layouter;
    }

    public void doLayout(LayoutGraph layoutGraph) {
        boolean bl = false;
        if (layoutGraph.getDataProvider(cm) == null) {
            this.n(layoutGraph);
            layoutGraph.addDataProvider(cm, DataProviders.createConstantDataProvider(Boolean.TRUE));
            bl = true;
        }
        Layouter layouter = this.lc();
        layouter.doLayout(layoutGraph);
        if (bl) {
            layoutGraph.removeDataProvider(cm);
        }
    }

    public void doLayout(GraphInterface graphInterface, GraphLayout graphLayout) {
        boolean bl = false;
        if (graphInterface.getDataProvider(cm) == null) {
            this.b(graphInterface, graphLayout);
            if (graphInterface instanceof Graph) {
                ((Graph)graphInterface).addDataProvider(cm, DataProviders.createConstantDataProvider(Boolean.TRUE));
                bl = true;
            }
        }
        new BufferedLayouter(this.lc()).doLayout(graphInterface, graphLayout);
        if (bl) {
            ((Graph)graphInterface).removeDataProvider(cm);
        }
    }

    public GraphLayout calcLayout(LayoutGraph layoutGraph) {
        return this.calcLayout(layoutGraph, layoutGraph);
    }

    public GraphLayout calcLayout(GraphInterface graphInterface, GraphLayout graphLayout) {
        boolean bl = false;
        if (graphInterface.getDataProvider(cm) == null) {
            this.b(graphInterface, graphLayout);
            if (graphInterface instanceof Graph) {
                ((Graph)graphInterface).addDataProvider(cm, DataProviders.createConstantDataProvider(Boolean.TRUE));
                bl = true;
            }
        }
        GraphLayout graphLayout2 = new BufferedLayouter(this.lc()).calcLayout(graphInterface, graphLayout);
        if (bl) {
            ((Graph)graphInterface).removeDataProvider(cm);
        }
        return graphLayout2;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        if (layoutGraph.getDataProvider(cm) == null) {
            try {
                this.n(layoutGraph);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
        Layouter layouter = this.lc();
        return layouter.canLayout(layoutGraph);
    }

    class _b
    implements Layouter {
        _b() {
        }

        public void doLayout(LayoutGraph layoutGraph) {
            boolean bl = false;
            if (layoutGraph.getDataProvider(CanonicMultiStageLayouter.cm) == null) {
                CanonicMultiStageLayouter.this.n(layoutGraph);
                layoutGraph.addDataProvider(CanonicMultiStageLayouter.cm, DataProviders.createConstantDataProvider(Boolean.TRUE));
                bl = true;
            }
            CanonicMultiStageLayouter.this.doLayoutCore(layoutGraph);
            if (bl) {
                layoutGraph.removeDataProvider(CanonicMultiStageLayouter.cm);
            }
        }

        public boolean canLayout(LayoutGraph layoutGraph) {
            if (layoutGraph.getDataProvider(CanonicMultiStageLayouter.cm) == null) {
                try {
                    CanonicMultiStageLayouter.this.n(layoutGraph);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }
            return CanonicMultiStageLayouter.this.canLayoutCore(layoutGraph);
        }
    }
}

