/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.util.HashMap;
import java.util.Map;
import y.base.Edge;
import y.base.EdgeMap;
import y.base.Node;
import y.base.NodeMap;
import y.base.YCursor;
import y.layout.DefaultEdgeLayout;
import y.layout.DefaultNodeLayout;
import y.layout.EdgeLabelLayout;
import y.layout.EdgeLayout;
import y.layout.LayoutGraph;
import y.layout.LayoutGraphCopyFactory;
import y.layout.NodeLabelLayout;
import y.layout.NodeLayout;
import y.util.GraphCopier;

public class DefaultLayoutGraph
extends LayoutGraph {
    private NodeMap zc;
    private EdgeMap ad;
    protected NodeMap nodeLabelMap;
    protected EdgeMap edgeLabelMap;
    protected Map nodeLabelFeatureMap = new HashMap();
    protected Map edgeLabelFeatureMap = new HashMap();

    public DefaultLayoutGraph() {
        this.zc = this.createNodeMap();
        this.nodeLabelMap = this.createNodeMap();
        this.ad = this.createEdgeMap();
        this.edgeLabelMap = this.createEdgeMap();
    }

    public DefaultLayoutGraph(LayoutGraph layoutGraph) {
        this(layoutGraph, (YCursor)layoutGraph.nodes());
    }

    public DefaultLayoutGraph(LayoutGraph layoutGraph, YCursor yCursor) {
        super(layoutGraph, yCursor);
        this.zc = this.createNodeMap();
        this.ad = this.createEdgeMap();
        this.nodeLabelMap = this.createNodeMap();
        this.edgeLabelMap = this.createEdgeMap();
    }

    protected GraphCopier.CopyFactory createGraphCopyFactory() {
        return new LayoutGraphCopyFactory.HierarchicGraphCopyFactory();
    }

    public DefaultLayoutGraph(DefaultLayoutGraph defaultLayoutGraph, YCursor yCursor) {
        this((LayoutGraph)defaultLayoutGraph, yCursor);
    }

    public NodeLayout getLayout(Node node) {
        NodeLayout nodeLayout = (NodeLayout)this.zc.get(node);
        if (nodeLayout == null) {
            nodeLayout = this.createNodeLayout();
            this.zc.set(node, nodeLayout);
        }
        return nodeLayout;
    }

    public void setLayout(Node node, NodeLayout nodeLayout) {
        this.zc.set(node, nodeLayout);
    }

    public void setLayout(Edge edge, EdgeLayout edgeLayout) {
        this.ad.set(edge, edgeLayout);
    }

    public EdgeLayout getLayout(Edge edge) {
        EdgeLayout edgeLayout = (EdgeLayout)this.ad.get(edge);
        if (edgeLayout == null) {
            edgeLayout = this.createEdgeLayout();
            this.ad.set(edge, edgeLayout);
        }
        return edgeLayout;
    }

    public NodeLabelLayout[] getLabelLayout(Node node) {
        NodeLabelLayout[] nodeLabelLayoutArray = (NodeLabelLayout[])this.nodeLabelMap.get(node);
        if (nodeLabelLayoutArray == null) {
            nodeLabelLayoutArray = new NodeLabelLayout[]{};
            this.nodeLabelMap.set(node, nodeLabelLayoutArray);
        }
        return nodeLabelLayoutArray;
    }

    public void setLabelLayout(Node node, NodeLabelLayout nodeLabelLayout) {
        NodeLabelLayout[] nodeLabelLayoutArray = new NodeLabelLayout[]{nodeLabelLayout};
        this.setLabelLayout(node, nodeLabelLayoutArray);
    }

    public void setLabelLayout(Node node, NodeLabelLayout[] nodeLabelLayoutArray) {
        int n2 = LayoutGraph.z;
        Object object = this.nodeLabelMap.get(node);
        if (object instanceof NodeLabelLayout[]) {
            NodeLabelLayout[] nodeLabelLayoutArray2 = (NodeLabelLayout[])object;
            for (int i2 = 0; i2 < nodeLabelLayoutArray2.length; ++i2) {
                NodeLabelLayout nodeLabelLayout = nodeLabelLayoutArray2[i2];
                this.nodeLabelFeatureMap.remove(nodeLabelLayout);
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break;
            }
        } else {
            this.nodeLabelMap.set(node, nodeLabelLayoutArray);
        }
        for (int i3 = 0; i3 < nodeLabelLayoutArray.length; ++i3) {
            NodeLabelLayout nodeLabelLayout = nodeLabelLayoutArray[i3];
            this.nodeLabelFeatureMap.put(nodeLabelLayout, node);
            if (n2 == 0) continue;
        }
    }

    public void setLabelLayout(Edge edge, EdgeLabelLayout[] edgeLabelLayoutArray) {
        int n2 = LayoutGraph.z;
        Object object = this.edgeLabelMap.get(edge);
        if (object instanceof EdgeLabelLayout[]) {
            EdgeLabelLayout[] edgeLabelLayoutArray2 = (EdgeLabelLayout[])object;
            for (int i2 = 0; i2 < edgeLabelLayoutArray2.length; ++i2) {
                EdgeLabelLayout edgeLabelLayout = edgeLabelLayoutArray2[i2];
                this.edgeLabelFeatureMap.remove(edgeLabelLayout);
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break;
            }
        } else {
            this.edgeLabelMap.set(edge, edgeLabelLayoutArray);
        }
        for (int i3 = 0; i3 < edgeLabelLayoutArray.length; ++i3) {
            this.edgeLabelFeatureMap.put(edgeLabelLayoutArray[i3], edge);
            if (n2 == 0) continue;
        }
    }

    public EdgeLabelLayout[] getLabelLayout(Edge edge) {
        EdgeLabelLayout[] edgeLabelLayoutArray = (EdgeLabelLayout[])this.edgeLabelMap.get(edge);
        if (edgeLabelLayoutArray == null) {
            edgeLabelLayoutArray = new EdgeLabelLayout[]{};
            this.edgeLabelMap.set(edge, edgeLabelLayoutArray);
        }
        return edgeLabelLayoutArray;
    }

    public Node getFeature(NodeLabelLayout nodeLabelLayout) {
        return (Node)this.nodeLabelFeatureMap.get(nodeLabelLayout);
    }

    public Edge getFeature(EdgeLabelLayout edgeLabelLayout) {
        return (Edge)this.edgeLabelFeatureMap.get(edgeLabelLayout);
    }

    protected EdgeLayout createEdgeLayout() {
        return new DefaultEdgeLayout();
    }

    protected NodeLayout createNodeLayout() {
        return new DefaultNodeLayout();
    }
}

