/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.NodeList;
import y.geom.YPoint;
import y.layout.AbstractLayoutStage;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.Layouter;

public class FixNodeLayoutStage
extends AbstractLayoutStage {
    public static final Object FIXED_NODE_DPKEY = "y.layout.FixNodeLayoutStage.FIXED_NODE_DPKEY";
    public static final byte FIX_POINT_POLICY_CENTER = 1;
    public static final byte FIX_POINT_POLICY_UPPER_LEFT = 2;
    private boolean lfc;
    private boolean nfc;
    private byte mfc = 1;

    public FixNodeLayoutStage() {
    }

    public FixNodeLayoutStage(Layouter layouter) {
        super(layouter);
    }

    public byte getFixPointPolicy() {
        return this.mfc;
    }

    public void setFixPointPolicy(byte by) {
        switch (by) {
            case 1: 
            case 2: {
                this.mfc = by;
                if (LayoutGraph.z == 0) break;
            }
            default: {
                throw new IllegalArgumentException("Invalid policy: " + by);
            }
        }
    }

    public boolean isIncludingEdges() {
        return this.lfc;
    }

    public void setIncludingEdges(boolean bl) {
        this.lfc = bl;
    }

    public boolean isIncludingLabels() {
        return this.nfc;
    }

    public void setIncludingLabels(boolean bl) {
        this.nfc = bl;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        return this.canLayoutCore(layoutGraph);
    }

    public void doLayout(LayoutGraph layoutGraph) {
        block7: {
            DataProvider dataProvider;
            int n2;
            block6: {
                n2 = LayoutGraph.z;
                dataProvider = layoutGraph.getDataProvider(FIXED_NODE_DPKEY);
                if (dataProvider != null) break block6;
                this.doLayoutCore(layoutGraph);
                if (n2 == 0) break block7;
            }
            NodeList nodeList = new NodeList();
            Object object = layoutGraph.nodes();
            while (object.ok()) {
                if (dataProvider.getBool(object.node())) {
                    nodeList.add(object.node());
                }
                object.next();
                if (n2 == 0) continue;
            }
            object = this.calculateFixPoint(layoutGraph, nodeList);
            this.doLayoutCore(layoutGraph);
            YPoint yPoint = this.calculateFixPoint(layoutGraph, nodeList);
            if (object != null && yPoint != null) {
                LayoutTool.moveSubgraph(layoutGraph, layoutGraph.nodes(), ((YPoint)object).getX() - yPoint.getX(), ((YPoint)object).getY() - yPoint.getY());
            }
        }
    }

    protected YPoint calculateFixPoint(LayoutGraph layoutGraph, NodeList nodeList) {
        return this.calculateFixPoint(this.calculateBounds(layoutGraph, nodeList));
    }

    protected YPoint calculateFixPoint(Rectangle2D rectangle2D) {
        if (rectangle2D == null || rectangle2D.getWidth() < 0.0 || rectangle2D.getHeight() < 0.0) {
            return null;
        }
        byte by = this.getFixPointPolicy();
        switch (by) {
            case 1: {
                return new YPoint(rectangle2D.getCenterX(), rectangle2D.getCenterY());
            }
            case 2: {
                return new YPoint(rectangle2D.getX(), rectangle2D.getY());
            }
        }
        throw new IllegalArgumentException("Invalid policy: " + by);
    }

    protected Rectangle2D calculateBounds(LayoutGraph layoutGraph, NodeList nodeList) {
        int n2 = LayoutGraph.z;
        if (nodeList.isEmpty()) {
            return new Rectangle2D.Double(0.0, 0.0, -1.0, -1.0);
        }
        EdgeList edgeList = new EdgeList();
        if (this.isIncludingEdges()) {
            HashSet hashSet = new HashSet(nodeList);
            HashSet<Edge> hashSet2 = new HashSet<Edge>();
            EdgeCursor edgeCursor = layoutGraph.edges();
            while (edgeCursor.ok()) {
                Edge edge = edgeCursor.edge();
                if (hashSet2.add(edge) && hashSet.contains(edge.source()) && hashSet.contains(edge.target())) {
                    edgeList.add(edge);
                }
                edgeCursor.next();
                if (n2 == 0) continue;
            }
        }
        return LayoutTool.getBoundingBox(layoutGraph, nodeList.nodes(), edgeList.edges(), this.isIncludingLabels());
    }
}

