/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.awt.Rectangle;
import java.util.ArrayList;
import y.base.Edge;
import y.base.EdgeList;
import y.base.Graph;
import y.base.ListCell;
import y.base.Node;
import y.base.YCursor;
import y.base.YList;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YPointCursor;
import y.geom.YPointPath;
import y.geom.YRectangle;
import y.layout.EdgeLabelLayout;
import y.layout.EdgeLayout;
import y.layout.GraphLayout;
import y.layout.NodeLabelLayout;
import y.layout.NodeLayout;
import y.util.GraphCopier;

public abstract class LayoutGraph
extends Graph
implements GraphLayout {
    public static int z;

    public LayoutGraph() {
    }

    public LayoutGraph(LayoutGraph layoutGraph) {
        this(layoutGraph, (YCursor)layoutGraph.nodes());
    }

    public LayoutGraph(LayoutGraph layoutGraph, YCursor yCursor) {
        super(layoutGraph, yCursor);
    }

    protected abstract GraphCopier.CopyFactory createGraphCopyFactory();

    public abstract NodeLayout getLayout(Node var1);

    public abstract EdgeLayout getLayout(Edge var1);

    public abstract NodeLabelLayout[] getLabelLayout(Node var1);

    public abstract EdgeLabelLayout[] getLabelLayout(Edge var1);

    public abstract Node getFeature(NodeLabelLayout var1);

    public abstract Edge getFeature(EdgeLabelLayout var1);

    public NodeLayout getNodeLayout(Object object) {
        return this.getLayout((Node)object);
    }

    public EdgeLayout getEdgeLayout(Object object) {
        return this.getLayout((Edge)object);
    }

    public NodeLabelLayout[] getNodeLabelLayout(Object object) {
        return this.getLabelLayout((Node)object);
    }

    public EdgeLabelLayout[] getEdgeLabelLayout(Object object) {
        return this.getLabelLayout((Edge)object);
    }

    public double getCenterX(Node node) {
        NodeLayout nodeLayout = this.getLayout(node);
        return nodeLayout.getX() + nodeLayout.getWidth() / 2.0;
    }

    public double getCenterY(Node node) {
        NodeLayout nodeLayout = this.getLayout(node);
        return nodeLayout.getY() + nodeLayout.getHeight() / 2.0;
    }

    public YPoint getCenter(Node node) {
        return new YPoint(this.getCenterX(node), this.getCenterY(node));
    }

    public double getX(Node node) {
        return this.getLayout(node).getX();
    }

    public double getY(Node node) {
        return this.getLayout(node).getY();
    }

    public YPoint getLocation(Node node) {
        NodeLayout nodeLayout = this.getLayout(node);
        return new YPoint(nodeLayout.getX(), nodeLayout.getY());
    }

    public double getWidth(Node node) {
        return this.getLayout(node).getWidth();
    }

    public double getHeight(Node node) {
        return this.getLayout(node).getHeight();
    }

    public YDimension getSize(Node node) {
        return new YDimension(this.getWidth(node), this.getHeight(node));
    }

    public YRectangle getRectangle(Node node) {
        return new YRectangle(this.getLocation(node), this.getSize(node));
    }

    public void setCenter(Node node, YPoint yPoint) {
        this.setCenter(node, yPoint.getX(), yPoint.getY());
    }

    public void setCenter(Node node, double d2, double d3) {
        NodeLayout nodeLayout = this.getLayout(node);
        nodeLayout.setLocation(d2 - nodeLayout.getWidth() / 2.0, d3 - nodeLayout.getHeight() / 2.0);
    }

    public void setSize(Node node, double d2, double d3) {
        this.getLayout(node).setSize(d2, d3);
    }

    public void setSize(Node node, YDimension yDimension) {
        this.setSize(node, yDimension.getWidth(), yDimension.getHeight());
    }

    public void setLocation(Node node, double d2, double d3) {
        this.getLayout(node).setLocation(d2, d3);
    }

    public void setLocation(Node node, YPoint yPoint) {
        this.setLocation(node, yPoint.getX(), yPoint.getY());
    }

    public void moveBy(Node node, double d2, double d3) {
        NodeLayout nodeLayout = this.getLayout(node);
        nodeLayout.setLocation(nodeLayout.getX() + d2, nodeLayout.getY() + d3);
    }

    public YPointPath getPoints(Edge edge) {
        int n2 = z;
        EdgeLayout edgeLayout = this.getLayout(edge);
        ArrayList<YPoint> arrayList = new ArrayList<YPoint>(edgeLayout.pointCount());
        for (int i2 = 0; i2 < edgeLayout.pointCount(); ++i2) {
            arrayList.add(edgeLayout.getPoint(i2));
            if (n2 == 0) continue;
        }
        return new YPointPath(arrayList);
    }

    public YList getPointList(Edge edge) {
        YList yList;
        block2: {
            int n2 = z;
            EdgeLayout edgeLayout = this.getLayout(edge);
            YList yList2 = new YList();
            for (int i2 = 0; i2 < edgeLayout.pointCount(); ++i2) {
                yList = yList2;
                if (n2 == 0) {
                    yList.add(edgeLayout.getPoint(i2));
                    if (n2 == 0) continue;
                }
                break block2;
            }
            yList = yList2;
        }
        return yList;
    }

    public YPointPath getPath(Edge edge) {
        ArrayList<Object> arrayList;
        block2: {
            int n2 = z;
            arrayList = new ArrayList<Object>();
            arrayList.add(this.getSourcePointAbs(edge));
            YPointCursor yPointCursor = this.getPoints(edge).points();
            while (yPointCursor.ok()) {
                arrayList.add(yPointCursor.current());
                yPointCursor.next();
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block2;
            }
            arrayList.add(this.getTargetPointAbs(edge));
        }
        return new YPointPath(arrayList);
    }

    public YList getPathList(Edge edge) {
        YList yList;
        block2: {
            int n2 = z;
            yList = new YList();
            yList.add(this.getSourcePointAbs(edge));
            YPointCursor yPointCursor = this.getPoints(edge).points();
            while (yPointCursor.ok()) {
                yList.add(yPointCursor.current());
                yPointCursor.next();
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block2;
            }
            yList.add(this.getTargetPointAbs(edge));
        }
        return yList;
    }

    public void setPath(Edge edge, YPointPath yPointPath) {
        block2: {
            int n2 = z;
            EdgeLayout edgeLayout = this.getLayout(edge);
            edgeLayout.clearPoints();
            YPointCursor yPointCursor = yPointPath.points();
            YPoint yPoint = yPointCursor.point();
            this.setSourcePointAbs(edge, yPoint);
            YPoint yPoint2 = yPointPath.getLast();
            yPointCursor.next();
            while (yPointCursor.current() != yPoint2) {
                yPoint = yPointCursor.point();
                edgeLayout.addPoint(yPoint.getX(), yPoint.getY());
                yPointCursor.next();
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block2;
            }
            this.setTargetPointAbs(edge, yPoint2);
        }
    }

    public void setPath(Edge edge, YList yList) {
        block2: {
            int n2 = z;
            EdgeLayout edgeLayout = this.getLayout(edge);
            edgeLayout.clearPoints();
            YCursor yCursor = yList.cursor();
            YPoint yPoint = (YPoint)yCursor.current();
            this.setSourcePointAbs(edge, yPoint);
            YPoint yPoint2 = (YPoint)yList.last();
            yCursor.next();
            while (yCursor.current() != yPoint2) {
                yPoint = (YPoint)yCursor.current();
                edgeLayout.addPoint(yPoint.getX(), yPoint.getY());
                yCursor.next();
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block2;
            }
            this.setTargetPointAbs(edge, yPoint2);
        }
    }

    public void setPoints(Edge edge, YPointPath yPointPath) {
        int n2 = z;
        EdgeLayout edgeLayout = this.getLayout(edge);
        edgeLayout.clearPoints();
        YPointCursor yPointCursor = yPointPath.points();
        while (yPointCursor.ok()) {
            YPoint yPoint = yPointCursor.point();
            edgeLayout.addPoint(yPoint.getX(), yPoint.getY());
            yPointCursor.next();
            if (n2 == 0) continue;
        }
    }

    public void setPoints(Edge edge, YList yList) {
        int n2 = z;
        EdgeLayout edgeLayout = this.getLayout(edge);
        edgeLayout.clearPoints();
        for (ListCell listCell = yList.firstCell(); listCell != null; listCell = listCell.succ()) {
            YPoint yPoint = (YPoint)listCell.getInfo();
            edgeLayout.addPoint(yPoint.getX(), yPoint.getY());
            if (n2 == 0) continue;
        }
    }

    public void setEndPointsAbs(Edge edge, YPoint yPoint, YPoint yPoint2) {
        this.setSourcePointAbs(edge, yPoint);
        this.setTargetPointAbs(edge, yPoint2);
    }

    public YPoint getSourcePointRel(Edge edge) {
        return this.getLayout(edge).getSourcePoint();
    }

    public YPoint getTargetPointRel(Edge edge) {
        return this.getLayout(edge).getTargetPoint();
    }

    public void setSourcePointRel(Edge edge, YPoint yPoint) {
        this.getLayout(edge).setSourcePoint(yPoint);
    }

    public void setTargetPointRel(Edge edge, YPoint yPoint) {
        this.getLayout(edge).setTargetPoint(yPoint);
    }

    public YPoint getSourcePointAbs(Edge edge) {
        YPoint yPoint = this.getLayout(edge).getSourcePoint();
        if (yPoint == null) {
            return this.getCenter(edge.source());
        }
        YPoint yPoint2 = new YPoint(this.getCenterX(edge.source()) + yPoint.getX(), this.getCenterY(edge.source()) + yPoint.getY());
        return yPoint2;
    }

    public YPoint getTargetPointAbs(Edge edge) {
        YPoint yPoint = this.getLayout(edge).getTargetPoint();
        if (yPoint == null) {
            return this.getCenter(edge.target());
        }
        YPoint yPoint2 = new YPoint(this.getCenterX(edge.target()) + yPoint.getX(), this.getCenterY(edge.target()) + yPoint.getY());
        return yPoint2;
    }

    public void setSourcePointAbs(Edge edge, YPoint yPoint) {
        YPoint yPoint2 = new YPoint(yPoint.getX() - this.getCenterX(edge.source()), yPoint.getY() - this.getCenterY(edge.source()));
        this.getLayout(edge).setSourcePoint(yPoint2);
    }

    public void setTargetPointAbs(Edge edge, YPoint yPoint) {
        YPoint yPoint2 = new YPoint(yPoint.getX() - this.getCenterX(edge.target()), yPoint.getY() - this.getCenterY(edge.target()));
        this.getLayout(edge).setTargetPoint(yPoint2);
    }

    public EdgeList getEdgeList() {
        return new EdgeList(this.edges());
    }

    public Rectangle getBoundingBox() {
        Comparable comparable;
        LayoutGraph layoutGraph;
        Object object;
        YCursor yCursor;
        double d2;
        double d3;
        double d4;
        double d5;
        int n2;
        block6: {
            n2 = z;
            d5 = Double.MAX_VALUE;
            d4 = Double.MAX_VALUE;
            d3 = -1.7976931348623157E308;
            d2 = -1.7976931348623157E308;
            yCursor = this.nodes();
            while (yCursor.ok()) {
                object = this.getLocation(yCursor.node());
                layoutGraph = this;
                if (n2 == 0) {
                    comparable = layoutGraph.getSize(yCursor.node());
                    d4 = Math.min(((YPoint)object).getX(), d4);
                    d5 = Math.min(((YPoint)object).getY(), d5);
                    d2 = Math.max(((YPoint)object).getX() + ((YDimension)comparable).getWidth(), d2);
                    d3 = Math.max(((YPoint)object).getY() + ((YDimension)comparable).getHeight(), d3);
                    yCursor.next();
                    if (n2 == 0) continue;
                }
                break block6;
            }
            layoutGraph = this;
        }
        yCursor = layoutGraph.edges();
        while (yCursor.ok()) {
            block7: {
                object = this.getPoints(yCursor.edge()).cursor();
                while (object.ok()) {
                    comparable = (YPoint)object.current();
                    d4 = Math.min(((YPoint)comparable).getX(), d4);
                    d5 = Math.min(((YPoint)comparable).getY(), d5);
                    d2 = Math.max(((YPoint)comparable).getX(), d2);
                    d3 = Math.max(((YPoint)comparable).getY(), d3);
                    object.next();
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break block7;
                }
                yCursor.next();
            }
            if (n2 == 0) continue;
        }
        if (d4 == Double.MAX_VALUE && d5 == Double.MAX_VALUE) {
            return new Rectangle(0, 0, -1, -1);
        }
        d4 = Math.floor(d4);
        d5 = Math.floor(d5);
        d2 = Math.ceil(d2);
        d3 = Math.ceil(d3);
        return new Rectangle((int)d4, (int)d5, (int)(d2 - d4), (int)(d3 - d5));
    }
}

