/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Graph;
import y.base.ListCell;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.YCursor;
import y.base.YList;
import y.geom.AffineLine;
import y.geom.Geom;
import y.geom.LineSegment;
import y.geom.OrientedRectangle;
import y.geom.YDimension;
import y.geom.YLineSegmentCursor;
import y.geom.YPoint;
import y.geom.YPointPath;
import y.geom.YRectangle;
import y.geom.YVector;
import y.layout.EdgeLabelModel;
import y.layout.EdgeLayout;
import y.layout.GraphLayout;
import y.layout.LabelLayout;
import y.layout.LayoutGraph;
import y.layout.NodeLabelModel;
import y.layout.NodeLayout;
import y.util.Comparators;

public class LayoutTool {
    public static final int LEADING = 1;
    public static final int TRAILING = 2;
    public static final int JUSTIFIED = 3;
    public static final int CENTER = 4;
    private static final double f = 0.5;
    public static final byte FLOW_UP = 2;
    public static final byte FLOW_DOWN = 0;
    public static final byte FLOW_LEFT = 3;
    public static final byte FLOW_RIGHT = 1;
    public static final byte FLOW_NONE = -1;
    private static final double e = 1.0E-4;
    private static final byte c = 0;
    private static final byte b = 1;
    private static final YPointPath d = new YPointPath();
    private static final YPoint g = YPoint.ORIGIN;

    public static byte determineEdgeFlowDirection(LayoutGraph layoutGraph, DataProvider dataProvider) {
        int n2 = LayoutGraph.z;
        int n3 = 0;
        int[] nArray = new int[4];
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (dataProvider == null || dataProvider.getBool(edge)) {
                YPointPath yPointPath = layoutGraph.getPath(edge);
                n3 += yPointPath.length() - 1;
                YLineSegmentCursor yLineSegmentCursor = yPointPath.lineSegments();
                while (yLineSegmentCursor.ok()) {
                    LineSegment lineSegment = yLineSegmentCursor.lineSegment();
                    LayoutTool.b(lineSegment, nArray);
                    yLineSegmentCursor.next();
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break;
                }
            } else {
                edgeCursor.next();
            }
            if (n2 == 0) continue;
        }
        return LayoutTool.b(nArray, n3);
    }

    public static boolean isUsingOrthogonalEdgeRoutes(LayoutGraph layoutGraph, DataProvider dataProvider) {
        return LayoutTool.b(layoutGraph, dataProvider, (byte)1);
    }

    public static boolean isUsingOctilinearEdgeRoutes(LayoutGraph layoutGraph, DataProvider dataProvider) {
        return LayoutTool.b(layoutGraph, dataProvider, (byte)0);
    }

    private static boolean b(LayoutGraph layoutGraph, DataProvider dataProvider, byte by) {
        block14: {
            block12: {
                int n2 = LayoutGraph.z;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                EdgeCursor edgeCursor = layoutGraph.edges();
                while (edgeCursor.ok()) {
                    Edge edge = edgeCursor.edge();
                    if (n2 != 0) break block12;
                    if (dataProvider == null || dataProvider.getBool(edge)) {
                        int n6;
                        block13: {
                            ++n3;
                            YPointPath yPointPath = layoutGraph.getPath(edge);
                            if (yPointPath.length() == 2) {
                                ++n5;
                            }
                            int n7 = 1;
                            YLineSegmentCursor yLineSegmentCursor = yPointPath.lineSegments();
                            while (yLineSegmentCursor.ok()) {
                                LineSegment lineSegment = yLineSegmentCursor.lineSegment();
                                double d2 = Math.abs(lineSegment.getDeltaX());
                                double d3 = Math.abs(lineSegment.getDeltaY());
                                double d4 = d2 - 1.0E-4;
                                n6 = d4 == 0.0 ? 0 : (d4 > 0.0 ? 1 : -1);
                                if (n2 == 0) {
                                    if (n6 > 0 && d3 > 1.0E-4 && (by == 1 || Math.abs(d2 - d3) > 1.0E-4)) {
                                        n7 = 0;
                                        if (n2 == 0) break;
                                    }
                                    yLineSegmentCursor.next();
                                    if (n2 == 0) continue;
                                }
                                break block13;
                            }
                            n6 = n7;
                        }
                        if (n6 != 0) {
                            ++n4;
                        }
                    }
                    edgeCursor.next();
                    if (n2 == 0) continue;
                }
                if (n4 != n3 && (n4 <= n5 || !((double)n4 > 0.5 * (double)n3))) break block14;
            }
            return true;
        }
        return false;
    }

    private static byte b(int[] nArray, int n2) {
        int n3 = 2;
        byte by = 0;
        if (nArray[n3] > nArray[0]) {
            n3 = 0;
            by = 2;
        }
        if (nArray[n3] > nArray[3]) {
            n3 = 3;
            by = 1;
        }
        if (nArray[n3] > nArray[1]) {
            n3 = 1;
            by = 3;
        }
        if ((double)nArray[by] > 0.3 * (double)n2 && nArray[by] > 5 * nArray[n3]) {
            return by;
        }
        return -1;
    }

    private static boolean b(LineSegment lineSegment) {
        YPoint yPoint = lineSegment.getFirstEndPoint();
        YPoint yPoint2 = lineSegment.getSecondEndPoint();
        return yPoint.x == yPoint2.x || yPoint.y == yPoint2.y;
    }

    private static void b(LineSegment lineSegment, int[] nArray) {
        block11: {
            YPoint yPoint;
            YPoint yPoint2;
            block10: {
                int n2;
                block9: {
                    block8: {
                        n2 = LayoutGraph.z;
                        yPoint2 = lineSegment.getFirstEndPoint();
                        yPoint = lineSegment.getSecondEndPoint();
                        if (!(yPoint2.x < yPoint.x)) break block8;
                        nArray[1] = nArray[1] + 1;
                        if (n2 == 0) break block9;
                    }
                    if (yPoint2.x > yPoint.x) {
                        nArray[3] = nArray[3] + 1;
                    }
                }
                if (!(yPoint2.y < yPoint.y)) break block10;
                nArray[0] = nArray[0] + 1;
                if (n2 == 0) break block11;
            }
            if (yPoint2.y > yPoint.y) {
                nArray[2] = nArray[2] + 1;
            }
        }
    }

    public static double getNodeDistance(LayoutGraph layoutGraph, Node node, Node node2) {
        double d2 = layoutGraph.getCenterX(node);
        double d3 = layoutGraph.getCenterY(node);
        double d4 = layoutGraph.getCenterX(node2);
        double d5 = layoutGraph.getCenterY(node2);
        return YPoint.distance(d2, d3, d4, d5);
    }

    public static double getPathLength(LayoutGraph layoutGraph, Edge edge) {
        double d2;
        YPoint yPoint;
        double d3;
        double d4;
        double d5;
        block2: {
            int n2 = LayoutGraph.z;
            YPoint yPoint2 = layoutGraph.getSourcePointAbs(edge);
            d5 = yPoint2.x;
            d4 = yPoint2.y;
            EdgeLayout edgeLayout = layoutGraph.getLayout(edge);
            double d6 = 0.0;
            for (int i2 = 0; i2 < edgeLayout.pointCount(); ++i2) {
                YPoint yPoint3 = edgeLayout.getPoint(i2);
                d3 = yPoint3.x;
                yPoint = yPoint3;
                if (n2 == 0) {
                    d2 = yPoint.y;
                    d6 += YPoint.distance(d5, d4, d3, d2);
                    d5 = d3;
                    d4 = d2;
                    if (n2 == 0) continue;
                }
                break block2;
            }
            yPoint = layoutGraph.getTargetPointAbs(edge);
        }
        YPoint yPoint4 = yPoint;
        d3 = yPoint4.x;
        d2 = yPoint4.y;
        return d6 += YPoint.distance(d5, d4, d3, d2);
    }

    public static void reverseEdgeLayout(EdgeLayout edgeLayout) {
        EdgeLayout edgeLayout2;
        Object object;
        block6: {
            int n2 = LayoutGraph.z;
            if (edgeLayout.pointCount() > 0) {
                int n3;
                block5: {
                    object = new ArrayList(edgeLayout.pointCount());
                    for (n3 = edgeLayout.pointCount() - 1; n3 >= 0; --n3) {
                        object.add(edgeLayout.getPoint(n3));
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                        }
                        break block5;
                    }
                    edgeLayout.clearPoints();
                }
                for (n3 = 0; n3 < object.size(); ++n3) {
                    YPoint yPoint = (YPoint)object.get(n3);
                    edgeLayout2 = edgeLayout;
                    if (n2 == 0) {
                        edgeLayout2.addPoint(yPoint.getX(), yPoint.getY());
                        if (n2 == 0) continue;
                    }
                    break block6;
                }
            }
            edgeLayout2 = edgeLayout;
        }
        object = edgeLayout2.getSourcePoint();
        edgeLayout.setSourcePoint(edgeLayout.getTargetPoint());
        edgeLayout.setTargetPoint((YPoint)object);
    }

    public static void resetPaths(LayoutGraph layoutGraph) {
        LayoutTool.resetPaths(layoutGraph, true);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static void resetPaths(LayoutGraph layoutGraph, boolean bl) {
        EdgeCursor edgeCursor;
        int n2 = LayoutGraph.z;
        if (bl) {
            edgeCursor = layoutGraph.edges();
            do {
                if (!edgeCursor.ok()) return;
                Edge edge = edgeCursor.edge();
                layoutGraph.setSourcePointRel(edge, g);
                layoutGraph.setTargetPointRel(edge, g);
                layoutGraph.setPoints(edge, d);
                edgeCursor.next();
            } while (n2 == 0);
        }
        edgeCursor = layoutGraph.edges();
        do {
            if (!edgeCursor.ok()) return;
            layoutGraph.setPoints(edgeCursor.edge(), d);
            edgeCursor.next();
        } while (n2 == 0);
    }

    public static void resetPath(LayoutGraph layoutGraph, Edge edge) {
        LayoutTool.resetPath(layoutGraph, edge, true);
    }

    public static void resetPath(LayoutGraph layoutGraph, Edge edge, boolean bl) {
        if (bl) {
            layoutGraph.setSourcePointRel(edge, g);
            layoutGraph.setTargetPointRel(edge, g);
        }
        layoutGraph.setPoints(edge, d);
    }

    public static void removeDuplicateBends(LayoutGraph layoutGraph) {
        int n2 = LayoutGraph.z;
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            LayoutTool.removeDuplicateBends(layoutGraph, edgeCursor.edge());
            edgeCursor.next();
            if (n2 == 0) continue;
        }
    }

    public static void removeDuplicateBends(LayoutGraph layoutGraph, Edge edge) {
        int n2 = LayoutGraph.z;
        EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edge);
        boolean bl = false;
        YPoint yPoint = layoutGraph.getSourcePointAbs(edge);
        if (edgeLayout.pointCount() > 0) {
            boolean bl2;
            YPoint yPoint2;
            block7: {
                for (int i2 = 0; i2 < edgeLayout.pointCount(); ++i2) {
                    yPoint2 = edgeLayout.getPoint(i2);
                    bl2 = yPoint.equals(yPoint2);
                    if (n2 == 0) {
                        if (bl2) {
                            bl = true;
                            if (n2 == 0) break;
                        }
                        yPoint = yPoint2;
                        if (n2 == 0) continue;
                    }
                    break block7;
                }
                bl2 = bl;
            }
            if (bl2 || yPoint.equals(layoutGraph.getTargetPointAbs(edge))) {
                YList yList = layoutGraph.getPathList(edge);
                yPoint2 = (YPoint)yList.firstCell().getInfo();
                for (ListCell listCell = yList.firstCell().succ(); listCell != yList.lastCell(); listCell = listCell.succ()) {
                    if (listCell.getInfo().equals(yPoint2)) {
                        yList.removeCell(listCell);
                    }
                    yPoint2 = (YPoint)listCell.getInfo();
                    if (n2 == 0) continue;
                }
                layoutGraph.setPath(edge, yList);
            }
        }
    }

    public static void moveEdge(LayoutGraph layoutGraph, Edge edge, double d2, double d3) {
        int n2 = LayoutGraph.z;
        EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edge);
        for (int i2 = edgeLayout.pointCount() - 1; i2 >= 0; --i2) {
            YPoint yPoint = edgeLayout.getPoint(i2);
            edgeLayout.setPoint(i2, yPoint.x + d2, yPoint.y + d3);
            if (n2 == 0) continue;
        }
    }

    public static void moveEdges(LayoutGraph layoutGraph, EdgeCursor edgeCursor, double d2, double d3) {
        int n2 = LayoutGraph.z;
        while (edgeCursor.ok()) {
            block3: {
                EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edgeCursor.edge());
                for (int i2 = edgeLayout.pointCount() - 1; i2 >= 0; --i2) {
                    YPoint yPoint = edgeLayout.getPoint(i2);
                    edgeLayout.setPoint(i2, yPoint.x + d2, yPoint.y + d3);
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break block3;
                }
                edgeCursor.next();
            }
            if (n2 == 0) continue;
        }
    }

    public static void moveNode(LayoutGraph layoutGraph, Node node, double d2, double d3) {
        NodeLayout nodeLayout = layoutGraph.getNodeLayout(node);
        nodeLayout.setLocation(nodeLayout.getX() + d2, nodeLayout.getY() + d3);
    }

    public static void moveNodes(LayoutGraph layoutGraph, NodeCursor nodeCursor, double d2, double d3) {
        int n2 = LayoutGraph.z;
        while (nodeCursor.ok()) {
            NodeLayout nodeLayout = layoutGraph.getNodeLayout(nodeCursor.node());
            nodeLayout.setLocation(nodeLayout.getX() + d2, nodeLayout.getY() + d3);
            nodeCursor.next();
            if (n2 == 0) continue;
        }
    }

    public static void moveSubgraph(LayoutGraph layoutGraph, EdgeCursor edgeCursor, double d2, double d3) {
        HashSet<Node> hashSet;
        Object object;
        int n2;
        block3: {
            n2 = LayoutGraph.z;
            HashSet<Node> hashSet2 = new HashSet<Node>();
            while (edgeCursor.ok()) {
                object = edgeCursor.edge();
                hashSet2.add(((Edge)object).source());
                hashSet = hashSet2;
                if (n2 == 0) {
                    hashSet.add(((Edge)object).target());
                    LayoutTool.moveEdge(layoutGraph, (Edge)object, d2, d3);
                    edgeCursor.next();
                    if (n2 == 0) continue;
                }
                break block3;
            }
            hashSet = hashSet2;
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            Node node = (Node)object.next();
            LayoutTool.moveNode(layoutGraph, node, d2, d3);
            if (n2 == 0) continue;
        }
    }

    public static void moveSubgraph(LayoutGraph layoutGraph, NodeCursor nodeCursor, double d2, double d3) {
        LayoutGraph layoutGraph2;
        HashSet<Node> hashSet;
        int n2;
        block4: {
            n2 = LayoutGraph.z;
            hashSet = new HashSet<Node>();
            while (nodeCursor.ok()) {
                layoutGraph2 = layoutGraph;
                if (n2 == 0) {
                    LayoutTool.moveNode(layoutGraph2, nodeCursor.node(), d2, d3);
                    hashSet.add(nodeCursor.node());
                    nodeCursor.next();
                    if (n2 == 0) continue;
                }
                break block4;
            }
            layoutGraph2 = layoutGraph;
        }
        EdgeCursor edgeCursor = layoutGraph2.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (hashSet.contains(edge.source()) && hashSet.contains(edge.target())) {
                LayoutTool.moveEdge(layoutGraph, edge, d2, d3);
            }
            edgeCursor.next();
            if (n2 == 0) continue;
        }
    }

    public static Rectangle2D getBoundingBox(LayoutGraph layoutGraph, NodeCursor nodeCursor, EdgeCursor edgeCursor) {
        Rectangle2D rectangle2D = LayoutTool.getBoundingBox(layoutGraph, nodeCursor);
        Rectangle2D rectangle2D2 = LayoutTool.getBoundingBox(layoutGraph, edgeCursor);
        if (rectangle2D.getWidth() < 0.0) {
            return rectangle2D2;
        }
        if (rectangle2D2.getWidth() < 0.0) {
            return rectangle2D;
        }
        rectangle2D.add(rectangle2D2);
        return rectangle2D;
    }

    public static Rectangle2D getBoundingBox(LayoutGraph layoutGraph, Node node) {
        NodeLayout nodeLayout = layoutGraph.getLayout(node);
        return new Rectangle2D.Double(nodeLayout.getX(), nodeLayout.getY(), nodeLayout.getWidth(), nodeLayout.getHeight());
    }

    public static Rectangle2D getBoundingBox(LayoutGraph layoutGraph, NodeCursor nodeCursor) {
        int n2 = LayoutGraph.z;
        if (!nodeCursor.ok()) {
            return new Rectangle2D.Double(0.0, 0.0, -1.0, -1.0);
        }
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        double d5 = -1.7976931348623157E308;
        while (nodeCursor.ok()) {
            NodeLayout nodeLayout = layoutGraph.getLayout(nodeCursor.node());
            d2 = Math.min(d2, nodeLayout.getX());
            d3 = Math.min(d3, nodeLayout.getY());
            d4 = Math.max(d4, nodeLayout.getX() + nodeLayout.getWidth());
            d5 = Math.max(d5, nodeLayout.getY() + nodeLayout.getHeight());
            nodeCursor.next();
            if (n2 == 0) continue;
        }
        return new Rectangle2D.Double(d2, d3, d4 - d2, d5 - d3);
    }

    public static Rectangle2D getBoundingBox(LayoutGraph layoutGraph, Edge edge) {
        int n2 = LayoutGraph.z;
        YPoint yPoint = layoutGraph.getSourcePointAbs(edge);
        double d2 = yPoint.x;
        double d3 = yPoint.x;
        double d4 = yPoint.y;
        double d5 = yPoint.y;
        yPoint = layoutGraph.getTargetPointAbs(edge);
        d2 = Math.min(d2, yPoint.x);
        d3 = Math.max(d3, yPoint.x);
        d4 = Math.min(d4, yPoint.y);
        d5 = Math.max(d5, yPoint.y);
        EdgeLayout edgeLayout = layoutGraph.getLayout(edge);
        for (int i2 = edgeLayout.pointCount() - 1; i2 >= 0; --i2) {
            yPoint = edgeLayout.getPoint(i2);
            d2 = Math.min(d2, yPoint.x);
            d3 = Math.max(d3, yPoint.x);
            d4 = Math.min(d4, yPoint.y);
            d5 = Math.max(d5, yPoint.y);
            if (n2 == 0) continue;
        }
        return new Rectangle2D.Double(d2, d4, d3 - d2, d5 - d4);
    }

    public static Rectangle2D getBoundingBox(LayoutGraph layoutGraph, EdgeCursor edgeCursor) {
        int n2 = LayoutGraph.z;
        if (!edgeCursor.ok()) {
            return new Rectangle2D.Double(0.0, 0.0, -1.0, -1.0);
        }
        YPoint yPoint = layoutGraph.getSourcePointAbs(edgeCursor.edge());
        double d2 = yPoint.x;
        double d3 = yPoint.x;
        double d4 = yPoint.y;
        double d5 = yPoint.y;
        while (edgeCursor.ok()) {
            block4: {
                Edge edge = edgeCursor.edge();
                EdgeLayout edgeLayout = layoutGraph.getLayout(edge);
                for (int i2 = edgeLayout.pointCount() - 1; i2 >= 0; --i2) {
                    yPoint = edgeLayout.getPoint(i2);
                    d2 = Math.min(d2, yPoint.x);
                    d3 = Math.max(d3, yPoint.x);
                    d4 = Math.min(d4, yPoint.y);
                    d5 = Math.max(d5, yPoint.y);
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break block4;
                }
                yPoint = layoutGraph.getSourcePointAbs(edge);
                d2 = Math.min(d2, yPoint.x);
                d3 = Math.max(d3, yPoint.x);
                d4 = Math.min(d4, yPoint.y);
                d5 = Math.max(d5, yPoint.y);
                yPoint = layoutGraph.getTargetPointAbs(edge);
                d2 = Math.min(d2, yPoint.x);
                d3 = Math.max(d3, yPoint.x);
                d4 = Math.min(d4, yPoint.y);
                d5 = Math.max(d5, yPoint.y);
                edgeCursor.next();
            }
            if (n2 == 0) continue;
        }
        return new Rectangle2D.Double(d2, d4, d3 - d2, d5 - d4);
    }

    public static Rectangle2D getBoundingBox(LayoutGraph layoutGraph, NodeCursor nodeCursor, EdgeCursor edgeCursor, boolean bl) {
        int n2 = LayoutGraph.z;
        Rectangle2D rectangle2D = LayoutTool.getBoundingBox(layoutGraph, nodeCursor, edgeCursor);
        if (bl) {
            Object object;
            Object object2;
            LabelLayout[] labelLayoutArray;
            block12: {
                nodeCursor.toFirst();
                while (nodeCursor.ok()) {
                    labelLayoutArray = layoutGraph.getNodeLabelLayout(nodeCursor.node());
                    object2 = layoutGraph.getLayout(nodeCursor.node());
                    if (n2 == 0) {
                        if (labelLayoutArray != null && labelLayoutArray.length > 0) {
                            for (int i2 = 0; i2 < labelLayoutArray.length; ++i2) {
                                object = labelLayoutArray[i2].getLabelModel();
                                YRectangle yRectangle = object.getLabelPlacement(labelLayoutArray[i2].getOrientedBox().getSize(), (NodeLayout)object2, labelLayoutArray[i2].getModelParameter()).getBoundingBox();
                                rectangle2D.add(yRectangle.x, yRectangle.y);
                                rectangle2D.add(yRectangle.x + yRectangle.width, yRectangle.y + yRectangle.height);
                                if (n2 == 0) {
                                    if (n2 == 0) continue;
                                }
                                break;
                            }
                        } else {
                            nodeCursor.next();
                        }
                        if (n2 == 0) continue;
                    }
                    break block12;
                }
                edgeCursor.toFirst();
            }
            while (edgeCursor.ok()) {
                labelLayoutArray = layoutGraph.getEdgeLabelLayout(edgeCursor.edge());
                object2 = layoutGraph.getEdgeLayout(edgeCursor.edge());
                NodeLayout nodeLayout = layoutGraph.getNodeLayout(edgeCursor.edge().source());
                object = layoutGraph.getNodeLayout(edgeCursor.edge().target());
                if (labelLayoutArray != null && labelLayoutArray.length > 0) {
                    for (int i3 = 0; i3 < labelLayoutArray.length; ++i3) {
                        EdgeLabelModel edgeLabelModel = labelLayoutArray[i3].getLabelModel();
                        YRectangle yRectangle = edgeLabelModel.getLabelPlacement(labelLayoutArray[i3].getOrientedBox().getSize(), (EdgeLayout)object2, nodeLayout, (NodeLayout)object, labelLayoutArray[i3].getModelParameter()).getBoundingBox();
                        rectangle2D.add(yRectangle.x, yRectangle.y);
                        rectangle2D.add(yRectangle.x + yRectangle.width, yRectangle.y + yRectangle.height);
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                        }
                        break;
                    }
                } else {
                    edgeCursor.next();
                }
                if (n2 == 0) continue;
            }
        }
        return rectangle2D;
    }

    public static YPoint getLabelPlacement(NodeLabelModel nodeLabelModel, YDimension yDimension, NodeLayout nodeLayout, Object object) {
        return nodeLabelModel.getLabelPlacement(yDimension, nodeLayout, object).getBoundingBox().getLocation();
    }

    public static YPoint getLabelPlacement(EdgeLabelModel edgeLabelModel, YDimension yDimension, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2, Object object) {
        return edgeLabelModel.getLabelPlacement(yDimension, edgeLayout, nodeLayout, nodeLayout2, object).getBoundingBox().getLocation();
    }

    public static void resetPorts(LayoutGraph layoutGraph) {
        int n2 = LayoutGraph.z;
        YPoint yPoint = YPoint.ORIGIN;
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            layoutGraph.setSourcePointRel(edge, yPoint);
            layoutGraph.setTargetPointRel(edge, yPoint);
            edgeCursor.next();
            if (n2 == 0) continue;
        }
    }

    public static YPointPath getEdgeClippedOnBB(EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2) {
        return LayoutTool.getEdgeClippedOnBB(edgeLayout, nodeLayout, nodeLayout2, 0.0);
    }

    public static YPointPath getEdgeClippedOnBB(LayoutGraph layoutGraph, Edge edge) {
        return LayoutTool.getEdgeClippedOnBB(layoutGraph.getLayout(edge), layoutGraph.getLayout(edge.source()), layoutGraph.getLayout(edge.target()));
    }

    public static YPointPath getEdgeClippedOnBB(EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2, double d2) {
        ArrayList<YPoint> arrayList;
        int n2;
        block16: {
            ArrayList<YPoint> arrayList2;
            block15: {
                int n3;
                YDimension yDimension;
                YPoint yPoint;
                block14: {
                    int n4;
                    block13: {
                        int n5;
                        n2 = LayoutGraph.z;
                        YPoint yPoint2 = new YPoint(nodeLayout.getX() - d2, nodeLayout.getY() - d2);
                        YDimension yDimension2 = new YDimension(nodeLayout.getWidth() + 2.0 * d2, nodeLayout.getHeight() + 2.0 * d2);
                        yPoint = new YPoint(nodeLayout2.getX() - d2, nodeLayout2.getY() - d2);
                        yDimension = new YDimension(nodeLayout2.getWidth() + 2.0 * d2, nodeLayout2.getHeight() + 2.0 * d2);
                        arrayList2 = new ArrayList<YPoint>(edgeLayout.pointCount() + 2);
                        YPoint yPoint3 = new YPoint(edgeLayout.getSourcePoint().getX() + yPoint2.getX() + yDimension2.getWidth() / 2.0, edgeLayout.getSourcePoint().getY() + yPoint2.getY() + yDimension2.getHeight() / 2.0);
                        arrayList2.add(yPoint3);
                        for (int i2 = 0; i2 < edgeLayout.pointCount(); ++i2) {
                            arrayList2.add(edgeLayout.getPoint(i2));
                            if (n2 == 0) continue;
                        }
                        YPoint yPoint4 = new YPoint(edgeLayout.getTargetPoint().getX() + yPoint.getX() + yDimension.getWidth() / 2.0, edgeLayout.getTargetPoint().getY() + yPoint.getY() + yDimension.getHeight() / 2.0);
                        arrayList2.add(yPoint4);
                        YPoint yPoint5 = (YPoint)arrayList2.get(0);
                        YPoint yPoint6 = (YPoint)arrayList2.get(arrayList2.size() - 1);
                        arrayList = new ArrayList<YPoint>();
                        int n6 = 0;
                        while (LayoutTool.b(yPoint2, yDimension2, (YPoint)arrayList2.get(n6))) {
                            if (++n6 != arrayList2.size()) continue;
                            return new YPointPath();
                        }
                        if (n6 > 0) {
                            arrayList.add(LayoutTool.b(yPoint2, yDimension2, (YPoint)arrayList2.get(n6 - 1), (YPoint)arrayList2.get(n6)));
                        }
                        for (n3 = arrayList2.size() - 1; n3 >= n6; --n3) {
                            n5 = LayoutTool.b(yPoint, yDimension, (YPoint)arrayList2.get(n3)) ? 1 : 0;
                            if (n2 == 0) {
                                if (n5 == 0) break;
                                if (n2 == 0) continue;
                            }
                            break block13;
                        }
                        n5 = n4 = n6;
                    }
                    while (n4 <= n3) {
                        arrayList.add((YPoint)arrayList2.get(n4));
                        ++n4;
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                        }
                        break block14;
                    }
                    if (n3 == arrayList2.size() - 1) {
                        return new YPointPath(arrayList);
                    }
                }
                if (arrayList.isEmpty()) break block15;
                arrayList.add(LayoutTool.b(yPoint, yDimension, (YPoint)arrayList2.get(n3 + 1), (YPoint)arrayList.get(arrayList.size() - 1)));
                if (n2 == 0) break block16;
            }
            arrayList = arrayList2;
        }
        YPointPath yPointPath = new YPointPath(arrayList);
        if (Graph.z) {
            LayoutGraph.z = ++n2;
        }
        return yPointPath;
    }

    public static boolean isEdgeOutsideNodes(LayoutGraph layoutGraph, Edge edge) {
        return LayoutTool.isEdgeOutsideNodes(layoutGraph.getLayout(edge), layoutGraph.getLayout(edge.source()), layoutGraph.getLayout(edge.target()), 0.0);
    }

    public static boolean isEdgeOutsideNodes(EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2, double d2) {
        boolean bl;
        boolean bl2;
        block6: {
            int n2 = LayoutGraph.z;
            YPoint yPoint = new YPoint(nodeLayout.getX() - d2, nodeLayout.getY() - d2);
            YDimension yDimension = new YDimension(nodeLayout.getWidth() + 2.0 * d2, nodeLayout.getHeight() + 2.0 * d2);
            YPoint yPoint2 = new YPoint(nodeLayout2.getX() - d2, nodeLayout2.getY() - d2);
            YDimension yDimension2 = new YDimension(nodeLayout2.getWidth() + 2.0 * d2, nodeLayout2.getHeight() + 2.0 * d2);
            ArrayList<YPoint> arrayList = new ArrayList<YPoint>(edgeLayout.pointCount() + 2);
            YPoint yPoint3 = new YPoint(edgeLayout.getSourcePoint().getX() + yPoint.getX() + yDimension.getWidth() / 2.0, edgeLayout.getSourcePoint().getY() + yPoint.getY() + yDimension.getHeight() / 2.0);
            arrayList.add(yPoint3);
            for (int i2 = 0; i2 < edgeLayout.pointCount(); ++i2) {
                arrayList.add(edgeLayout.getPoint(i2));
                if (n2 == 0) continue;
                Graph.z = !Graph.z;
                break;
            }
            YPoint yPoint4 = new YPoint(edgeLayout.getTargetPoint().getX() + yPoint2.getX() + yDimension2.getWidth() / 2.0, edgeLayout.getTargetPoint().getY() + yPoint2.getY() + yDimension2.getHeight() / 2.0);
            arrayList.add(yPoint4);
            YPoint yPoint5 = (YPoint)arrayList.get(0);
            YPoint yPoint6 = (YPoint)arrayList.get(arrayList.size() - 1);
            if (!LayoutTool.b(yPoint, yDimension, yPoint5)) {
                arrayList.add(0, new YPoint(yPoint.getX() + yDimension.getWidth() / 2.0, yPoint.getY() + yDimension.getHeight() / 2.0));
            }
            if (!LayoutTool.b(yPoint2, yDimension2, yPoint6)) {
                arrayList.add(new YPoint(yPoint2.getX() + yDimension2.getWidth() / 2.0, yPoint2.getY() + yDimension2.getHeight() / 2.0));
            }
            bl2 = false;
            boolean bl3 = false;
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                YPoint yPoint7 = (YPoint)arrayList.get(i3);
                bl = LayoutTool.b(yPoint, yDimension, yPoint7);
                if (n2 == 0) {
                    if (!bl) {
                        bl2 = true;
                    }
                    if (LayoutTool.b(yPoint2, yDimension2, yPoint7)) continue;
                    bl3 = true;
                    if (n2 == 0) continue;
                }
                break block6;
            }
            bl = bl3;
        }
        return bl && bl2;
    }

    public static void clipEdgesOnBB(LayoutGraph layoutGraph) {
        int n2 = LayoutGraph.z;
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            LayoutTool.clipEdgeOnBB(layoutGraph, edge);
            edgeCursor.next();
            if (n2 == 0) continue;
        }
    }

    public static void clipEdgeOnBB(LayoutGraph layoutGraph, Edge edge) {
        YPointPath yPointPath = LayoutTool.getEdgeClippedOnBB(layoutGraph, edge);
        List list2 = yPointPath.toList();
        if (!list2.isEmpty()) {
            layoutGraph.setSourcePointAbs(edge, (YPoint)list2.get(0));
            layoutGraph.setTargetPointAbs(edge, (YPoint)list2.get(list2.size() - 1));
            list2.remove(list2.size() - 1);
            list2.remove(0);
            layoutGraph.setPoints(edge, new YPointPath(list2));
        }
    }

    public static String edgeLayoutString(LayoutGraph layoutGraph, Edge edge) {
        StringBuffer stringBuffer;
        block2: {
            int n2 = LayoutGraph.z;
            StringBuffer stringBuffer2 = new StringBuffer();
            YCursor yCursor = layoutGraph.getPoints(edge).cursor();
            while (yCursor.ok()) {
                YPoint yPoint = (YPoint)yCursor.current();
                stringBuffer = stringBuffer2.append("X: " + yPoint.getX() + " Y: " + yPoint.getY() + "\n");
                if (n2 == 0) {
                    yCursor.next();
                    if (n2 == 0) continue;
                }
                break block2;
            }
            stringBuffer = stringBuffer2;
        }
        return stringBuffer.toString();
    }

    public static void roundNodeLayout(LayoutGraph layoutGraph, Node node) {
        YDimension yDimension = layoutGraph.getSize(node);
        layoutGraph.setSize(node, LayoutTool.b(yDimension));
        YPoint yPoint = layoutGraph.getLocation(node);
        layoutGraph.setLocation(node, LayoutTool.b(yPoint));
    }

    public static void roundEdgeLayout(LayoutGraph layoutGraph, Edge edge) {
        block2: {
            int n2 = LayoutGraph.z;
            List list2 = layoutGraph.getPoints(edge).toList();
            ArrayList<YPoint> arrayList = new ArrayList<YPoint>(list2.size());
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                arrayList.add(LayoutTool.b((YPoint)list2.get(i2)));
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block2;
            }
            layoutGraph.setPoints(edge, new YPointPath(arrayList));
            layoutGraph.setSourcePointRel(edge, LayoutTool.b(layoutGraph.getSourcePointRel(edge)));
            layoutGraph.setTargetPointRel(edge, LayoutTool.b(layoutGraph.getTargetPointRel(edge)));
        }
    }

    public static void roundLayout(LayoutGraph layoutGraph) {
        LayoutGraph layoutGraph2;
        YCursor yCursor;
        int n2;
        block3: {
            n2 = LayoutGraph.z;
            yCursor = layoutGraph.edges();
            while (yCursor.ok()) {
                layoutGraph2 = layoutGraph;
                if (n2 == 0) {
                    LayoutTool.roundEdgeLayout(layoutGraph2, yCursor.edge());
                    yCursor.next();
                    if (n2 == 0) continue;
                }
                break block3;
            }
            layoutGraph2 = layoutGraph;
        }
        yCursor = layoutGraph2.nodes();
        while (yCursor.ok()) {
            LayoutTool.roundNodeLayout(layoutGraph, yCursor.node());
            yCursor.next();
            if (n2 == 0) continue;
        }
    }

    public static void routeEdgesParallel(LayoutGraph layoutGraph, Edge edge, Edge edge2, double d2) {
        LayoutTool.routeEdgesParallel(layoutGraph, edge, edge2, d2, false, 0.0, 0.0);
    }

    public static void routeEdgesParallel(LayoutGraph layoutGraph, Edge edge, Edge edge2, double d2, boolean bl, double d3, double d4) {
        block39: {
            YPoint yPoint;
            YPoint yPoint2;
            Object object;
            block38: {
                int n2;
                block37: {
                    YVector yVector;
                    YPoint[] yPointArray;
                    int n3;
                    block36: {
                        YVector yVector2;
                        YVector yVector3;
                        Object object2;
                        Object object3;
                        block31: {
                            Object object4;
                            int n4;
                            Object object5;
                            Object object6;
                            block35: {
                                YVector yVector4;
                                block34: {
                                    int n5;
                                    Object object7;
                                    block30: {
                                        n2 = LayoutGraph.z;
                                        n3 = layoutGraph.getPath(edge).length();
                                        yPointArray = new YPoint[n3];
                                        int n6 = 0;
                                        object = layoutGraph.getPath(edge).cursor();
                                        while (object.ok()) {
                                            block32: {
                                                block33: {
                                                    object7 = (YPoint)object.current();
                                                    n5 = n6;
                                                    if (n2 != 0) break block30;
                                                    if (n5 > 0 && ((YPoint)object7).equals(yPointArray[n6 - 1])) break block32;
                                                    if (n6 <= 1 || !Geom.collinear(yPointArray[n6 - 2], yPointArray[n6 - 1], (YPoint)object7)) break block33;
                                                    yPointArray[n6 - 1] = new YPoint(((YPoint)object7).getX(), ((YPoint)object7).getY());
                                                    if (n2 == 0) break block32;
                                                }
                                                yPointArray[n6] = new YPoint(((YPoint)object7).getX(), ((YPoint)object7).getY());
                                                ++n6;
                                            }
                                            object.next();
                                            if (n2 == 0) continue;
                                        }
                                        n5 = n3 = n6;
                                    }
                                    if (n5 < 2) {
                                        return;
                                    }
                                    object = new YList();
                                    object7 = new YVector(yPointArray[1], yPointArray[0]);
                                    yVector4 = YVector.orthoNormal((YVector)object7);
                                    yVector4.scale(d2);
                                    object6 = YVector.add(yPointArray[1], yVector4);
                                    if (!bl) break block34;
                                    object5 = new YVector((YVector)object7);
                                    n4 = 1;
                                    double d5 = ((YVector)object5).length();
                                    double d6 = (d4 * d5 + d3) / d5;
                                    if (n3 == 2 && d6 > 0.5) {
                                        d6 = 0.5;
                                    }
                                    ((YVector)object5).scale(d6);
                                    ((YVector)object5).add(yVector4);
                                    if (n3 > 2) {
                                        object4 = new AffineLine(YVector.add(yPointArray[1], yVector4), YVector.add(yPointArray[0], yVector4));
                                        YVector yVector5 = YVector.orthoNormal(new YVector(yPointArray[2], yPointArray[1]));
                                        yVector5.scale(d2);
                                        AffineLine affineLine = new AffineLine(YVector.add(yPointArray[2], yVector5), YVector.add(yPointArray[1], yVector5));
                                        object3 = AffineLine.getCrossing((AffineLine)object4, affineLine);
                                        if (object3 != null) {
                                            object2 = new YVector((YPoint)object3, yPointArray[0]);
                                            if (((YVector)object5).length() > ((YVector)object2).length()) {
                                                n4 = 0;
                                                object6 = object3;
                                            }
                                        }
                                    }
                                    if (n4 != 0) {
                                        ((YList)object).add(YVector.add(yPointArray[0], (YVector)object5));
                                    }
                                    yPoint2 = yPointArray[0];
                                    if (n2 == 0) break block35;
                                }
                                yPoint2 = YVector.add(yPointArray[0], yVector4);
                            }
                            object5 = new AffineLine(yPoint2, (YPoint)object6);
                            for (n4 = 1; n4 < n3 - 1; ++n4) {
                                Object object8 = object5;
                                yVector2 = yVector3 = YVector.orthoNormal(new YVector(yPointArray[n4 + 1], yPointArray[n4]));
                                if (n2 == 0) {
                                    yVector2.scale(d2);
                                    YPoint yPoint3 = YVector.add(yPointArray[n4], yVector3);
                                    YPoint yPoint4 = YVector.add(yPointArray[n4 + 1], yVector3);
                                    object5 = new AffineLine(yPoint3, yPoint4);
                                    object4 = AffineLine.getCrossing((AffineLine)object8, (AffineLine)object5);
                                    if (object4 == null) continue;
                                    ((YList)object).add(object4);
                                    if (n2 == 0) continue;
                                }
                                break block31;
                            }
                            yVector2 = new YVector(yPointArray[n3 - 1], yPointArray[n3 - 2]);
                        }
                        YVector yVector6 = yVector2;
                        yVector = YVector.orthoNormal(yVector6);
                        yVector.scale(d2);
                        if (!bl) break block36;
                        yVector3 = new YVector(yVector6);
                        boolean bl2 = true;
                        double d7 = yVector3.length();
                        double d8 = (d4 * d7 + d3) / d7;
                        if (n3 == 2 && d8 > 0.5) {
                            d8 = 0.5;
                            bl2 = false;
                        }
                        yVector3.scale(-d8);
                        yVector3.add(yVector);
                        if (n3 > 2) {
                            object3 = YVector.orthoNormal(new YVector(yPointArray[n3 - 2], yPointArray[n3 - 3]));
                            ((YVector)object3).scale(d2);
                            object2 = new AffineLine(YVector.add(yPointArray[n3 - 2], (YVector)object3), YVector.add(yPointArray[n3 - 3], (YVector)object3));
                            AffineLine affineLine = new AffineLine(YVector.add(yPointArray[n3 - 1], yVector), YVector.add(yPointArray[n3 - 2], yVector));
                            YPoint yPoint5 = AffineLine.getCrossing((AffineLine)object2, affineLine);
                            if (yPoint5 != null) {
                                YVector yVector7 = new YVector(yPoint5, yPointArray[n3 - 1]);
                                if (yVector3.length() > yVector7.length()) {
                                    bl2 = false;
                                }
                            }
                        }
                        if (bl2) {
                            ((YList)object).add(YVector.add(yPointArray[n3 - 1], yVector3));
                        }
                        yPoint = yPointArray[n3 - 1];
                        if (n2 == 0) break block37;
                    }
                    yPoint = YVector.add(yPointArray[n3 - 1], yVector);
                }
                if (!edge.source().equals(edge2.source())) break block38;
                layoutGraph.setPoints(edge2, (YList)object);
                layoutGraph.setEndPointsAbs(edge2, yPoint2, yPoint);
                if (n2 == 0) break block39;
            }
            ((YList)object).reverse();
            layoutGraph.setPoints(edge2, (YList)object);
            layoutGraph.setEndPointsAbs(edge2, yPoint, yPoint2);
        }
    }

    public static void routeEdgesParallel(LayoutGraph layoutGraph, Edge edge, EdgeList edgeList, double d2) {
        LayoutTool.routeEdgesParallel(layoutGraph, edge, edgeList, d2, false, false, 0.0, 0.0);
    }

    public static void routeEdgesParallel(LayoutGraph layoutGraph, Edge edge, EdgeList edgeList, double d2, boolean n2, boolean bl, double d3, double d4) {
        int n3;
        block5: {
            int n4 = LayoutGraph.z;
            double d5 = d2;
            double d6 = 0.0;
            if (n2 != 0 && edgeList.size() % 2 == 1) {
                d6 -= d2 * 0.5;
            }
            EdgeCursor edgeCursor = edgeList.edges();
            while (edgeCursor.ok()) {
                Edge edge2 = edgeCursor.edge();
                LayoutTool.routeEdgesParallel(layoutGraph, edge, edge2, d5 + d6, bl, d3, d4);
                double d7 = d5 - 0.0;
                n3 = d7 == 0.0 ? 0 : (d7 < 0.0 ? -1 : 1);
                if (n4 == 0) {
                    if (n3 < 0) {
                        d5 -= d2;
                    }
                    d5 = -d5;
                    edgeCursor.next();
                    if (n4 == 0) continue;
                }
                break block5;
            }
            n3 = n2;
        }
        if (n3 != 0 && edgeList.size() % 2 == 1) {
            LayoutTool.routeEdgesParallel(layoutGraph, edge, edge, -d2 * 0.5, bl, d3, d4);
        }
    }

    public static void routeSelfLoop(LayoutGraph layoutGraph, Edge edge) {
        ArrayList<YPoint> arrayList = new ArrayList<YPoint>();
        YPoint yPoint = layoutGraph.getLocation(edge.source());
        YDimension yDimension = layoutGraph.getSize(edge.source());
        YPoint yPoint2 = new YPoint(yPoint.getX() + yDimension.getWidth() / 4.0, yPoint.getY() + yDimension.getHeight() / 4.0);
        arrayList.add(new YPoint(yPoint.getX() + yDimension.getWidth() / 4.0, yPoint.getY() - 20.0));
        arrayList.add(new YPoint(yPoint.getX() - 20.0, yPoint.getY() - 20.0));
        arrayList.add(new YPoint(yPoint.getX() - 20.0, yPoint.getY() + yDimension.getHeight() / 4.0));
        layoutGraph.setPoints(edge, new YPointPath(arrayList));
        layoutGraph.setSourcePointAbs(edge, yPoint2);
        layoutGraph.setTargetPointAbs(edge, yPoint2);
    }

    public static void assignReverseLayout(LayoutGraph layoutGraph, Edge edge, Edge edge2) {
        layoutGraph.setSourcePointAbs(edge, layoutGraph.getTargetPointAbs(edge2));
        layoutGraph.setTargetPointAbs(edge, layoutGraph.getSourcePointAbs(edge2));
        layoutGraph.setPoints(edge, layoutGraph.getPoints(edge2).createReverse());
    }

    public static String getNodePositions(LayoutGraph layoutGraph) {
        StringBuffer stringBuffer;
        block2: {
            int n2 = LayoutGraph.z;
            StringBuffer stringBuffer2 = new StringBuffer("Node Positions:\n");
            NodeCursor nodeCursor = layoutGraph.nodes();
            while (nodeCursor.ok()) {
                stringBuffer = stringBuffer2.append(nodeCursor.node() + " " + layoutGraph.getLocation(nodeCursor.node()) + "\n");
                if (n2 == 0) {
                    nodeCursor.next();
                    if (n2 == 0) continue;
                }
                break block2;
            }
            stringBuffer = stringBuffer2;
        }
        return stringBuffer.toString();
    }

    public static void initDiagram(LayoutGraph layoutGraph) {
        block2: {
            int n2 = LayoutGraph.z;
            NodeCursor nodeCursor = layoutGraph.nodes();
            while (nodeCursor.ok()) {
                layoutGraph.setLocation(nodeCursor.node(), new YPoint(0.0, 0.0));
                nodeCursor.next();
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block2;
            }
            LayoutTool.resetPaths(layoutGraph);
        }
    }

    private static boolean b(YPoint yPoint, YDimension yDimension, YPoint yPoint2) {
        return yPoint2.x >= yPoint.x && yPoint2.y >= yPoint.y && yPoint2.x <= yPoint.x + yDimension.getWidth() && yPoint2.y <= yPoint.y + yDimension.getHeight();
    }

    private static YPoint b(YPoint yPoint, YDimension yDimension, YPoint yPoint2, YPoint yPoint3) {
        Point2D.Double double_ = LayoutTool.b(yPoint.x, yPoint.y, yDimension.getWidth(), yDimension.getHeight(), yPoint2.x, yPoint2.y, yPoint3.x, yPoint3.y, null);
        return new YPoint(double_.x, double_.y);
    }

    private static Point2D.Double b(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, Point2D.Double double_) {
        if (double_ == null) {
            double_ = new Point2D.Double();
        }
        if (d6 >= d2 && d7 >= d3 && d6 <= d2 + d4 && d7 <= d3 + d5) {
            double d10 = d8 - d6;
            double d11 = d9 - d7;
            if (d10 == 0.0) {
                if (d11 < 0.0) {
                    double_.x = d6;
                    double_.y = d3;
                    return double_;
                }
                double_.x = d6;
                double_.y = d3 + d5;
                return double_;
            }
            if (d11 == 0.0) {
                if (d10 < 0.0) {
                    double_.x = d2;
                    double_.y = d7;
                    return double_;
                }
                double_.x = d2 + d4;
                double_.y = d7;
                return double_;
            }
            double d12 = d11 / d10;
            if (d10 > 0.0) {
                double d13 = d7 + d12 * (d2 + d4 - d6);
                if (d13 < d3) {
                    double_.x = d6 + (d3 - d7) / d12;
                    double_.y = d3;
                    return double_;
                }
                if (d13 <= d3 + d5) {
                    double_.x = d2 + d4;
                    double_.y = d13;
                    return double_;
                }
                double_.x = d6 + (d3 + d5 - d7) / d12;
                double_.y = d3 + d5;
                return double_;
            }
            double d14 = d7 + d12 * (d2 - d6);
            if (d14 < d3) {
                double_.x = d6 + (d3 - d7) / d12;
                double_.y = d3;
                return double_;
            }
            if (d14 <= d3 + d5) {
                double_.x = d2;
                double_.y = d14;
                return double_;
            }
            double_.x = d6 + (d3 + d5 - d7) / d12;
            double_.y = d3 + d5;
            return double_;
        }
        double_.x = d6;
        double_.y = d7;
        return double_;
    }

    private static YPoint b(YPoint yPoint) {
        return new YPoint(LayoutTool.b(yPoint.getX()), LayoutTool.b(yPoint.getY()));
    }

    private static YDimension b(YDimension yDimension) {
        return new YDimension(LayoutTool.b(yDimension.getWidth()), LayoutTool.b(yDimension.getHeight()));
    }

    private static double b(double d2) {
        return Math.floor(d2 + 0.5);
    }

    public static int arrangeRectangleRows(Rectangle2D[] rectangle2DArray, Rectangle2D rectangle2D, double d2) {
        return LayoutTool.arrangeRectangleRows(rectangle2DArray, rectangle2D, d2, 1);
    }

    /*
     * Unable to fully structure code
     */
    static void b(Rectangle2D[] var0, Rectangle2D var1_1, double var2_2, int[] var4_3) {
        block14: {
            block16: {
                block15: {
                    block13: {
                        var28_4 = LayoutGraph.z;
                        if (var0 == null || var0.length < 1) {
                            if (var1_1 != null) {
                                var1_1.setFrame(0.0, 0.0, 0.0, 0.0);
                            }
                            var4_3[1] = 0;
                            var4_3[0] = 0;
                        }
                        var5_5 = 0.0;
                        var7_6 = 0.0;
                        for (var9_7 = 0; var9_7 < var0.length; ++var9_7) {
                            var10_9 = var0[var9_7];
                            var5_5 = Math.max(var5_5, var10_9.getWidth());
                            v0 = Math.max(var7_6, var10_9.getHeight());
                            if (var28_4 == 0) {
                                var7_6 = v0;
                                if (var28_4 == 0) continue;
                            }
                            break block13;
                        }
                        v0 = var5_5 * var7_6 * (double)var0.length;
                    }
                    var9_8 = v0;
                    var11_10 = Math.sqrt(var9_8 / var2_2);
                    var13_11 = var9_8 / var11_10;
                    var15_12 = (int)Math.floor(var13_11 / var5_5);
                    var16_13 = (int)Math.ceil(var13_11 / var5_5);
                    var17_14 = (int)Math.ceil((double)var0.length / (double)var15_12);
                    if (var15_12 * var17_14 >= var16_13 * (var18_15 = (int)Math.ceil((double)var0.length / (double)var16_13))) break block15;
                    var19_16 = var15_12;
                    var20_17 = var17_14;
                    if (var28_4 == 0) break block16;
                }
                var19_16 = var16_13;
                var20_17 = var18_15;
            }
            var21_18 = 0;
            var22_19 = 0;
            var23_20 = 0.0;
            var25_21 = 0.0;
            if (!(var5_5 > var7_6)) ** GOTO lbl49
            for (var27_22 = 0; var27_22 < var0.length; ++var27_22) {
                var0[var27_22].setFrame((double)var22_19 * var5_5, (double)var21_18 * var7_6, var0[var27_22].getWidth(), var0[var27_22].getHeight());
                var23_20 = Math.max(var23_20, var0[var27_22].getMaxX());
                var25_21 = Math.max(var25_21, var0[var27_22].getMaxY());
                ++var22_19;
                if (var28_4 == 0) {
                    if (var22_19 < var19_16) continue;
                    ++var21_18;
                    var22_19 = 0;
                    if (var28_4 == 0) continue;
                }
                break block14;
lbl49:
                // 4 sources

                for (var27_22 = 0; var27_22 < var0.length; ++var27_22) {
                    var0[var27_22].setFrame((double)var22_19 * var5_5, (double)var21_18 * var7_6, var0[var27_22].getWidth(), var0[var27_22].getHeight());
                    var23_20 = Math.max(var23_20, var0[var27_22].getMaxX());
                    var25_21 = Math.max(var25_21, var0[var27_22].getMaxY());
                    ++var21_18;
                    if (var28_4 == 0) {
                        if (var21_18 < var20_17) continue;
                        ++var22_19;
                        var21_18 = 0;
                        if (var28_4 == 0) continue;
                    }
                    break block14;
                }
            }
            if (var1_1 != null) {
                var1_1.setFrame(0.0, 0.0, var23_20, var25_21);
            }
            var4_3[0] = var20_17;
            var4_3[1] = var19_16;
        }
    }

    public static Dimension arrangeRectangleGrid(Rectangle2D[] rectangle2DArray, Rectangle2D rectangle2D, double d2) {
        int[] nArray = new int[2];
        LayoutTool.b(rectangle2DArray, rectangle2D, d2, nArray);
        return new Dimension(nArray[0], nArray[1]);
    }

    /*
     * Unable to fully structure code
     */
    public static int arrangeRectangleRows(Rectangle2D[] var0, Rectangle2D var1_1, double var2_2, int var4_3) {
        block52: {
            block49: {
                block48: {
                    var50_4 = LayoutGraph.z;
                    if (var0 == null || var0.length < 1) {
                        if (var1_1 != null) {
                            var1_1.setFrame(0.0, 0.0, 0.0, 0.0);
                        }
                        return 0;
                    }
                    var5_6 = var7_5 = var0[0].getWidth();
                    var9_8 = var11_7 = var0[0].getHeight();
                    for (var13_9 = 1; var13_9 < var0.length; ++var13_9) {
                        var14_14 = var0[var13_9].getWidth();
                        var5_6 = Math.min(var5_6, var14_14);
                        var7_5 = Math.max(var7_5, var14_14);
                        var16_12 = var0[var13_9].getHeight();
                        var9_8 = Math.min(var9_8, var16_12);
                        var11_7 = Math.max(var11_7, var16_12);
                        if (var50_4 == 0) {
                            if (var50_4 == 0) continue;
                        }
                        break block48;
                    }
                    if (var9_8 / var11_7 > 0.95 && var5_6 / var7_5 > 0.95) {
                        var13_10 = new int[2];
                        LayoutTool.b(var0, var1_1, var2_2, var13_10);
                        return var13_10[0];
                    }
                }
                var13_11 = new YList();
                var14_14 = 0.0;
                var16_13 = false;
                for (var17_15 = 0; var17_15 < var0.length; ++var17_15) {
                    var18_17 = var0[var17_15];
                    var13_11.add(var0[var17_15]);
                    var14_14 += var18_17.getWidth() * var18_17.getHeight();
                    if (var50_4 == 0) {
                        if (var50_4 == 0) continue;
                    }
                    break block49;
                }
                var13_11.sort(new Comparator(){

                    public int compare(Object object, Object object2) {
                        Rectangle2D rectangle2D = (Rectangle2D)object;
                        Rectangle2D rectangle2D2 = (Rectangle2D)object2;
                        int n2 = Comparators.compare((int)rectangle2D2.getHeight(), (int)rectangle2D.getHeight());
                        if (n2 == 0) {
                            return Comparators.compare((int)rectangle2D2.getWidth(), (int)rectangle2D.getWidth());
                        }
                        return n2;
                    }
                });
            }
            var17_16 = 0.0;
            var19_18 = 0.0;
            var22_19 = Math.max(var5_6, 0.9 * (var2_2 * Math.sqrt(var14_14 / var2_2)));
            var24_20 = 0.0;
            var26_21 = 0.0;
            var28_22 = 0.0;
            var30_23 = 0.0;
            var32_24 = var22_19;
            var34_25 = 1.7976931348623157E308;
            var36_26 = null;
            var21_27 = new YList();
            var37_28 = false;
            var38_29 = 0;
            var39_30 = 0;
            block7: while (true) {
                block50: {
                    ++var38_29;
                    var40_31 = 1.7976931348623157E308;
                    var42_32 = new YList();
                    var21_27.add(var42_32);
                    var26_21 = 0.0;
                    var24_20 = 0.0;
                    var30_23 = 0.0;
                    for (var43_34 = var13_11.firstCell(); var43_34 != null; var43_34 = var43_34.succ()) {
                        block54: {
                            block53: {
                                var44_37 = (Rectangle2D)var43_34.getInfo();
                                cfr_temp_0 = var30_23 + var44_37.getWidth() - var32_24;
                                v0 = cfr_temp_0 == 0.0 ? 0 : (cfr_temp_0 > 0.0 ? 1 : -1);
                                if (var50_4 != 0) break block50;
                                if (v0 <= 0 || var42_32.size() <= 0) break block53;
                                var40_31 = Math.min(var30_23 + var44_37.getWidth(), var40_31);
                                var26_21 = Math.max(var26_21, var30_23);
                                var42_32 = new YList();
                                var42_32.add(var44_37);
                                var21_27.add(var42_32);
                                var30_23 = var44_37.getWidth();
                                if (var50_4 == 0) break block54;
                            }
                            var42_32.add(var44_37);
                            var30_23 += var44_37.getWidth();
                        }
                        if (var42_32.size() == 1) {
                            var24_20 += ((Rectangle2D)var42_32.first()).getHeight();
                        }
                        var26_21 = Math.max(var26_21, var30_23);
                        if (var50_4 == 0) continue;
                    }
                    v0 = var39_30 = var21_27.size();
                }
                if ((var43_33 = var26_21 / var24_20) > 0.0 && (var45_40 = Math.max(var43_33, var2_2) / Math.min(var43_33, var2_2)) < var34_25) {
                    var34_25 = var45_40;
                    var36_26 = var21_27;
                    var21_27 = new YList();
                }
                var37_28 = true;
                if (!(var2_2 * var24_20 > var26_21) || var39_30 <= 1) ** GOTO lbl100
                var37_28 = false;
                v1 = var21_27;
                do {
                    block56: {
                        block55: {
                            v1.clear();
                            if (!(var40_31 < 1.7976931348623157E308)) break block55;
                            var32_24 = Math.max(1.1 * var32_24, var40_31);
                            if (var50_4 == 0) break block56;
                        }
                        var32_24 *= 1.1;
                    }
                    if (var38_29 > 50) {
                        var37_28 = true;
                    }
                    if (!var37_28) continue block7;
                    v1 = var36_26;
                } while (var50_4 != 0);
                break;
            }
            if (v1 != null) {
                var21_27 = var36_26;
            }
            var40_31 = 0.0;
            var42_32 = var21_27.cursor();
            while (var42_32.ok()) {
                var43_33 = 0.0;
                var45_41 = (YList)var42_32.current();
                v2 = var45_41.cursor();
                if (var50_4 == 0) {
                    block51: {
                        var46_43 = v2;
                        while (var46_43.ok()) {
                            var47_45 = (Rectangle2D)var46_43.current();
                            var47_45.setFrame(var43_33, var40_31, var47_45.getWidth(), var47_45.getHeight());
                            var43_33 += var47_45.getWidth();
                            var46_43.next();
                            if (var50_4 == 0) {
                                if (var50_4 == 0) continue;
                            }
                            break block51;
                        }
                        var17_16 = Math.max(var17_16, var43_33);
                        var19_18 = Math.max(var19_18, var40_31 += LayoutTool.b(var45_41));
                        var42_32.next();
                    }
                    if (var50_4 == 0) continue;
                }
                ** GOTO lbl148
            }
            block0 : switch (var4_3) {
                case 4: {
                    var42_32 = var21_27.cursor();
                    block12: while (var42_32.ok()) {
                        var43_35 = (YList)var42_32.current();
                        var44_38 = (var17_16 - LayoutTool.c(var43_35)) / 2.0;
                        v3 = var43_35;
                        if (var50_4 != 0) break block0;
                        for (var46_43 = (v3720542).firstCell(); var46_43 != null; var46_43 = var46_43.succ()) {
                            var47_45 = (Rectangle2D)var46_43.getInfo();
                            var47_45.setFrame(var47_45.getX() + var44_38, var47_45.getY(), var47_45.getWidth(), var47_45.getHeight());
                            if (var50_4 != 0) continue block12;
                            if (var50_4 == 0) continue;
                        }
                        var42_32.next();
                    }
                    ** GOTO lbl180
                }
                case 2: {
                    v2 = var42_32 = var21_27.cursor();
lbl148:
                    // 4 sources

                    block14: while (var42_32.ok()) {
                        var43_36 = (YList)var42_32.current();
                        var44_39 = var17_16 - LayoutTool.c(var43_36);
                        v3 = var43_36;
                        if (var50_4 != 0) break block0;
                        for (var46_43 = (v3720542).firstCell(); var46_43 != null; var46_43 = var46_43.succ()) {
                            var47_45 = (Rectangle2D)var46_43.getInfo();
                            var47_45.setFrame(var47_45.getX() + var44_39, var47_45.getY(), var47_45.getWidth(), var47_45.getHeight());
                            if (var50_4 != 0) continue block14;
                            if (var50_4 == 0) continue;
                        }
                        var42_32.next();
                    }
                    ** GOTO lbl180
                }
                case 3: {
                    var42_32 = var21_27.cursor();
                    while (var42_32.ok()) {
                        var43_33 = 0.0;
                        var45_42 = (YList)var42_32.current();
                        v4 = var45_42.size();
                        if (var50_4 == 0) {
                            if (v4 > 1) {
                                var46_44 = (var17_16 - LayoutTool.c(var45_42)) / (double)(var45_42.size() - 1);
                                for (var48_46 = var45_42.firstCell(); var48_46 != null; var48_46 = var48_46.succ()) {
                                    var49_47 = (Rectangle2D)var48_46.getInfo();
                                    var49_47.setFrame(var43_33, var49_47.getY(), var49_47.getWidth(), var49_47.getHeight());
                                    var43_33 += var49_47.getWidth() + var46_44;
                                    if (var50_4 == 0) {
                                        if (var50_4 == 0) continue;
                                    }
                                    break;
                                }
                            } else {
                                var42_32.next();
                            }
                            if (var50_4 == 0) continue;
                        }
                        break block52;
                    }
                }
lbl180:
                // 5 sources

                default: {
                    if (var1_1 != null) {
                        var1_1.setFrame(0.0, 0.0, var17_16, var19_18);
                    }
                    v3 = var21_27;
                }
            }
            v4 = v3.size();
        }
        return v4;
    }

    private static double b(YList yList) {
        double d2;
        block2: {
            int n2 = LayoutGraph.z;
            double d3 = 0.0;
            for (ListCell listCell = yList.firstCell(); listCell != null; listCell = listCell.succ()) {
                d2 = Math.max(((Rectangle2D)listCell.getInfo()).getHeight(), d3);
                if (n2 == 0) {
                    d3 = d2;
                    if (n2 == 0) continue;
                }
                break block2;
            }
            d2 = d3;
        }
        return d2;
    }

    private static double c(YList yList) {
        double d2;
        block2: {
            int n2 = LayoutGraph.z;
            double d3 = 0.0;
            for (ListCell listCell = yList.firstCell(); listCell != null; listCell = listCell.succ()) {
                d2 = d3 + ((Rectangle2D)listCell.getInfo()).getWidth();
                if (n2 == 0) {
                    d3 = d2;
                    if (n2 == 0) continue;
                }
                break block2;
            }
            d2 = d3;
        }
        return d2;
    }

    public static boolean pathIntersectsRect(LayoutGraph layoutGraph, Edge edge, Rectangle2D rectangle2D) {
        boolean bl;
        block3: {
            int n2 = LayoutGraph.z;
            YList yList = layoutGraph.getPathList(edge);
            YPoint yPoint = (YPoint)yList.pop();
            while (!yList.isEmpty()) {
                YPoint yPoint2 = (YPoint)yList.pop();
                bl = rectangle2D.intersectsLine(yPoint.x, yPoint.y, yPoint2.x, yPoint2.y);
                if (n2 == 0) {
                    if (bl) {
                        return true;
                    }
                    yPoint = yPoint2;
                    if (n2 == 0) continue;
                }
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void applyGraphLayout(LayoutGraph var0, GraphLayout var1_1) {
        var8_2 = LayoutGraph.z;
        var2_3 = var0.nodes();
        while (var2_3.ok()) {
            var3_4 /* !! */  = var2_3.node();
            var4_5 = var1_1.getNodeLayout(var3_4 /* !! */ );
            if (var4_5 != null) {
                var5_6 = var0.getNodeLayout(var3_4 /* !! */ );
                var0.setSize(var3_4 /* !! */ , var4_5.getWidth(), var4_5.getHeight());
                var0.setLocation(var3_4 /* !! */ , var4_5.getX(), var4_5.getY());
            }
            var5_6 = var1_1.getNodeLabelLayout(var3_4 /* !! */ );
            var6_7 = var0.getNodeLabelLayout(var3_4 /* !! */ );
            if (var5_6 != null && var6_7 != null) {
                var7_10 = 0;
                block1: while (true) {
                    v0 = var7_10;
                    v1 = ((Object)var5_6).length;
                    while (v0 < v1) {
                        v0 = var7_10;
                        v1 = var6_7.length;
                        if (var8_2 != 0) continue;
                        if (v0 >= v1) break block1;
                        var6_7[var7_10].setModelParameter(var5_6[var7_10].getModelParameter());
                        ++var7_10;
                        if (var8_2 == 0) continue block1;
                    }
                    break;
                }
            }
            var2_3.next();
            if (var8_2 == 0) continue;
        }
        var2_3 = var0.edges();
        block3: while (var2_3.ok()) {
            block11: {
                var3_4 /* !! */  = var2_3.edge();
                var4_5 = var1_1.getEdgeLayout(var3_4 /* !! */ );
                if (var4_5 == null) break block11;
                var5_6 = var0.getEdgeLayout(var3_4 /* !! */ );
                var5_6.setSourcePoint(var4_5.getSourcePoint());
                var5_6.setTargetPoint(var4_5.getTargetPoint());
                if (var5_6.pointCount() == var4_5.pointCount()) ** GOTO lbl42
                var5_6.clearPoints();
                for (var6_8 = 0; var6_8 < var4_5.pointCount(); ++var6_8) {
                    var7_12 = var4_5.getPoint(var6_8);
                    var5_6.addPoint(var7_12.getX(), var7_12.getY());
                    if (var8_2 != 0) continue block3;
                    if (var8_2 == 0) continue;
lbl42:
                    // 3 sources

                    for (var6_9 = 0; var6_9 < var4_5.pointCount(); ++var6_9) {
                        var7_13 = var4_5.getPoint(var6_9);
                        var5_6.setPoint(var6_9, var7_13.getX(), var7_13.getY());
                        if (var8_2 != 0) continue block3;
                        if (var8_2 == 0) continue;
                    }
                }
            }
            var5_6 = var1_1.getEdgeLabelLayout(var3_4 /* !! */ );
            var6_7 = var0.getEdgeLabelLayout(var3_4 /* !! */ );
            if (var5_6 != null && var6_7 != null) {
                var7_14 = 0;
                block6: while (true) {
                    v2 = var7_14;
                    v3 = ((Object)var5_6).length;
                    while (v2 < v3) {
                        v2 = var7_14;
                        v3 = var6_7.length;
                        if (var8_2 != 0) continue;
                        if (v2 >= v3) break block6;
                        var6_7[var7_14].setModelParameter(var5_6[var7_14].getModelParameter());
                        ++var7_14;
                        if (var8_2 == 0) continue block6;
                    }
                    break;
                }
            }
            var2_3.next();
            if (var8_2 == 0) continue;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static void alignNodeLayouts(final LayoutGraph var0, NodeList var1_1, Node var2_2, final boolean var3_3, byte var4_4) {
        var21_5 = LayoutGraph.z;
        if (var1_1.size() <= 1) return;
        var5_6 = 1.7976931348623157E308;
        var7_7 = -1.7976931348623157E308;
        var9_8 = 0.0;
        var11_9 = var1_1.nodes();
        while (var11_9.ok()) {
            block28: {
                block27: {
                    var12_10 = var11_9.node();
                    var13_18 = var0.getNodeLayout(var12_10);
                    if (var21_5 != 0) ** GOTO lbl-1000
                    if (!var3_3) break block27;
                    var9_8 += var13_18.getHeight();
                    var5_6 = Math.min(var5_6, var13_18.getY());
                    var7_7 = Math.max(var7_7, var13_18.getY() + var13_18.getHeight());
                    if (var21_5 == 0) break block28;
                }
                var9_8 += var13_18.getWidth();
                var5_6 = Math.min(var5_6, var13_18.getX());
                var7_7 = Math.max(var7_7, var13_18.getX() + var13_18.getWidth());
            }
            var11_9.next();
            if (var21_5 == 0) continue;
        }
        if (var2_2 != null) {
            v0 = var0.getNodeLayout(var2_2);
        } else lbl-1000:
        // 2 sources

        {
            v0 = null;
        }
        var11_9 = v0;
        switch (var4_4) {
            case -1: {
                if (var3_3) {
                    var12_11 = var11_9 != null ? var11_9.getY() : var5_6;
                    var14_19 = var1_1.nodes();
                    do {
                        if (var14_19.ok() == false) return;
                        var15_21 = var14_19.node();
                        var16_22 = var0.getNodeLayout(var15_21);
                        var16_22.setLocation(var16_22.getX(), var12_11);
                        var14_19.next();
                    } while (var21_5 == 0);
                }
                var12_12 = var11_9 != null ? var11_9.getX() : var5_6;
                var14_19 = var1_1.nodes();
                do {
                    if (var14_19.ok() == false) return;
                    var15_21 = var14_19.node();
                    var16_22 = var0.getNodeLayout(var15_21);
                    var16_22.setLocation(var12_12, var16_22.getY());
                    var14_19.next();
                } while (var21_5 == 0);
            }
            case 0: {
                if (var3_3) {
                    var12_13 = var11_9 != null ? var11_9.getY() + var11_9.getHeight() * 0.5 : (var5_6 + var7_7) * 0.5;
                    var14_19 = var1_1.nodes();
                    do {
                        if (var14_19.ok() == false) return;
                        var15_21 = var14_19.node();
                        var16_22 = var0.getNodeLayout(var15_21);
                        var16_22.setLocation(var16_22.getX(), var12_13 - var16_22.getHeight() * 0.5);
                        var14_19.next();
                    } while (var21_5 == 0);
                }
                var12_14 = var11_9 != null ? var11_9.getX() + var11_9.getWidth() * 0.5 : (var5_6 + var7_7) * 0.5;
                var14_19 = var1_1.nodes();
                do {
                    if (var14_19.ok() == false) return;
                    var15_21 = var14_19.node();
                    var16_22 = var0.getNodeLayout(var15_21);
                    var16_22.setLocation(var12_14 - var16_22.getWidth() * 0.5, var16_22.getY());
                    var14_19.next();
                } while (var21_5 == 0);
            }
            case 1: {
                if (var3_3) {
                    var12_15 = var11_9 != null ? var11_9.getY() + var11_9.getHeight() : var7_7;
                    var14_19 = var1_1.nodes();
                    do {
                        if (var14_19.ok() == false) return;
                        var15_21 = var14_19.node();
                        var16_22 = var0.getNodeLayout(var15_21);
                        var16_22.setLocation(var16_22.getX(), var12_15 - var16_22.getHeight());
                        var14_19.next();
                    } while (var21_5 == 0);
                }
                var12_16 = var11_9 != null ? var11_9.getX() + var11_9.getWidth() : var7_7;
                var14_19 = var1_1.nodes();
                do {
                    if (var14_19.ok() == false) return;
                    var15_21 = var14_19.node();
                    var16_22 = var0.getNodeLayout(var15_21);
                    var16_22.setLocation(var12_16 - var16_22.getWidth(), var16_22.getY());
                    var14_19.next();
                } while (var21_5 == 0);
            }
            case 2: {
                var1_1.sort(new Comparator(){

                    public int compare(Object object, Object object2) {
                        NodeLayout nodeLayout = var0.getNodeLayout(object);
                        NodeLayout nodeLayout2 = var0.getNodeLayout(object2);
                        if (var3_3) {
                            return Comparators.compare(nodeLayout.getY() + nodeLayout.getHeight() * 0.5, nodeLayout2.getY() + nodeLayout2.getHeight() * 0.5);
                        }
                        return Comparators.compare(nodeLayout.getX() + nodeLayout.getWidth() * 0.5, nodeLayout2.getX() + nodeLayout2.getWidth() * 0.5);
                    }
                });
                var12_17 = var7_7 - var5_6 - var9_8;
                if (!(var12_17 <= 0.0)) ** GOTO lbl95
                var14_20 = 0.0;
                if (var21_5 == 0) ** GOTO lbl96
lbl95:
                // 2 sources

                var14_20 = var12_17 / (double)(var1_1.size() - 1);
lbl96:
                // 2 sources

                if (var3_3) {
                    var16_23 = var0.getNodeLayout(var1_1.firstNode()).getY();
                    var18_25 = var1_1.nodes();
                    do {
                        if (var18_25.ok() == false) return;
                        var19_26 = var18_25.node();
                        var20_27 = var0.getNodeLayout(var19_26);
                        var20_27.setLocation(var20_27.getX(), var16_23);
                        var16_23 += var20_27.getHeight() + var14_20;
                        var18_25.next();
                    } while (var21_5 == 0);
                }
                var16_24 = var0.getNodeLayout(var1_1.firstNode()).getX();
                var18_25 = var1_1.nodes();
                do {
                    if (var18_25.ok() == false) return;
                    var19_26 = var18_25.node();
                    var20_27 = var0.getNodeLayout(var19_26);
                    var20_27.setLocation(var16_24, var20_27.getY());
                    var16_24 += var20_27.getWidth() + var14_20;
                    var18_25.next();
                } while (var21_5 == 0);
                return;
            }
        }
    }

    static boolean b(OrientedRectangle orientedRectangle) {
        return Double.isNaN(orientedRectangle.getAnchorX()) || Double.isNaN(orientedRectangle.getAnchorY()) || Double.isNaN(orientedRectangle.getWidth()) || Double.isNaN(orientedRectangle.getHeight()) || Double.isNaN(orientedRectangle.getUpX()) || Double.isNaN(orientedRectangle.getUpY());
    }

    public static boolean autoFlipBox(OrientedRectangle orientedRectangle) {
        double d2 = orientedRectangle.getUpY();
        if (d2 > 0.0) {
            YPoint yPoint = orientedRectangle.getCenter();
            orientedRectangle.setUpVector(-orientedRectangle.getUpX(), -d2);
            orientedRectangle.setCenter(yPoint);
            return true;
        }
        return false;
    }

    private LayoutTool() {
    }
}

