/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.awt.Insets;
import y.base.DataMap;
import y.base.DataProvider;
import y.base.EdgeCursor;
import y.base.NodeCursor;
import y.geom.YDimension;
import y.geom.YInsets;
import y.geom.YPoint;
import y.layout.AbstractLayoutStage;
import y.layout.EdgeLayout;
import y.layout.LabelLayoutData;
import y.layout.LabelLayoutKeys;
import y.layout.LayoutGraph;
import y.layout.LayoutOrientation;
import y.layout.Layouter;
import y.layout.NodeLayout;
import y.layout.PortConstraint;
import y.layout.PortConstraintKeys;
import y.layout.PreferredPlacementDescriptor;
import y.layout.grouping.Grouping;
import y.layout.grouping.GroupingKeys;
import y.layout.hierarchic.incremental.PartitionGrid;
import y.util.DataProviderAdapter;
import y.util.DataProviders;
import y.util.Maps;

public class OrientationLayouter
extends AbstractLayoutStage
implements LayoutOrientation {
    DataProvider pgc;
    DataProvider tgc;
    DataProvider mgc;
    DataProvider ogc;
    private DataMap ngc = null;
    private DataMap rgc = null;
    private byte lgc;
    private int ugc = 4;
    private boolean qgc = true;
    public static final int MIRROR_NONE = 0;
    public static final int MIRROR_TOP_TO_BOTTOM = 1;
    public static final int MIRROR_RIGHT_TO_LEFT = 2;
    public static final int MIRROR_BOTTOM_TO_TOP = 4;
    public static final int MIRROR_LEFT_TO_RIGHT = 8;
    private static final String sgc = "PARTITION_ORIENTATION_DPKEY";

    public OrientationLayouter(Layouter layouter) {
        this();
        this.setCoreLayouter(layouter);
        this.setOrientation((byte)0);
    }

    public OrientationLayouter() {
    }

    public OrientationLayouter(byte by) {
        this.setOrientation(by);
    }

    public void setOrientation(byte by) {
        this.lgc = by;
    }

    public byte getOrientation() {
        return this.lgc;
    }

    public int getMirrorMask() {
        return this.ugc;
    }

    public void setMirrorMask(int n2) {
        this.ugc = n2;
    }

    public boolean isHorizontalOrientation() {
        return this.lgc == 1 || this.lgc == 3;
    }

    public boolean isConsiderEdgeLabelsEnabled() {
        return this.qgc;
    }

    public void setConsiderEdgeLabelsEnabled(boolean bl) {
        this.qgc = bl;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        return this.canLayoutCore(layoutGraph);
    }

    public void doLayout(LayoutGraph layoutGraph) {
        layoutGraph.addDataProvider(sgc, DataProviders.createConstantDataProvider(this));
        Transformer transformer = new Transformer();
        PartitionGrid partitionGrid = PartitionGrid.getPartitionGrid(layoutGraph);
        if (partitionGrid != null) {
            partitionGrid.prepareOrientationChange(this, transformer);
        }
        this.ngc = Maps.createHashedDataMap();
        this.rgc = Maps.createHashedDataMap();
        this.prepareOrientationChange(layoutGraph);
        if (this.getCoreLayouter() != null) {
            this.doLayoutCore(layoutGraph);
        }
        this.completeOrientationChange(layoutGraph);
        this.ngc = null;
        this.rgc = null;
        if (partitionGrid != null) {
            partitionGrid.finalizeOrientationChange(this, transformer);
        }
        layoutGraph.removeDataProvider(sgc);
    }

    public boolean isOrientationMirrored(byte by) {
        int n2 = LayoutGraph.z;
        boolean bl = false;
        switch (by) {
            case 0: {
                boolean bl2 = bl = (1 & this.ugc) != 0;
                if (n2 == 0) break;
            }
            case 3: {
                boolean bl3 = bl = (2 & this.ugc) != 0;
                if (n2 == 0) break;
            }
            case 2: {
                boolean bl4 = bl = (4 & this.ugc) != 0;
                if (n2 == 0) break;
            }
            case 1: {
                boolean bl5 = bl = (8 & this.ugc) != 0;
                if (n2 == 0) break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    protected void prepareOrientationChange(LayoutGraph layoutGraph) {
        this.ge(layoutGraph);
        this.oe(layoutGraph);
        this.ke(layoutGraph);
        this.je(layoutGraph);
        this.ne(layoutGraph);
        this.re(layoutGraph);
    }

    private void re(LayoutGraph layoutGraph) {
        DataProvider dataProvider = layoutGraph.getDataProvider(GroupingKeys.MINIMUM_NODE_SIZE_DPKEY);
        if (dataProvider != null) {
            dataProvider = new _d(dataProvider);
            layoutGraph.addDataProvider(GroupingKeys.MINIMUM_NODE_SIZE_DPKEY, dataProvider);
        }
    }

    private void qe(LayoutGraph layoutGraph) {
        DataProvider dataProvider = layoutGraph.getDataProvider(GroupingKeys.MINIMUM_NODE_SIZE_DPKEY);
        if (dataProvider != null) {
            dataProvider = ((_d)dataProvider).ed;
            layoutGraph.removeDataProvider(GroupingKeys.MINIMUM_NODE_SIZE_DPKEY);
            layoutGraph.addDataProvider(GroupingKeys.MINIMUM_NODE_SIZE_DPKEY, dataProvider);
        }
    }

    private void ne(LayoutGraph layoutGraph) {
        DataProvider dataProvider = layoutGraph.getDataProvider(GroupingKeys.GROUP_NODE_INSETS_DPKEY);
        if (Grouping.isGrouped(layoutGraph) && dataProvider != null) {
            dataProvider = new _b(dataProvider);
            layoutGraph.addDataProvider(GroupingKeys.GROUP_NODE_INSETS_DPKEY, dataProvider);
        }
    }

    private void me(LayoutGraph layoutGraph) {
        DataProvider dataProvider = layoutGraph.getDataProvider(GroupingKeys.GROUP_NODE_INSETS_DPKEY);
        if (Grouping.isGrouped(layoutGraph) && dataProvider instanceof _b) {
            dataProvider = ((_b)dataProvider).cd;
            layoutGraph.removeDataProvider(GroupingKeys.GROUP_NODE_INSETS_DPKEY);
            layoutGraph.addDataProvider(GroupingKeys.GROUP_NODE_INSETS_DPKEY, dataProvider);
        }
    }

    private void ge(LayoutGraph layoutGraph) {
        int n2 = LayoutGraph.z;
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            YPoint yPoint = layoutGraph.getCenter(nodeCursor.node());
            if (this.isHorizontalOrientation()) {
                NodeLayout nodeLayout = layoutGraph.getLayout(nodeCursor.node());
                nodeLayout.setSize(nodeLayout.getHeight(), nodeLayout.getWidth());
            }
            layoutGraph.setCenter(nodeCursor.node(), this.prepareTransform(yPoint));
            nodeCursor.next();
            if (n2 == 0) continue;
        }
    }

    protected void completeOrientationChange(LayoutGraph layoutGraph) {
        this.pe(layoutGraph);
        this.le(layoutGraph);
        this.ie(layoutGraph);
        this.he(layoutGraph);
        this.me(layoutGraph);
        this.qe(layoutGraph);
    }

    private void pe(LayoutGraph layoutGraph) {
        int n2 = LayoutGraph.z;
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            YPoint yPoint = layoutGraph.getCenter(nodeCursor.node());
            if (this.isHorizontalOrientation()) {
                NodeLayout nodeLayout = layoutGraph.getLayout(nodeCursor.node());
                nodeLayout.setSize(nodeLayout.getHeight(), nodeLayout.getWidth());
            }
            layoutGraph.setCenter(nodeCursor.node(), this.completeTransform(yPoint));
            nodeCursor.next();
            if (n2 == 0) continue;
        }
    }

    private void le(LayoutGraph layoutGraph) {
        int n2 = LayoutGraph.z;
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            block3: {
                EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edgeCursor.edge());
                YPoint yPoint = edgeLayout.getSourcePoint();
                edgeLayout.setSourcePoint(this.completeTransform(yPoint));
                yPoint = edgeLayout.getTargetPoint();
                edgeLayout.setTargetPoint(this.completeTransform(yPoint));
                for (int i2 = 0; i2 < edgeLayout.pointCount(); ++i2) {
                    yPoint = this.completeTransform(edgeLayout.getPoint(i2));
                    edgeLayout.setPoint(i2, yPoint.getX(), yPoint.getY());
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break block3;
                }
                edgeCursor.next();
            }
            if (n2 == 0) continue;
        }
    }

    private void oe(LayoutGraph layoutGraph) {
        int n2 = LayoutGraph.z;
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            block3: {
                EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edgeCursor.edge());
                YPoint yPoint = edgeLayout.getSourcePoint();
                edgeLayout.setSourcePoint(this.prepareTransform(yPoint));
                yPoint = edgeLayout.getTargetPoint();
                edgeLayout.setTargetPoint(this.prepareTransform(yPoint));
                for (int i2 = 0; i2 < edgeLayout.pointCount(); ++i2) {
                    yPoint = this.prepareTransform(edgeLayout.getPoint(i2));
                    edgeLayout.setPoint(i2, yPoint.getX(), yPoint.getY());
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break block3;
                }
                edgeCursor.next();
            }
            if (n2 == 0) continue;
        }
    }

    protected YPoint transform(YPoint yPoint, boolean bl) {
        return bl ? this.prepareTransform(yPoint) : this.completeTransform(yPoint);
    }

    protected YPoint prepareTransform(YPoint yPoint) {
        block15: {
            block14: {
                if (!this.isOrientationMirrored(this.lgc)) break block14;
                switch (this.lgc) {
                    case 0: {
                        return new YPoint(-yPoint.x, yPoint.y);
                    }
                    case 1: {
                        return new YPoint(yPoint.getY(), yPoint.getX());
                    }
                    case 3: {
                        return new YPoint(-yPoint.getY(), -yPoint.getX());
                    }
                    case 2: {
                        return new YPoint(yPoint.getX(), -yPoint.getY());
                    }
                }
                if (LayoutGraph.z == 0) break block15;
            }
            switch (this.lgc) {
                case 0: {
                    return yPoint;
                }
                case 1: {
                    return new YPoint(-yPoint.getY(), yPoint.getX());
                }
                case 3: {
                    return new YPoint(yPoint.getY(), -yPoint.getX());
                }
                case 2: {
                    return new YPoint(-yPoint.getX(), -yPoint.getY());
                }
            }
        }
        return yPoint;
    }

    protected YPoint completeTransform(YPoint yPoint) {
        block15: {
            block14: {
                if (!this.isOrientationMirrored(this.lgc)) break block14;
                switch (this.lgc) {
                    case 0: {
                        return new YPoint(-yPoint.x, yPoint.y);
                    }
                    case 1: {
                        return new YPoint(yPoint.getY(), yPoint.getX());
                    }
                    case 3: {
                        return new YPoint(-yPoint.getY(), -yPoint.getX());
                    }
                    case 2: {
                        return new YPoint(yPoint.getX(), -yPoint.getY());
                    }
                }
                if (LayoutGraph.z == 0) break block15;
            }
            switch (this.lgc) {
                case 0: {
                    return yPoint;
                }
                case 1: {
                    return new YPoint(yPoint.getY(), -yPoint.getX());
                }
                case 3: {
                    return new YPoint(-yPoint.getY(), yPoint.getX());
                }
                case 2: {
                    return new YPoint(-yPoint.getX(), -yPoint.getY());
                }
            }
        }
        return yPoint;
    }

    private void ie(LayoutGraph layoutGraph) {
        if (this.pgc != null) {
            layoutGraph.addDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY, this.pgc);
            this.pgc = null;
            this.mgc = null;
        }
        if (this.tgc != null) {
            layoutGraph.addDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY, this.tgc);
            this.tgc = null;
            this.ogc = null;
        }
    }

    private void he(LayoutGraph layoutGraph) {
        this.e(layoutGraph, false);
    }

    private void ke(LayoutGraph layoutGraph) {
        this.pgc = layoutGraph.getDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY);
        if (this.pgc != null) {
            this.mgc = new _c(this.pgc);
            layoutGraph.addDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY, this.mgc);
        }
        this.tgc = layoutGraph.getDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY);
        if (this.tgc != null) {
            this.ogc = new _c(this.tgc);
            layoutGraph.addDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY, this.ogc);
        }
    }

    private void je(LayoutGraph layoutGraph) {
        this.e(layoutGraph, true);
    }

    private void e(LayoutGraph layoutGraph, boolean bl) {
        this.c(layoutGraph, bl);
        if (this.isConsiderEdgeLabelsEnabled()) {
            this.d(layoutGraph, bl);
        }
    }

    private void d(LayoutGraph layoutGraph, boolean bl) {
        int n2 = LayoutGraph.z;
        DataProvider dataProvider = layoutGraph.getDataProvider(LabelLayoutKeys.EDGE_LABEL_LAYOUT_KEY);
        if (dataProvider != null) {
            EdgeCursor edgeCursor = layoutGraph.edges();
            while (edgeCursor.ok()) {
                LabelLayoutData[] labelLayoutDataArray = (LabelLayoutData[])dataProvider.get(edgeCursor.edge());
                if (labelLayoutDataArray != null && labelLayoutDataArray.length > 0) {
                    for (int i2 = 0; i2 < labelLayoutDataArray.length; ++i2) {
                        LabelLayoutData labelLayoutData = labelLayoutDataArray[i2];
                        this.c(labelLayoutData, bl);
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                        }
                        break;
                    }
                } else {
                    edgeCursor.next();
                }
                if (n2 == 0) continue;
            }
        }
    }

    private void c(LayoutGraph layoutGraph, boolean bl) {
        int n2 = LayoutGraph.z;
        DataProvider dataProvider = layoutGraph.getDataProvider(LabelLayoutKeys.NODE_LABEL_LAYOUT_KEY);
        if (dataProvider != null) {
            NodeCursor nodeCursor = layoutGraph.nodes();
            while (nodeCursor.ok()) {
                LabelLayoutData[] labelLayoutDataArray = (LabelLayoutData[])dataProvider.get(nodeCursor.node());
                if (labelLayoutDataArray != null && labelLayoutDataArray.length > 0) {
                    for (int i2 = 0; i2 < labelLayoutDataArray.length; ++i2) {
                        LabelLayoutData labelLayoutData = labelLayoutDataArray[i2];
                        this.b(labelLayoutData, bl);
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                        }
                        break;
                    }
                } else {
                    nodeCursor.next();
                }
                if (n2 == 0) continue;
            }
        }
    }

    private void b(LabelLayoutData labelLayoutData, boolean bl) {
        YPoint yPoint = this.transform(new YPoint(labelLayoutData.getX() + labelLayoutData.getWidth() / 2.0, labelLayoutData.getY() + labelLayoutData.getHeight() / 2.0), bl);
        YPoint yPoint2 = this.transform(new YPoint(labelLayoutData.getBounds().getUpX(), labelLayoutData.getBounds().getUpY()), bl);
        labelLayoutData.getBounds().setUpVector(yPoint2.x, yPoint2.y);
        double d2 = yPoint.getX() - labelLayoutData.getWidth() / 2.0;
        double d3 = yPoint.getY() - labelLayoutData.getHeight() / 2.0;
        labelLayoutData.setLocation(d2, d3);
    }

    private void c(LabelLayoutData labelLayoutData, boolean bl) {
        block8: {
            PreferredPlacementDescriptor preferredPlacementDescriptor;
            block9: {
                YPoint yPoint = this.transform(new YPoint(labelLayoutData.getX() + labelLayoutData.getWidth() / 2.0, labelLayoutData.getY() + labelLayoutData.getHeight() / 2.0), bl);
                YPoint yPoint2 = this.transform(new YPoint(labelLayoutData.getBounds().getUpX(), labelLayoutData.getBounds().getUpY()), bl);
                labelLayoutData.getBounds().setUpVector(yPoint2.x, yPoint2.y);
                double d2 = yPoint.getX() - labelLayoutData.getWidth() / 2.0;
                double d3 = yPoint.getY() - labelLayoutData.getHeight() / 2.0;
                labelLayoutData.setLocation(d2, d3);
                boolean bl2 = this.isOrientationMirrored(this.lgc);
                if (!bl2) break block8;
                if (!bl) break block9;
                preferredPlacementDescriptor = labelLayoutData.getPreferredPlacementDescriptor();
                byte by = 0;
                if (preferredPlacementDescriptor.isOnEdge()) {
                    by = (byte)(by | 8);
                }
                if (preferredPlacementDescriptor.isLeftOfEdge()) {
                    by = (byte)(by | 0x20);
                }
                if (preferredPlacementDescriptor.isRightOfEdge()) {
                    by = (byte)(by | 0x10);
                }
                if (preferredPlacementDescriptor.getSideOfEdge() == by) break block8;
                this.ngc.set(labelLayoutData, preferredPlacementDescriptor);
                PreferredPlacementDescriptor preferredPlacementDescriptor2 = (PreferredPlacementDescriptor)this.rgc.get(preferredPlacementDescriptor);
                if (preferredPlacementDescriptor2 == null) {
                    preferredPlacementDescriptor2 = new PreferredPlacementDescriptor(preferredPlacementDescriptor);
                    preferredPlacementDescriptor2.setSideOfEdge(by);
                    this.rgc.set(preferredPlacementDescriptor, preferredPlacementDescriptor2);
                }
                labelLayoutData.setPreferredPlacementDescriptor(preferredPlacementDescriptor2);
                if (LayoutGraph.z == 0) break block8;
            }
            if ((preferredPlacementDescriptor = (PreferredPlacementDescriptor)this.ngc.get(labelLayoutData)) != null) {
                labelLayoutData.setPreferredPlacementDescriptor(preferredPlacementDescriptor);
            }
        }
    }

    public YInsets createOrientedInsets(Insets insets) {
        return this.createOrientedInsets(new YInsets(insets));
    }

    public YInsets createOrientedInsets(YInsets yInsets) {
        if (this.isOrientationMirrored(this.lgc)) {
            switch (this.lgc) {
                case 2: {
                    return new YInsets(yInsets.bottom, yInsets.left, yInsets.top, yInsets.right);
                }
                case 1: {
                    return new YInsets(yInsets.left, yInsets.top, yInsets.right, yInsets.bottom);
                }
                case 3: {
                    return new YInsets(yInsets.right, yInsets.bottom, yInsets.left, yInsets.top);
                }
            }
            return new YInsets(yInsets.top, yInsets.right, yInsets.bottom, yInsets.left);
        }
        switch (this.lgc) {
            case 2: {
                return new YInsets(yInsets.bottom, yInsets.right, yInsets.top, yInsets.left);
            }
            case 1: {
                return new YInsets(yInsets.left, yInsets.bottom, yInsets.right, yInsets.top);
            }
            case 3: {
                return new YInsets(yInsets.right, yInsets.top, yInsets.left, yInsets.bottom);
            }
        }
        return yInsets;
    }

    public YDimension createOrientedNodeSize(YDimension yDimension) {
        switch (this.lgc) {
            case 1: 
            case 3: {
                return new YDimension(yDimension.getHeight(), yDimension.getWidth());
            }
        }
        return new YDimension(yDimension.getWidth(), yDimension.getHeight());
    }

    public final class Transformer {
        Transformer() {
        }

        public YPoint finalizeTransform(YPoint yPoint) {
            return OrientationLayouter.this.completeTransform(yPoint);
        }

        public YPoint initTransform(YPoint yPoint) {
            return OrientationLayouter.this.prepareTransform(yPoint);
        }
    }

    private class _c
    extends DataProviderAdapter {
        DataProvider dd;

        _c(DataProvider dataProvider) {
            this.dd = dataProvider;
        }

        public Object get(Object object) {
            PortConstraint portConstraint;
            block55: {
                byte by;
                boolean bl;
                block56: {
                    portConstraint = (PortConstraint)this.dd.get(object);
                    if (portConstraint == null || portConstraint.isAtAnySide()) break block55;
                    bl = portConstraint.isStrong();
                    by = OrientationLayouter.this.getOrientation();
                    if (!OrientationLayouter.this.isOrientationMirrored(by)) break block56;
                    switch (by) {
                        case 1: {
                            switch (portConstraint.getSide()) {
                                case 2: {
                                    return PortConstraint.create((byte)4, bl);
                                }
                                case 8: {
                                    return PortConstraint.create((byte)1, bl);
                                }
                                case 1: {
                                    return PortConstraint.create((byte)8, bl);
                                }
                                case 4: {
                                    return PortConstraint.create((byte)2, bl);
                                }
                            }
                        }
                        case 3: {
                            switch (portConstraint.getSide()) {
                                case 2: {
                                    return PortConstraint.create((byte)8, bl);
                                }
                                case 4: {
                                    return PortConstraint.create((byte)1, bl);
                                }
                                case 1: {
                                    return PortConstraint.create((byte)4, bl);
                                }
                                case 8: {
                                    return PortConstraint.create((byte)2, bl);
                                }
                            }
                        }
                        case 2: {
                            switch (portConstraint.getSide()) {
                                case 2: {
                                    return PortConstraint.create((byte)1, bl);
                                }
                                case 4: {
                                    return portConstraint;
                                }
                                case 1: {
                                    return PortConstraint.create((byte)2, bl);
                                }
                                case 8: {
                                    return portConstraint;
                                }
                            }
                        }
                        case 0: {
                            switch (portConstraint.getSide()) {
                                case 2: {
                                    return portConstraint;
                                }
                                case 4: {
                                    return PortConstraint.create((byte)8, bl);
                                }
                                case 1: {
                                    return portConstraint;
                                }
                                case 8: {
                                    return PortConstraint.create((byte)4, bl);
                                }
                            }
                        }
                    }
                    if (LayoutGraph.z == 0) break block55;
                }
                switch (by) {
                    case 1: {
                        switch (portConstraint.getSide()) {
                            case 2: {
                                return PortConstraint.create((byte)8, bl);
                            }
                            case 8: {
                                return PortConstraint.create((byte)1, bl);
                            }
                            case 1: {
                                return PortConstraint.create((byte)4, bl);
                            }
                            case 4: {
                                return PortConstraint.create((byte)2, bl);
                            }
                        }
                    }
                    case 3: {
                        switch (portConstraint.getSide()) {
                            case 2: {
                                return PortConstraint.create((byte)4, bl);
                            }
                            case 4: {
                                return PortConstraint.create((byte)1, bl);
                            }
                            case 1: {
                                return PortConstraint.create((byte)8, bl);
                            }
                            case 8: {
                                return PortConstraint.create((byte)2, bl);
                            }
                        }
                    }
                    case 2: {
                        switch (portConstraint.getSide()) {
                            case 2: {
                                return PortConstraint.create((byte)1, bl);
                            }
                            case 4: {
                                return PortConstraint.create((byte)8, bl);
                            }
                            case 1: {
                                return PortConstraint.create((byte)2, bl);
                            }
                            case 8: {
                                return PortConstraint.create((byte)4, bl);
                            }
                        }
                    }
                }
            }
            return portConstraint;
        }
    }

    class _d
    extends DataProviderAdapter {
        DataProvider ed;

        _d(DataProvider dataProvider) {
            this.ed = dataProvider;
        }

        public Object get(Object object) {
            Object object2 = this.ed.get(object);
            if (object2 instanceof YDimension) {
                object2 = OrientationLayouter.this.createOrientedNodeSize((YDimension)object2);
            }
            return object2;
        }
    }

    class _b
    extends DataProviderAdapter {
        DataProvider cd;

        _b(DataProvider dataProvider) {
            this.cd = dataProvider;
        }

        public Object get(Object object) {
            YInsets yInsets = YInsets.asYInsets(this.cd.get(object));
            if (yInsets != null) {
                return OrientationLayouter.this.createOrientedInsets(yInsets);
            }
            return yInsets;
        }
    }
}

