/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.util.Comparator;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeMap;
import y.base.YList;
import y.geom.AffineLine;
import y.geom.LineSegment;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YPointPath;
import y.geom.YRectangle;
import y.geom.YVector;
import y.layout.AbstractLayoutStage;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.Layouter;

public class ParallelEdgeLayouter
extends AbstractLayoutStage {
    private static final double ygc = 0.001;
    public static final Object SCOPE_DPKEY = "y.layout.ParallelEdgeLayouter.SCOPE_DPKEY";
    public static final Object LEADING_EDGE_DPKEY = "y.layout.ParallelEdgeLayouter.MASTER_EDGE_DPKEY";
    protected EdgeList hiddenEdges = new EdgeList();
    public EdgeMap parallelEdges;
    protected double lineDistance = 10.0;
    boolean xgc = false;
    private boolean zgc = false;
    private double ahc = 20.0;
    private double wgc = 0.1;
    private boolean chc = true;
    private boolean bhc = true;

    public ParallelEdgeLayouter(Layouter layouter) {
        this();
        this.setCoreLayouter(layouter);
    }

    public ParallelEdgeLayouter() {
    }

    public boolean isDirectedModeEnabled() {
        return this.xgc;
    }

    public void setDirectedModeEnabled(boolean bl) {
        this.xgc = bl;
    }

    public boolean isUsingAdaptiveLineDistances() {
        return this.bhc;
    }

    public void setUsingAdaptiveLineDistances(boolean bl) {
        this.bhc = bl;
    }

    public void setLineDistance(double d2) {
        this.lineDistance = d2;
    }

    public double getLineDistance() {
        return this.lineDistance;
    }

    public void doLayout(LayoutGraph layoutGraph) {
        this.parallelEdges = layoutGraph.createEdgeMap();
        this.findAndHideParallelEdges(layoutGraph);
        this.doLayoutCore(layoutGraph);
        this.p(layoutGraph);
        this.layoutParallelEdges(layoutGraph, this.parallelEdges);
        layoutGraph.disposeEdgeMap(this.parallelEdges);
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        if (this.getCoreLayouter() == null) {
            return true;
        }
        this.parallelEdges = layoutGraph.createEdgeMap();
        this.findAndHideParallelEdges(layoutGraph);
        boolean bl = this.canLayoutCore(layoutGraph);
        this.p(layoutGraph);
        layoutGraph.disposeEdgeMap(this.parallelEdges);
        return bl;
    }

    protected void layoutParallelEdges(LayoutGraph layoutGraph, EdgeMap edgeMap) {
        int n2 = LayoutGraph.z;
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            block3: {
                double d2;
                EdgeList edgeList;
                Edge edge;
                block7: {
                    block4: {
                        AffineLine affineLine;
                        Object object;
                        Object object2;
                        block6: {
                            block5: {
                                edge = edgeCursor.edge();
                                if (edgeMap.get(edge) == null) break block3;
                                edgeList = (EdgeList)edgeMap.get(edge);
                                d2 = this.lineDistance;
                                if (!this.bhc || this.zgc) break block4;
                                if (!edge.isSelfLoop()) break block5;
                                int n3 = edgeList.size() + 1;
                                object2 = layoutGraph.getRectangle(edge.source());
                                double d3 = Math.min(((YDimension)object2).getWidth(), ((YDimension)object2).getHeight()) * 0.5 / (double)(n3 + 1);
                                LayoutTool.routeEdgesParallel(layoutGraph, edge, edgeList, Math.floor(Math.min(d3, this.lineDistance)), this.chc, false, this.ahc, this.wgc);
                                if (n2 == 0) break block3;
                            }
                            if (!layoutGraph.getPointList(edge).isEmpty()) break block6;
                            YVector yVector = new YVector(layoutGraph.getSourcePointAbs(edge), layoutGraph.getTargetPointAbs(edge));
                            object2 = layoutGraph.getRectangle(edge.source());
                            YList yList = ParallelEdgeLayouter.b((YRectangle)object2, yVector);
                            object = layoutGraph.getRectangle(edge.target());
                            yList.splice(ParallelEdgeLayouter.b((YRectangle)object, yVector));
                            yList.sort((Comparator)new _c());
                            affineLine = (AffineLine)yList.get(1);
                            AffineLine affineLine2 = (AffineLine)yList.get(2);
                            AffineLine affineLine3 = new AffineLine(layoutGraph.getSourcePointAbs(edge), yVector);
                            double d4 = 2.0 * Math.min(ParallelEdgeLayouter.b(affineLine, affineLine3, yVector), ParallelEdgeLayouter.b(affineLine2, affineLine3, yVector)) / (double)(edgeList.size() + 2);
                            LayoutTool.routeEdgesParallel(layoutGraph, edge, edgeList, Math.floor(Math.min(d4, d2)), this.chc, this.zgc, this.ahc, this.wgc);
                            this.b(edgeList, edge.source(), layoutGraph.getSourcePointAbs(edge), affineLine, affineLine2, layoutGraph);
                            this.b(edgeList, edge.target(), layoutGraph.getTargetPointAbs(edge), affineLine, affineLine2, layoutGraph);
                            if (n2 == 0) break block3;
                        }
                        YPointPath yPointPath = layoutGraph.getPath(edge);
                        object2 = yPointPath.getLineSegment(0).toYVector();
                        YRectangle yRectangle = layoutGraph.getRectangle(edge.source());
                        object = ParallelEdgeLayouter.b(yRectangle, (YVector)object2);
                        affineLine = new AffineLine(layoutGraph.getSourcePointAbs(edge), (YVector)object2);
                        double d5 = 2.0 * Math.min(ParallelEdgeLayouter.b((AffineLine)((YList)object).first(), affineLine, (YVector)object2), ParallelEdgeLayouter.b((AffineLine)((YList)object).last(), affineLine, (YVector)object2)) / (double)(edgeList.size() + 2);
                        object2 = yPointPath.getLineSegment(yPointPath.length() - 2).toYVector();
                        YRectangle yRectangle2 = layoutGraph.getRectangle(edge.target());
                        YList yList = ParallelEdgeLayouter.b(yRectangle2, (YVector)object2);
                        d5 = Math.min(d5, ParallelEdgeLayouter.b((AffineLine)yList.first(), (AffineLine)yList.last(), (YVector)object2) / (double)(edgeList.size() + 2));
                        LayoutTool.routeEdgesParallel(layoutGraph, edge, edgeList, Math.floor(Math.min(d5, d2)), this.chc, this.zgc, this.ahc, this.wgc);
                        this.b(edgeList, edge.source(), layoutGraph.getSourcePointAbs(edge), (AffineLine)((YList)object).first(), (AffineLine)((YList)object).last(), layoutGraph);
                        this.b(edgeList, edge.target(), layoutGraph.getTargetPointAbs(edge), (AffineLine)yList.first(), (AffineLine)yList.last(), layoutGraph);
                        if (n2 == 0) break block3;
                    }
                    if (!edge.isSelfLoop()) break block7;
                    LayoutTool.routeEdgesParallel(layoutGraph, edge, edgeList, Math.floor(d2), this.chc, false, this.ahc, this.wgc);
                    if (n2 == 0) break block3;
                }
                LayoutTool.routeEdgesParallel(layoutGraph, edge, edgeList, Math.floor(d2), this.chc, this.zgc, this.ahc, this.wgc);
            }
            edgeCursor.next();
            if (n2 == 0) continue;
        }
    }

    private void b(EdgeList edgeList, Node node, YPoint yPoint, AffineLine affineLine, AffineLine affineLine2, LayoutGraph layoutGraph) {
        int n2 = LayoutGraph.z;
        YRectangle yRectangle = layoutGraph.getRectangle(node);
        boolean bl = !yRectangle.contains(yPoint);
        YPoint yPoint2 = bl ? yPoint : layoutGraph.getCenter(node);
        AffineLine affineLine3 = new AffineLine(yPoint2, new YVector(1.0, 0.0));
        AffineLine affineLine4 = new AffineLine(yPoint2, new YVector(0.0, 1.0));
        boolean bl2 = this.b(yRectangle, affineLine4, affineLine3, affineLine, affineLine2);
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            block4: {
                YPoint yPoint3;
                Edge edge;
                block3: {
                    edge = edgeCursor.edge();
                    boolean bl3 = edge.source() == node;
                    YPointPath yPointPath = layoutGraph.getPath(edge);
                    LineSegment lineSegment = bl3 ? yPointPath.getLineSegment(0) : yPointPath.getLineSegment(yPointPath.length() - 2);
                    AffineLine affineLine5 = lineSegment.toAffineLine();
                    YPoint yPoint4 = yPoint3 = bl2 ? AffineLine.getCrossing(affineLine3, affineLine5) : AffineLine.getCrossing(affineLine4, affineLine5);
                    if (!bl3) break block3;
                    layoutGraph.setSourcePointAbs(edge, yPoint3);
                    if (n2 == 0) break block4;
                }
                layoutGraph.setTargetPointAbs(edge, yPoint3);
            }
            edgeCursor.next();
            if (n2 == 0) continue;
        }
    }

    private boolean b(YRectangle yRectangle, AffineLine affineLine, AffineLine affineLine2, AffineLine affineLine3, AffineLine affineLine4) {
        double d2;
        YPoint yPoint = AffineLine.getCrossing(affineLine, affineLine3);
        if (yPoint == null) {
            return true;
        }
        YPoint yPoint2 = AffineLine.getCrossing(affineLine, affineLine4);
        if (ParallelEdgeLayouter.d(yRectangle, yPoint) && ParallelEdgeLayouter.d(yRectangle, yPoint2)) {
            return false;
        }
        YPoint yPoint3 = AffineLine.getCrossing(affineLine2, affineLine3);
        if (yPoint3 == null) {
            return false;
        }
        YPoint yPoint4 = AffineLine.getCrossing(affineLine2, affineLine4);
        if (ParallelEdgeLayouter.d(yRectangle, yPoint3) && ParallelEdgeLayouter.d(yRectangle, yPoint4)) {
            return true;
        }
        double d3 = Math.abs(yPoint3.x - yPoint4.x);
        return d3 < (d2 = Math.abs(yPoint.y - yPoint2.y));
    }

    private static boolean d(YRectangle yRectangle, YPoint yPoint) {
        return yPoint.getX() + 0.001 >= yRectangle.getX() && yPoint.getX() - yRectangle.getX() <= yRectangle.getWidth() + 0.001 && yPoint.getY() + 0.001 >= yRectangle.getY() && yPoint.getY() - yRectangle.getY() <= yRectangle.getHeight() + 0.001;
    }

    private static double b(AffineLine affineLine, AffineLine affineLine2, YVector yVector) {
        AffineLine affineLine3 = new AffineLine(new YPoint(0.0, 0.0), YVector.orthoNormal(yVector));
        YPoint yPoint = AffineLine.getCrossing(affineLine, affineLine3);
        YPoint yPoint2 = AffineLine.getCrossing(affineLine2, affineLine3);
        if (yPoint == null || yPoint2 == null) {
            return 0.0;
        }
        return YPoint.distance(yPoint, yPoint2);
    }

    private static YList b(YRectangle yRectangle, YVector yVector) {
        YPoint yPoint = new YPoint(yRectangle.getX() + 0.5 * yRectangle.getWidth(), yRectangle.getY());
        YPoint yPoint2 = new YPoint(yRectangle.getX(), yRectangle.getY() + 0.5 * yRectangle.getHeight());
        YPoint yPoint3 = new YPoint(yRectangle.getX() + 0.5 * yRectangle.getWidth(), yRectangle.getY() + yRectangle.getHeight());
        YPoint yPoint4 = new YPoint(yRectangle.getX() + yRectangle.getWidth(), yRectangle.getY() + 0.5 * yRectangle.getHeight());
        YList yList = new YList();
        yList.add(new AffineLine(yPoint, yVector));
        yList.add(new AffineLine(yPoint2, yVector));
        yList.add(new AffineLine(yPoint4, yVector));
        yList.add(new AffineLine(yPoint3, yVector));
        yList.sort((Comparator)new _c());
        YList yList2 = new YList();
        yList2.add(yList.first());
        yList2.add(yList.last());
        return yList2;
    }

    private EdgeList gc(Node node) {
        int n2 = LayoutGraph.z;
        EdgeList edgeList = new EdgeList(node.outEdges());
        EdgeCursor edgeCursor = node.inEdges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (!edge.isSelfLoop()) {
                edgeList.add(edge);
            }
            edgeCursor.next();
            if (n2 == 0) continue;
        }
        return edgeList;
    }

    protected void findAndHideParallelEdges(Graph graph) {
        block11: {
            int n2 = LayoutGraph.z;
            NodeMap nodeMap = graph.createNodeMap();
            DataProvider dataProvider = graph.getDataProvider(SCOPE_DPKEY);
            DataProvider dataProvider2 = graph.getDataProvider(LEADING_EDGE_DPKEY);
            NodeCursor nodeCursor = graph.nodes();
            while (nodeCursor.ok()) {
                block12: {
                    Node node;
                    Edge edge;
                    EdgeCursor edgeCursor;
                    Node node2 = nodeCursor.node();
                    if (n2 != 0) break block11;
                    EdgeList edgeList = this.xgc ? new EdgeList(node2.outEdges()) : this.gc(node2);
                    DataProvider dataProvider3 = dataProvider2;
                    block1: while (true) {
                        if (dataProvider3 != null) {
                            edgeList.sort((Comparator)new _b(dataProvider2));
                        }
                        edgeCursor = edgeList.edges();
                        while (edgeCursor.ok()) {
                            block13: {
                                Edge edge2;
                                block14: {
                                    edge = edgeCursor.edge();
                                    dataProvider3 = dataProvider;
                                    if (n2 != 0) continue block1;
                                    if (dataProvider3 != null && !dataProvider.getBool(edge) || (edge2 = (Edge)nodeMap.get(node = edge.opposite(node2))) == edge) break block13;
                                    if (edge2 != null) break block14;
                                    nodeMap.set(node, edge);
                                    if (n2 == 0) break block13;
                                }
                                if (this.parallelEdges.get(edge2) == null) {
                                    this.parallelEdges.set(edge2, new EdgeList());
                                }
                                EdgeList edgeList2 = (EdgeList)this.parallelEdges.get(edge2);
                                edgeList2.add(edge);
                                this.hiddenEdges.push(edge);
                                graph.hide(edge);
                            }
                            edgeCursor.next();
                            if (n2 == 0) continue;
                        }
                        break;
                    }
                    edgeCursor = node2.edges();
                    while (edgeCursor.ok()) {
                        edge = edgeCursor.edge();
                        node = edge.opposite(node2);
                        nodeMap.set(node, null);
                        edgeCursor.next();
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                        }
                        break block12;
                    }
                    nodeCursor.next();
                }
                if (n2 == 0) continue;
            }
            graph.disposeNodeMap(nodeMap);
        }
    }

    private void p(Graph graph) {
        int n2 = LayoutGraph.z;
        while (!this.hiddenEdges.isEmpty()) {
            graph.unhide(this.hiddenEdges.popEdge());
            if (n2 == 0) continue;
        }
    }

    public boolean isJoinEndsEnabled() {
        return this.zgc;
    }

    public void setJoinEndsEnabled(boolean bl) {
        this.zgc = bl;
    }

    public double getAbsJoinEndDistance() {
        return this.ahc;
    }

    public void setAbsJoinEndDistance(double d2) {
        this.ahc = d2;
    }

    public double getRelJoinEndDistance() {
        return this.wgc;
    }

    public void setRelJoinEndDistance(double d2) {
        this.wgc = d2;
    }

    public boolean isLeadingEdgeAdjustmentEnabled() {
        return this.chc;
    }

    public void setLeadingEdgeAdjustmentEnabled(boolean bl) {
        this.chc = bl;
    }

    private static class _b
    implements Comparator {
        final DataProvider b;

        private _b(DataProvider dataProvider) {
            this.b = dataProvider;
        }

        public int compare(Object object, Object object2) {
            if (this.b.getBool(object) && !this.b.getBool(object2)) {
                return -1;
            }
            if (!this.b.getBool(object) && this.b.getBool(object2)) {
                return 1;
            }
            return 0;
        }
    }

    static class _c
    implements Comparator {
        _c() {
        }

        public int compare(Object object, Object object2) {
            AffineLine affineLine = (AffineLine)object;
            AffineLine affineLine2 = (AffineLine)object2;
            if (affineLine.getC() < affineLine2.getC()) {
                return -1;
            }
            if (affineLine.getC() > affineLine2.getC()) {
                return 1;
            }
            return 0;
        }
    }
}

