/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.awt.Rectangle;
import y.algo.GraphConnectivity;
import y.algo.Groups;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.Node;
import y.base.NodeMap;
import y.layout.AbstractLayoutStage;
import y.layout.ComponentLayouter;
import y.layout.LayoutGraph;
import y.layout.Layouter;
import y.layout.PortConstraintConfigurator;
import y.layout.PortConstraintKeys;
import y.layout.router.ChannelEdgeRouter;
import y.layout.router.OrthogonalEdgeRouter;
import y.layout.router.OrthogonalPatternEdgeRouter;
import y.layout.router.OrthogonalSegmentDistributionStage;
import y.util.GraphHider;

public class PartitionLayouter
extends AbstractLayoutStage {
    PartitionFinder rfc;
    PartitionPlacer tfc;
    InterEdgeRouter sfc;

    public boolean canLayout(LayoutGraph layoutGraph) {
        return this.canLayoutCore(layoutGraph);
    }

    public void doLayout(LayoutGraph layoutGraph) {
        EdgeMap edgeMap;
        NodeMap nodeMap;
        block6: {
            int n2 = LayoutGraph.z;
            if (this.rfc == null) {
                throw new IllegalStateException("PartitionFinder must not be null");
            }
            nodeMap = layoutGraph.createNodeMap();
            this.rfc.findPartitions(layoutGraph, nodeMap);
            edgeMap = layoutGraph.createEdgeMap();
            Object object = layoutGraph.edges();
            while (object.ok()) {
                Edge edge = object.edge();
                if (n2 == 0) {
                    edgeMap.setBool(edge, nodeMap.getInt(edge.source()) != nodeMap.getInt(edge.target()));
                    object.next();
                    if (n2 == 0) continue;
                }
                break block6;
            }
            if (this.getCoreLayouter() != null) {
                object = new GraphHider(layoutGraph);
                ((GraphHider)object).hide(new EdgeList(layoutGraph.edges(), (DataProvider)edgeMap));
                this.getCoreLayouter().doLayout(layoutGraph);
                ((GraphHider)object).unhideAll();
            }
        }
        if (this.tfc != null) {
            this.tfc.placePartitions(layoutGraph, nodeMap, edgeMap);
        }
        if (this.sfc != null) {
            this.sfc.routeInterEdges(layoutGraph, nodeMap, edgeMap);
        }
        layoutGraph.disposeEdgeMap(edgeMap);
        layoutGraph.disposeNodeMap(nodeMap);
    }

    public PartitionFinder getPartitionFinder() {
        return this.rfc;
    }

    public void setPartitionFinder(PartitionFinder partitionFinder) {
        this.rfc = partitionFinder;
    }

    public PartitionPlacer getPartitionPlacer() {
        return this.tfc;
    }

    public void setPartitionPlacer(PartitionPlacer partitionPlacer) {
        this.tfc = partitionPlacer;
    }

    public InterEdgeRouter getInterEdgeRouter() {
        return this.sfc;
    }

    public void setInterEdgeRouter(InterEdgeRouter interEdgeRouter) {
        this.sfc = interEdgeRouter;
    }

    public static class ComponentPartitionPlacer
    implements PartitionPlacer {
        ComponentLayouter b = new ComponentLayouter();

        public ComponentPartitionPlacer() {
            this.b.setStyle((byte)5);
        }

        public void placePartitions(LayoutGraph layoutGraph, DataProvider dataProvider, DataProvider dataProvider2) {
            GraphHider graphHider = new GraphHider(layoutGraph);
            graphHider.hide(new EdgeList(layoutGraph.edges(), dataProvider2));
            this.b.doLayout(layoutGraph);
            graphHider.unhideAll();
        }

        public ComponentLayouter getComponentLayouter() {
            return this.b;
        }

        public void setComponentLayouter(ComponentLayouter componentLayouter) {
            this.b = componentLayouter;
        }
    }

    public static class EdgeBetweennessPartitionFinder
    implements PartitionFinder {
        int c;
        int b = Integer.MAX_VALUE;

        public void findPartitions(LayoutGraph layoutGraph, NodeMap nodeMap) {
            int n2 = GraphConnectivity.connectedComponents(layoutGraph).length;
            int n3 = this.b;
            if (n2 > 1 && (n3 += n2 - 1) <= 0) {
                n3 = this.b;
            }
            Groups.edgeBetweennessClustering((Graph)layoutGraph, nodeMap, false, Math.min(this.c, layoutGraph.N()), n3, null);
        }

        public int getMaximumPartitionCount() {
            return this.b;
        }

        public void setMaximumPartitionCount(int n2) {
            this.b = n2;
        }

        public int getMinimumPartitionCount() {
            return this.c;
        }

        public void setMinimumPartitionCount(int n2) {
            this.c = n2;
        }
    }

    public static class OrthogonalInterEdgeRouter
    implements InterEdgeRouter {
        OrthogonalEdgeRouter b = new OrthogonalEdgeRouter();

        public OrthogonalInterEdgeRouter() {
            this.b.setCrossingCost(0.0);
        }

        public Object getSelectedEdgesDpKey() {
            return this.b.getSelectedEdgesDpKey();
        }

        public void setSelectedEdgesDpKey(Object object) {
            this.b.setSelectedEdgesDpKey(object);
        }

        public void routeInterEdges(LayoutGraph layoutGraph, DataProvider dataProvider, DataProvider dataProvider2) {
            Object object = this.getSelectedEdgesDpKey();
            DataProvider dataProvider3 = layoutGraph.getDataProvider(object);
            layoutGraph.addDataProvider(object, dataProvider2);
            this.b.setSelectedEdgesDpKey(object);
            this.b.setSphereOfAction((byte)2);
            this.b.doLayout(layoutGraph);
            layoutGraph.removeDataProvider(object);
            if (dataProvider3 != null) {
                layoutGraph.addDataProvider(object, dataProvider3);
            }
        }

        public OrthogonalEdgeRouter getOrthogonalEdgeRouter() {
            return this.b;
        }

        public void setOrthogonalEdgeRouter(OrthogonalEdgeRouter orthogonalEdgeRouter) {
            this.b = orthogonalEdgeRouter;
        }
    }

    public static class ChannelInterEdgeRouter
    implements InterEdgeRouter {
        private static final boolean e = false;
        private static final boolean h = true;
        private static final boolean j = false;
        private static final byte g = 1;
        private ChannelEdgeRouter d;
        private Object f;
        private boolean c;
        private double i;

        public ChannelInterEdgeRouter() {
            ChannelEdgeRouter.OrthogonalShortestPathPathFinder orthogonalShortestPathPathFinder = new ChannelEdgeRouter.OrthogonalShortestPathPathFinder();
            orthogonalShortestPathPathFinder.setRoutingStyle((byte)1);
            orthogonalShortestPathPathFinder.setCenterToSpaceRatio(0.75);
            this.d = new ChannelEdgeRouter();
            this.d.setPathFinderStrategy(orthogonalShortestPathPathFinder);
            this.f = Layouter.SELECTED_EDGES;
            this.c = false;
            this.i = -1.0;
        }

        public boolean isRouteInterEdgesOnly() {
            return this.c;
        }

        public void setRouteInterEdgesOnly(boolean bl) {
            this.c = bl;
        }

        public Object getInterEdgeDPKey() {
            return this.f;
        }

        public void setInterEdgeDPKey(Object object) {
            this.f = object;
        }

        public ChannelEdgeRouter getChannelEdgeRouter() {
            return this.d;
        }

        public void setChannelEdgeRouter(ChannelEdgeRouter channelEdgeRouter) {
            this.d = channelEdgeRouter;
        }

        public double getMargin() {
            return this.i;
        }

        public void setMargin(double d2) {
            this.i = d2;
        }

        public void routeInterEdges(LayoutGraph layoutGraph, DataProvider dataProvider, DataProvider dataProvider2) {
            block3: {
                block2: {
                    if (!this.c) break block2;
                    this.c(layoutGraph, dataProvider2);
                    if (LayoutGraph.z == 0) break block3;
                }
                this.b(layoutGraph, dataProvider2);
            }
        }

        private void c(LayoutGraph layoutGraph, DataProvider dataProvider) {
            Layouter layouter;
            block6: {
                block5: {
                    layoutGraph.addDataProvider(this.f, dataProvider);
                    layouter = this.d.getPathFinderStrategy();
                    if (!(layouter instanceof ChannelEdgeRouter.OrthogonalShortestPathPathFinder)) break block5;
                    ((ChannelEdgeRouter.OrthogonalShortestPathPathFinder)layouter).setAffectedEdgesDPKey(this.f);
                    if (LayoutGraph.z == 0) break block6;
                }
                if (layouter instanceof OrthogonalPatternEdgeRouter) {
                    ((OrthogonalPatternEdgeRouter)layouter).setAffectedEdgesDPKey(this.f);
                }
            }
            if ((layouter = this.d.getEdgeDistributionStrategy()) instanceof OrthogonalSegmentDistributionStage) {
                ((OrthogonalSegmentDistributionStage)layouter).setAffectedEdgesDPKey(this.f);
            }
            this.b(layoutGraph);
            layoutGraph.removeDataProvider(this.f);
        }

        private void b(LayoutGraph layoutGraph, DataProvider dataProvider) {
            DataProvider dataProvider2;
            DataProvider dataProvider3;
            DataProvider dataProvider4;
            block11: {
                int n2 = LayoutGraph.z;
                dataProvider4 = layoutGraph.getDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY);
                dataProvider3 = layoutGraph.getDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY);
                EdgeMap edgeMap = layoutGraph.createEdgeMap();
                EdgeMap edgeMap2 = layoutGraph.createEdgeMap();
                PortConstraintConfigurator portConstraintConfigurator = new PortConstraintConfigurator();
                EdgeCursor edgeCursor = layoutGraph.edges();
                while (edgeCursor.ok()) {
                    block15: {
                        boolean bl;
                        Edge edge;
                        block14: {
                            Object object;
                            block13: {
                                block12: {
                                    Object object2;
                                    edge = edgeCursor.edge();
                                    bl = dataProvider.getBool(edge);
                                    dataProvider2 = dataProvider3;
                                    if (n2 != 0) break block11;
                                    Object object3 = object2 = dataProvider2 != null ? dataProvider3.get(edge) : null;
                                    if (object2 == null) break block12;
                                    edgeMap.set(edge, object2);
                                    if (n2 == 0) break block13;
                                }
                                if (!bl) {
                                    edgeMap.set(edge, portConstraintConfigurator.createPortConstraintFromSketch(layoutGraph, edge, true, false));
                                }
                            }
                            Object object4 = object = dataProvider4 != null ? dataProvider4.get(edge) : null;
                            if (object == null) break block14;
                            edgeMap2.set(edge, object);
                            if (n2 == 0) break block15;
                        }
                        if (!bl) {
                            edgeMap2.set(edge, portConstraintConfigurator.createPortConstraintFromSketch(layoutGraph, edge, false, false));
                        }
                    }
                    edgeCursor.next();
                    if (n2 == 0) continue;
                }
                layoutGraph.addDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY, edgeMap);
                layoutGraph.addDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY, edgeMap2);
                this.b(layoutGraph);
                layoutGraph.removeDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY);
                layoutGraph.removeDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY);
                layoutGraph.disposeEdgeMap(edgeMap2);
                layoutGraph.disposeEdgeMap(edgeMap);
                dataProvider2 = dataProvider3;
            }
            if (dataProvider2 != null) {
                layoutGraph.addDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY, dataProvider3);
            }
            if (dataProvider4 != null) {
                layoutGraph.addDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY, dataProvider4);
            }
        }

        private void b(LayoutGraph layoutGraph) {
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            Rectangle rectangle;
            block10: {
                double d7;
                double d8;
                block9: {
                    rectangle = layoutGraph.getBoundingBox();
                    d6 = rectangle.width;
                    d5 = rectangle.height;
                    double d9 = d8 = d5 != 0.0 ? d6 / d5 : 1.0;
                    if (!(d8 > 1.0)) break block9;
                    d4 = d5 * this.i;
                    d7 = 2.0 * d4 + d5;
                    d3 = (d7 * d8 - d6) / 2.0;
                    if (LayoutGraph.z == 0) break block10;
                }
                d3 = d6 * this.i;
                d7 = 2.0 * d3 + d6;
                d4 = (d7 / d8 - d5) / 2.0;
            }
            Node node = null;
            Node node2 = null;
            Node node3 = null;
            Node node4 = null;
            if (d4 >= 0.0) {
                d2 = Math.max(d3, 0.0);
                node = layoutGraph.createNode();
                layoutGraph.setSize(node, d6 + 2.0 * d2 + 20.0, 10.0);
                layoutGraph.setLocation(node, (double)rectangle.x - d2 - 10.0, (double)rectangle.y - d4 - 10.0);
                node3 = layoutGraph.createNode();
                layoutGraph.setSize(node3, d6 + 2.0 * d2 + 20.0, 10.0);
                layoutGraph.setLocation(node3, (double)rectangle.x - d2 - 10.0, (double)rectangle.y + d5 + d4);
            }
            if (d3 >= 0.0) {
                d2 = Math.max(d4, 0.0);
                node2 = layoutGraph.createNode();
                layoutGraph.setSize(node2, 10.0, d5 + 2.0 * d2);
                layoutGraph.setLocation(node2, (double)rectangle.x - d3 - 10.0, (double)rectangle.y - d2);
                node4 = layoutGraph.createNode();
                layoutGraph.setSize(node4, 10.0, d5 + 2.0 * d2);
                layoutGraph.setLocation(node4, (double)rectangle.x + d6 + d3, (double)rectangle.y - d2);
            }
            this.d.doLayout(layoutGraph);
            if (node4 != null) {
                layoutGraph.removeNode(node4);
            }
            if (node2 != null) {
                layoutGraph.removeNode(node2);
            }
            if (node3 != null) {
                layoutGraph.removeNode(node3);
            }
            if (node != null) {
                layoutGraph.removeNode(node);
            }
        }
    }

    public static interface InterEdgeRouter {
        public void routeInterEdges(LayoutGraph var1, DataProvider var2, DataProvider var3);
    }

    public static interface PartitionPlacer {
        public void placePartitions(LayoutGraph var1, DataProvider var2, DataProvider var3);
    }

    public static interface PartitionFinder {
        public void findPartitions(LayoutGraph var1, NodeMap var2);
    }
}

