/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.layout.LayoutGraph;
import y.layout.PortConstraint;

public class PortCandidate {
    public static final int NORTH = 1;
    public static final int EAST = 4;
    public static final int WEST = 8;
    public static final int SOUTH = 2;
    public static final int WITH_THE_FLOW = 16;
    public static final int AGAINST_THE_FLOW = 32;
    public static final int LEFT_IN_FLOW = 64;
    public static final int RIGHT_IN_FLOW = 128;
    public static final int ANY = 255;
    private static final PortCandidate[] e = new PortCandidate[256];
    private static final PortCandidate[] j = new PortCandidate[256];
    private double k;
    private double g;
    private boolean d;
    private int c;
    private double h;
    public static final Object SOURCE_PCLIST_DPKEY = "y.layout.PortCandidate.SOURCE_PCLIST_DPKEY";
    public static final Object TARGET_PCLIST_DPKEY = "y.layout.PortCandidate.TARGET_PCLIST_DPKEY";
    private static final byte[] b = new byte[]{0, 2, 1, 3, 4, 6, 5, 7, 8, 10, 9, 11, 12, 14, 13, 15};
    private static final byte[] i = new byte[]{0, 4, 8, 12, 2, 6, 10, 14, 1, 5, 9, 13, 3, 7, 11, 15};
    private static final byte[] f = new byte[]{0, 8, 4, 12, 1, 9, 5, 13, 2, 10, 6, 14, 3, 11, 7, 15};

    protected PortCandidate(double d2, double d3, boolean bl, int n2, double d4) {
        this.k = d2;
        this.g = d3;
        this.d = bl;
        this.c = n2 & 0xFF;
        this.h = d4;
    }

    protected PortCandidate(double d2, double d3, int n2) {
        this(d2, d3, true, n2, 0.0);
    }

    protected PortCandidate(int n2) {
        this(0.0, 0.0, false, n2, 0.0);
    }

    protected PortCandidate(int n2, double d2) {
        this(0.0, 0.0, false, n2, d2);
    }

    public boolean isInDirection(int n2) {
        return (this.c & n2) != 0;
    }

    public int getDirection() {
        return this.c;
    }

    public boolean isFixed() {
        return this.d;
    }

    public double getXOffset() {
        return this.k;
    }

    public double getYOffset() {
        return this.g;
    }

    public static PortCandidate createCandidate(int n2) {
        return PortCandidate.createCandidate(n2, 0.0);
    }

    public static PortCandidate createCandidate(int n2, double d2) {
        int n3 = n2 & 0xFF;
        if (d2 == 0.0) {
            PortCandidate portCandidate = e[n3];
            if (portCandidate == null) {
                PortCandidate.e[n3] = portCandidate = new PortCandidate(n2);
            }
            return portCandidate;
        }
        if (d2 == 1.0) {
            PortCandidate portCandidate = j[n3];
            if (portCandidate == null) {
                portCandidate = new PortCandidate(n2);
                portCandidate.h = 1.0;
                PortCandidate.j[n3] = portCandidate;
            }
            return portCandidate;
        }
        return new PortCandidate(n2, d2);
    }

    public static PortCandidate createCandidate(double d2, double d3, int n2) {
        return PortCandidate.createCandidate(d2, d3, n2, 0.0);
    }

    public static PortCandidate createCandidate(double d2, double d3, int n2, double d4) {
        return new PortCandidate(d2, d3, true, n2, d4);
    }

    public static PortCandidate createCandidate(PortConstraint portConstraint) {
        if (portConstraint.isAtAnySide()) {
            return PortCandidate.createCandidate(15);
        }
        return PortCandidate.createCandidate(portConstraint.getSide());
    }

    public int hashCode() {
        return (this.d ? 4096 : 0) + this.c + (int)(Double.doubleToLongBits(this.h) + Double.doubleToLongBits(this.k) + Double.doubleToLongBits(this.g));
    }

    public PortConstraint toPortConstraint() {
        byte by;
        int n2 = LayoutGraph.z;
        switch (this.c) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                by = (byte)this.c;
                if (n2 == 0) break;
            }
            case 16: {
                by = 2;
                if (n2 == 0) break;
            }
            case 32: {
                by = 1;
                if (n2 == 0) break;
            }
            case 64: {
                by = 4;
                if (n2 == 0) break;
            }
            case 128: {
                by = 8;
                if (n2 == 0) break;
            }
            default: {
                by = 0;
            }
        }
        return PortConstraint.create(by, this.isFixed());
    }

    public PortConstraint toPortConstraintForLayoutOrientation(byte by) {
        byte by2;
        int n2 = LayoutGraph.z;
        switch (this.getDirectionForLayoutOrientation(by)) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                by2 = (byte)this.c;
                if (n2 == 0) break;
            }
            case 16: {
                by2 = 2;
                if (n2 == 0) break;
            }
            case 32: {
                by2 = 1;
                if (n2 == 0) break;
            }
            case 64: {
                by2 = 4;
                if (n2 == 0) break;
            }
            case 128: {
                by2 = 8;
                if (n2 == 0) break;
            }
            default: {
                by2 = 0;
            }
        }
        return PortConstraint.create(by2, this.isFixed());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PortCandidate)) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        PortCandidate portCandidate = (PortCandidate)object;
        return portCandidate.d == this.d && portCandidate.k == this.k && portCandidate.h == this.h && portCandidate.g == this.g && portCandidate.c == this.c;
    }

    public double getCost() {
        return this.h;
    }

    public int getDirectionForLayoutOrientation(byte by) {
        byte[] byArray;
        int n2 = LayoutGraph.z;
        switch (by) {
            default: {
                return this.getDirection();
            }
            case 2: {
                byArray = b;
                if (n2 == 0) break;
            }
            case 1: {
                byArray = i;
                if (n2 == 0) break;
            }
            case 3: {
                byArray = f;
            }
        }
        int n3 = this.getDirection();
        int n4 = n3 & 0xF;
        return (n3 &= 0xFFFFFFF0) | byArray[n4];
    }

    public double getXOffsetForLayoutOrientation(byte by, int n2) {
        switch (by) {
            default: {
                if ((n2 & 1) != 0) {
                    return -this.getXOffset();
                }
                return this.getXOffset();
            }
            case 2: {
                if ((n2 & 4) != 0) {
                    return this.getXOffset();
                }
                return -this.getXOffset();
            }
            case 1: {
                if ((n2 & 8) != 0) {
                    return this.getYOffset();
                }
                return -this.getYOffset();
            }
            case 3: 
        }
        if ((n2 & 2) != 0) {
            return -this.getYOffset();
        }
        return this.getYOffset();
    }

    public double getYOffsetForLayoutOrientation(byte by, int n2) {
        switch (by) {
            default: {
                return this.getYOffset();
            }
            case 2: {
                return -this.getYOffset();
            }
            case 1: {
                return this.getXOffset();
            }
            case 3: 
        }
        return -this.getXOffset();
    }

    public double getXOffsetForLayoutOrientation(byte by) {
        switch (by) {
            default: {
                return this.getXOffset();
            }
            case 2: {
                return this.getXOffset();
            }
            case 1: {
                return -this.getYOffset();
            }
            case 3: 
        }
        return this.getYOffset();
    }

    public double getYOffsetForLayoutOrientation(byte by) {
        switch (by) {
            default: {
                return this.getYOffset();
            }
            case 2: {
                return -this.getYOffset();
            }
            case 1: {
                return this.getXOffset();
            }
            case 3: 
        }
        return -this.getXOffset();
    }

    public String toString() {
        StringBuffer stringBuffer;
        block12: {
            block11: {
                stringBuffer = new StringBuffer(50);
                stringBuffer.append("PortCandidate(");
                stringBuffer.append('(').append(this.k).append(':').append(this.g).append(')');
                if (!this.d) break block11;
                stringBuffer.append("[fixed]");
                if (LayoutGraph.z == 0) break block12;
            }
            stringBuffer.append("[free]");
        }
        if (this.isInDirection(1)) {
            stringBuffer.append(" NORTH");
        }
        if (this.isInDirection(4)) {
            stringBuffer.append(" EAST");
        }
        if (this.isInDirection(2)) {
            stringBuffer.append(" SOUTH");
        }
        if (this.isInDirection(8)) {
            stringBuffer.append(" WEST");
        }
        if (this.isInDirection(32)) {
            stringBuffer.append(" AGAINST_THE_FLOW");
        }
        if (this.isInDirection(16)) {
            stringBuffer.append(" WITH_THE_FLOW");
        }
        if (this.isInDirection(64)) {
            stringBuffer.append(" LEFT_IN_FLOW");
        }
        if (this.isInDirection(128)) {
            stringBuffer.append(" RIGHT_IN_FLOW");
        }
        stringBuffer.append(", cost=");
        stringBuffer.append(this.h);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

