/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.DataProvider;
import y.base.Edge;
import y.layout.LayoutGraph;
import y.layout.PortConstraintKeys;

public class PortConstraint
implements PortConstraintKeys {
    public static final byte ANY_SIDE = 0;
    public static final byte NORTH = 1;
    public static final byte SOUTH = 2;
    public static final byte EAST = 4;
    public static final byte WEST = 8;
    private static final PortConstraint lab = new PortConstraint(0);
    private static final PortConstraint fab = new PortConstraint(1);
    private static final PortConstraint jab = new PortConstraint(2);
    private static final PortConstraint eab = new PortConstraint(4);
    private static final PortConstraint kab = new PortConstraint(8);
    private static final PortConstraint dab = new PortConstraint(0, true);
    private static final PortConstraint bab = new PortConstraint(4, true);
    private static final PortConstraint cab = new PortConstraint(8, true);
    private static final PortConstraint aab = new PortConstraint(1, true);
    private static final PortConstraint hab = new PortConstraint(2, true);
    private byte gab;
    private boolean iab;

    public PortConstraint() {
        this(0);
    }

    public PortConstraint(byte by) {
        this.gab = by;
    }

    public PortConstraint(byte by, boolean bl) {
        this(by);
        this.iab = bl;
    }

    public boolean isStrong() {
        return this.iab;
    }

    public byte getSide() {
        return this.gab;
    }

    public boolean isAtNorth() {
        return this.gab == 1;
    }

    public boolean isAtSouth() {
        return this.gab == 2;
    }

    public boolean isAtEast() {
        return this.gab == 4;
    }

    public boolean isAtWest() {
        return this.gab == 8;
    }

    public boolean isAtAnySide() {
        return this.gab == 0;
    }

    public static boolean hasPC(LayoutGraph layoutGraph, Edge edge) {
        return PortConstraint.hasSPC(layoutGraph, edge) || PortConstraint.hasTPC(layoutGraph, edge);
    }

    public static boolean hasSPC(LayoutGraph layoutGraph, Edge edge) {
        PortConstraint portConstraint = PortConstraint.getSPC(layoutGraph, edge);
        return portConstraint != null && (portConstraint.gab != 0 || portConstraint.iab);
    }

    public static boolean hasTPC(LayoutGraph layoutGraph, Edge edge) {
        PortConstraint portConstraint = PortConstraint.getTPC(layoutGraph, edge);
        return portConstraint != null && (portConstraint.gab != 0 || portConstraint.iab);
    }

    public static PortConstraint getSPC(LayoutGraph layoutGraph, Edge edge) {
        DataProvider dataProvider = layoutGraph.getDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY);
        if (dataProvider == null) {
            return null;
        }
        return (PortConstraint)dataProvider.get(edge);
    }

    public static PortConstraint getTPC(LayoutGraph layoutGraph, Edge edge) {
        DataProvider dataProvider = layoutGraph.getDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY);
        if (dataProvider == null) {
            return null;
        }
        return (PortConstraint)dataProvider.get(edge);
    }

    public static PortConstraint create(byte by) {
        return PortConstraint.create(by, false);
    }

    public int hashCode() {
        return this.iab ? 1024 + this.gab : this.gab;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PortConstraint)) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        PortConstraint portConstraint = (PortConstraint)object;
        return portConstraint.iab == this.iab && portConstraint.gab == this.gab;
    }

    public static PortConstraint create(byte by, boolean bl) {
        if (bl) {
            switch (by) {
                case 0: {
                    return dab;
                }
                case 1: {
                    return aab;
                }
                case 2: {
                    return hab;
                }
                case 4: {
                    return bab;
                }
                case 8: {
                    return cab;
                }
            }
            return null;
        }
        switch (by) {
            case 0: {
                return lab;
            }
            case 1: {
                return fab;
            }
            case 2: {
                return jab;
            }
            case 4: {
                return eab;
            }
            case 8: {
                return kab;
            }
        }
        return null;
    }

    public String toString() {
        if (this.gab == 0) {
            if (this.iab) {
                return "ANY_SIDE [strong] [-]";
            }
            return "ANY_SIDE [-]";
        }
        String string2 = null;
        switch (this.gab) {
            case 1: {
                string2 = "NORTH";
                break;
            }
            case 2: {
                string2 = "SOUTH";
                break;
            }
            case 4: {
                string2 = "EAST";
                break;
            }
            case 8: {
                string2 = "WEST";
            }
        }
        if (this.iab) {
            string2 = string2 + " [strong] ";
        }
        return string2;
    }
}

