/*
 * Decompiled with CFR 0.152.
 */
package y.layout.grouping;

import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.geom.YInsets;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.grouping.GroupBoundsCalculator;
import y.layout.grouping.Grouping;
import y.layout.grouping.GroupingKeys;

public class InsetsGroupBoundsCalculator
implements GroupBoundsCalculator {
    private Object i;
    private int g;
    private int f;
    private int k;
    private int h;
    private boolean j;

    public InsetsGroupBoundsCalculator() {
        this(GroupingKeys.GROUP_NODE_INSETS_DPKEY);
    }

    public InsetsGroupBoundsCalculator(Insets insets) {
        this(GroupingKeys.GROUP_NODE_INSETS_DPKEY, insets);
    }

    public InsetsGroupBoundsCalculator(Object object) {
        this.i = object;
        this.h = 15;
        this.k = 15;
        this.f = 15;
        this.g = 15;
    }

    public InsetsGroupBoundsCalculator(Object object, Insets insets) {
        this.i = object;
        this.g = insets.top;
        this.f = insets.bottom;
        this.k = insets.left;
        this.h = insets.right;
    }

    public boolean isConsiderNodeLabelsEnabled() {
        return this.j;
    }

    public void setConsiderNodeLabelsEnabled(boolean bl) {
        this.j = bl;
    }

    public Rectangle2D calculateBounds(LayoutGraph layoutGraph, Node node, NodeList nodeList) {
        Rectangle2D rectangle2D = LayoutTool.getBoundingBox(layoutGraph, layoutGraph.nodes(), layoutGraph.edges(), this.isConsiderNodeLabelsEnabled());
        return this.createEnlargedBounds(layoutGraph, node, nodeList, rectangle2D);
    }

    protected Rectangle2D createEnlargedBounds(LayoutGraph layoutGraph, Node node, NodeList nodeList, Rectangle2D rectangle2D) {
        YInsets yInsets;
        Object object;
        double d2 = this.g;
        double d3 = this.f;
        double d4 = this.h;
        double d5 = this.k;
        if (this.i != null && (object = layoutGraph.getDataProvider(this.i)) != null && (yInsets = YInsets.asYInsets(object.get(node))) != null) {
            d2 = yInsets.top;
            d3 = yInsets.bottom;
            d5 = yInsets.left;
            d4 = yInsets.right;
        }
        object = new Rectangle2D.Double();
        ((Rectangle2D)object).setFrame(rectangle2D.getX() - d5, rectangle2D.getY() - d2, rectangle2D.getWidth() + d5 + d4, rectangle2D.getHeight() + d2 + d3);
        return object;
    }

    protected Rectangle2D getNodeBounds(LayoutGraph layoutGraph, NodeList nodeList) {
        Rectangle2D.Double double_;
        block3: {
            boolean bl = Grouping.z;
            if (nodeList.isEmpty()) {
                return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            }
            NodeCursor nodeCursor = nodeList.nodes();
            Node node = nodeList.firstNode();
            Rectangle2D.Double double_2 = new Rectangle2D.Double(layoutGraph.getX(node), layoutGraph.getY(node), layoutGraph.getWidth(node), layoutGraph.getHeight(node));
            Rectangle2D.Double double_3 = new Rectangle2D.Double(double_2.x, double_2.y, double_2.width, double_2.height);
            nodeCursor.next();
            while (nodeCursor.ok()) {
                node = nodeCursor.node();
                double_2.x = layoutGraph.getX(node);
                double_2.y = layoutGraph.getY(node);
                double_2.width = layoutGraph.getWidth(node);
                double_2.height = layoutGraph.getHeight(node);
                double_ = double_3;
                if (!bl) {
                    double_.add(double_2);
                    nodeCursor.next();
                    if (!bl) continue;
                }
                break block3;
            }
            double_ = double_3;
        }
        return double_;
    }

    public void setDefaultInsets(Insets insets) {
        this.g = insets.top;
        this.k = insets.left;
        this.f = insets.bottom;
        this.h = insets.right;
    }

    public Insets getDefaultInsets() {
        return new Insets(this.g, this.k, this.f, this.h);
    }

    public void setGroupNodeInsetsDPKey(Object object) {
        this.i = object;
    }

    public Object getGroupNodeInsetsDPKey() {
        return this.i;
    }
}

