/*
 * Decompiled with CFR 0.152.
 */
package y.layout.hierarchic;

import y.base.DataProvider;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.geom.YPoint;
import y.layout.LayoutGraph;
import y.layout.hierarchic.Drawer;
import y.layout.hierarchic.g;
import y.util.Maps;

public abstract class AbstractDrawer
implements Drawer {
    protected double minimalNodeDistance = 20.0;
    protected double minimalLayerDistance = 60.0;
    protected double minimalEdgeDistance = 5.0;
    protected double minimalMultiEdgeDistance = 0.0;
    protected NodeMap dummyMap;
    protected Object edgeLengthKey;
    protected LayoutGraph graph;
    protected NodeMap distanceToNextNode;
    public static int z;

    public void setMinimalEdgeDistance(double d2) {
        this.minimalEdgeDistance = d2;
    }

    public void setMinimalMultiEdgeDistance(double d2) {
        this.minimalMultiEdgeDistance = d2;
    }

    public double getMinimalEdgeDistance() {
        return this.minimalEdgeDistance;
    }

    public double getMinimalMultiEdgeDistance() {
        return this.minimalMultiEdgeDistance;
    }

    public void setMinimalNodeDistance(double d2) {
        this.minimalNodeDistance = d2;
    }

    public void setMinimalLayerDistance(double d2) {
        this.minimalLayerDistance = d2;
    }

    public void setDummyMap(NodeMap nodeMap) {
        this.dummyMap = nodeMap;
    }

    public double getMinimalNodeDistance() {
        return this.minimalNodeDistance;
    }

    public double getMinimalLayerDistance() {
        return this.minimalLayerDistance;
    }

    public void setEdgeLengthKey(Object object) {
        this.edgeLengthKey = object;
    }

    public void assignYCoords(LayoutGraph layoutGraph, NodeList[] nodeListArray) {
        block2: {
            int n2 = z;
            NodeCursor[] nodeCursorArray = new NodeCursor[nodeListArray.length];
            for (int i2 = 0; i2 < nodeListArray.length; ++i2) {
                nodeCursorArray[i2] = nodeListArray[i2].nodes();
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block2;
            }
            this.assignYCoords(layoutGraph, nodeCursorArray);
        }
    }

    public void assignYCoords(LayoutGraph layoutGraph, NodeCursor[] nodeCursorArray) {
        int n2 = z;
        double[] dArray = new double[nodeCursorArray.length];
        double d2 = 0.0;
        for (int i2 = 0; i2 < nodeCursorArray.length; ++i2) {
            DataProvider dataProvider;
            double d3;
            NodeCursor nodeCursor;
            block10: {
                block9: {
                    double d4 = 0.0;
                    nodeCursor = nodeCursorArray[i2];
                    nodeCursor.toFirst();
                    while (nodeCursor.ok()) {
                        d4 = Math.max(d4, layoutGraph.getHeight(nodeCursor.node()));
                        nodeCursor.next();
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                        }
                        break block9;
                    }
                    dArray[i2] = d4;
                }
                nodeCursor.toFirst();
                while (nodeCursor.ok()) {
                    d3 = (dArray[i2] - layoutGraph.getHeight(nodeCursor.node())) / 2.0;
                    layoutGraph.setLocation(nodeCursor.node(), new YPoint(layoutGraph.getX(nodeCursor.node()), d2 + d3));
                    nodeCursor.next();
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break block10;
                }
                d3 = this.getMinimalLayerDistance();
            }
            Object object = this.edgeLengthKey;
            block3: while (object != null && (dataProvider = layoutGraph.getDataProvider(this.edgeLengthKey)) != null) {
                nodeCursor.toFirst();
                while (nodeCursor.ok()) {
                    block11: {
                        Node node = nodeCursor.node();
                        object = node.outEdges();
                        if (n2 != 0) continue block3;
                        Object object2 = object;
                        while (object2.ok()) {
                            d3 = Math.max(d3, dataProvider.getDouble(object2.edge()));
                            object2.next();
                            if (n2 == 0) {
                                if (n2 == 0) continue;
                            }
                            break block11;
                        }
                        nodeCursor.next();
                    }
                    if (n2 == 0) continue;
                }
                break block3;
            }
            d2 += dArray[i2] + d3;
            nodeCursor.toFirst();
            if (n2 == 0) continue;
        }
    }

    public void assignCoordinates(LayoutGraph layoutGraph, NodeList[] nodeListArray, DataProvider dataProvider) {
        this.graph = layoutGraph;
        this.initializeDistancesToNextNode(nodeListArray);
        this.assignCoordinates(nodeListArray, dataProvider);
        this.dispose();
    }

    protected abstract void assignCoordinates(NodeList[] var1, DataProvider var2);

    public double getLeftX(Node node) {
        return this.graph.getX(node) - this.getLeftBorder(node);
    }

    public double getRightX(Node node) {
        return this.graph.getX(node) + this.graph.getWidth(node) + this.getRightBorder(node);
    }

    public double getTopY(Node node) {
        return this.graph.getY(node) - this.getTopBorder(node);
    }

    public double getBottomY(Node node) {
        return this.graph.getY(node) + this.graph.getHeight(node) + this.getBottomBorder(node);
    }

    public double getFullWidth(Node node) {
        return this.graph.getWidth(node) + this.getLeftBorder(node) + this.getRightBorder(node);
    }

    public double getFullHeight(Node node) {
        return this.graph.getHeight(node) + this.getTopBorder(node) + this.getBottomBorder(node);
    }

    public double getLeftBorder(Node node) {
        if (this.dummyMap.get(node) != null) {
            return 0.0;
        }
        DataProvider dataProvider = this.graph.getDataProvider(Drawer.NODE_BORDER_LEFT);
        return dataProvider != null ? dataProvider.getDouble(node) : 0.0;
    }

    public double getRightBorder(Node node) {
        if (this.dummyMap.get(node) != null) {
            return 0.0;
        }
        DataProvider dataProvider = this.graph.getDataProvider(Drawer.NODE_BORDER_RIGHT);
        return dataProvider != null ? dataProvider.getDouble(node) : 0.0;
    }

    public double getTopBorder(Node node) {
        if (this.dummyMap.get(node) != null) {
            return 0.0;
        }
        DataProvider dataProvider = this.graph.getDataProvider(Drawer.NODE_BORDER_TOP);
        return dataProvider != null ? dataProvider.getDouble(node) : 0.0;
    }

    public double getBottomBorder(Node node) {
        if (this.dummyMap.get(node) != null) {
            return 0.0;
        }
        DataProvider dataProvider = this.graph.getDataProvider(Drawer.NODE_BORDER_BOTTOM);
        return dataProvider != null ? dataProvider.getDouble(node) : 0.0;
    }

    public double getLeftHalf(Node node) {
        return this.graph.getWidth(node) / 2.0 + this.getLeftBorder(node);
    }

    public double getRightHalf(Node node) {
        return this.graph.getWidth(node) / 2.0 + this.getRightBorder(node);
    }

    public double getTopHalf(Node node) {
        return this.graph.getHeight(node) / 2.0 + this.getTopBorder(node);
    }

    public double getBottomHalf(Node node) {
        return this.graph.getHeight(node) / 2.0 + this.getBottomBorder(node);
    }

    protected void initializeDistancesToNextNode(NodeList[] nodeListArray) {
        Object object;
        DataProvider dataProvider;
        DataProvider dataProvider2;
        int n2;
        block13: {
            Object object2;
            DataProvider dataProvider3;
            block12: {
                n2 = z;
                dataProvider2 = this.graph.getDataProvider(Drawer.NODE_BORDER_RIGHT);
                dataProvider = this.graph.getDataProvider(Drawer.NODE_BORDER_LEFT);
                dataProvider3 = this.graph.getDataProvider(Drawer.NODE_DISTANCE);
                this.distanceToNextNode = Maps.createIndexNodeMap(new double[this.graph.N()]);
                if (dataProvider3 != null) break block12;
                object2 = new g();
                ((g)object2).b(this.getMinimalEdgeDistance());
                ((g)object2).c(this.getMinimalNodeDistance());
                ((g)object2).b(this.graph, nodeListArray, this.dummyMap, this.distanceToNextNode);
                if (n2 == 0) break block13;
            }
            object2 = this.graph.nodes();
            while (object2.ok()) {
                object = object2.node();
                this.distanceToNextNode.setDouble(object, dataProvider3.getDouble(object));
                object2.next();
                if (n2 == 0) continue;
            }
        }
        int n3 = 0;
        while (n3 < nodeListArray.length) {
            object = nodeListArray[n3].nodes();
            if (object.ok()) {
                Node node = object.node();
                object.next();
                while (object.ok()) {
                    Node node2 = object.node();
                    double d2 = this.distanceToNextNode.getDouble(node);
                    if (n2 == 0) {
                        if (dataProvider2 != null) {
                            d2 += dataProvider2.getDouble(node);
                        }
                        if (dataProvider != null) {
                            d2 += dataProvider.getDouble(node2);
                        }
                        this.distanceToNextNode.setDouble(node, d2);
                        node = node2;
                        object.next();
                        if (n2 == 0) continue;
                    }
                    break;
                }
            } else {
                ++n3;
            }
            if (n2 == 0) continue;
        }
    }

    protected double getDistanceToNextNode(Node node) {
        return this.distanceToNextNode.getDouble(node);
    }

    protected void dispose() {
        this.distanceToNextNode = null;
    }
}

