/*
 * Decompiled with CFR 0.152.
 */
package y.layout.hierarchic;

import y.algo.AlgorithmAbortedException;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.ListCell;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YCursor;
import y.base.YList;
import y.layout.LayoutGraph;
import y.layout.hierarchic.AbstractDrawer;
import y.util.Maps;
import y.util.Timer;

public class PendularDrawer
extends AbstractDrawer {
    static final boolean he = false;
    private boolean ie = false;
    private double je;
    private double fe;
    private double ke = 10.0;
    private double le = 2.0;
    static final double ue = 1.0E-5;
    protected NodeMap right;
    protected NodeMap left;
    private int pe = 1;
    Timer qe = new Timer(false);
    Timer se = new Timer(false);
    Timer me = new Timer(false);
    Timer re = new Timer(false);
    Timer ge = new Timer(false);
    Timer ye = new Timer(false);
    Timer xe = new Timer(false);
    Timer ne = new Timer(false);
    Timer we = new Timer(false);
    Timer oe = new Timer(false);
    Timer ve = new Timer(false);
    Timer te = new Timer(false);

    protected void initStructures() {
        this.qe.toggle();
        this.je = Math.max(this.getMinimalMultiEdgeDistance(), this.getMinimalEdgeDistance());
        if (this.je < 1.0) {
            this.je = 1.0;
        }
        this.fe = (double)((int)(this.getMinimalNodeDistance() / this.je)) * this.je;
        this.right = Maps.createIndexNodeMap(new Object[this.graph.nodeCount()]);
        this.left = Maps.createIndexNodeMap(new Object[this.graph.nodeCount()]);
        this.qe.toggle();
    }

    protected void assignCoordinates(NodeList[] nodeListArray, DataProvider dataProvider) {
        int n2 = AbstractDrawer.z;
        this.se.toggle();
        this.initStructures();
        this.initializePositions(nodeListArray);
        double d2 = this.getZ();
        double d3 = Double.POSITIVE_INFINITY;
        int n3 = 0;
        while (n3 < this.pe && d2 < d3) {
            block9: {
                YList yList;
                int n4;
                block8: {
                    block7: {
                        AlgorithmAbortedException.check();
                        ++n3;
                        d3 = d2;
                        for (n4 = 1; n4 < nodeListArray.length; ++n4) {
                            yList = this.partitionLayer(nodeListArray[n4], -1);
                            this.shakePartition(yList, -1);
                            if (n2 == 0) {
                                if (n2 == 0) continue;
                            }
                            break block7;
                        }
                        n4 = nodeListArray.length - 2;
                    }
                    while (n4 >= 0) {
                        yList = this.partitionLayer(nodeListArray[n4], 1);
                        this.shakePartition(yList, 1);
                        --n4;
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                        }
                        break block8;
                    }
                    n4 = 1;
                }
                while (n4 < nodeListArray.length - 1) {
                    yList = this.partitionLayer(nodeListArray[n4], 0);
                    this.shakePartition(yList, 0);
                    ++n4;
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break block9;
                }
                this.minNode();
                d2 = this.getZ();
            }
            if (n2 == 0) continue;
        }
        AlgorithmAbortedException.check();
        YList yList = this.findChains();
        this.minPath(yList);
        this.se.toggle();
    }

    protected void disposeStructures() {
        this.graph.disposeNodeMap(this.left);
        this.graph.disposeNodeMap(this.right);
    }

    protected boolean minPath(YList yList) {
        int n2;
        int n3 = AbstractDrawer.z;
        this.me.toggle();
        int n4 = 0;
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        block0: while (true) {
            int n5 = 0;
            YList yList2 = yList;
            block1: while (true) {
                YCursor yCursor = yList2.cursor();
                block2: while (true) {
                    n2 = yCursor.ok();
                    do {
                        if (n2 != 0) {
                            int n6;
                            block9: {
                                NodeList nodeList = (NodeList)yCursor.current();
                                Node node = nodeList.firstNode();
                                dArray[0] = this.getMaximumExtent(node, true);
                                dArray[1] = this.getMaximumExtent(node, false);
                                ListCell listCell = nodeList.firstCell();
                                yList2 = nodeList;
                                if (n3 != 0) continue block1;
                                for (ListCell listCell2 = (v3967804).firstCell().succ(); listCell2 != null; listCell2 = listCell2.succ()) {
                                    node = (Node)listCell2.getInfo();
                                    dArray2[0] = this.getMaximumExtent(node, true);
                                    dArray2[1] = this.getMaximumExtent(node, false);
                                    dArray3[0] = Math.max(dArray[0], dArray2[0]);
                                    dArray3[1] = Math.min(dArray[1], dArray2[1]);
                                    double d2 = dArray3[1] - dArray3[0];
                                    n6 = d2 == 0.0 ? 0 : (d2 < 0.0 ? -1 : 1);
                                    if (n3 == 0) {
                                        if (n6 < 0) {
                                            ListCell listCell3 = listCell2.pred();
                                            if (listCell3 != null && listCell3 != listCell) {
                                                n4 |= (n5 |= this.straightenPath(listCell, listCell3, dArray));
                                            }
                                            listCell = listCell2;
                                            dArray[0] = dArray2[0];
                                            dArray[1] = dArray2[1];
                                            if (n3 == 0) continue;
                                        }
                                        dArray[0] = dArray3[0];
                                        dArray[1] = dArray3[1];
                                        if (n3 == 0) continue;
                                    }
                                    break block9;
                                }
                                n6 = n4 | (n5 |= this.straightenPath(listCell, nodeList.lastCell(), dArray));
                            }
                            n4 = n6;
                            yCursor.next();
                            if (n3 == 0) continue block2;
                        }
                        if (n5 != 0) continue block0;
                        this.me.toggle();
                        n2 = n4;
                    } while (n3 != 0);
                    break;
                }
                break;
            }
            break;
        }
        return n2 != 0;
    }

    protected YList findChains() {
        YList yList;
        block7: {
            int n2 = AbstractDrawer.z;
            this.re.toggle();
            NodeMap nodeMap = Maps.createIndexNodeMap(new Object[this.graph.nodeCount()]);
            yList = new YList();
            NodeCursor nodeCursor = this.graph.nodes();
            block0: while (true) {
                boolean bl = nodeCursor.ok();
                block1: while (bl) {
                    Node node = nodeCursor.node();
                    if (n2 != 0) break block7;
                    if (nodeMap.get(node) == null && this.isSegmentNode(node)) {
                        int n3;
                        NodeList nodeList;
                        block8: {
                            while (node.inDegree() == 1) {
                                bl = this.isSegmentNode(node.predecessors().node());
                                if (n2 != 0) continue block1;
                                if (!bl) break;
                                node = node.predecessors().node();
                                if (n2 == 0) continue;
                            }
                            nodeList = new NodeList();
                            nodeList.add(node);
                            nodeMap.set(node, nodeList);
                            while (node.outDegree() == 1) {
                                node = node.successors().node();
                                n3 = this.isSegmentNode(node) ? 1 : 0;
                                if (n2 == 0) {
                                    if (n3 == 0) break;
                                    nodeList.add(node);
                                    nodeMap.set(node, nodeList);
                                    if (n2 == 0) continue;
                                }
                                break block8;
                            }
                            n3 = nodeList.size();
                        }
                        if (n3 > 1) {
                            yList.add(nodeList);
                        }
                    }
                    nodeCursor.next();
                    if (n2 == 0) continue block0;
                }
                break;
            }
            this.re.toggle();
        }
        return yList;
    }

    protected boolean straightenPath(ListCell listCell, ListCell listCell2, double[] dArray) {
        double d2;
        int n2 = AbstractDrawer.z;
        this.ge.toggle();
        boolean bl = false;
        if (listCell == listCell2) {
            this.ge.toggle();
            return false;
        }
        Node node = (Node)listCell.getInfo();
        Node node2 = (Node)listCell2.getInfo();
        double d3 = (dArray[0] + dArray[1]) / 2.0;
        if (dArray[0] <= -1.7976931348623157E308) {
            dArray[0] = Math.min(this.graph.getCenterX(node), this.graph.getCenterX(node2));
            d2 = dArray[0];
            if (node.inDegree() == 1) {
                d2 = Math.min(d2, this.graph.getCenterX(node.predecessors().node()));
            }
            if (node2.outDegree() == 1) {
                d2 = Math.min(d2, this.graph.getCenterX(node2.successors().node()));
            }
            dArray[0] = d2;
            if (dArray[0] > dArray[1]) {
                dArray[0] = dArray[1];
            }
            d3 = dArray[0];
        }
        if (dArray[1] >= Double.MAX_VALUE) {
            dArray[1] = Math.max(this.graph.getCenterX(node), this.graph.getCenterX(node2));
            d2 = dArray[1];
            if (node.inDegree() == 1) {
                d2 = Math.max(d2, this.graph.getCenterX(node.predecessors().node()));
            }
            if (node2.outDegree() == 1) {
                d2 = Math.max(d2, this.graph.getCenterX(node2.successors().node()));
            }
            dArray[1] = d2;
            if (dArray[1] < dArray[0]) {
                dArray[1] = dArray[0];
            }
            d3 = dArray[1];
        }
        block0: while (true) {
            Node node3 = (Node)listCell.getInfo();
            if (!bl && Math.abs(this.graph.getCenterX(node3) - d3) > 5.0) {
                bl = true;
            }
            this.graph.setCenter(node3, d3, this.graph.getCenterY(node3));
            listCell = listCell.succ();
            do {
                if (listCell != listCell2.succ()) continue block0;
                this.ge.toggle();
            } while (n2 != 0);
            break;
        }
        return bl;
    }

    protected boolean isSegmentNode(Node node) {
        if (node.inDegree() == 1) {
            return node.outDegree() < 2;
        }
        if (node.outDegree() == 1) {
            return node.inDegree() < 2;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected void minNode() {
        block4: {
            var8_1 = AbstractDrawer.z;
            this.ye.toggle();
            var1_2 = new NodeList(this.graph.nodes());
            var2_3 = new boolean[this.graph.nodeCount()];
            var3_4 = 0;
            block0: while (true) {
                v0 = var1_2.isEmpty();
                block1: while (!v0 && var3_4 < this.graph.nodeCount() * this.graph.nodeCount()) {
                    ++var3_4;
                    var4_5 = var1_2.popNode();
                    var2_3[var4_5.index()] = true;
                    var5_6 = this.getPendulumForce(var4_5, var4_5.edges());
                    if (!(Math.abs(var5_6 = this.verifyMovement(var4_5, var5_6)) > 1.0E-5)) continue block0;
                    this.move(var4_5, var5_6);
                    if (var8_1 != 0) break block4;
                    var7_7 = var4_5.neighbors();
                    do {
                        if (var7_7.ok()) ** break;
                        continue block0;
                        v0 = var2_3[var7_7.node().index()];
                        if (var8_1 != 0) continue block1;
                        if (v0) {
                            var2_3[var7_7.node().index()] = false;
                            var1_2.addLast(var7_7.node());
                        }
                        var7_7.next();
                    } while (var8_1 == 0);
                }
                break;
            }
            this.ye.toggle();
        }
    }

    protected void shakePartition(YList yList, int n2) {
        block3: {
            int n3 = AbstractDrawer.z;
            this.xe.toggle();
            YCursor yCursor = yList.cursor();
            while (yCursor.ok()) {
                block5: {
                    double d2;
                    NodeList nodeList;
                    block4: {
                        nodeList = (NodeList)yCursor.current();
                        d2 = this.getPendulumForce(nodeList.cursor(), n2);
                        if (n3 != 0) break block3;
                        if (!(d2 < 0.0)) break block4;
                        d2 = this.verifyMovement(nodeList.firstNode(), d2);
                        this.move(nodeList.cursor(), d2);
                        if (n3 == 0) break block5;
                    }
                    d2 = this.verifyMovement((Node)nodeList.last(), d2);
                    this.move(nodeList.cursor(), d2);
                }
                yCursor.next();
                if (n3 == 0) continue;
            }
            this.xe.toggle();
        }
    }

    protected YList partitionLayer(NodeList nodeList, int n2) {
        Object object;
        boolean bl;
        Object object2;
        YList yList;
        int n3;
        block6: {
            n3 = AbstractDrawer.z;
            this.ne.toggle();
            yList = new YList();
            NodeCursor nodeCursor = nodeList.nodes();
            while (nodeCursor.ok()) {
                object2 = new NodeList();
                ((YList)object2).add(nodeCursor.node());
                bl = yList.add(object2);
                if (n3 == 0) {
                    nodeCursor.next();
                    if (n3 == 0) continue;
                }
                break block6;
            }
            bl = false;
        }
        boolean bl2 = bl;
        block1: while (true) {
            bl2 = false;
            object2 = yList.firstCell();
            block2: while (object2 != null) {
                object = ((ListCell)object2).getInfo();
                do {
                    boolean bl3;
                    block7: {
                        NodeList nodeList2 = (NodeList)object;
                        if ((object2 = ((ListCell)object2).succ()) == null) continue block2;
                        NodeList nodeList3 = (NodeList)((ListCell)object2).getInfo();
                        bl3 = this.touches((Node)nodeList2.last(), nodeList3.firstNode());
                        if (n3 == 0) {
                            double d2;
                            double d3;
                            if (!bl3 || !((d3 = this.getPendulumForce(nodeList2.cursor(), n2)) >= (d2 = this.getPendulumForce(nodeList3.cursor(), n2)))) continue block2;
                            bl2 = true;
                            nodeList2.addAll(nodeList3.cursor());
                            Object object3 = object2;
                            yList.removeCell((ListCell)object3);
                            object2 = ((ListCell)object2).succ();
                            if (n3 == 0) continue block2;
                        }
                        break block7;
                        bl3 = bl2;
                    }
                    if (bl3) continue block1;
                    this.ne.toggle();
                    object = yList;
                } while (n3 != 0);
            }
            break;
        }
        return object;
    }

    protected void setLayoutGraph(LayoutGraph layoutGraph) {
        this.graph = layoutGraph;
    }

    protected double getPendulumForce(Node node, EdgeCursor edgeCursor) {
        double d2;
        double d3;
        block3: {
            int n2 = AbstractDrawer.z;
            d3 = 0.0;
            d2 = 0.0;
            edgeCursor.toFirst();
            while (edgeCursor.ok()) {
                Edge edge = edgeCursor.edge();
                double d4 = this.getEdgeWeight(edge);
                d2 += d4;
                d3 += d4 * (this.graph.getCenterX(edge.opposite(node)) - this.graph.getCenterX(node));
                edgeCursor.next();
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block3;
            }
            if (d3 == 0.0) {
                return 0.0;
            }
        }
        return d3 / d2;
    }

    protected boolean touches(Node node, Node node2) {
        if (this.right.get(node) == node2) {
            return this.getLeftX(node2) - this.getRightX(node) - 1.0E-5 < this.getMinimalLayerDistance(node, false);
        }
        if (this.left.get(node) == node2) {
            return this.getLeftX(node) - this.getRightX(node2) - 1.0E-5 < this.getMinimalLayerDistance(node, true);
        }
        return false;
    }

    protected double verifyMovement(Node node, double d2) {
        block4: {
            Node node2;
            block5: {
                this.oe.toggle();
                if (d2 == 0.0) break block4;
                if (!(d2 < 0.0)) break block5;
                node2 = (Node)this.left.get(node);
                if (node2 == null) break block4;
                d2 = Math.max(d2, this.getRightX(node2) - this.getLeftX(node) + this.getMinimalLayerDistance(node, true));
                if (AbstractDrawer.z == 0) break block4;
            }
            if ((node2 = (Node)this.right.get(node)) != null) {
                d2 = Math.min(d2, this.getLeftX(node2) - this.getRightX(node) - this.getMinimalLayerDistance(node, false));
            }
        }
        this.oe.toggle();
        return d2;
    }

    protected double getPendulumForce(YCursor yCursor, int n2) {
        double d2;
        int n3;
        block3: {
            int n4 = AbstractDrawer.z;
            this.we.toggle();
            n3 = 0;
            d2 = 0.0;
            yCursor.toFirst();
            while (yCursor.ok()) {
                block5: {
                    Node node;
                    block6: {
                        block4: {
                            ++n3;
                            node = (Node)yCursor.current();
                            if (n4 != 0) break block3;
                            if (n2 != -1) break block4;
                            d2 += this.getPendulumForce(node, node.inEdges());
                            if (n4 == 0) break block5;
                        }
                        if (n2 != 0) break block6;
                        d2 += this.getPendulumForce(node, node.edges());
                        if (n4 == 0) break block5;
                    }
                    d2 += this.getPendulumForce(node, node.outEdges());
                }
                yCursor.next();
                if (n4 == 0) continue;
            }
            this.we.toggle();
        }
        return d2 / (double)n3;
    }

    protected void move(Node node, double d2) {
        double d3;
        block2: {
            block3: {
                d3 = this.graph.getCenterX(node) + d2;
                if (!this.ie) break block2;
                if (this.dummyMap.get(node) != null) break block3;
                d3 = (double)((int)((d3 + this.fe / 2.0) / this.fe)) * this.fe;
                if (AbstractDrawer.z == 0) break block2;
            }
            d3 = (double)((int)((d3 + this.je / 2.0) / this.je)) * this.je;
        }
        this.graph.setCenter(node, d3, this.graph.getCenterY(node));
    }

    protected void move(YCursor yCursor, double d2) {
        int n2 = AbstractDrawer.z;
        yCursor.toFirst();
        while (yCursor.ok()) {
            Node node = (Node)yCursor.current();
            this.move(node, d2);
            yCursor.next();
            if (n2 == 0) continue;
        }
    }

    protected double getZ() {
        int n2 = AbstractDrawer.z;
        this.ve.toggle();
        double d2 = 0.0;
        NodeCursor nodeCursor = this.graph.nodes();
        while (nodeCursor.ok()) {
            block3: {
                EdgeCursor edgeCursor = nodeCursor.node().edges();
                while (edgeCursor.ok()) {
                    Edge edge = edgeCursor.edge();
                    d2 += this.getEdgeWeight(edge) * Math.abs(this.graph.getCenterX(edge.source()) - this.graph.getCenterX(edge.target()));
                    edgeCursor.next();
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break block3;
                }
                nodeCursor.next();
            }
            if (n2 == 0) continue;
        }
        this.ve.toggle();
        return d2;
    }

    protected double getEdgeWeight(Edge edge) {
        if (this.dummyMap.get(edge.source()) == null) {
            if (this.dummyMap.get(edge.target()) == null) {
                return 1.0;
            }
            return this.le * 1.0;
        }
        if (this.dummyMap.get(edge.target()) == null) {
            return this.le * 1.0;
        }
        return this.ke * 1.0;
    }

    protected double getMaximumExtent(Node node, boolean bl) {
        if (bl) {
            Node node2 = (Node)this.left.get(node);
            if (node2 == null) {
                return -1.7976931348623157E308;
            }
            return this.getRightX(node2) + this.getMinimalLayerDistance(node, true) + this.getLeftHalf(node);
        }
        Node node3 = (Node)this.right.get(node);
        if (node3 == null) {
            return Double.MAX_VALUE;
        }
        return this.getLeftX(node3) - this.getMinimalLayerDistance(node, false) - this.getRightHalf(node);
    }

    protected double getMinimalLayerDistance(Node node, boolean bl) {
        Node node2;
        block8: {
            block7: {
                if (!bl) break block7;
                if (this.left.get(node) == null) {
                    return 0.0;
                }
                node2 = (Node)this.left.get(node);
                if (AbstractDrawer.z == 0) break block8;
            }
            if (this.right.get(node) == null) {
                return 0.0;
            }
            node2 = (Node)this.right.get(node);
        }
        Edge edge = (Edge)this.dummyMap.get(node);
        Edge edge2 = (Edge)this.dummyMap.get(node2);
        if (edge == null || edge2 == null) {
            return this.getMinimalNodeDistance();
        }
        if (edge.target() == edge2.source() || edge.target() == edge2.target()) {
            return this.getMinimalMultiEdgeDistance();
        }
        return this.getMinimalEdgeDistance();
    }

    protected void initializePositions(NodeList[] nodeListArray) {
        block6: {
            int n2 = AbstractDrawer.z;
            this.te.toggle();
            this.assignYCoords(this.graph, nodeListArray);
            int n3 = 0;
            while (n3 < nodeListArray.length) {
                block7: {
                    double d2 = 0.0;
                    Node node = null;
                    if (n2 != 0) break block6;
                    NodeCursor nodeCursor = nodeListArray[n3].nodes();
                    while (nodeCursor.ok()) {
                        Node node2;
                        block8: {
                            block9: {
                                node2 = nodeCursor.node();
                                if (n2 != 0) break block7;
                                if (node != null) {
                                    this.right.set(node, node2);
                                    this.left.set(node2, node);
                                }
                                node = node2;
                                d2 += this.graph.getNodeLayout(node2).getWidth() / 2.0 + this.getLeftBorder(node2) + this.getMinimalLayerDistance(node2, true);
                                if (!this.ie) break block8;
                                if (this.dummyMap.get(node2) != null) break block9;
                                d2 = (double)((int)((d2 + this.fe / 2.0) / this.fe)) * this.fe;
                                if (n2 == 0) break block8;
                            }
                            d2 = (double)((int)((d2 + this.je / 2.0) / this.je)) * this.je;
                        }
                        this.graph.setCenter(node2, d2, this.graph.getCenterY(node2));
                        d2 += this.graph.getNodeLayout(node2).getWidth() / 2.0 + this.getRightBorder(node2);
                        nodeCursor.next();
                        if (n2 == 0) continue;
                    }
                    ++n3;
                }
                if (n2 == 0) continue;
            }
            this.te.toggle();
        }
    }
}

