/*
 * Decompiled with CFR 0.152.
 */
package y.layout.hierarchic.incremental;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import y.base.DataProvider;
import y.base.Edge;
import y.base.ListCell;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.layout.LayoutGraph;
import y.layout.PortCandidate;
import y.layout.hierarchic.incremental.EdgeData;
import y.layout.hierarchic.incremental.HierarchicLayouter;
import y.layout.hierarchic.incremental.ItemFactory;
import y.layout.hierarchic.incremental.Layer;
import y.layout.hierarchic.incremental.Layers;
import y.layout.hierarchic.incremental.LayoutDataProvider;
import y.layout.hierarchic.incremental.NodeData;
import y.layout.hierarchic.incremental.PortConstraintOptimizer;
import y.layout.hierarchic.incremental.m;
import y.util.Comparators;
import y.util.Maps;

public abstract class AbstractPortConstraintOptimizer
implements PortConstraintOptimizer {
    private byte c = 0;
    private int b = 4;

    protected AbstractPortConstraintOptimizer() {
    }

    public int getMirrorMask() {
        return this.b;
    }

    public void setMirrorMask(int n2) {
        this.b = n2;
    }

    public void setLayoutOrientation(byte by) {
        this.c = by;
    }

    public byte getLayoutOrientation() {
        return this.c;
    }

    public abstract void optimizeAfterLayering(LayoutGraph var1, Layers var2, LayoutDataProvider var3, ItemFactory var4);

    public void optimizeAfterSequencing(LayoutGraph layoutGraph, Layers layers, LayoutDataProvider layoutDataProvider, ItemFactory itemFactory) {
        SameLayerData sameLayerData = this.insertSameLayerStructures(layoutGraph, layers, layoutDataProvider, itemFactory);
        Comparator[] comparatorArray = this.b(sameLayerData, layoutGraph, layers, layoutDataProvider);
        this.optimizeAfterSequencing(comparatorArray[0], comparatorArray[1], layoutGraph, layers, layoutDataProvider, itemFactory);
        this.removeSameLayerStructures(sameLayerData, layoutGraph, layoutDataProvider, itemFactory);
    }

    protected void optimizeAfterSequencing(Comparator comparator2, Comparator comparator3, LayoutGraph layoutGraph, Layers layers, LayoutDataProvider layoutDataProvider, ItemFactory itemFactory) {
        boolean bl = HierarchicLayouter.z;
        int n2 = 0;
        block0: while (true) {
            int n3 = n2;
            block1: while (n3 < layers.size()) {
                Layer layer = layers.getLayer(n2);
                for (ListCell listCell = layer.getList().firstCell(); listCell != null; listCell = listCell.succ()) {
                    Node node = (Node)listCell.getInfo();
                    n3 = layoutDataProvider.getNodeData(node).getType();
                    if (bl) continue block1;
                    if (n3 != 0) continue;
                    this.optimizeAfterSequencing(node, comparator2, comparator3, layoutGraph, layoutDataProvider, itemFactory);
                    if (!bl) continue;
                }
                ++n2;
                if (!bl) continue block0;
            }
            break;
        }
    }

    protected abstract void optimizeAfterSequencing(Node var1, Comparator var2, Comparator var3, LayoutGraph var4, LayoutDataProvider var5, ItemFactory var6);

    protected SameLayerData insertSameLayerStructures(LayoutGraph layoutGraph, Layers layers, LayoutDataProvider layoutDataProvider, ItemFactory itemFactory) {
        boolean bl = HierarchicLayouter.z;
        SameLayerData sameLayerData = new SameLayerData();
        int n2 = 0;
        block0: while (true) {
            int n3 = n2;
            block1: while (n3 < layers.size()) {
                Layer layer = layers.getLayer(n2);
                for (ListCell listCell = layer.getList().firstCell(); listCell != null; listCell = listCell.succ()) {
                    Node node = (Node)listCell.getInfo();
                    NodeData nodeData = layoutDataProvider.getNodeData(node);
                    n3 = nodeData.sameLayerEdgeCount();
                    if (bl) continue block1;
                    if (n3 <= 0) continue;
                    for (ListCell listCell2 = nodeData.getFirstSameLayerEdgeCell(); listCell2 != null; listCell2 = listCell2.succ()) {
                        Edge edge = (Edge)listCell2.getInfo();
                        n3 = edge.source().equals(node) ? 1 : 0;
                        if (bl) continue block1;
                        if (n3 == 0) continue;
                        Node node2 = layoutGraph.createNode();
                        sameLayerData.addDummyNode(node2, edge);
                        if (layoutDataProvider.getEdgeData(edge).isUpperSameLayerEdge()) {
                            itemFactory.createReverseDummyEdge(node2, node, edge, false, true);
                            itemFactory.createDummyEdge(node2, edge.target(), edge, false, true);
                            if (!bl) continue;
                        }
                        itemFactory.createDummyEdge(node, node2, edge, true, false);
                        itemFactory.createReverseDummyEdge(edge.target(), node2, edge, true, false);
                        if (!bl) continue;
                    }
                    if (!bl) continue;
                }
                ++n2;
                if (!bl) continue block0;
            }
            break;
        }
        return sameLayerData;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    protected void removeSameLayerStructures(SameLayerData sameLayerData, LayoutGraph layoutGraph, LayoutDataProvider layoutDataProvider, ItemFactory itemFactory) {
        int n2;
        boolean bl = HierarchicLayouter.z;
        NodeCursor nodeCursor = sameLayerData.getDummyNodes().nodes();
        while (nodeCursor.ok()) {
            Edge edge;
            block17: {
                EdgeData edgeData;
                EdgeData edgeData2;
                Edge edge2;
                Edge edge3;
                EdgeData edgeData3;
                block18: {
                    Node node;
                    block15: {
                        block16: {
                            node = nodeCursor.node();
                            edge = sameLayerData.getOriginalEdge(node);
                            layoutGraph.unhide(edge);
                            edgeData3 = layoutDataProvider.getEdgeData(edge);
                            n2 = node.outDegree();
                            if (bl) {
                                return;
                            }
                            if (n2 <= 0) break block15;
                            edge3 = node.firstOutEdge();
                            edge2 = node.lastOutEdge();
                            edgeData2 = layoutDataProvider.getEdgeData(edge3);
                            edgeData = layoutDataProvider.getEdgeData(edge2);
                            if (edge3.target() != edge.source()) break block16;
                            if (edgeData2.getTPC() != edgeData3.getSPC()) {
                                itemFactory.setTemporaryPortConstraint(edge, true, edgeData2.getTPC());
                            }
                            if (edgeData.getTPC() != edgeData3.getTPC()) {
                                itemFactory.setTemporaryPortConstraint(edge, false, edgeData.getTPC());
                            }
                            layoutGraph.setSourcePointRel(edge, layoutGraph.getTargetPointRel(edge3));
                            layoutGraph.setTargetPointRel(edge, layoutGraph.getTargetPointRel(edge2));
                            if (!bl) break block17;
                        }
                        if (edgeData.getTPC() != edgeData3.getSPC()) {
                            itemFactory.setTemporaryPortConstraint(edge, true, edgeData.getTPC());
                        }
                        if (edgeData2.getTPC() != edgeData3.getTPC()) {
                            itemFactory.setTemporaryPortConstraint(edge, false, edgeData2.getTPC());
                        }
                        layoutGraph.setSourcePointRel(edge, layoutGraph.getTargetPointRel(edge2));
                        layoutGraph.setTargetPointRel(edge, layoutGraph.getTargetPointRel(edge3));
                        if (!bl) break block17;
                    }
                    edge3 = node.firstInEdge();
                    edge2 = node.lastInEdge();
                    edgeData2 = layoutDataProvider.getEdgeData(edge3);
                    edgeData = layoutDataProvider.getEdgeData(edge2);
                    if (edge3.source() != edge.source()) break block18;
                    if (edgeData2.getSPC() != edgeData3.getSPC()) {
                        itemFactory.setTemporaryPortConstraint(edge, true, edgeData2.getSPC());
                    }
                    if (edgeData.getSPC() != edgeData3.getTPC()) {
                        itemFactory.setTemporaryPortConstraint(edge, false, edgeData.getSPC());
                    }
                    layoutGraph.setSourcePointRel(edge, layoutGraph.getSourcePointRel(edge3));
                    layoutGraph.setTargetPointRel(edge, layoutGraph.getSourcePointRel(edge2));
                    if (!bl) break block17;
                }
                if (edgeData.getSPC() != edgeData3.getSPC()) {
                    itemFactory.setTemporaryPortConstraint(edge, true, edgeData.getSPC());
                }
                if (edgeData2.getSPC() != edgeData3.getTPC()) {
                    itemFactory.setTemporaryPortConstraint(edge, false, edgeData2.getSPC());
                }
                layoutGraph.setSourcePointRel(edge, layoutGraph.getSourcePointRel(edge2));
                layoutGraph.setTargetPointRel(edge, layoutGraph.getSourcePointRel(edge3));
            }
            layoutGraph.hide(edge);
            nodeCursor.next();
            if (!bl) continue;
        }
        nodeCursor = sameLayerData.getDummyNodes().nodes();
        do {
            n2 = nodeCursor.ok();
            if (n2 == 0) return;
            layoutGraph.removeNode(nodeCursor.node());
            nodeCursor.next();
        } while (!bl);
    }

    private Comparator[] b(SameLayerData sameLayerData, LayoutGraph layoutGraph, Layers layers, LayoutDataProvider layoutDataProvider) {
        Comparator comparator2;
        boolean bl = HierarchicLayouter.z;
        int[] nArray = new int[layoutGraph.N()];
        m m2 = m.b(layoutGraph, layers, layoutDataProvider, nArray, new int[layoutGraph.N()], new byte[layoutGraph.E()], new int[layoutGraph.E()], new byte[layoutGraph.E()], new int[layoutGraph.E()], (byte)1, (byte)0);
        Object object = sameLayerData.getDummyNodes().nodes();
        while (object.ok()) {
            int n2 = object.node().index();
            nArray[n2] = -1;
            object.next();
            if (!bl) continue;
        }
        if ((object = m2.d(true)) instanceof m._c) {
            m._c _c2 = (m._c)object;
            _c2.b(new _b(layoutGraph.getDataProvider(PortCandidate.TARGET_PCLIST_DPKEY), _c2.b(), this.c, this.b));
        }
        if ((comparator2 = m2.d(false)) instanceof m._n) {
            m._n _n2 = (m._n)comparator2;
            _n2.d(new _b(layoutGraph.getDataProvider(PortCandidate.SOURCE_PCLIST_DPKEY), _n2.d(), this.c, this.b));
        }
        return new Comparator[]{comparator2, object};
    }

    static class _b
    implements Comparator,
    Comparators.PartialOrder {
        private final DataProvider bc;
        private final Comparator ac;
        private final byte zb;
        private final int yb;

        _b(DataProvider dataProvider, Comparator comparator2, byte by, int n2) {
            this.bc = dataProvider;
            this.ac = comparator2;
            this.yb = n2;
            this.zb = by;
        }

        public int compare(Object object, Object object2) {
            double d2;
            double d3;
            block10: {
                Collection collection;
                boolean bl;
                block9: {
                    bl = HierarchicLayouter.z;
                    if (this.ac != null && this.ac.compare(object, object2) != 0) {
                        return this.ac.compare(object, object2);
                    }
                    if (this.bc == null) {
                        return 0;
                    }
                    Collection collection2 = (Collection)this.bc.get(object);
                    collection = (Collection)this.bc.get(object2);
                    if (collection2 == null && collection == null) {
                        return 0;
                    }
                    if (collection2 == null) {
                        return -1;
                    }
                    if (collection == null) {
                        return 1;
                    }
                    d3 = 0.0;
                    Iterator iterator2 = collection2.iterator();
                    while (iterator2.hasNext()) {
                        PortCandidate portCandidate = (PortCandidate)iterator2.next();
                        d3 += portCandidate.getXOffsetForLayoutOrientation(this.zb, this.yb);
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block9;
                    }
                    d3 /= (double)collection2.size();
                }
                d2 = 0.0;
                Iterator iterator3 = collection.iterator();
                while (iterator3.hasNext()) {
                    PortCandidate portCandidate = (PortCandidate)iterator3.next();
                    d2 += portCandidate.getXOffsetForLayoutOrientation(this.zb, this.yb);
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block10;
                }
                d2 /= (double)collection.size();
            }
            return (int)(100.0 * (d3 - d2));
        }
    }

    public static class SameLayerData {
        private final NodeList b = new NodeList();
        private final NodeMap c = Maps.createHashedNodeMap();

        public void addDummyNode(Node node, Edge edge) {
            this.b.add(node);
            this.c.set(node, edge);
        }

        public NodeList getDummyNodes() {
            return this.b;
        }

        public Edge getOriginalEdge(Node node) {
            return (Edge)this.c.get(node);
        }
    }
}

