/*
 * Decompiled with CFR 0.152.
 */
package y.layout.router;

import java.util.Iterator;
import y.base.DataProvider;
import y.base.GraphInterface;
import y.layout.AbstractLayoutStage;
import y.layout.GraphLayout;
import y.layout.LayoutGraph;
import y.layout.Layouter;
import y.layout.NodeLayout;
import y.layout.grouping.GroupingKeys;
import y.layout.router.GroupNodeRouterStage;
import y.layout.router.OrthogonalEdgeRouter;
import y.layout.router.OrthogonalPatternEdgeRouter;
import y.layout.router.OrthogonalSegmentDistributionStage;
import y.util.DataProviders;

public class ChannelEdgeRouter
extends AbstractLayoutStage {
    public static final Object AFFECTED_EDGES = "y.layout.router.ChannelEdgeRouter.AFFECTED_EDGES";
    private static final String ebc = "y.layout.router.CHANNEL_EDGE_ROUTER_NODE_SIZE_CHECKED_DPKEY";
    private Layouter dbc;
    private Layouter fbc;

    public ChannelEdgeRouter() {
        OrthogonalPatternEdgeRouter orthogonalPatternEdgeRouter = new OrthogonalPatternEdgeRouter();
        orthogonalPatternEdgeRouter.setAffectedEdgesDPKey(AFFECTED_EDGES);
        this.dbc = orthogonalPatternEdgeRouter;
        OrthogonalSegmentDistributionStage orthogonalSegmentDistributionStage = new OrthogonalSegmentDistributionStage();
        orthogonalSegmentDistributionStage.setAffectedEdgesDPKey(AFFECTED_EDGES);
        this.fbc = orthogonalSegmentDistributionStage;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        Layouter layouter;
        if (layoutGraph.getDataProvider(ebc) == null) {
            try {
                this.td(layoutGraph);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
        return (layouter = this.getCoreLayouter()) == null || layouter.canLayout(layoutGraph);
    }

    public void doLayout(LayoutGraph layoutGraph) {
        boolean bl;
        block6: {
            block7: {
                block8: {
                    bl = false;
                    if (layoutGraph.getDataProvider(ebc) == null) {
                        this.td(layoutGraph);
                        layoutGraph.addDataProvider(ebc, DataProviders.createConstantDataProvider(Boolean.TRUE));
                        bl = true;
                    }
                    this.doLayoutCore(layoutGraph);
                    if (layoutGraph.edgeCount() <= 0) break block6;
                    if (this.dbc == null) break block7;
                    if (!(this.dbc instanceof OrthogonalEdgeRouter)) break block8;
                    new GroupNodeRouterStage(this.dbc).doLayout(layoutGraph);
                    if (OrthogonalEdgeRouter.z == 0) break block7;
                }
                this.dbc.doLayout(layoutGraph);
            }
            if (this.fbc != null) {
                this.fbc.doLayout(layoutGraph);
            }
        }
        if (bl) {
            layoutGraph.removeDataProvider(ebc);
        }
    }

    private void td(LayoutGraph layoutGraph) {
        this.g(layoutGraph, layoutGraph);
    }

    private void g(GraphInterface graphInterface, GraphLayout graphLayout) {
        int n2 = OrthogonalEdgeRouter.z;
        DataProvider dataProvider = graphInterface.getDataProvider(GroupingKeys.GROUP_DPKEY);
        if (dataProvider == null) {
            dataProvider = DataProviders.createConstantDataProvider(Boolean.FALSE);
        }
        Iterator iterator2 = graphInterface.nodeObjects();
        while (iterator2.hasNext()) {
            Object e2 = iterator2.next();
            if (!dataProvider.getBool(e2)) {
                this.checkNodeSize(graphLayout, e2);
                if (n2 == 0) continue;
            }
            this.checkGroupNodeSize(graphLayout, e2);
            if (n2 == 0) continue;
        }
    }

    protected void checkNodeSize(GraphLayout graphLayout, Object object) throws IllegalArgumentException {
        NodeLayout nodeLayout = graphLayout.getNodeLayout(object);
        if (nodeLayout.getWidth() == 0.0 || nodeLayout.getHeight() == 0.0) {
            throw new IllegalArgumentException("Graph contains nodes with zero width/height. Please enlarge those nodes manually or by using LayoutStage y.layout.MinNodeSizeStage.");
        }
    }

    protected void checkGroupNodeSize(GraphLayout graphLayout, Object object) throws IllegalArgumentException {
        NodeLayout nodeLayout = graphLayout.getNodeLayout(object);
        if (nodeLayout.getWidth() == 0.0 || nodeLayout.getHeight() == 0.0) {
            throw new IllegalArgumentException("Graph contains group nodes with zero width/height. Please enlarge those nodes manually or by using LayoutStage y.layout.MinNodeSizeStage.");
        }
    }

    public void setPathFinderStrategy(Layouter layouter) {
        this.dbc = layouter;
    }

    public void setEdgeDistributionStrategy(Layouter layouter) {
        this.fbc = layouter;
    }

    public Layouter getPathFinderStrategy() {
        return this.dbc;
    }

    public Layouter getEdgeDistributionStrategy() {
        return this.fbc;
    }

    public static class OrthogonalShortestPathPathFinder
    extends OrthogonalEdgeRouter {
        private Object cbc = AFFECTED_EDGES;

        public boolean canLayout(LayoutGraph layoutGraph) {
            Layouter layouter = this.getCoreLayouter();
            return layouter == null || layouter.canLayout(layoutGraph);
        }

        public void doLayout(LayoutGraph layoutGraph) {
            Object object;
            block3: {
                block2: {
                    this.doLayoutCore(layoutGraph);
                    object = this.getSelectedEdgesDpKey();
                    DataProvider dataProvider = layoutGraph.getDataProvider(this.cbc);
                    if (dataProvider == null) break block2;
                    this.setSphereOfAction((byte)2);
                    this.setSelectedEdgesDpKey(this.cbc);
                    if (OrthogonalEdgeRouter.z == 0) break block3;
                }
                this.setSphereOfAction((byte)0);
            }
            this.setProperty("AllowRigModification", Boolean.FALSE);
            this.setLocalCrossingMinimizationEnabled(false);
            super.doLayout(layoutGraph);
            this.setSelectedEdgesDpKey(object);
        }

        public void setAffectedEdgesDPKey(Object object) {
            this.cbc = object;
        }

        public Object getAffectedEdgesDPKey() {
            return this.cbc;
        }
    }
}

