/*
 * Decompiled with CFR 0.152.
 */
package y.layout.router.polyline;

import y.base.Edge;
import y.geom.LineSegment;
import y.geom.YPoint;
import y.layout.Direction;
import y.layout.router.polyline.Interval;
import y.layout.router.polyline.PathSearchExtension;
import y.layout.router.polyline.SegmentGroup;

public abstract class AbstractSegmentInfo {
    public static final byte ALIGNMENT_MIN = -1;
    public static final byte ALIGNMENT_MAX = 1;
    public static final byte ALIGNMENT_ANY = 0;
    private static final double d = 1.0E-6;
    private double i;
    private boolean b;
    private final Direction h;
    private final _b k;
    private Interval f;
    private Interval c;
    private final Interval e;
    private SegmentGroup g;
    private byte j = 0;

    protected AbstractSegmentInfo(Edge edge, int n2, Direction direction, Interval interval, Interval interval2, Interval interval3) {
        this.h = direction;
        this.k = new _b(edge, n2);
        this.b = false;
        this.f = interval;
        this.c = interval2;
        this.e = interval3;
    }

    protected AbstractSegmentInfo(Edge edge, int n2, LineSegment lineSegment) {
        this.h = AbstractSegmentInfo.b(lineSegment);
        this.k = new _b(edge, n2);
        this.i = AbstractSegmentInfo.d(lineSegment);
        this.f = new Interval(this.i, this.i);
        this.c = this.e = AbstractSegmentInfo.c(lineSegment);
        this.b = true;
    }

    public String toString() {
        return "SegmentInfo{" + (this.getEdge() != null ? "edge=" + this.getEdge().source().index() + "->" + this.getEdge().target().index() : "grouped Segment") + ", segmentIndex=" + this.getSegmentIndex() + ", direction=" + this.h + ", location range=" + this.f + ", min extension=" + this.c + ", max extension=" + this.e + '}';
    }

    static double d(LineSegment lineSegment) {
        boolean bl;
        YPoint yPoint = lineSegment.getFirstEndPoint();
        boolean bl2 = bl = Math.abs(yPoint.x - lineSegment.getSecondEndPoint().x) < 1.0E-6;
        if (bl) {
            return yPoint.x;
        }
        return yPoint.y;
    }

    static Interval c(LineSegment lineSegment) {
        boolean bl;
        YPoint yPoint = lineSegment.getFirstEndPoint();
        YPoint yPoint2 = lineSegment.getSecondEndPoint();
        boolean bl2 = bl = Math.abs(yPoint.x - yPoint2.x) < 1.0E-6;
        if (bl) {
            return new Interval(yPoint.y, yPoint2.y);
        }
        return new Interval(yPoint.x, yPoint2.x);
    }

    static Direction b(LineSegment lineSegment) {
        YPoint yPoint = lineSegment.getFirstEndPoint();
        YPoint yPoint2 = lineSegment.getSecondEndPoint();
        if (yPoint.x > yPoint2.x + 1.0E-6) {
            return Direction.LEFT;
        }
        if (yPoint.x + 1.0E-6 < yPoint2.x) {
            return Direction.RIGHT;
        }
        if (yPoint.y > yPoint2.y + 1.0E-6) {
            return Direction.UP;
        }
        if (yPoint.y + 1.0E-6 < yPoint2.y) {
            return Direction.DOWN;
        }
        throw new RuntimeException("could not determine direction for segment " + lineSegment);
    }

    public Interval getMinExtension() {
        return this.c;
    }

    void b(Interval interval) {
        this.c = interval;
    }

    public Interval getMaxExtension() {
        return this.e;
    }

    public Interval getLocationRange() {
        return this.f;
    }

    void c(Interval interval) {
        this.f = interval;
    }

    public byte getPreferredAlignment() {
        return this.j;
    }

    public void setPreferredAlignment(byte by) {
        switch (by) {
            case -1: 
            case 0: 
            case 1: {
                this.j = by;
                if (PathSearchExtension.z == 0) break;
            }
            default: {
                throw new IllegalArgumentException("unknown alignment " + by);
            }
        }
    }

    public void setLocation(double d2) {
        if (this.isFixed()) {
            throw new IllegalStateException("try to change location for a fixed segment");
        }
        if (this.f.getMin() - 1.0E-6 > d2 || this.f.getMax() + 1.0E-6 < d2) {
            throw new IllegalArgumentException("location " + d2 + " does not lie in location range " + this.f + "!");
        }
        this.i = d2;
        this.b = true;
    }

    public double getLocation() {
        return this.i;
    }

    public boolean isFixed() {
        return this.b;
    }

    public boolean isVertical() {
        return this.h.isVertical();
    }

    public Direction getDirection() {
        return this.h;
    }

    public Edge getEdge() {
        return this.k.b;
    }

    public int getSegmentIndex() {
        return this.k.c;
    }

    void b(int n2) {
        this.k.c = n2;
    }

    private _b b() {
        return this.k;
    }

    public void setSegmentGroup(SegmentGroup segmentGroup) {
        this.g = segmentGroup;
        this.f = segmentGroup.getCommonLocationRange();
    }

    public SegmentGroup getSegmentGroup() {
        return this.g;
    }

    private static class _b {
        private Edge b;
        private int c;

        private _b(Edge edge, int n2) {
            this.b = edge;
            this.c = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            _b _b2 = (_b)object;
            if (this.c != _b2.c) {
                return false;
            }
            return !(this.b != null ? !this.b.equals(_b2.b) : _b2.b != null);
        }

        public int hashCode() {
            int n2 = this.b != null ? this.b.hashCode() : 0;
            n2 = 31 * n2 + this.c;
            return n2;
        }

        public static _b b(Edge edge, int n2) {
            return new _b(edge, n2);
        }
    }
}

