/*
 * Decompiled with CFR 0.152.
 */
package y.layout.router.polyline;

import y.layout.router.polyline.PathSearchExtension;
import y.layout.router.polyline.PenaltySettings;

public class EdgeLayoutDescriptor {
    public static final byte MONOTONIC_NONE = 0;
    public static final byte MONOTONIC_VERTICAL = 1;
    public static final byte MONOTONIC_HORIZONTAL = 2;
    public static final byte MONOTONIC_BOTH = 3;
    private static final double k = 5.0;
    private static final double e = 10.0;
    private static final int h = 3;
    private static final int g = 3;
    private double f = 5.0;
    private double i = 10.0;
    private double j = 3.0;
    private double c = 3.0;
    private byte b = 0;
    private PenaltySettings d = new PenaltySettings();

    public void setMinimalFirstSegmentLength(double d2) {
        this.f = d2 < 0.0 ? 5.0 : d2;
    }

    public double getMinimalFirstSegmentLength() {
        return this.f;
    }

    public void setMinimalLastSegmentLength(double d2) {
        this.i = d2 < 0.0 ? 10.0 : d2;
    }

    public double getMinimalLastSegmentLength() {
        return this.i;
    }

    public double getMinimalEdgeToEdgeDistance() {
        return this.j;
    }

    public void setMinimalEdgeToEdgeDistance(double d2) {
        this.j = d2 < 0.0 ? 3.0 : d2;
    }

    public double getMinimalNodeCornerDistance() {
        return this.c;
    }

    public void setMinimalNodeCornerDistance(double d2) {
        this.c = d2 < 0.0 ? 3.0 : d2;
    }

    public byte getMonotonicPathRestriction() {
        return this.b;
    }

    public void setMonotonicPathRestriction(byte by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.b = by;
                if (PathSearchExtension.z == 0) break;
            }
            default: {
                this.b = 0;
            }
        }
    }

    public PenaltySettings getPenaltySettings() {
        return this.d;
    }

    public void setPenaltySettings(PenaltySettings penaltySettings) {
        if (penaltySettings == null) {
            throw new IllegalArgumentException("penaltySettings must not be null");
        }
        this.d = penaltySettings;
    }

    public EdgeLayoutDescriptor createCopy() {
        EdgeLayoutDescriptor edgeLayoutDescriptor = new EdgeLayoutDescriptor();
        edgeLayoutDescriptor.setMinimalFirstSegmentLength(this.getMinimalFirstSegmentLength());
        edgeLayoutDescriptor.setMinimalLastSegmentLength(this.getMinimalLastSegmentLength());
        edgeLayoutDescriptor.setMinimalEdgeToEdgeDistance(this.getMinimalEdgeToEdgeDistance());
        edgeLayoutDescriptor.setMinimalNodeCornerDistance(this.getMinimalNodeCornerDistance());
        edgeLayoutDescriptor.setMonotonicPathRestriction(this.getMonotonicPathRestriction());
        edgeLayoutDescriptor.setPenaltySettings(this.getPenaltySettings().createCopy());
        return edgeLayoutDescriptor;
    }
}

