/*
 * Decompiled with CFR 0.152.
 */
package y.layout.router.polyline;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Graph;
import y.base.YList;
import y.geom.LineSegment;
import y.geom.YPoint;
import y.geom.YRectangle;
import y.layout.AbstractLayoutStage;
import y.layout.Direction;
import y.layout.LayoutGraph;
import y.layout.Layouter;
import y.layout.RemoveColinearBendsStage;
import y.layout.grouping.Grouping;
import y.layout.router.polyline.AbstractSegmentInfo;
import y.layout.router.polyline.CellSegmentInfo;
import y.layout.router.polyline.DynamicObstacleDecomposition;
import y.layout.router.polyline.EdgeInfo;
import y.layout.router.polyline.EdgeRouter;
import y.layout.router.polyline.GraphPartition;
import y.layout.router.polyline.Interval;
import y.layout.router.polyline.Obstacle;
import y.layout.router.polyline.ObstaclePartition;
import y.layout.router.polyline.PartitionCell;
import y.layout.router.polyline.PathSearchConfiguration;
import y.layout.router.polyline.PathSearchExtension;
import y.layout.router.polyline.PathSearchResult;
import y.layout.router.polyline.SegmentGroup;
import y.layout.router.polyline.SegmentInfo;
import y.layout.router.polyline.d;
import y.layout.router.polyline.db;
import y.layout.router.polyline.g;
import y.util.GraphHider;

public class PolylineLayoutStage
extends AbstractLayoutStage {
    public static final byte ROUTE_ALL_EDGES = 0;
    public static final byte ROUTE_SELECTED_EDGES = 2;
    public static final byte ROUTE_EDGES_AT_SELECTED_NODES = 4;
    private static final EdgeRouter ntb = PolylineLayoutStage.mj();
    private static final double rtb = 1.0E-6;
    private Object utb = Layouter.SELECTED_EDGES;
    private Object ttb = Layouter.SELECTED_NODES;
    private byte otb;
    private double qtb = 10.0;
    private double stb = 0.5;
    private double ptb = 50.0;

    public PolylineLayoutStage(Layouter layouter) {
        super(layouter);
    }

    public PolylineLayoutStage() {
    }

    private static EdgeRouter mj() {
        EdgeRouter edgeRouter = new EdgeRouter();
        edgeRouter.setSphereOfAction((byte)2);
        return edgeRouter;
    }

    public Object getSelectedNodesDpKey() {
        return this.ttb;
    }

    public void setSelectedNodesDpKey(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null");
        }
        this.ttb = object;
    }

    public Object getSelectedEdgesDpKey() {
        return this.utb;
    }

    public void setSelectedEdgesDpKey(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null");
        }
        this.utb = object;
    }

    public void setSphereOfAction(byte by) {
        switch (by) {
            case 0: 
            case 2: 
            case 4: {
                this.otb = by;
                if (PathSearchExtension.z == 0) break;
            }
            default: {
                throw new IllegalArgumentException("Argument '" + by + "' not allowed.");
            }
        }
    }

    public byte getSphereOfAction() {
        return this.otb;
    }

    public double getMinimalNodeToEdgeDistance() {
        return this.qtb;
    }

    public void setMinimalNodeToEdgeDistance(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The distance must not be less than 0!");
        }
        this.qtb = d2;
    }

    public double getMaximumNonOrthogonalSegmentRatio() {
        return this.stb;
    }

    public void setMaximumNonOrthogonalSegmentRatio(double d2) {
        if (d2 < 0.0 || d2 > 0.5) {
            throw new IllegalArgumentException("The ratio must be between 0 and 0.5!");
        }
        this.stb = d2;
    }

    public double getPreferredPolylineSegmentLength() {
        return this.ptb;
    }

    public void setPreferredPolylineSegmentLength(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The length must not be less than 0!");
        }
        this.ptb = d2;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        return this.canLayoutCore(layoutGraph);
    }

    public void doLayout(LayoutGraph layoutGraph) {
        Object object;
        Object object2;
        GraphHider graphHider;
        EdgeList edgeList;
        int n2;
        block6: {
            n2 = PathSearchExtension.z;
            this.doLayoutCore(layoutGraph);
            edgeList = new EdgeList();
            graphHider = new GraphHider(layoutGraph);
            object2 = layoutGraph.edges();
            while (object2.ok()) {
                block8: {
                    block7: {
                        object = object2.edge();
                        if (n2 != 0) break block6;
                        if (EdgeRouter.h((Edge)object, layoutGraph)) break block7;
                        graphHider.hide((Edge)object);
                        if (n2 == 0) break block8;
                    }
                    if (this.c((Edge)object, layoutGraph)) {
                        edgeList.add(object);
                    }
                }
                object2.next();
                if (n2 == 0) continue;
            }
            ntb.setMinimalNodeToEdgeDistance(this.getMinimalNodeToEdgeDistance());
        }
        object2 = new DynamicObstacleDecomposition();
        object = new _b((ObstaclePartition)object2);
        ((GraphPartition)object).addDynamicDecompositionListener(new db());
        ((GraphPartition)object).addDynamicDecompositionListener(new d());
        Grouping grouping = new Grouping(layoutGraph);
        PathSearchConfiguration pathSearchConfiguration = new PathSearchConfiguration(layoutGraph, grouping, ntb);
        ((GraphPartition)object).init(pathSearchConfiguration);
        PathSearchResult pathSearchResult = this.b(layoutGraph, (GraphPartition)object, pathSearchConfiguration);
        g g2 = new g();
        g2.b(this.getMaximumNonOrthogonalSegmentRatio());
        g2.c(this.getPreferredPolylineSegmentLength());
        g2.b(edgeList, pathSearchResult, pathSearchConfiguration);
        ((GraphPartition)object).clear();
        RemoveColinearBendsStage removeColinearBendsStage = new RemoveColinearBendsStage();
        removeColinearBendsStage.doLayout(layoutGraph);
        grouping.dispose();
        graphHider.unhideAll();
        if (Graph.z) {
            PathSearchExtension.z = ++n2;
        }
    }

    private boolean c(Edge edge, Graph graph) {
        if (this.getSphereOfAction() == 0) {
            return true;
        }
        if (this.getSphereOfAction() == 2) {
            DataProvider dataProvider = graph.getDataProvider(this.getSelectedEdgesDpKey());
            return dataProvider != null && dataProvider.getBool(edge);
        }
        if (this.getSphereOfAction() == 4) {
            DataProvider dataProvider = graph.getDataProvider(this.getSelectedNodesDpKey());
            return dataProvider != null && (dataProvider.getBool(edge.source()) || dataProvider.getBool(edge.target()));
        }
        return false;
    }

    private PathSearchResult b(LayoutGraph layoutGraph, GraphPartition graphPartition, PathSearchConfiguration pathSearchConfiguration) {
        PathSearchResult pathSearchResult;
        block2: {
            int n2 = PathSearchExtension.z;
            pathSearchResult = new PathSearchResult(pathSearchConfiguration);
            EdgeCursor edgeCursor = layoutGraph.edges();
            while (edgeCursor.ok()) {
                Edge edge = (Edge)edgeCursor.current();
                EdgeInfo edgeInfo = this.b(edge, layoutGraph, graphPartition, pathSearchConfiguration);
                pathSearchResult.b(edge, edgeInfo);
                edgeCursor.next();
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block2;
            }
            this.b(layoutGraph, pathSearchResult);
        }
        return pathSearchResult;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void b(LayoutGraph var1_1, PathSearchResult var2_2) {
        var14_3 = PathSearchExtension.z;
        var3_4 = new HashMap<YPoint, SegmentInfo>();
        var4_5 = var1_1.edges();
        block0: while (true) {
            v0 = var4_5.ok();
            block1: while (v0) {
                var5_6 = var2_2.getEdgeInfo(var4_5.edge());
                if (var5_6 != null) {
                    var6_7 = var5_6.calculatePathPoints();
                    var7_8 = var6_7.iterator();
                    var7_8.next();
                    for (var8_9 = 1; var8_9 < var5_6.segmentCount(); ++var8_9) {
                        v0 = var7_8.hasNext();
                        if (var14_3 != 0) continue block1;
                        if (!v0) break;
                        var9_12 = (YPoint)var7_8.next();
                        var10_13 = var5_6.getSegmentInfo(var8_9);
                        if (var3_4.containsKey(var9_12)) {
                            var11_14 = (SegmentInfo)var3_4.get(var9_12);
                            var12_15 = var11_14.getSegmentGroup();
                            if (var12_15 == null) {
                                var13_16 = new YList();
                                var13_16.add(var11_14);
                                var13_16.add(var10_13);
                                var12_15 = new SegmentGroup(var11_14.getLocationRange(), var13_16);
                                var11_14.setSegmentGroup((SegmentGroup)var12_15);
                                var10_13.setSegmentGroup((SegmentGroup)var12_15);
                                if (var14_3 == 0) continue;
                            }
                            var12_15.getSegmentInfos().add(var10_13);
                            var10_13.setSegmentGroup((SegmentGroup)var12_15);
                            if (var14_3 == 0) continue;
                        }
                        var3_4.put((YPoint)var9_12, (SegmentInfo)var10_13);
                        if (var14_3 == 0) continue;
                    }
                }
                var4_5.next();
                if (var14_3 == 0) continue block0;
            }
            break;
        }
        var4_5 = new YList(var3_4.keySet());
        var4_5.sort(new Comparator(){

            public int compare(Object object, Object object2) {
                YPoint yPoint = (YPoint)object;
                YPoint yPoint2 = (YPoint)object2;
                if (yPoint.getX() < yPoint2.getX() - 1.0E-6) {
                    return -1;
                }
                if (yPoint.getX() > yPoint2.getX() + 1.0E-6) {
                    return 1;
                }
                if (yPoint.getY() < yPoint2.getY() - 1.0E-6) {
                    return -1;
                }
                if (yPoint.getY() > yPoint2.getY() + 1.0E-6) {
                    return 1;
                }
                return (int)(yPoint.getX() + yPoint.getY() - (yPoint2.getX() + yPoint2.getY()));
            }
        });
        var5_6 = null;
        var6_7 = null;
        var7_8 = var4_5.iterator();
        block3: do {
            if (var7_8.hasNext() == false) return;
            var8_11 = (YPoint)var7_8.next();
            if (var5_6 == null || !(Math.abs(var5_6.getX() - var8_11.getX()) < 1.0E-6) || !(Math.abs(var5_6.getY() - var8_11.getY()) < 1.0E-6)) ** GOTO lbl82
            if (var6_7 == null) ** GOTO lbl66
            var9_12 = (SegmentInfo)var3_4.get(var8_11);
            if (var9_12.getSegmentGroup() == null) ** GOTO lbl62
            var10_13 = var9_12.getSegmentGroup();
            var11_14 = var10_13.getSegmentInfos().iterator();
            while (var11_14.hasNext()) {
                var12_15 = (SegmentInfo)var11_14.next();
                var12_15.setSegmentGroup((SegmentGroup)var6_7);
                var6_7.getSegmentInfos().add(var12_15);
                if (var14_3 != 0) continue block3;
                if (var14_3 == 0) continue;
lbl62:
                // 2 sources

                var9_12.setSegmentGroup((SegmentGroup)var6_7);
                var6_7.getSegmentInfos().add(var9_12);
                if (var14_3 == 0) break;
lbl66:
                // 2 sources

                var9_12 = (SegmentInfo)var3_4.get(var5_6);
                var10_13 = (SegmentInfo)var3_4.get(var8_11);
                if (var10_13.getSegmentGroup() != null) {
                    var6_7 = var10_13.getSegmentGroup();
                    var6_7.getSegmentInfos().add(var9_12);
                    var9_12.setSegmentGroup((SegmentGroup)var6_7);
                    if (var14_3 == 0) break;
                }
                var6_7 = new SegmentGroup(var9_12.getLocationRange(), new YList());
                var6_7.getSegmentInfos().add(var9_12);
                var6_7.getSegmentInfos().add(var10_13);
                var9_12.setSegmentGroup((SegmentGroup)var6_7);
                var10_13.setSegmentGroup((SegmentGroup)var6_7);
                if (var14_3 == 0) break;
lbl82:
                // 2 sources

                var6_7 = null;
                break;
            }
            var5_6 = var8_11;
        } while (var14_3 == 0);
    }

    private EdgeInfo b(Edge edge, LayoutGraph layoutGraph, GraphPartition graphPartition, PathSearchConfiguration pathSearchConfiguration) {
        block12: {
            EdgeInfo edgeInfo;
            block11: {
                Object object;
                Object object2;
                int n2 = PathSearchExtension.z;
                if (!EdgeRouter.f(edge, layoutGraph)) break block12;
                YList yList = new YList();
                LineSegment[] lineSegmentArray = EdgeRouter.g(edge, layoutGraph);
                if (lineSegmentArray.length == 0) {
                    return null;
                }
                int n3 = 0;
                block0: while (true) {
                    int n4 = n3;
                    block1: while (n4 < lineSegmentArray.length) {
                        PartitionCell partitionCell = null;
                        object2 = lineSegmentArray[n3];
                        object = PolylineLayoutStage.d((LineSegment)object2);
                        while (object2 != null) {
                            Interval interval;
                            double d2;
                            LineSegment[] lineSegmentArray2;
                            block14: {
                                block13: {
                                    partitionCell = this.b((LineSegment)object2, graphPartition, partitionCell);
                                    lineSegmentArray2 = this.b((LineSegment)object2, partitionCell, (Direction)object);
                                    n4 = ((LineSegment)object2).isHorizontal() ? 1 : 0;
                                    if (n2 != 0) continue block1;
                                    if (n4 == 0) break block13;
                                    d2 = ((LineSegment)object2).getFirstEndPoint().getY();
                                    interval = new Interval(lineSegmentArray2[0].getFirstEndPoint().getX(), lineSegmentArray2[0].getSecondEndPoint().getX());
                                    if (n2 == 0) break block14;
                                }
                                d2 = ((LineSegment)object2).getFirstEndPoint().getX();
                                interval = new Interval(lineSegmentArray2[0].getFirstEndPoint().getY(), lineSegmentArray2[0].getSecondEndPoint().getY());
                            }
                            if (interval.getSize() > 0.0) {
                                CellSegmentInfo cellSegmentInfo = new CellSegmentInfo(edge, n3, (Direction)object, new Interval(d2, d2), interval, interval, partitionCell);
                                cellSegmentInfo.setLocation(d2);
                                yList.add(cellSegmentInfo);
                            }
                            object2 = lineSegmentArray2[1];
                            if (n2 == 0) continue;
                        }
                        ++n3;
                        if (n2 == 0) continue block0;
                    }
                    break;
                }
                EdgeInfo edgeInfo2 = new EdgeInfo(edge, yList, pathSearchConfiguration);
                for (int i2 = 0; i2 < edgeInfo2.segmentCount(); ++i2) {
                    edgeInfo = edgeInfo2;
                    if (n2 == 0) {
                        object2 = edgeInfo.getSegmentInfo(i2);
                        object = ((SegmentInfo)object2).getCellSegmentInfo(0);
                        ((AbstractSegmentInfo)object2).setLocation(((AbstractSegmentInfo)object).getLocation());
                        if (n2 == 0) continue;
                    }
                    break block11;
                }
                edgeInfo = edgeInfo2;
            }
            return edgeInfo;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PartitionCell b(LineSegment lineSegment, GraphPartition graphPartition, PartitionCell partitionCell) {
        List list2;
        block11: {
            double d2;
            double d3;
            int n2;
            block10: {
                YRectangle yRectangle;
                block9: {
                    block8: {
                        n2 = PathSearchExtension.z;
                        double d4 = this.c(lineSegment);
                        if (!(d4 > 3.0E-6)) break block8;
                        d3 = lineSegment.getFirstEndPoint().getX() + (lineSegment.getSecondEndPoint().getX() - lineSegment.getFirstEndPoint().getX()) / d4 * 1.0E-6 * 2.0;
                        d2 = lineSegment.getFirstEndPoint().getY() + (lineSegment.getSecondEndPoint().getY() - lineSegment.getFirstEndPoint().getY()) / d4 * 1.0E-6 * 2.0;
                        if (n2 == 0) break block9;
                    }
                    d3 = lineSegment.getSecondEndPoint().getX();
                    d2 = lineSegment.getSecondEndPoint().getY();
                }
                if (partitionCell != null && YRectangle.contains((yRectangle = partitionCell.getBounds()).getX() - 1.0E-6, yRectangle.getY() - 1.0E-6, yRectangle.getWidth() + 2.0E-6, yRectangle.getHeight() + 2.0E-6, d3, d2, true)) {
                    return partitionCell;
                }
                yRectangle = new YRectangle(d3 - 1.0E-6, d2 - 1.0E-6, 2.0E-6, 2.0E-6);
                if (partitionCell != null) break block10;
                list2 = graphPartition.getCells(yRectangle);
                if (n2 == 0) break block11;
            }
            list2 = new YList();
            List list3 = graphPartition.getNeighbors(partitionCell);
            Iterator iterator2 = list3.iterator();
            while (iterator2.hasNext()) {
                PartitionCell partitionCell2 = (PartitionCell)iterator2.next();
                YRectangle yRectangle = partitionCell2.getBounds();
                if (!YRectangle.contains(yRectangle.getX() - 1.0E-6, yRectangle.getY() - 1.0E-6, yRectangle.getWidth() + 2.0E-6, yRectangle.getHeight() + 2.0E-6, d3, d2, true)) continue;
                list2.add(partitionCell2);
                if (n2 != 0) return (PartitionCell)list2.get(0);
                if (n2 == 0) continue;
            }
        }
        if (!list2.isEmpty()) return (PartitionCell)list2.get(0);
        return null;
    }

    private double c(LineSegment lineSegment) {
        if (lineSegment.isHorizontal()) {
            return Math.abs(lineSegment.getFirstEndPoint().getX() - lineSegment.getSecondEndPoint().getX());
        }
        if (lineSegment.isVertical()) {
            return Math.abs(lineSegment.getFirstEndPoint().getY() - lineSegment.getSecondEndPoint().getY());
        }
        return lineSegment.length();
    }

    private static Direction d(LineSegment lineSegment) {
        YPoint yPoint = lineSegment.getFirstEndPoint();
        YPoint yPoint2 = lineSegment.getSecondEndPoint();
        if (yPoint.getX() < yPoint2.getX() && Math.abs(yPoint.getY() - yPoint2.getY()) < 1.0E-6) {
            return Direction.RIGHT;
        }
        if (yPoint.getY() < yPoint2.getY() && Math.abs(yPoint.getX() - yPoint2.getX()) < 1.0E-6) {
            return Direction.DOWN;
        }
        if (yPoint2.getX() < yPoint.getX() && Math.abs(yPoint.getY() - yPoint2.getY()) < 1.0E-6) {
            return Direction.LEFT;
        }
        if (yPoint2.getY() < yPoint.getY() && Math.abs(yPoint.getX() - yPoint2.getX()) < 1.0E-6) {
            return Direction.UP;
        }
        throw new IllegalArgumentException("Segment isn't orthogonal");
    }

    private LineSegment[] b(LineSegment lineSegment, PartitionCell partitionCell, Direction direction) {
        double d2;
        double d3;
        double d4;
        YPoint yPoint;
        YPoint yPoint2;
        YRectangle yRectangle;
        block6: {
            block5: {
                yRectangle = partitionCell.getBounds();
                yPoint2 = lineSegment.getFirstEndPoint();
                yPoint = lineSegment.getSecondEndPoint();
                double d5 = this.c(lineSegment);
                if (!(d5 > 3.0E-6)) break block5;
                d4 = yPoint2.getX() + (yPoint.getX() - yPoint2.getX()) / d5 * 1.0E-6 * 2.0;
                d3 = yPoint2.getY() + (yPoint.getY() - yPoint2.getY()) / d5 * 1.0E-6 * 2.0;
                if (PathSearchExtension.z == 0) break block6;
            }
            d4 = yPoint.getX();
            d3 = yPoint.getY();
        }
        double d6 = yRectangle.getX();
        double d7 = yRectangle.getWidth();
        double d8 = yRectangle.getY();
        if (!YRectangle.contains(d6 - 1.0E-6, d8 - 1.0E-6, d7 + 2.0E-6, (d2 = yRectangle.getHeight()) + 2.0E-6, d4, d3, true)) {
            throw new IllegalArgumentException("LineSegment doesn't start in passed cell");
        }
        if (direction.isHorizontal() && PolylineLayoutStage.b(d6, d6 + d7, yPoint.getX()) || !direction.isHorizontal() && PolylineLayoutStage.b(d8, d8 + d2, yPoint.getY())) {
            return new LineSegment[]{lineSegment, null};
        }
        YPoint yPoint3 = null;
        yPoint3 = Direction.RIGHT.equals(direction) ? new YPoint(partitionCell.getMaxX(), yPoint2.getY()) : (Direction.LEFT.equals(direction) ? new YPoint(partitionCell.getMinX(), yPoint2.getY()) : (Direction.DOWN.equals(direction) ? new YPoint(yPoint2.getX(), partitionCell.getMaxY()) : new YPoint(yPoint2.getX(), partitionCell.getMinY())));
        return new LineSegment[]{new LineSegment(yPoint2, yPoint3), new LineSegment(yPoint3, yPoint)};
    }

    private static boolean b(double d2, double d3, double d4) {
        return d4 + 1.0E-6 >= d2 && d4 - 1.0E-6 <= d3;
    }

    private static class _b
    extends GraphPartition {
        private _b(ObstaclePartition obstaclePartition) {
            super(obstaclePartition);
        }

        YRectangle b(LayoutGraph layoutGraph, List list2) {
            YRectangle yRectangle;
            block2: {
                int n2 = PathSearchExtension.z;
                Rectangle rectangle = layoutGraph.getBoundingBox();
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    Obstacle obstacle = (Obstacle)iterator2.next();
                    yRectangle = obstacle.getBounds();
                    if (n2 == 0) {
                        YRectangle yRectangle2 = yRectangle;
                        Rectangle2D.Double double_ = new Rectangle2D.Double(yRectangle2.getX(), yRectangle2.getY(), yRectangle2.getWidth(), yRectangle2.getHeight());
                        Rectangle2D.union(rectangle, double_, rectangle);
                        if (n2 == 0) continue;
                    }
                    break block2;
                }
                yRectangle = new YRectangle(((RectangularShape)rectangle).getX() - 100.0, ((RectangularShape)rectangle).getY() - 100.0, ((RectangularShape)rectangle).getWidth() + 200.0, ((RectangularShape)rectangle).getHeight() + 200.0);
            }
            return yRectangle;
        }
    }
}

