/*
 * Decompiled with CFR 0.152.
 */
package y.layout.transformer;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import y.base.Edge;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.YCursor;
import y.base.YList;
import y.geom.Geom;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YPointCursor;
import y.geom.YPointPath;
import y.layout.AbstractLayoutStage;
import y.layout.CanonicMultiStageLayouter;
import y.layout.LayoutGraph;
import y.layout.LayoutStage;
import y.layout.LayoutTool;
import y.layout.Layouter;
import y.layout.NodeLayout;
import y.layout.grouping.Grouping;
import y.layout.grouping.RecursiveGroupLayouter;

public class GraphTransformer
extends CanonicMultiStageLayouter
implements LayoutStage {
    public static final int MIRROR_XAXIS = 0;
    public static final int MIRROR_YAXIS = 1;
    public static final int ROTATE = 2;
    public static final int SCALE = 3;
    public static final int TRANSLATE = 4;
    private int pjb;
    private double rjb;
    private boolean qjb;
    private double ujb;
    private double tjb;
    private double mjb;
    private double ljb;
    private boolean njb;
    private double sjb;
    private double kjb;
    private Layouter ojb;
    public static int z;

    public GraphTransformer() {
        int n2 = z;
        this.pjb = 3;
        this.rjb = 0.0;
        this.qjb = false;
        this.ujb = 1.0;
        this.tjb = 1.0;
        this.mjb = 0.0;
        this.ljb = 0.0;
        this.njb = false;
        this.sjb = 1.41;
        this.kjb = 1.0;
        this.setComponentLayouterEnabled(false);
        this.setSelfLoopLayouterEnabled(false);
        this.setParallelEdgeLayouterEnabled(false);
        this.setGroupNodeHidingEnabled(false);
        this.prependStage(new _b());
        if (n2 != 0) {
            Graph.z = !Graph.z;
        }
    }

    public void setCoreLayouter(Layouter layouter) {
        this.ojb = layouter;
    }

    public Layouter getCoreLayouter() {
        return this.ojb;
    }

    public void setOperation(int n2) {
        this.pjb = n2;
        if (n2 != 2) {
            this.njb = false;
        }
    }

    public int getOperation() {
        return this.pjb;
    }

    public void setRotationAngle(double d2) {
        this.rjb = d2;
    }

    public double getRotationAngle() {
        return this.rjb;
    }

    public void setBestFitRotationEnabled(boolean bl) {
        this.njb = bl;
    }

    public boolean isBestFitRotationEnabled() {
        return this.njb;
    }

    public void setPreferedLayoutSize(double d2, double d3) {
        this.sjb = d2;
        this.kjb = d3;
    }

    public void setScaleNodeSize(boolean bl) {
        this.qjb = bl;
    }

    public boolean getScaleNodeSize() {
        return this.qjb;
    }

    public void setScaleFactor(double d2) {
        this.ujb = this.tjb = d2;
    }

    public void setScaleFactors(double d2, double d3) {
        this.ujb = d2;
        this.tjb = d3;
    }

    public double getScaleFactorY() {
        return this.tjb;
    }

    public double getScaleFactorX() {
        return this.ujb;
    }

    public double getTranslateX() {
        return this.mjb;
    }

    public void setTranslateX(double d2) {
        this.mjb = d2;
    }

    public double getTranslateY() {
        return this.ljb;
    }

    public void setTranslateY(double d2) {
        this.ljb = d2;
    }

    public boolean canLayoutCore(LayoutGraph layoutGraph) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public void doLayoutCore(LayoutGraph layoutGraph) {
        int n2 = z;
        if (this.getCoreLayouter() != null) {
            this.getCoreLayouter().doLayout(layoutGraph);
        }
        Rectangle rectangle = layoutGraph.getBoundingBox();
        if (rectangle.width <= 0) return;
        if (rectangle.height <= 0) {
            return;
        }
        switch (this.pjb) {
            case 0: {
                Object object7;
                Object object2;
                YPoint yPoint;
                Object object3;
                Object object4;
                ArrayList<YPoint> arrayList = layoutGraph.nodes();
                while (arrayList.ok()) {
                    object4 = arrayList.node();
                    object3 = layoutGraph.getCenter((Node)object4);
                    layoutGraph.setCenter((Node)object4, GraphTransformer.b((YPoint)object3, rectangle));
                    arrayList.next();
                    if (n2 != 0) return;
                    if (n2 == 0) continue;
                }
                arrayList = layoutGraph.edges();
                block8: do {
                    if (!arrayList.ok()) return;
                    object4 = arrayList.edge();
                    object3 = layoutGraph.getSourcePointRel((Edge)object4);
                    layoutGraph.setSourcePointRel((Edge)object4, new YPoint(((YPoint)object3).getX(), -((YPoint)object3).getY()));
                    yPoint = layoutGraph.getTargetPointRel((Edge)object4);
                    layoutGraph.setTargetPointRel((Edge)object4, new YPoint(yPoint.getX(), -yPoint.getY()));
                    object2 = new ArrayList();
                    object7 = layoutGraph.getPoints((Edge)object4).points();
                    while (object7.ok()) {
                        ((ArrayList)object2).add(GraphTransformer.b(object7.point(), rectangle));
                        object7.next();
                        if (n2 != 0) continue block8;
                        if (n2 == 0) continue;
                    }
                    layoutGraph.setPoints((Edge)object4, new YPointPath((List)object2));
                    arrayList.next();
                } while (n2 == 0);
            }
            case 1: {
                Object object7;
                Object object2;
                YPoint yPoint;
                Object object3;
                Object object4;
                ArrayList<YPoint> arrayList = layoutGraph.nodes();
                while (arrayList.ok()) {
                    object4 = arrayList.node();
                    object3 = layoutGraph.getCenter((Node)object4);
                    layoutGraph.setCenter((Node)object4, GraphTransformer.c((YPoint)object3, rectangle));
                    arrayList.next();
                    if (n2 != 0) return;
                    if (n2 == 0) continue;
                }
                arrayList = new ArrayList<YPoint>();
                object4 = layoutGraph.edges();
                block11: do {
                    if (!object4.ok()) return;
                    object3 = object4.edge();
                    yPoint = layoutGraph.getSourcePointRel((Edge)object3);
                    layoutGraph.setSourcePointRel((Edge)object3, new YPoint(-yPoint.getX(), yPoint.getY()));
                    object2 = layoutGraph.getTargetPointRel((Edge)object3);
                    layoutGraph.setTargetPointRel((Edge)object3, new YPoint(-((YPoint)object2).getX(), ((YPoint)object2).getY()));
                    arrayList.clear();
                    object7 = layoutGraph.getPoints((Edge)object3).points();
                    while (object7.ok()) {
                        arrayList.add(GraphTransformer.c(object7.point(), rectangle));
                        object7.next();
                        if (n2 != 0) continue block11;
                        if (n2 == 0) continue;
                    }
                    layoutGraph.setPoints((Edge)object3, new YPointPath(arrayList));
                    object4.next();
                } while (n2 == 0);
            }
            case 2: {
                if (this.njb) {
                    GraphTransformer.applyBestFitRotationAngle(layoutGraph, this.sjb, this.kjb);
                    if (n2 == 0) return;
                }
                GraphTransformer.b(layoutGraph, this.rjb, rectangle);
                if (n2 == 0) return;
            }
            case 3: {
                YPoint yPoint;
                Object object;
                Object object5;
                Object object6;
                ArrayList<YPoint> arrayList = new AffineTransform();
                double d2 = rectangle.x + rectangle.width / 2;
                double d3 = rectangle.y + rectangle.height / 2;
                Object object7 = new Point2D.Double();
                ((AffineTransform)((Object)arrayList)).translate(d2, d3);
                ((AffineTransform)((Object)arrayList)).scale(this.ujb, this.tjb);
                ((AffineTransform)((Object)arrayList)).translate(-d2, -d3);
                Object object8 = layoutGraph.nodes();
                while (object8.ok()) {
                    Node node = object8.node();
                    block14: while (true) {
                        object6 = node;
                        ((Point2D)object7).setLocation(layoutGraph.getCenterX((Node)object6), layoutGraph.getCenterY((Node)object6));
                        ((AffineTransform)((Object)arrayList)).transform((Point2D)object7, (Point2D)object7);
                        if (n2 != 0) return;
                        if (!this.qjb) break;
                        layoutGraph.setSize((Node)object6, layoutGraph.getWidth((Node)object6) * this.ujb, layoutGraph.getHeight((Node)object6) * this.tjb);
                        object5 = ((Node)object6).edges();
                        while (object5.ok()) {
                            object = object5.edge();
                            node = ((Edge)object).source();
                            if (n2 != 0) continue block14;
                            if (node == object6) {
                                yPoint = layoutGraph.getSourcePointRel((Edge)object);
                                layoutGraph.setSourcePointRel((Edge)object, new YPoint(yPoint.x * this.ujb, yPoint.y * this.tjb));
                            }
                            if (((Edge)object).target() == object6) {
                                yPoint = layoutGraph.getTargetPointRel((Edge)object);
                                layoutGraph.setTargetPointRel((Edge)object, new YPoint(yPoint.x * this.ujb, yPoint.y * this.tjb));
                            }
                            object5.next();
                            if (n2 == 0) continue;
                        }
                        break;
                    }
                    layoutGraph.setCenter((Node)object6, ((Point2D)object7).getX(), ((Point2D)object7).getY());
                    object8.next();
                    if (n2 == 0) continue;
                }
                object8 = new ArrayList();
                object6 = layoutGraph.edges();
                block16: do {
                    if (!object6.ok()) return;
                    object5 = object6.edge();
                    ((ArrayList)object8).clear();
                    object = layoutGraph.getPoints((Edge)object5).points();
                    while (object.ok()) {
                        yPoint = object.point();
                        ((Point2D)object7).setLocation(yPoint.getX(), yPoint.getY());
                        ((AffineTransform)((Object)arrayList)).transform((Point2D)object7, (Point2D)object7);
                        ((ArrayList)object8).add(new YPoint(((Point2D)object7).getX(), ((Point2D)object7).getY()));
                        object.next();
                        if (n2 != 0) continue block16;
                        if (n2 == 0) continue;
                    }
                    layoutGraph.setPoints((Edge)object5, new YPointPath((List)object8));
                    object6.next();
                } while (n2 == 0);
            }
            case 4: {
                LayoutTool.moveSubgraph(layoutGraph, layoutGraph.nodes(), this.getTranslateX(), this.getTranslateY());
                return;
            }
        }
    }

    private static void b(LayoutGraph layoutGraph, double d2, Rectangle rectangle) {
        Object object;
        int n2 = z;
        AffineTransform affineTransform = new AffineTransform();
        double d3 = rectangle.x + rectangle.width / 2;
        double d4 = rectangle.y + rectangle.height / 2;
        Point2D.Double double_ = new Point2D.Double();
        affineTransform.translate(d3, d4);
        affineTransform.rotate(Geom.toRadians(d2));
        affineTransform.translate(-d3, -d4);
        Object object2 = layoutGraph.nodes();
        while (object2.ok()) {
            object = object2.node();
            ((Point2D)double_).setLocation(layoutGraph.getCenterX((Node)object), layoutGraph.getCenterY((Node)object));
            affineTransform.transform(double_, double_);
            layoutGraph.setCenter((Node)object, ((Point2D)double_).getX(), ((Point2D)double_).getY());
            object2.next();
            if (n2 == 0) continue;
        }
        object2 = new ArrayList();
        object = layoutGraph.edges();
        while (object.ok()) {
            block4: {
                Edge edge = object.edge();
                ((ArrayList)object2).clear();
                YPointCursor yPointCursor = layoutGraph.getPoints(edge).points();
                while (yPointCursor.ok()) {
                    YPoint yPoint = yPointCursor.point();
                    ((Point2D)double_).setLocation(yPoint.getX(), yPoint.getY());
                    affineTransform.transform(double_, double_);
                    ((ArrayList)object2).add(new YPoint(((Point2D)double_).getX(), ((Point2D)double_).getY()));
                    yPointCursor.next();
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break block4;
                }
                layoutGraph.setPoints(edge, new YPointPath((List)object2));
                object.next();
            }
            if (n2 == 0) continue;
        }
    }

    public static double applyBestFitRotationAngle(LayoutGraph layoutGraph, double d2, double d3) {
        double d4 = GraphTransformer.findBestFitRotationAngle(layoutGraph, d2, d3);
        GraphTransformer.b(layoutGraph, d4, layoutGraph.getBoundingBox());
        return d4;
    }

    public static double findBestFitRotationAngle(LayoutGraph layoutGraph, double d2, double d3) {
        int n2 = z;
        if (layoutGraph.nodeCount() > 1) {
            double d4;
            block3: {
                YList yList = GraphTransformer.xb(layoutGraph);
                double d5 = Double.MAX_VALUE;
                double d6 = 0.0;
                for (double d7 = 0.0; d7 < 360.0; d7 += 10.0) {
                    double d8;
                    YDimension yDimension = GraphTransformer.c(yList, d7);
                    d4 = d8 = Math.abs(yDimension.getWidth() * d3 - d2 * yDimension.getHeight());
                    if (n2 == 0) {
                        if (!(d4 < d5)) continue;
                        d5 = d8;
                        d6 = d7;
                        if (n2 == 0) continue;
                    }
                    break block3;
                }
                d4 = d6;
            }
            return d4;
        }
        return 0.0;
    }

    public static double[] scaleToRect(LayoutGraph layoutGraph, Rectangle rectangle) {
        LayoutGraph layoutGraph2;
        Object object;
        double[] dArray;
        block11: {
            Object object2;
            int n2 = z;
            dArray = new double[2];
            if (layoutGraph.nodeCount() == 0) {
                return dArray;
            }
            Node node = null;
            Node node2 = null;
            Node node3 = null;
            Node node4 = null;
            double d2 = Double.MAX_VALUE;
            double d3 = Double.MAX_VALUE;
            double d4 = -1.7976931348623157E308;
            double d5 = -1.7976931348623157E308;
            object = layoutGraph.nodes();
            while (object.ok()) {
                Node node5 = object.node();
                NodeLayout nodeLayout = layoutGraph.getLayout(node5);
                if (nodeLayout.getX() < d2) {
                    d2 = nodeLayout.getX();
                    node = node5;
                }
                if (nodeLayout.getX() + nodeLayout.getWidth() > d4) {
                    d4 = nodeLayout.getX() + nodeLayout.getWidth();
                    node2 = node5;
                }
                if (nodeLayout.getY() < d3) {
                    d3 = nodeLayout.getY();
                    node3 = node5;
                }
                if (nodeLayout.getY() + nodeLayout.getHeight() > d5) {
                    d5 = nodeLayout.getY() + nodeLayout.getHeight();
                    node4 = node5;
                }
                object.next();
                if (n2 == 0) continue;
            }
            object = new Rectangle((int)layoutGraph.getCenterX(node), (int)layoutGraph.getCenterY(node3), (int)(layoutGraph.getCenterX(node2) - layoutGraph.getCenterX(node)), (int)(layoutGraph.getCenterY(node4) - layoutGraph.getCenterY(node3)));
            double d6 = layoutGraph.getWidth(node) / 2.0;
            double d7 = layoutGraph.getWidth(node2) / 2.0;
            double d8 = layoutGraph.getHeight(node3) / 2.0;
            double d9 = layoutGraph.getHeight(node4) / 2.0;
            Rectangle rectangle2 = new Rectangle((int)((double)rectangle.x + d6), (int)((double)rectangle.y + d7), (int)((double)rectangle.width - d6 - d7), (int)((double)rectangle.height - d8 - d9));
            if (((Rectangle)object).width <= 1 || ((Rectangle)object).height <= 1) {
                dArray[0] = 1.0;
                dArray[1] = 1.0;
                return dArray;
            }
            double d10 = (double)rectangle2.width / (double)((Rectangle)object).width;
            double d11 = (double)rectangle2.height / (double)((Rectangle)object).height;
            dArray[0] = d10;
            dArray[1] = d11;
            Object object3 = layoutGraph.nodes();
            while (object3.ok()) {
                object2 = object3.node();
                layoutGraph.setCenter((Node)object2, layoutGraph.getCenterX((Node)object2) * d10, layoutGraph.getCenterY((Node)object2) * d11);
                object3.next();
                if (n2 == 0) continue;
            }
            object3 = new ArrayList();
            object2 = layoutGraph.edges();
            while (object2.ok()) {
                block12: {
                    Edge edge = object2.edge();
                    ((ArrayList)object3).clear();
                    layoutGraph2 = layoutGraph;
                    if (n2 != 0) break block11;
                    YPointCursor yPointCursor = layoutGraph2.getPoints(edge).points();
                    while (yPointCursor.ok()) {
                        YPoint yPoint = yPointCursor.point();
                        ((ArrayList)object3).add(new YPoint(yPoint.x * d10, yPoint.y * d11));
                        yPointCursor.next();
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                        }
                        break block12;
                    }
                    layoutGraph.setPoints(edge, new YPointPath((List)object3));
                    object2.next();
                }
                if (n2 == 0) continue;
            }
            layoutGraph2 = layoutGraph;
        }
        object = layoutGraph2.getBoundingBox();
        double d12 = rectangle.x - ((Rectangle)object).x;
        double d13 = rectangle.y - ((Rectangle)object).y;
        GraphTransformer.translate(layoutGraph, d12, d13);
        return dArray;
    }

    public static void setMaximalBounds(LayoutGraph layoutGraph, double d2, double d3, double d4, double d5) {
        Object object;
        Rectangle2D.Double double_;
        block13: {
            double d6;
            double d7;
            block12: {
                double d8;
                double d9;
                double d10;
                double d11;
                int n2;
                block11: {
                    n2 = z;
                    double_ = new Rectangle2D.Double(d2, d3, d4, d5);
                    if (layoutGraph.N() == 0) {
                        return;
                    }
                    double d12 = Double.MAX_VALUE;
                    d11 = Double.MAX_VALUE;
                    double d13 = -1.7976931348623157E308;
                    d10 = -1.7976931348623157E308;
                    NodeCursor nodeCursor = layoutGraph.nodes();
                    while (nodeCursor.ok()) {
                        Node node = nodeCursor.node();
                        d9 = layoutGraph.getWidth(node);
                        d8 = d4;
                        if (n2 == 0) {
                            if (d9 > d8 || layoutGraph.getHeight(node) > d5) {
                                return;
                            }
                            d12 = Math.min(d12, layoutGraph.getCenterX(node));
                            d11 = Math.min(d11, layoutGraph.getCenterY(node));
                            d13 = Math.max(d13, layoutGraph.getCenterX(node));
                            d10 = Math.max(d10, layoutGraph.getCenterY(node));
                            nodeCursor.next();
                            if (n2 == 0) continue;
                        }
                        break block11;
                    }
                    d9 = d12;
                    d8 = (d13 - d12) / 2.0;
                }
                double d14 = d9 + d8;
                double d15 = d11 + (d10 - d11) / 2.0;
                d4 /= 2.0;
                d5 /= 2.0;
                d7 = 1.0;
                d6 = 1.0;
                object = layoutGraph.nodes();
                while (object.ok()) {
                    Node node = object.node();
                    double d16 = Math.abs(d14 - layoutGraph.getCenterX(node));
                    double d17 = Math.abs(d15 - layoutGraph.getCenterY(node));
                    double d18 = d4 - layoutGraph.getWidth(node) / 2.0;
                    double d19 = d5 - layoutGraph.getHeight(node) / 2.0;
                    d7 = Math.min(d7, d18 / d16);
                    d6 = Math.min(d6, d19 / d17);
                    object.next();
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break block12;
                }
                if (!(d7 < 1.0) && !(d6 < 1.0)) break block13;
            }
            object = new GraphTransformer();
            ((GraphTransformer)object).setOperation(3);
            ((GraphTransformer)object).setScaleFactors(d7, d6);
            ((GraphTransformer)object).setScaleNodeSize(false);
            ((GraphTransformer)object).doLayoutCore(layoutGraph);
        }
        if (!double_.contains((Rectangle2D)(object = LayoutTool.getBoundingBox(layoutGraph, layoutGraph.nodes(), layoutGraph.edges())))) {
            LayoutTool.moveSubgraph(layoutGraph, layoutGraph.nodes(), double_.getCenterX() - ((RectangularShape)object).getCenterX(), double_.getCenterY() - ((RectangularShape)object).getCenterY());
        }
    }

    public static void translate(LayoutGraph layoutGraph, double d2, double d3) {
        Object object;
        int n2 = z;
        Object object2 = layoutGraph.nodes();
        while (object2.ok()) {
            object = object2.node();
            layoutGraph.setCenter((Node)object, layoutGraph.getCenterX((Node)object) + d2, layoutGraph.getCenterY((Node)object) + d3);
            object2.next();
            if (n2 == 0) continue;
        }
        object2 = new ArrayList();
        object = layoutGraph.edges();
        while (object.ok()) {
            block4: {
                Edge edge = object.edge();
                ((ArrayList)object2).clear();
                YPointCursor yPointCursor = layoutGraph.getPoints(edge).points();
                while (yPointCursor.ok()) {
                    YPoint yPoint = yPointCursor.point();
                    ((ArrayList)object2).add(new YPoint(yPoint.x + d2, yPoint.y + d3));
                    yPointCursor.next();
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break block4;
                }
                layoutGraph.setPoints(edge, new YPointPath((List)object2));
                object.next();
            }
            if (n2 == 0) continue;
        }
    }

    private static YPoint b(YPoint yPoint, Rectangle rectangle) {
        return new YPoint(yPoint.x, (double)(2 * rectangle.y + rectangle.height) - yPoint.y);
    }

    private static YPoint c(YPoint yPoint, Rectangle rectangle) {
        return new YPoint((double)(2 * rectangle.x + rectangle.width) - yPoint.x, yPoint.y);
    }

    private static YList xb(LayoutGraph layoutGraph) {
        Object object;
        LayoutGraph layoutGraph2;
        YCursor yCursor;
        YList yList;
        int n2;
        block5: {
            n2 = z;
            yList = new YList();
            yCursor = layoutGraph.nodes();
            while (yCursor.ok()) {
                layoutGraph2 = layoutGraph;
                if (n2 == 0) {
                    object = layoutGraph2.getLayout(yCursor.node());
                    yList.add(new YPoint(object.getX() + object.getWidth() / 2.0, object.getY() + object.getHeight() / 2.0));
                    yCursor.next();
                    if (n2 == 0) continue;
                }
                break block5;
            }
            layoutGraph2 = layoutGraph;
        }
        yCursor = layoutGraph2.edges();
        while (yCursor.ok()) {
            block6: {
                object = layoutGraph.getLayout(yCursor.edge());
                for (int i2 = 0; i2 < object.pointCount(); ++i2) {
                    yList.add(object.getPoint(i2));
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break block6;
                }
                yCursor.next();
            }
            if (n2 == 0) continue;
        }
        return Geom.calcConvexHull(yList);
    }

    private static YDimension c(YList yList, double d2) {
        int n2 = z;
        d2 = Geom.toRadians(d2);
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        double d5 = Double.MAX_VALUE;
        double d6 = -1.7976931348623157E308;
        double d7 = Math.cos(d2);
        double d8 = Math.sin(d2);
        YCursor yCursor = yList.cursor();
        while (yCursor.ok()) {
            YPoint yPoint = (YPoint)yCursor.current();
            double d9 = yPoint.getX() * d7 - yPoint.getY() * d8;
            double d10 = yPoint.getX() * d8 + yPoint.getY() * d7;
            if (d9 < d3) {
                d3 = d9;
            }
            if (d10 < d5) {
                d5 = d10;
            }
            if (d9 > d4) {
                d4 = d9;
            }
            if (d10 > d6) {
                d6 = d10;
            }
            yCursor.next();
            if (n2 == 0) continue;
        }
        return new YDimension(d4 - d3, d6 - d5);
    }

    private static final class _b
    extends AbstractLayoutStage {
        private _b() {
        }

        public boolean canLayout(LayoutGraph layoutGraph) {
            return super.canLayoutCore(layoutGraph);
        }

        public void doLayout(LayoutGraph layoutGraph) {
            super.doLayoutCore(layoutGraph);
            if (!Grouping.isFlat(layoutGraph)) {
                new RecursiveGroupLayouter().doLayout(layoutGraph);
            }
        }
    }
}

