/*
 * Decompiled with CFR 0.152.
 */
package y.layout.tree;

import java.util.Comparator;
import y.algo.Trees;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.ListCell;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeMap;
import y.base.WrongGraphStructure;
import y.base.YCursor;
import y.base.YList;
import y.geom.Geom;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YRectangle;
import y.layout.CanonicMultiStageLayouter;
import y.layout.LayoutGraph;
import y.layout.LayoutStage;
import y.layout.LayoutTool;
import y.layout.NodeLabelLayout;
import y.layout.grouping.GroupNodeHider;
import y.layout.tree.AbstractRotatableNodePlacer;
import y.util.Comparators;
import y.util.D;

public class BalloonLayouter
extends CanonicMultiStageLayouter {
    private static final double kgb = 1.0E-5;
    public static final byte CHILD_ORDERING_POLICY_COMPACT = 0;
    public static final byte CHILD_ORDERING_POLICY_SYMMETRIC = 1;
    public static final byte DIRECTED_ROOT = 0;
    public static final byte CENTER_ROOT = 1;
    public static final byte WEIGHTED_CENTER_ROOT = 2;
    private static double hgb = 1000.0;
    private double ngb = 340.0;
    private double jgb = 360.0;
    private double lgb = 40.0;
    private boolean agb = false;
    private double zfb = 0.5;
    private byte dgb = 0;
    private boolean fgb = false;
    private int yfb = 0;
    private NodeMap egb;
    private byte bgb = 0;
    private boolean ggb;
    private NodeInfo[] mgb;
    protected LayoutGraph graph;
    private Comparator cgb;
    private NodeMap igb;

    public BalloonLayouter() {
        LayoutStage layoutStage = this.getGroupNodeHider();
        if (layoutStage instanceof GroupNodeHider) {
            ((GroupNodeHider)layoutStage).setHidingEmptyGroupNodes(false);
        }
    }

    public Comparator getComparator() {
        return this.cgb;
    }

    public void setComparator(Comparator comparator2) {
        this.cgb = comparator2;
    }

    public byte getChildOrderingPolicy() {
        return this.bgb;
    }

    public void setChildOrderingPolicy(byte by) {
        this.bgb = by;
    }

    public int getMinimalNodeDistance() {
        return this.yfb;
    }

    public void setMinimalNodeDistance(int n2) {
        this.yfb = n2;
    }

    public boolean isFromSketchModeEnabled() {
        return this.fgb;
    }

    public void setFromSketchModeEnabled(boolean bl) {
        this.fgb = bl;
    }

    public void setRootNodePolicy(byte by) {
        this.dgb = by;
    }

    public byte getRootNodePolicy() {
        return this.dgb;
    }

    public void setPreferredChildWedge(int n2) {
        block5: {
            block4: {
                if (n2 >= 1) break block4;
                n2 = 1;
                if (!AbstractRotatableNodePlacer.z) break block5;
            }
            if (n2 > 359) {
                n2 = 359;
            }
        }
        this.ngb = n2;
    }

    public void setPreferredRootWedge(int n2) {
        block5: {
            block4: {
                if (n2 >= 1) break block4;
                n2 = 1;
                if (!AbstractRotatableNodePlacer.z) break block5;
            }
            if (n2 > 359) {
                n2 = 359;
            }
        }
        this.jgb = n2;
    }

    public int getPreferredRootWedge() {
        return (int)this.jgb;
    }

    public int getPreferredChildWedge() {
        return (int)this.ngb;
    }

    public void setAllowOverlaps(boolean bl) {
        this.agb = bl;
    }

    public boolean getAllowOverlaps() {
        return this.agb;
    }

    public void setCompactnessFactor(double d2) {
        if (d2 <= 0.0) {
            d2 = 0.05;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        this.zfb = d2;
    }

    public double getCompactnessFactor() {
        return this.zfb;
    }

    public void setMinimalEdgeLength(int n2) {
        this.lgb = n2;
    }

    public int getMinimalEdgeLength() {
        return (int)this.lgb;
    }

    public boolean isConsiderNodeLabelsEnabled() {
        return this.ggb;
    }

    public void setConsiderNodeLabelsEnabled(boolean bl) {
        this.ggb = bl;
    }

    public void doLayoutCore(LayoutGraph layoutGraph) {
        block11: {
            Object object;
            EdgeList edgeList;
            boolean bl;
            block10: {
                bl = AbstractRotatableNodePlacer.z;
                if (!Trees.isTree(layoutGraph)) {
                    throw new WrongGraphStructure("Graph is not a tree");
                }
                this.graph = layoutGraph;
                this.egb = layoutGraph.createNodeMap();
                if (this.isConsiderNodeLabelsEnabled()) {
                    this.qb(layoutGraph);
                }
                Node node = this.determineRoot();
                edgeList = Trees.directTree(layoutGraph, node);
                this.f(node, this.egb);
                LayoutTool.resetPaths(layoutGraph);
                this.mgb = new NodeInfo[layoutGraph.nodeCount()];
                object = layoutGraph.nodes();
                while (object.ok()) {
                    block13: {
                        Node node2;
                        block12: {
                            node2 = object.node();
                            if (bl) break block10;
                            if (node2 == node) break block12;
                            this.b(node2, new NodeInfo(this.lgb + this.db(node2.predecessors().node())));
                            if (!bl) break block13;
                        }
                        this.b(node2, new NodeInfo(Math.max(this.lgb, (double)this.yfb)));
                    }
                    object.next();
                    if (!bl) continue;
                }
                this.bb(node);
                layoutGraph.setCenter(node, 0.0, 0.0);
                this.y(node);
            }
            if (this.isConsiderNodeLabelsEnabled()) {
                this.rb(layoutGraph);
            }
            while (!edgeList.isEmpty()) {
                object = edgeList.popEdge();
                layoutGraph.reverseEdge((Edge)object);
                if (!bl) {
                    if (!bl) continue;
                }
                break block11;
            }
            layoutGraph.disposeNodeMap(this.egb);
        }
    }

    private void qb(LayoutGraph layoutGraph) {
        boolean bl = AbstractRotatableNodePlacer.z;
        this.igb = layoutGraph.createNodeMap();
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            YRectangle yRectangle;
            Node node;
            block3: {
                node = nodeCursor.node();
                yRectangle = layoutGraph.getRectangle(node);
                NodeLabelLayout[] nodeLabelLayoutArray = layoutGraph.getNodeLabelLayout(node);
                for (int i2 = 0; i2 < nodeLabelLayoutArray.length; ++i2) {
                    NodeLabelLayout nodeLabelLayout = nodeLabelLayoutArray[i2];
                    yRectangle = BalloonLayouter.d(yRectangle, nodeLabelLayout.getBox());
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block3;
                }
                this.igb.set(node, layoutGraph.getSize(node));
            }
            YPoint yPoint = layoutGraph.getCenter(node);
            double d2 = Math.floor(Math.max(yPoint.getX() - yRectangle.getX(), yRectangle.getX() + yRectangle.getWidth() - yPoint.getX()) + 1.0E-5);
            double d3 = Math.floor(Math.max(yPoint.getY() - yRectangle.getY(), yRectangle.getY() + yRectangle.getHeight() - yPoint.getY()) + 1.0E-5);
            layoutGraph.setSize(node, 2.0 * d2, 2.0 * d3);
            layoutGraph.setCenter(node, yPoint);
            nodeCursor.next();
            if (!bl) continue;
        }
    }

    private void rb(LayoutGraph layoutGraph) {
        block2: {
            boolean bl = AbstractRotatableNodePlacer.z;
            NodeCursor nodeCursor = layoutGraph.nodes();
            while (nodeCursor.ok()) {
                Node node = nodeCursor.node();
                YPoint yPoint = layoutGraph.getCenter(node);
                layoutGraph.setSize(node, (YDimension)this.igb.get(node));
                layoutGraph.setCenter(node, yPoint);
                nodeCursor.next();
                if (!bl) {
                    if (!bl) continue;
                }
                break block2;
            }
            layoutGraph.disposeNodeMap(this.igb);
        }
    }

    private static YRectangle d(YRectangle yRectangle, YRectangle yRectangle2) {
        if (yRectangle == null || yRectangle2 == null) {
            return yRectangle == null ? yRectangle2 : yRectangle;
        }
        double d2 = Math.min(yRectangle.getX(), yRectangle2.getX());
        double d3 = Math.max(yRectangle.getX() + yRectangle.getWidth(), yRectangle2.getX() + yRectangle2.getWidth());
        double d4 = Math.min(yRectangle.getY(), yRectangle2.getY());
        double d5 = Math.max(yRectangle.getY() + yRectangle.getHeight(), yRectangle2.getY() + yRectangle2.getHeight());
        return new YRectangle(d2, d4, d3 - d2, d5 - d4);
    }

    private double f(Node node, NodeMap nodeMap) {
        double d2;
        block2: {
            boolean bl = AbstractRotatableNodePlacer.z;
            d2 = this.graph.getWidth(node) * this.graph.getHeight(node);
            for (Edge edge = node.firstOutEdge(); edge != null; edge = edge.nextOutEdge()) {
                Node node2 = edge.target();
                d2 += this.f(node2, nodeMap);
                if (!bl) {
                    if (!bl) continue;
                }
                break block2;
            }
            nodeMap.setDouble(node, d2);
        }
        return d2;
    }

    public boolean canLayoutCore(LayoutGraph layoutGraph) {
        return Trees.isTree(layoutGraph);
    }

    protected NodeInfo getInfo(Node node) {
        return this.mgb[node.index()];
    }

    protected Node determineRoot() {
        switch (this.dgb) {
            case 2: {
                return Trees.getWeightedCenterNode(this.graph);
            }
            case 1: {
                return Trees.getCenterRoot(this.graph);
            }
        }
        return Trees.getRoot(this.graph);
    }

    protected void calcChildArrangement(Node node) {
        block5: {
            Object object;
            double d2;
            boolean bl = AbstractRotatableNodePlacer.z;
            double d3 = this.getPreferredChildWedge(node);
            block0: while (true) {
                d2 = this.calcAngles(node);
                block1: while (d2 > d3) {
                    NodeCursor nodeCursor = node.successors();
                    do {
                        if (!nodeCursor.ok()) continue block0;
                        Node node2 = nodeCursor.node();
                        object = this.getInfo(node2);
                        this.getInfo((Node)node2).dist *= 1.0 + this.zfb;
                        nodeCursor.next();
                        if (bl) continue block1;
                    } while (!bl);
                }
                break;
            }
            double d4 = (d3 - d2) / (double)(2 * node.outDegree());
            d2 = 0.0;
            object = node.successors();
            while (object.ok()) {
                NodeInfo nodeInfo = this.getInfo(object.node());
                nodeInfo.upperAngle += d4;
                nodeInfo.lowerAngle += d4;
                d2 += nodeInfo.upperAngle + nodeInfo.lowerAngle;
                object.next();
                if (!bl) {
                    if (!bl) continue;
                }
                break block5;
            }
            this.sortChildNodes(node);
        }
    }

    protected void sortChildNodes(Node node) {
        block3: {
            block5: {
                boolean bl;
                block4: {
                    block2: {
                        bl = AbstractRotatableNodePlacer.z;
                        if (!this.fgb) break block2;
                        this.z(node);
                        if (!bl) break block3;
                    }
                    if (this.cgb == null) break block4;
                    node.sortOutEdges(this.cgb);
                    if (!bl) break block3;
                }
                if (this.bgb != 0) break block5;
                this.ab(node);
                if (!bl) break block3;
            }
            this.fb(node);
        }
    }

    static double c(YPoint yPoint, YPoint yPoint2) {
        double d2 = yPoint2.x - yPoint.x;
        double d3 = yPoint2.y - yPoint.y;
        return Math.atan2(d3, d2);
    }

    private void z(Node node) {
        final LayoutGraph layoutGraph = (LayoutGraph)node.getGraph();
        final YPoint yPoint = layoutGraph.getCenter(node);
        YPoint yPoint2 = node.inDegree() > 0 ? layoutGraph.getCenter(node.firstInEdge().source()) : null;
        final double d2 = yPoint2 == null ? Math.PI : BalloonLayouter.c(yPoint, yPoint2);
        Comparator comparator2 = new Comparator(){

            public int compare(Object object, Object object2) {
                double d22;
                YPoint yPoint3 = layoutGraph.getCenter(((Edge)object).target());
                YPoint yPoint2 = layoutGraph.getCenter(((Edge)object2).target());
                double d3 = BalloonLayouter.c(yPoint, yPoint3);
                if (d3 < d2) {
                    d3 += Math.PI * 2;
                }
                if ((d22 = BalloonLayouter.c(yPoint, yPoint2)) < d2) {
                    d22 += Math.PI * 2;
                }
                return d3 < d22 ? 1 : (d3 > d22 ? -1 : 0);
            }
        };
        node.sortOutEdges(comparator2);
    }

    private void ab(Node node) {
        int n2;
        int n3;
        Object[] objectArray;
        boolean bl;
        block6: {
            block5: {
                bl = AbstractRotatableNodePlacer.z;
                objectArray = new Edge[node.outDegree()];
                int n4 = 0;
                EdgeCursor edgeCursor = node.outEdges();
                while (edgeCursor.ok()) {
                    objectArray[n4] = edgeCursor.edge();
                    edgeCursor.next();
                    ++n4;
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block5;
                }
                Comparators.sort(objectArray, (Comparator)new _c());
            }
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                this.graph.hide((Edge)objectArray[n3]);
                if (!bl) {
                    if (!bl) continue;
                }
                break block6;
            }
            n3 = 0;
        }
        while (n3 < objectArray.length && (n2 = objectArray.length - 1 - n3) >= n3) {
            this.graph.unhide((Edge)objectArray[n3]);
            if (n2 == n3) break;
            this.graph.unhide((Edge)objectArray[n2]);
            ++n3;
            if (!bl) continue;
        }
    }

    private void fb(Node node) {
        int n2;
        Object[] objectArray;
        boolean bl;
        block10: {
            int n3;
            block9: {
                block8: {
                    bl = AbstractRotatableNodePlacer.z;
                    objectArray = new Edge[node.outDegree()];
                    n2 = 0;
                    EdgeCursor edgeCursor = node.outEdges();
                    while (edgeCursor.ok()) {
                        objectArray[n2] = edgeCursor.edge();
                        edgeCursor.next();
                        ++n2;
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block8;
                    }
                    Comparators.sort(objectArray, (Comparator)new _b());
                }
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    this.graph.hide((Edge)objectArray[n3]);
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block9;
                }
                n3 = 0;
            }
            while (n3 < objectArray.length) {
                this.graph.unhide((Edge)objectArray[n3]);
                n3 += 2;
                if (!bl) {
                    if (!bl) continue;
                }
                break block10;
            }
            n2 = objectArray.length - 1;
        }
        if (n2 % 2 == 0) {
            --n2;
        }
        while (n2 > 0) {
            this.graph.unhide((Edge)objectArray[n2]);
            n2 -= 2;
            if (!bl) continue;
        }
    }

    protected double getPreferredChildWedge(Node node) {
        if (node.inDegree() == 0) {
            return this.jgb;
        }
        if (node.outDegree() == 2) {
            return Math.min(180.0, this.ngb);
        }
        return this.ngb;
    }

    protected double calcAngles(Node node) {
        double d2;
        block7: {
            boolean bl = AbstractRotatableNodePlacer.z;
            double d3 = 0.0;
            double d4 = this.db(node);
            EdgeCursor edgeCursor = node.outEdges();
            while (edgeCursor.ok()) {
                block9: {
                    YPoint yPoint;
                    YPoint yPoint2;
                    ListCell listCell;
                    double d5;
                    double d6;
                    YList yList;
                    double d7;
                    double d8;
                    NodeInfo nodeInfo;
                    block8: {
                        Edge edge = edgeCursor.edge();
                        Node node2 = edge.target();
                        nodeInfo = this.getInfo(node2);
                        d8 = -nodeInfo.dist;
                        d7 = nodeInfo.c;
                        yList = nodeInfo.d;
                        d6 = 0.0;
                        d2 = d6 + 1.0;
                        if (bl) break block7;
                        d5 = d2;
                        listCell = yList.firstCell();
                        yPoint2 = (YPoint)listCell.getInfo();
                        yPoint = null;
                        while (d5 > d6) {
                            yPoint = yPoint2;
                            listCell = yList.cyclicPred(listCell);
                            yPoint2 = (YPoint)listCell.getInfo();
                            d6 = (yPoint2.getY() - yPoint.getY()) / (yPoint2.getX() - yPoint.getX());
                            d5 = (yPoint.getY() - d7) / (yPoint.getX() - d8);
                            if (!bl) {
                                if (!bl) continue;
                            }
                            break block8;
                        }
                        nodeInfo.upperAngle = -Geom.toDegrees(Math.atan(d5));
                        d6 = 0.0;
                        d5 = d6 - 1.0;
                        listCell = yList.firstCell();
                    }
                    yPoint2 = (YPoint)listCell.getInfo();
                    while (((YPoint)listCell.succ().getInfo()).getX() == yPoint2.getX()) {
                        listCell = listCell.succ();
                        yPoint2 = (YPoint)listCell.getInfo();
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block9;
                    }
                    while (d5 < d6) {
                        yPoint = yPoint2;
                        listCell = yList.cyclicSucc(listCell);
                        yPoint2 = (YPoint)listCell.getInfo();
                        d6 = (yPoint2.getY() - yPoint.getY()) / (yPoint2.getX() - yPoint.getX());
                        d5 = (yPoint.getY() - d7) / (yPoint.getX() - d8);
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block9;
                    }
                    nodeInfo.lowerAngle = Geom.toDegrees(Math.atan(d5));
                    d3 += nodeInfo.upperAngle + nodeInfo.lowerAngle;
                    edgeCursor.next();
                }
                if (!bl) continue;
            }
            d2 = d3;
        }
        return d2;
    }

    void b(Node node, NodeInfo nodeInfo) {
        this.mgb[node.index()] = nodeInfo;
    }

    void eb(Node node) {
        NodeInfo nodeInfo = this.getInfo(node);
        YList yList = new YList();
        double d2 = 2.0 * this.db(node);
        yList.add(new YPoint(0.0, 0.0));
        yList.add(new YPoint(0.0, d2));
        yList.add(new YPoint(d2, d2));
        yList.add(new YPoint(d2, 0.0));
        nodeInfo.d = yList;
        nodeInfo.b = d2 / 2.0;
        nodeInfo.c = d2 / 2.0;
    }

    void cb(Node node) {
        block11: {
            double d2;
            block13: {
                double d3;
                double d4;
                double d5;
                double d6;
                Object object;
                boolean bl;
                block12: {
                    block14: {
                        bl = AbstractRotatableNodePlacer.z;
                        if (node.outDegree() != 0) break block14;
                        this.eb(node);
                        if (!bl) break block11;
                    }
                    NodeInfo nodeInfo = this.getInfo(node);
                    double d7 = this.db(node);
                    YList yList = new YList();
                    yList.add(new YPoint(-d7, -d7));
                    yList.add(new YPoint(-d7, d7));
                    yList.add(new YPoint(d7, -d7));
                    yList.add(new YPoint(d7, d7));
                    object = node.successors();
                    while (object.ok()) {
                        NodeInfo nodeInfo2 = this.getInfo(object.node());
                        yList.splice(nodeInfo2.d);
                        object.next();
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block11;
                    }
                    object = Geom.calcConvexHull(yList);
                    d6 = Double.MAX_VALUE;
                    d2 = Double.MAX_VALUE;
                    double d8 = -1.7976931348623157E308;
                    d5 = -1.7976931348623157E308;
                    YCursor yCursor = ((YList)object).cursor();
                    while (yCursor.ok()) {
                        YPoint yPoint = (YPoint)yCursor.current();
                        d4 = yPoint.getX();
                        d3 = d6;
                        if (!bl) {
                            if (d4 < d3) {
                                d6 = yPoint.getX();
                            }
                            if (yPoint.getX() > d8) {
                                d8 = yPoint.getX();
                            }
                            if (yPoint.getY() < d2) {
                                d2 = yPoint.getY();
                            }
                            if (yPoint.getY() > d5) {
                                d5 = yPoint.getY();
                            }
                            yCursor.next();
                            if (!bl) continue;
                        }
                        break block12;
                    }
                    d4 = d8;
                    d3 = d6;
                }
                double d9 = d4 - d3;
                double d10 = d5 - d2;
                YList yList = new YList();
                YCursor yCursor = ((YList)object).cursor();
                while (yCursor.ok()) {
                    YPoint yPoint = (YPoint)yCursor.current();
                    yList.add(new YPoint(yPoint.getX() - d6, yPoint.getY() - d2));
                    yCursor.next();
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block13;
                }
                nodeInfo.d = yList;
                nodeInfo.b = -d6;
            }
            nodeInfo.c = -d2;
        }
    }

    void bb(Node node) {
        block7: {
            boolean bl;
            block6: {
                block9: {
                    bl = AbstractRotatableNodePlacer.z;
                    if (node.outDegree() != 0) break block9;
                    this.cb(node);
                    if (!bl) break block7;
                }
                NodeCursor nodeCursor = node.successors();
                while (nodeCursor.ok()) {
                    this.bb(nodeCursor.node());
                    nodeCursor.next();
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block6;
                }
                this.calcChildArrangement(node);
            }
            double d2 = 0.0;
            NodeCursor nodeCursor = node.successors();
            while (nodeCursor.ok()) {
                block8: {
                    double d3;
                    double d4;
                    Node node2 = nodeCursor.node();
                    NodeInfo nodeInfo = this.getInfo(node2);
                    double d5 = 180.0 - (360.0 - this.getPreferredChildWedge(node)) / 2.0 - d2 - (nodeInfo.lowerAngle + nodeInfo.gapAngle);
                    d2 += nodeInfo.getAngleSum();
                    d5 = Geom.toRadians(d5);
                    double d6 = Math.sin(d5);
                    double d7 = Math.cos(d5);
                    if (bl) break block7;
                    for (ListCell listCell = nodeInfo.d.firstCell(); listCell != null; listCell = listCell.succ()) {
                        YPoint yPoint = (YPoint)listCell.getInfo();
                        d4 = yPoint.getX() + nodeInfo.dist;
                        d3 = yPoint.getY() - nodeInfo.c;
                        YPoint yPoint2 = new YPoint(d4 * d7 - d6 * d3, d4 * d6 + d7 * d3);
                        listCell.setInfo(yPoint2);
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block8;
                    }
                    d4 = nodeInfo.b + nodeInfo.dist;
                    d3 = 0.0;
                    nodeInfo.b = d4 * d7;
                    nodeInfo.c = d4 * d6;
                    nodeCursor.next();
                }
                if (!bl) continue;
            }
            this.cb(node);
        }
    }

    void y(Node node) {
        Object object;
        Object object2;
        boolean bl = AbstractRotatableNodePlacer.z;
        YPoint yPoint = this.graph.getCenter(node);
        double d2 = 0.0;
        if (node.inDegree() > 0) {
            object2 = node.predecessors().node();
            object = this.graph.getCenter((Node)object2);
            d2 = Math.PI + Math.atan2(((YPoint)object).getY() - yPoint.getY(), ((YPoint)object).getX() - yPoint.getX());
        }
        object2 = node.successors();
        while (object2.ok()) {
            object = object2.node();
            NodeInfo nodeInfo = this.getInfo((Node)object);
            if (d2 != 0.0) {
                double d3 = Math.cos(d2);
                double d4 = Math.sin(d2);
                double d5 = nodeInfo.b * d3 - d4 * nodeInfo.c;
                double d6 = nodeInfo.b * d4 + d3 * nodeInfo.c;
                nodeInfo.b = d5;
                nodeInfo.c = d6;
            }
            this.graph.setCenter((Node)object, yPoint.getX() + nodeInfo.b, yPoint.getY() + nodeInfo.c);
            this.y((Node)object);
            object2.next();
            if (!bl) continue;
        }
    }

    double db(Node node) {
        if (this.agb) {
            return (this.graph.getWidth(node) + this.graph.getHeight(node)) / 4.0 + 0.5 * (double)this.yfb;
        }
        return 1.41 * (Math.max(this.graph.getWidth(node), this.graph.getHeight(node)) / 2.0) + 0.5 * (double)this.yfb;
    }

    void c(Graph graph, Object object, EdgeMap edgeMap, NodeMap nodeMap) {
        boolean bl = AbstractRotatableNodePlacer.z;
        D.bug(object);
        D.bug("nodes: " + graph.nodeCount());
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            block3: {
                Node node = nodeCursor.node();
                D.bug(node + " inAngle: " + nodeMap.get(node));
                EdgeCursor edgeCursor = node.outEdges();
                while (edgeCursor.ok()) {
                    Edge edge = edgeCursor.edge();
                    Node node2 = edge.target();
                    D.bug(" >edge to " + node2 + " outAngle: " + edgeMap.get(edge));
                    edgeCursor.next();
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block3;
                }
                nodeCursor.next();
            }
            if (!bl) continue;
        }
    }

    class _b
    implements Comparator {
        _b() {
        }

        public int compare(Object object, Object object2) {
            Node node = ((Edge)object).target();
            Node node2 = ((Edge)object2).target();
            return Comparators.compare(BalloonLayouter.this.getInfo(node).getAngleSum(), BalloonLayouter.this.getInfo(node2).getAngleSum());
        }
    }

    class _c
    implements Comparator,
    Comparators.PartialOrder {
        _c() {
        }

        public int compare(Object object, Object object2) {
            double d2;
            Node node = ((Edge)object).target();
            Node node2 = ((Edge)object2).target();
            double d3 = BalloonLayouter.this.egb.getDouble(node);
            if (d3 > (d2 = BalloonLayouter.this.egb.getDouble(node2)) + hgb) {
                return 1;
            }
            if (d3 + hgb < d2) {
                return -1;
            }
            return Comparators.compare(BalloonLayouter.this.getInfo(node).getAngleSum(), BalloonLayouter.this.getInfo(node2).getAngleSum());
        }
    }

    public static class NodeInfo {
        YList d;
        public double upperAngle;
        public double lowerAngle;
        public double gapAngle;
        public double dist;
        double b;
        double c;

        NodeInfo(double d2) {
            this.dist = d2;
            this.d = new YList();
        }

        public double getAngleSum() {
            return this.upperAngle + this.lowerAngle + this.gapAngle;
        }
    }
}

