/*
 * Decompiled with CFR 0.152.
 */
package y.layout.tree;

import y.base.Edge;
import y.base.Node;
import y.geom.YPoint;
import y.layout.EdgeLayout;
import y.layout.LayoutGraph;
import y.layout.NodeLayout;
import y.layout.PortConstraint;
import y.layout.tree.AbstractRotatableNodePlacer;
import y.layout.tree.PortAssignment;

public class DefaultPortAssignment
implements PortAssignment {
    public static final byte MODE_PORT_CONSTRAINTS = 1;
    public static final byte MODE_PORT_DISTRIBUTED_NORTH = 2;
    public static final byte MODE_PORT_DISTRIBUTED_SOUTH = 3;
    public static final byte MODE_PORT_DISTRIBUTED_EAST = 4;
    public static final byte MODE_PORT_DISTRIBUTED_WEST = 5;
    public static final byte MODE_NONE = 0;
    private byte b;
    private double d;
    private boolean c;

    public DefaultPortAssignment() {
        this(0, 0.5);
    }

    public DefaultPortAssignment(byte by) {
        this(by, 0.5);
    }

    public DefaultPortAssignment(byte by, double d2) {
        this.b = by;
        this.d = d2;
        this.c = false;
    }

    public void assignPorts(LayoutGraph layoutGraph, Node node) {
        boolean bl = AbstractRotatableNodePlacer.z;
        if (node.firstInEdge() != null) {
            this.assignParentEdgeTargetPort(layoutGraph, node, node.firstInEdge());
        }
        int n2 = 0;
        Edge edge = node.firstOutEdge();
        while (edge != null) {
            this.assignChildEdgeSourcePort(layoutGraph, node, edge, n2);
            edge = edge.nextOutEdge();
            ++n2;
            if (!bl) continue;
        }
    }

    protected void assignParentEdgeTargetPort(LayoutGraph layoutGraph, Node node, Edge edge) {
        boolean bl = AbstractRotatableNodePlacer.z;
        EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edge);
        switch (this.b) {
            default: {
                edgeLayout.setTargetPoint(YPoint.ORIGIN);
                if (!bl) break;
            }
            case 1: {
                PortConstraint portConstraint = this.getTargetPortConstraint(layoutGraph, edge);
                if (portConstraint != null && portConstraint.isStrong()) break;
                if (portConstraint == null || portConstraint.isAtAnySide()) {
                    edgeLayout.setTargetPoint(YPoint.ORIGIN);
                    if (!bl) break;
                }
                NodeLayout nodeLayout = layoutGraph.getNodeLayout(node);
                if (portConstraint.isAtNorth()) {
                    edgeLayout.setTargetPoint(new YPoint(0.0, -nodeLayout.getHeight() * 0.5));
                    if (!bl) break;
                }
                if (portConstraint.isAtEast()) {
                    edgeLayout.setTargetPoint(new YPoint(nodeLayout.getWidth() * 0.5, 0.0));
                    if (!bl) break;
                }
                if (portConstraint.isAtSouth()) {
                    edgeLayout.setTargetPoint(new YPoint(0.0, nodeLayout.getHeight() * 0.5));
                    if (!bl) break;
                }
                edgeLayout.setTargetPoint(new YPoint(-nodeLayout.getWidth() * 0.5, 0.0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void assignChildEdgeSourcePort(LayoutGraph layoutGraph, Node node, Edge edge, int n2) {
        boolean bl = AbstractRotatableNodePlacer.z;
        EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edge);
        NodeLayout nodeLayout = layoutGraph.getNodeLayout(node);
        double d2 = nodeLayout.getWidth();
        double d3 = nodeLayout.getHeight();
        int n3 = node.outDegree();
        int n4 = this.c ? -1 : 1;
        switch (this.b) {
            case 2: {
                double d4 = this.getPortBorderGap(d2, n3);
                double d5 = this.getPortDistanceDelta(d2, n3, d4);
                edgeLayout.setSourcePoint(new YPoint((double)n4 * (d4 + (double)n2 * d5 - d2 / 2.0), -d3 / 2.0));
                return;
            }
            case 3: {
                double d6 = this.getPortBorderGap(d2, n3);
                double d7 = this.getPortDistanceDelta(d2, n3, d6);
                edgeLayout.setSourcePoint(new YPoint((double)n4 * (d6 + (double)n2 * d7 - d2 / 2.0), d3 / 2.0));
                return;
            }
            case 4: {
                double d8 = this.getPortBorderGap(d3, n3);
                double d9 = this.getPortDistanceDelta(d3, n3, d8);
                edgeLayout.setSourcePoint(new YPoint(d2 / 2.0, (double)n4 * (d8 + (double)n2 * d9 - d3 / 2.0)));
                return;
            }
            case 5: {
                double d10 = this.getPortBorderGap(d3, n3);
                double d11 = this.getPortDistanceDelta(d3, n3, d10);
                edgeLayout.setSourcePoint(new YPoint(-d2 / 2.0, (double)n4 * (d10 + (double)n2 * d11 - d3 / 2.0)));
                return;
            }
            case 0: {
                edgeLayout.setSourcePoint(YPoint.ORIGIN);
                return;
            }
            case 1: {
                PortConstraint portConstraint = this.getSourcePortConstraint(layoutGraph, edge, n2);
                if (portConstraint != null && portConstraint.isStrong()) return;
                if (portConstraint == null || portConstraint.isAtAnySide()) {
                    edgeLayout.setSourcePoint(YPoint.ORIGIN);
                    if (!bl) return;
                }
                if (portConstraint.isAtNorth()) {
                    edgeLayout.setSourcePoint(new YPoint(0.0, -nodeLayout.getHeight() * 0.5));
                    if (!bl) return;
                }
                if (portConstraint.isAtEast()) {
                    edgeLayout.setSourcePoint(new YPoint(nodeLayout.getWidth() * 0.5, 0.0));
                    if (!bl) return;
                }
                if (portConstraint.isAtSouth()) {
                    edgeLayout.setSourcePoint(new YPoint(0.0, nodeLayout.getHeight() * 0.5));
                    if (!bl) return;
                }
                edgeLayout.setSourcePoint(new YPoint(-nodeLayout.getWidth() * 0.5, 0.0));
                return;
            }
        }
    }

    protected double getPortBorderGap(double d2, int n2) {
        if (n2 <= 1) {
            return d2 * 0.5;
        }
        return this.d * (d2 / ((double)(n2 - 1) + 2.0 * this.d));
    }

    protected double getPortDistanceDelta(double d2, int n2, double d3) {
        if (n2 <= 1) {
            return 0.0;
        }
        return (d2 - 2.0 * d3) / (double)(n2 - 1);
    }

    protected PortConstraint getSourcePortConstraint(LayoutGraph layoutGraph, Edge edge, int n2) {
        return PortConstraint.getSPC(layoutGraph, edge);
    }

    protected PortConstraint getTargetPortConstraint(LayoutGraph layoutGraph, Edge edge) {
        return PortConstraint.getTPC(layoutGraph, edge);
    }

    public byte getMode() {
        return this.b;
    }

    public void setMode(byte by) {
        this.b = by;
    }

    public double getBorderGapToPortGapRatio() {
        return this.d;
    }

    public void setBorderGapToPortGapRatio(double d2) {
        this.d = d2;
    }

    public boolean isReversedPortOrder() {
        return this.c;
    }

    public void setReversedPortOrder(boolean bl) {
        this.c = bl;
    }
}

