/*
 * Decompiled with CFR 0.152.
 */
package y.layout.tree;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import y.algo.Bfs;
import y.algo.Trees;
import y.base.DataAcceptor;
import y.base.DataMap;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.ListCell;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.WrongGraphStructure;
import y.base.YList;
import y.geom.BorderLine;
import y.geom.OrientedRectangle;
import y.geom.YInsets;
import y.geom.YPoint;
import y.layout.CanonicMultiStageLayouter;
import y.layout.DefaultNodeLayout;
import y.layout.EdgeLabelOrientationSupport;
import y.layout.EdgeLayout;
import y.layout.LabelLayoutData;
import y.layout.LabelLayoutKeys;
import y.layout.LabelLayoutTranslator;
import y.layout.LayoutGraph;
import y.layout.LayoutStage;
import y.layout.LayoutTool;
import y.layout.NodeLayout;
import y.layout.OrientationLayouter;
import y.layout.PortConstraint;
import y.layout.PortConstraintKeys;
import y.layout.RemoveColinearBendsStage;
import y.layout.grouping.Grouping;
import y.layout.grouping.GroupingKeys;
import y.layout.grouping.RecursiveGroupLayouter;
import y.layout.tree.AbstractRotatableNodePlacer;
import y.layout.tree.DefaultNodePlacer;
import y.layout.tree.DefaultPortAssignment;
import y.layout.tree.LayeredNodePlacer;
import y.layout.tree.LeafPlacer;
import y.layout.tree.NodePlacer;
import y.layout.tree.PortAssignment;
import y.layout.tree.Processor;
import y.layout.tree.b;
import y.layout.tree.d;
import y.util.DataProviderAdapter;
import y.util.GraphHider;
import y.util.Maps;
import y.util.WrappedObjectDataProvider;

public class GenericTreeLayouter
extends CanonicMultiStageLayouter {
    public static final Object NODE_PLACER_DPKEY = "y.layout.tree.GenericTreeLayouter.NODE_PLACER_DPKEY";
    public static final Object PORT_ASSIGNMENT_DPKEY = "y.layout.tree.GenericTreeLayouter.PORT_ASSIGNMENT_DPKEY";
    public static final Object CHILD_COMPARATOR_DPKEY = "y.layout.tree.GenericTreeLayouter.CHILD_COMPARATOR_DPKEY";
    static final Object fhb = "y.layout.tree.GenericTreeLayouter.EDGE_REVERSED_DPKEY";
    private NodeMap qhb;
    private NodeMap ygb;
    private double xgb = 2.0;
    private DataProvider mhb;
    private DataProvider ghb;
    private WrappedObjectDataProvider dhb;
    private WrappedObjectDataProvider ehb;
    private WrappedObjectDataProvider phb;
    private WrappedObjectDataProvider wgb;
    private WrappedObjectDataProvider jhb;
    protected LayoutGraph graph;
    private NodePlacer lhb;
    private NodePlacer hhb = new LeafPlacer();
    private PortAssignment vgb;
    private Comparator ihb = null;
    private boolean chb;
    private boolean khb;
    private boolean bhb = true;
    private NodeMap ugb;
    private NodeMap nhb;
    private Grouping ohb;
    private EdgeMap ahb;
    private final EdgeLabelOrientationSupport zgb;

    public GenericTreeLayouter() {
        this.mhb = new DataProviderAdapter(){

            public Object get(Object object) {
                Node node = (Node)object;
                return GenericTreeLayouter.this.getNodeShape(node);
            }
        };
        this.ghb = new DataProviderAdapter(){

            public Object get(Object object) {
                return GenericTreeLayouter.this.getSubtreeShape((Node)object);
            }
        };
        this.vgb = new DefaultPortAssignment();
        this.lhb = new DefaultNodePlacer();
        this.setGroupNodeHidingEnabled(!this.isGroupingSupported());
        OrientationLayouter orientationLayouter = new OrientationLayouter();
        orientationLayouter.setConsiderEdgeLabelsEnabled(false);
        this.setOrientationLayouter(orientationLayouter);
        this.zgb = new EdgeLabelOrientationSupport();
    }

    EdgeLabelOrientationSupport bi() {
        return this.zgb;
    }

    public boolean isGroupingSupported() {
        return this.bhb;
    }

    public void setGroupingSupported(boolean bl) {
        this.bhb = bl;
        this.setGroupNodeHidingEnabled(!bl);
    }

    protected boolean canLayoutCore(LayoutGraph layoutGraph) {
        return GenericTreeLayouter.b(layoutGraph, this.isGroupingSupported());
    }

    static boolean b(LayoutGraph layoutGraph, boolean bl) {
        boolean bl2;
        GraphHider graphHider;
        block9: {
            boolean bl3;
            block8: {
                boolean bl4 = AbstractRotatableNodePlacer.z;
                if (layoutGraph == null) {
                    return false;
                }
                graphHider = null;
                if (bl && Grouping.isGrouped(layoutGraph)) {
                    graphHider = new GraphHider(layoutGraph);
                    DataProvider dataProvider = layoutGraph.getDataProvider(GroupingKeys.PARENT_NODE_ID_DPKEY);
                    HashSet<Object> hashSet = new HashSet<Object>();
                    Object object = layoutGraph.nodes();
                    while (object.ok()) {
                        hashSet.add(dataProvider.get(object.node()));
                        object.next();
                        if (!bl4) {
                            if (!bl4) continue;
                        }
                        break block8;
                    }
                    object = layoutGraph.getDataProvider(GroupingKeys.NODE_ID_DPKEY);
                    DataProvider dataProvider2 = layoutGraph.getDataProvider(GroupingKeys.GROUP_DPKEY);
                    NodeCursor nodeCursor = layoutGraph.nodes();
                    while (nodeCursor.ok()) {
                        Node node = nodeCursor.node();
                        bl3 = dataProvider2.getBool(node);
                        if (!bl4) {
                            if (bl3 && hashSet.contains(object.get(node))) {
                                graphHider.hide(node);
                            }
                            nodeCursor.next();
                            if (!bl4) continue;
                        }
                        break block9;
                    }
                }
            }
            bl3 = bl2 = Trees.isTree(layoutGraph);
        }
        if (graphHider != null) {
            graphHider.unhideAll();
        }
        return bl2;
    }

    private NodeList c(Grouping grouping) {
        NodeList nodeList;
        block2: {
            boolean bl = AbstractRotatableNodePlacer.z;
            nodeList = new NodeList();
            NodeList nodeList2 = grouping.getChildren(grouping.getRoot());
            while (!nodeList2.isEmpty()) {
                Node node = nodeList2.popNode();
                if (!grouping.hasChildren(node)) continue;
                nodeList.add(node);
                nodeList2.addAll((Collection)grouping.getChildren(node));
                if (!bl) {
                    if (!bl) continue;
                }
                break block2;
            }
            nodeList.reverse();
        }
        return nodeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLayoutCore(LayoutGraph layoutGraph) {
        block20: {
            boolean bl = AbstractRotatableNodePlacer.z;
            if (!this.canLayoutCore(layoutGraph)) {
                throw new WrongGraphStructure("Graph is not a tree");
            }
            boolean bl2 = Grouping.isGrouped(layoutGraph) && this.bhb;
            this.ohb = null;
            YList yList = null;
            GraphHider graphHider = null;
            if (bl2) {
                this.ohb = new Grouping(layoutGraph);
                yList = this.c(this.ohb);
                graphHider = new GraphHider(layoutGraph);
                graphHider.hide((NodeList)yList);
            }
            if (bl2 && layoutGraph.isEmpty() && !yList.isEmpty()) {
                graphHider.unhideAll();
                this.ohb.dispose();
                this.ohb = null;
                return;
            }
            this.graph = layoutGraph;
            this.qhb = layoutGraph.createNodeMap();
            this.ygb = layoutGraph.createNodeMap();
            try {
                Object object;
                this.dhb = WrappedObjectDataProvider.wrapUsingNodeMap(layoutGraph, NODE_PLACER_DPKEY);
                this.ehb = WrappedObjectDataProvider.wrapUsingNodeMap(layoutGraph, PORT_ASSIGNMENT_DPKEY);
                this.phb = WrappedObjectDataProvider.wrapUsingNodeMap(layoutGraph, CHILD_COMPARATOR_DPKEY);
                this.wgb = WrappedObjectDataProvider.wrapUsingEdgeMap(layoutGraph, PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY);
                this.jhb = WrappedObjectDataProvider.wrapUsingEdgeMap(layoutGraph, PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY);
                EdgeList edgeList = this.directTree();
                this.reverseEdges(edgeList);
                this.ahb = layoutGraph.createEdgeMap();
                layoutGraph.addDataProvider(fhb, this.ahb);
                Object object2 = edgeList.edges();
                while (object2.ok()) {
                    object = object2.edge();
                    this.ahb.set(object, Boolean.TRUE);
                    object2.next();
                    if (!bl) continue;
                }
                try {
                    block18: {
                        Object object3;
                        block21: {
                            object2 = Trees.getRoot(layoutGraph);
                            if (!bl2) break block21;
                            object = this.b((Graph)layoutGraph, (Node)object2);
                            this.ugb = layoutGraph.createNodeMap();
                            this.nhb = layoutGraph.createNodeMap();
                            NodeCursor nodeCursor = ((NodeList)yList).nodes();
                            while (nodeCursor.ok()) {
                                block22: {
                                    NodeList nodeList;
                                    Node node;
                                    Node node2;
                                    block23: {
                                        node2 = nodeCursor.node();
                                        NodeList nodeList2 = this.b(node2, this.ohb);
                                        object3 = nodeList2;
                                        if (bl) break block18;
                                        if (((YList)object3).isEmpty()) break block22;
                                        node = GenericTreeLayouter.b((Node)object2, nodeList2, (NodeMap)object);
                                        this.nhb.set(node2, node);
                                        if (this.ugb.get(node) != null) break block23;
                                        nodeList = new NodeList(node2);
                                        this.ugb.set(node, nodeList);
                                        if (!bl) break block22;
                                    }
                                    nodeList = (NodeList)this.ugb.get(node);
                                    nodeList.add(node2);
                                }
                                nodeCursor.next();
                                if (!bl) continue;
                            }
                        }
                        object3 = object = this.b((Node)object2, layoutGraph);
                    }
                    if (bl2 && !yList.isEmpty() && layoutGraph.getDataProvider(LayeredNodePlacer.DP_KEY_DISTANCE_TO_PARENT_MAP) != null) {
                        this.h((NodeList)yList);
                    }
                    this.jb((Node)object2);
                    this.b(layoutGraph, (List)object);
                }
                finally {
                    this.reverseEdges(edgeList);
                    new RemoveColinearBendsStage().doLayout(layoutGraph);
                }
                Object var15_15 = null;
                if (!bl2) break block20;
                graphHider.unhideAll();
                RecursiveGroupLayouter recursiveGroupLayouter = new RecursiveGroupLayouter();
                recursiveGroupLayouter.setConsiderEmptyGroupsEnabled(false);
                recursiveGroupLayouter.doLayout(layoutGraph);
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                if (bl2) {
                    graphHider.unhideAll();
                    RecursiveGroupLayouter recursiveGroupLayouter = new RecursiveGroupLayouter();
                    recursiveGroupLayouter.setConsiderEmptyGroupsEnabled(false);
                    recursiveGroupLayouter.doLayout(layoutGraph);
                    layoutGraph.disposeNodeMap(this.ugb);
                    layoutGraph.disposeNodeMap(this.nhb);
                    this.ohb.dispose();
                    this.ohb = null;
                }
                this.ehb.dispose();
                this.ehb = null;
                this.dhb.dispose();
                this.dhb = null;
                this.wgb.dispose();
                this.wgb = null;
                this.jhb.dispose();
                this.jhb = null;
                this.phb.dispose();
                this.phb = null;
                if (this.ahb != null) {
                    layoutGraph.removeDataProvider(fhb);
                    layoutGraph.disposeEdgeMap(this.ahb);
                    this.ahb = null;
                }
                this.graph.disposeNodeMap(this.ygb);
                this.graph.disposeNodeMap(this.qhb);
                this.ygb = null;
                this.qhb = null;
                this.graph = null;
                throw throwable;
            }
            layoutGraph.disposeNodeMap(this.ugb);
            layoutGraph.disposeNodeMap(this.nhb);
            this.ohb.dispose();
            this.ohb = null;
        }
        this.ehb.dispose();
        this.ehb = null;
        this.dhb.dispose();
        this.dhb = null;
        this.wgb.dispose();
        this.wgb = null;
        this.jhb.dispose();
        this.jhb = null;
        this.phb.dispose();
        this.phb = null;
        if (this.ahb != null) {
            layoutGraph.removeDataProvider(fhb);
            layoutGraph.disposeEdgeMap(this.ahb);
            this.ahb = null;
        }
        this.graph.disposeNodeMap(this.ygb);
        this.graph.disposeNodeMap(this.qhb);
        this.ygb = null;
        this.qhb = null;
        this.graph = null;
    }

    /*
     * Unable to fully structure code
     */
    private void h(NodeList var1_1) {
        block18: {
            var18_2 = AbstractRotatableNodePlacer.z;
            var2_3 = this.graph.getDataProvider(LayeredNodePlacer.DP_KEY_DISTANCE_TO_PARENT_MAP);
            var3_4 = this.graph.getDataProvider(GroupingKeys.GROUP_NODE_INSETS_DPKEY);
            if (var2_3 == null || var3_4 == null) break block18;
            var4_5 = Maps.createIndexNodeMap(new double[this.graph.nodeCount()]);
            var5_6 = Maps.createIndexNodeMap(new double[this.graph.nodeCount()]);
            var6_7 = var1_1.nodes();
            while (var6_7.ok()) {
                block17: {
                    block19: {
                        block16: {
                            var7_8 = var6_7.node();
                            v0 = var8_9 = YInsets.asYInsets(var3_4.get(var7_8));
                            if (var18_2) ** GOTO lbl66
                            if (v0 == null) break block19;
                            var9_10 = 0x7FFFFFFF;
                            var10_13 = -2147483648;
                            var11_14 = new NodeList();
                            var12_15 = new NodeList();
                            var13_16 = this.b(var7_8, this.ohb);
                            var14_17 = var13_16.nodes();
                            while (var14_17.ok()) {
                                var15_18 = var14_17.node();
                                v1 = var16_19 = (LayeredNodePlacer._d)var2_3.get(var15_18);
                                if (!var18_2) {
                                    if (v1 != null) {
                                        if (var16_19.j() >= var10_13) {
                                            if (var16_19.j() > var10_13) {
                                                var10_13 = var16_19.j();
                                                var12_15.clear();
                                            }
                                            var12_15.add(var15_18);
                                        }
                                        if (var16_19.j() <= var9_10) {
                                            if (var16_19.j() < var9_10) {
                                                var9_10 = var16_19.j();
                                                var11_14.clear();
                                            }
                                            var11_14.add(var15_18);
                                        }
                                    }
                                    var14_17.next();
                                    if (!var18_2) continue;
                                }
                                ** GOTO lbl67
                            }
                            var14_17 = var11_14.nodes();
                            while (var14_17.ok()) {
                                var15_18 = var14_17.node();
                                var16_20 = var4_5.getDouble(var15_18);
                                var4_5.setDouble(var15_18, var16_20 + var8_9.top);
                                var14_17.next();
                                if (!var18_2) {
                                    if (!var18_2) continue;
                                }
                                break block16;
                            }
                            var14_17 = var12_15.nodes();
                        }
                        while (var14_17.ok()) {
                            var15_18 = var14_17.node();
                            var16_21 = var5_6.getDouble(var15_18);
                            var5_6.setDouble(var15_18, var16_21 + var8_9.bottom);
                            var14_17.next();
                            if (!var18_2) {
                                if (!var18_2) continue;
                            }
                            break block17;
                        }
                    }
                    var6_7.next();
                }
                if (!var18_2) continue;
            }
            var6_7 = this.graph.nodes();
            while (var6_7.ok()) {
                var7_8 = var6_7.node();
                v0 = var2_3.get(var7_8);
lbl66:
                // 2 sources

                v1 = (LayeredNodePlacer._d)v0;
lbl67:
                // 2 sources

                if ((var8_9 = v1) != null) {
                    var9_12 = this.getNodePlacer(var7_8);
                    if (var9_12 instanceof b) {
                        var9_12 = ((b)var9_12).b();
                    }
                    if (var9_12 instanceof LayeredNodePlacer) {
                        var8_9.b(var7_8, this, ((LayeredNodePlacer)var9_12).getModificationMatrix(), var4_5.getDouble(var7_8), var5_6.getDouble(var7_8));
                    }
                }
                var6_7.next();
                if (!var18_2) continue;
            }
        }
    }

    private NodeMap b(Graph graph, Node node) {
        boolean bl = AbstractRotatableNodePlacer.z;
        NodeMap nodeMap = Maps.createIndexNodeMap(new int[graph.nodeCount()]);
        NodeList[] nodeListArray = Bfs.getLayers(graph, new NodeList(node));
        int n2 = 0;
        while (n2 < nodeListArray.length) {
            block3: {
                NodeCursor nodeCursor = nodeListArray[n2].nodes();
                while (nodeCursor.ok()) {
                    nodeMap.setInt(nodeCursor.node(), n2);
                    nodeCursor.next();
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block3;
                }
                ++n2;
            }
            if (!bl) continue;
        }
        return nodeMap;
    }

    private static Node b(Node node, Node node2, NodeMap nodeMap) {
        Node node3;
        block9: {
            Node node4;
            block8: {
                Node node5;
                boolean bl;
                block7: {
                    bl = AbstractRotatableNodePlacer.z;
                    if (node == node2) {
                        return node;
                    }
                    node4 = node;
                    node5 = node2;
                    while (nodeMap.getInt(node4) < nodeMap.getInt(node5)) {
                        node5 = node5.firstInEdge().source();
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block7;
                    }
                    while (nodeMap.getInt(node4) > nodeMap.getInt(node5)) {
                        node4 = node4.firstInEdge().source();
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block8;
                    }
                }
                while (node4 != node5) {
                    node4 = node4.firstInEdge().source();
                    node3 = node5.firstInEdge().source();
                    if (!bl) {
                        node5 = node3;
                        if (!bl) continue;
                    }
                    break block9;
                }
            }
            node3 = node4;
        }
        return node3;
    }

    private static Node b(Node node, NodeList nodeList, NodeMap nodeMap) {
        Node node2;
        block3: {
            boolean bl = AbstractRotatableNodePlacer.z;
            Node node3 = nodeList.firstNode();
            NodeCursor nodeCursor = nodeList.nodes();
            while (nodeCursor.ok()) {
                Node node4 = nodeCursor.node();
                node2 = node3 = GenericTreeLayouter.b(node3, node4, nodeMap);
                if (!bl) {
                    if (node2 == node) {
                        return node;
                    }
                    nodeCursor.next();
                    if (!bl) continue;
                }
                break block3;
            }
            node2 = node3;
        }
        return node2;
    }

    private NodeList b(Node node, Grouping grouping) {
        boolean bl = AbstractRotatableNodePlacer.z;
        NodeList nodeList = grouping.getDescendants(node);
        NodeList nodeList2 = new NodeList();
        NodeCursor nodeCursor = nodeList.nodes();
        while (nodeCursor.ok()) {
            Node node2 = nodeCursor.node();
            if (!grouping.isGroupNode(node2)) {
                nodeList2.add(node2);
            }
            nodeCursor.next();
            if (!bl) continue;
        }
        return nodeList2;
    }

    private void jb(Node node) {
        int n2;
        Node[] nodeArray;
        boolean bl;
        block8: {
            Object object;
            Node node2;
            block7: {
                int n3;
                bl = AbstractRotatableNodePlacer.z;
                nodeArray = this.getRootsArray(node);
                for (n2 = nodeArray.length - 1; n2 >= 0; --n2) {
                    node2 = nodeArray[n2];
                    n3 = node2.outDegree();
                    if (!bl) {
                        if (n3 <= 0) continue;
                        object = this.getChildNodeInEdgeComparator(node2);
                        if (object != null) {
                            node2.sortOutEdges((Comparator)object);
                        }
                        this.getNodePlacer(node2).determineChildConnectors(node2, this.ygb);
                        if (!bl) continue;
                    }
                    break block7;
                }
                n3 = n2 = 0;
            }
            while (n2 < nodeArray.length) {
                node2 = nodeArray[n2];
                this.hb(node2);
                object = this.layoutRoot(node2);
                this.qhb.set(node2, object);
                this.ib(node2);
                ++n2;
                if (!bl) {
                    if (!bl) continue;
                }
                break block8;
            }
            n2 = nodeArray.length - 1;
        }
        while (n2 >= 0) {
            Object object;
            double d2 = 0.0;
            double d3 = 0.0;
            Node node3 = nodeArray[n2];
            if (node3 != node) {
                object = node3.firstInEdge().source();
                SubtreeShape subtreeShape = this.getSubtreeShape((Node)object);
                d2 = subtreeShape.k;
                d3 = subtreeShape.j;
            }
            object = this.getSubtreeShape(node3);
            ((SubtreeShape)object).k += d2;
            ((SubtreeShape)object).j += d3;
            this.c(node3, d2, d3);
            --n2;
            if (!bl) continue;
        }
    }

    private List b(Node node, LayoutGraph layoutGraph) {
        YList yList;
        block4: {
            boolean bl = AbstractRotatableNodePlacer.z;
            YList yList2 = new YList();
            YList yList3 = new YList();
            yList3.add(node);
            while (!yList3.isEmpty()) {
                Node node2 = (Node)yList3.popLast();
                Processor processor2 = this.getNodePlacer(node2).createProcessor(this, layoutGraph, node2);
                if (processor2 != null) {
                    processor2.preProcess(this.dhb.getDataMapView(), this.ehb.getDataMapView(), this.phb.getDataMapView());
                    yList2.addFirst(processor2);
                }
                for (Edge edge = node2.firstOutEdge(); edge != null; edge = edge.nextOutEdge()) {
                    yList = yList3;
                    if (!bl) {
                        yList.add(edge.target());
                        if (!bl && !bl) continue;
                    }
                    break block4;
                }
            }
            yList = yList2;
        }
        return yList;
    }

    private void b(LayoutGraph layoutGraph, List list2) {
        boolean bl = AbstractRotatableNodePlacer.z;
        this.sb(layoutGraph);
        Iterator iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            Processor processor2 = (Processor)iterator2.next();
            if (processor2 == null) continue;
            processor2.postProcess();
            if (!bl) continue;
        }
    }

    private void sb(LayoutGraph layoutGraph) {
        boolean bl = AbstractRotatableNodePlacer.z;
        if (!this.khb) {
            return;
        }
        DataProvider dataProvider = layoutGraph.getDataProvider(LabelLayoutKeys.EDGE_LABEL_LAYOUT_KEY);
        if (dataProvider == null) {
            return;
        }
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            NodeLayout nodeLayout = layoutGraph.getNodeLayout(edge.target());
            LabelLayoutData[] labelLayoutDataArray = (LabelLayoutData[])dataProvider.get(edge);
            if (labelLayoutDataArray != null) {
                for (int i2 = 0; i2 < labelLayoutDataArray.length; ++i2) {
                    LabelLayoutData labelLayoutData = labelLayoutDataArray[i2];
                    double d2 = labelLayoutData.getX();
                    double d3 = labelLayoutData.getY();
                    labelLayoutData.setLocation(d2 + nodeLayout.getX(), d3 + nodeLayout.getY());
                    this.zgb.postProcessLabel(layoutGraph, labelLayoutData);
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break;
                }
            } else {
                edgeCursor.next();
            }
            if (!bl) continue;
        }
    }

    private void hb(Node node) {
        boolean bl = AbstractRotatableNodePlacer.z;
        for (Edge edge = node.firstOutEdge(); edge != null; edge = edge.nextOutEdge()) {
            Node node2 = edge.target();
            SubtreeShape subtreeShape = this.getSubtreeShape(node2);
            subtreeShape.k = subtreeShape.getOriginX();
            subtreeShape.j = subtreeShape.getOriginY();
            if (!bl) continue;
        }
    }

    private void ib(Node node) {
        boolean bl = AbstractRotatableNodePlacer.z;
        for (Edge edge = node.firstOutEdge(); edge != null; edge = edge.nextOutEdge()) {
            Node node2 = edge.target();
            SubtreeShape subtreeShape = this.getSubtreeShape(node2);
            subtreeShape.k = subtreeShape.getOriginX() - subtreeShape.k;
            subtreeShape.j = subtreeShape.getOriginY() - subtreeShape.j;
            if (!bl) continue;
        }
    }

    protected SubtreeShape getSubtreeShape(Node node) {
        return (SubtreeShape)this.qhb.get(node);
    }

    private void c(Node node, double d2, double d3) {
        boolean bl = AbstractRotatableNodePlacer.z;
        SubtreeShape subtreeShape = this.getSubtreeShape(node);
        subtreeShape.move(d2, d3);
        Edge edge = node.firstOutEdge();
        while (edge != null) {
            block3: {
                EdgeLayout edgeLayout = this.graph.getEdgeLayout(edge);
                for (int i2 = 0; i2 < edgeLayout.pointCount(); ++i2) {
                    YPoint yPoint = edgeLayout.getPoint(i2);
                    edgeLayout.setPoint(i2, yPoint.x + subtreeShape.k, yPoint.y + subtreeShape.j);
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block3;
                }
                edge = edge.nextOutEdge();
            }
            if (!bl) continue;
        }
    }

    protected SubtreeShape layoutRoot(Node node) {
        PortAssignment portAssignment = this.getPortAssignment(node);
        NodePlacer nodePlacer = this.getNodePlacer(node);
        portAssignment.assignPorts(this.graph, node);
        SubtreeShape subtreeShape = nodePlacer.placeSubtree(this.mhb, this.ghb, this.graph, node, (byte)this.ygb.getInt(node));
        if (this.isIntegratedEdgeLabeling()) {
            d d2 = new d(node, this.graph);
            d2.b(subtreeShape, (byte)this.ygb.getInt(node), this.xgb, this.bi());
        }
        return subtreeShape;
    }

    protected PortAssignment getPortAssignment(Node node) {
        PortAssignment portAssignment;
        if (this.ehb != null && (portAssignment = (PortAssignment)this.ehb.get(node)) != null) {
            return portAssignment;
        }
        return this.vgb;
    }

    protected Comparator getChildNodeInEdgeComparator(Node node) {
        Comparator comparator2;
        if (this.phb != null && (comparator2 = (Comparator)this.phb.get(node)) != null) {
            return comparator2;
        }
        return this.ihb;
    }

    protected NodePlacer getNodePlacer(Node node) {
        NodePlacer nodePlacer = null;
        if (this.dhb != null) {
            nodePlacer = (NodePlacer)this.dhb.get(node);
        }
        if (nodePlacer != null) {
            return this.b(node, nodePlacer);
        }
        if (node.outDegree() > 0) {
            return this.b(node, this.lhb);
        }
        return this.b(node, this.hhb);
    }

    private NodePlacer b(Node node, NodePlacer nodePlacer) {
        block3: {
            boolean bl = AbstractRotatableNodePlacer.z;
            if (this.ohb == null || this.ugb == null || this.ugb.get(node) == null) break block3;
            DataProvider dataProvider = this.graph.getDataProvider(GroupingKeys.GROUP_NODE_INSETS_DPKEY);
            NodeList nodeList = (NodeList)this.ugb.get(node);
            b b2 = null;
            NodeCursor nodeCursor = nodeList.nodes();
            while (nodeCursor.ok()) {
                block5: {
                    NodeList nodeList2;
                    YInsets yInsets;
                    Node node2;
                    block4: {
                        node2 = nodeCursor.node();
                        Object object = dataProvider == null ? null : dataProvider.get(node2);
                        yInsets = YInsets.asYInsets(object);
                        nodeList2 = this.ohb.getDescendants(node2);
                        if (b2 != null) break block4;
                        b2 = new b(nodePlacer, node2, nodeList2, this.qhb, this.nhb, yInsets);
                        if (!bl) break block5;
                    }
                    b2 = new b(b2, node2, nodeList2, this.qhb, this.nhb, yInsets);
                }
                nodeCursor.next();
                if (!bl) continue;
            }
            return b2;
        }
        return nodePlacer;
    }

    protected SubtreeShape getNodeShape(Node node) {
        NodeLayout nodeLayout = this.graph.getNodeLayout(node);
        SubtreeShape subtreeShape = new SubtreeShape(node, nodeLayout);
        if (this.chb) {
            d d2 = new d(node, this.graph);
            d2.b(subtreeShape);
        }
        return subtreeShape;
    }

    protected Node[] getRootsArray(Node node) {
        Node[] nodeArray;
        block8: {
            int n2;
            int[] nArray;
            ArrayList<Node> arrayList;
            boolean bl;
            block7: {
                int n3;
                bl = AbstractRotatableNodePlacer.z;
                arrayList = new ArrayList<Node>(this.graph.N());
                nArray = new int[this.graph.N()];
                nodeArray = this.graph.getNodeArray();
                for (n2 = 0; n2 < nodeArray.length; ++n2) {
                    int n4;
                    nArray[n2] = n4 = nodeArray[n2].outDegree();
                    n3 = n4;
                    if (!bl) {
                        if (n3 != 0) continue;
                        arrayList.add(nodeArray[n2]);
                        if (!bl) continue;
                    }
                    break block7;
                }
                n3 = n2 = 0;
            }
            while (!arrayList.isEmpty()) {
                Node node2 = (Node)arrayList.remove(arrayList.size() - 1);
                if (!bl) {
                    if (node2 != node) {
                        Node node3 = node2.firstInEdge().source();
                        int n5 = node3.index();
                        nArray[n5] = nArray[n5] - 1;
                        if (nArray[n5] == 0) {
                            arrayList.add(node3);
                        }
                    }
                    nodeArray[n2++] = node2;
                    if (!bl) continue;
                }
                break block8;
            }
            if (n2 != this.graph.N()) {
                throw new RuntimeException("Not all nodes found!");
            }
        }
        return nodeArray;
    }

    protected EdgeList directTree() {
        boolean bl = AbstractRotatableNodePlacer.z;
        EdgeList edgeList = Trees.directTree(this.graph);
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            this.graph.reverseEdge(edgeCursor.edge());
            edgeCursor.next();
            if (!bl) continue;
        }
        return edgeList;
    }

    protected DataAcceptor getSourcePortConstraintDataAcceptor() {
        return (DataMap)this.wgb.getWrappingProvider();
    }

    protected DataAcceptor getTargetPortConstraintDataAcceptor() {
        return (DataMap)this.jhb.getWrappingProvider();
    }

    protected void reverseEdges(EdgeList edgeList) {
        boolean bl = AbstractRotatableNodePlacer.z;
        for (ListCell listCell = edgeList.firstCell(); listCell != null; listCell = listCell.succ()) {
            Edge edge = (Edge)listCell.getInfo();
            LayoutTool.reverseEdgeLayout(this.graph.getLayout(edge));
            PortConstraint portConstraint = PortConstraint.getSPC(this.graph, edge);
            PortConstraint portConstraint2 = PortConstraint.getTPC(this.graph, edge);
            this.graph.reverseEdge(edge);
            this.getSourcePortConstraintDataAcceptor().set(edge, portConstraint2);
            this.getTargetPortConstraintDataAcceptor().set(edge, portConstraint);
            if (!bl) continue;
        }
    }

    public NodePlacer getDefaultNodePlacer() {
        return this.lhb;
    }

    public void setDefaultNodePlacer(NodePlacer nodePlacer) {
        this.lhb = nodePlacer;
    }

    public NodePlacer getDefaultLeafPlacer() {
        return this.hhb;
    }

    public void setDefaultLeafPlacer(NodePlacer nodePlacer) {
        this.hhb = nodePlacer;
    }

    public PortAssignment getDefaultPortAssignment() {
        return this.vgb;
    }

    public void setDefaultPortAssignment(PortAssignment portAssignment) {
        this.vgb = portAssignment;
    }

    public Comparator getDefaultChildComparator() {
        return this.ihb;
    }

    public void setDefaultChildComparator(Comparator comparator2) {
        this.ihb = comparator2;
    }

    public void setIntegratedNodeLabeling(boolean bl) {
        this.chb = bl;
        this.ai();
    }

    private void ai() {
        block7: {
            block4: {
                boolean bl;
                block6: {
                    block5: {
                        bl = AbstractRotatableNodePlacer.z;
                        if (!this.khb && !this.chb) break block4;
                        this.setLabelLayouter(new LabelLayoutTranslator());
                        LayoutStage layoutStage = this.getLabelLayouter();
                        if (!(layoutStage instanceof LabelLayoutTranslator)) break block5;
                        ((LabelLayoutTranslator)layoutStage).setTranslateEdgeLabelsEnabled(this.khb);
                        ((LabelLayoutTranslator)layoutStage).setWriteBackEdgeLabelsEnabled(this.khb);
                        ((LabelLayoutTranslator)layoutStage).setTranslateNodeLabelsEnabled(this.chb);
                        if (!bl) break block6;
                    }
                    throw new IllegalStateException("No LabelLayoutTranslator registered");
                }
                this.setLabelLayouterEnabled(true);
                if (!bl) break block7;
            }
            this.setLabelLayouterEnabled(false);
        }
    }

    public boolean isIntegratedNodeLabeling() {
        return this.chb;
    }

    public boolean isIntegratedEdgeLabeling() {
        return this.khb;
    }

    public void setIntegratedEdgeLabeling(boolean bl) {
        this.khb = bl;
        this.ai();
    }

    public static final class SubtreeShape {
        public static final byte DIRECTION_NORTH = 1;
        public static final byte DIRECTION_EAST = 2;
        public static final byte DIRECTION_SOUTH = 4;
        public static final byte DIRECTION_WEST = 8;
        public static final int BORDERLINE_NORTH = 0;
        public static final int BORDERLINE_EAST = 1;
        public static final int BORDERLINE_SOUTH = 2;
        public static final int BORDERLINE_WEST = 3;
        private static final double l = 1.0E-4;
        private BorderLine[] f;
        double k;
        double j;
        private double h;
        private double g;
        private List i;
        private double e;
        private double d;
        private byte b;
        private Node m;
        private NodeLayout c;

        SubtreeShape(Node node, NodeLayout nodeLayout) {
            block6: {
                block5: {
                    double d2;
                    boolean bl = AbstractRotatableNodePlacer.z;
                    this.f = new BorderLine[4];
                    this.m = node;
                    this.c = nodeLayout;
                    this.h = nodeLayout.getX();
                    this.g = nodeLayout.getY();
                    double d3 = nodeLayout.getWidth();
                    if (d3 <= 0.0) {
                        d3 = 1.0;
                        this.h -= 0.5;
                    }
                    if ((d2 = nodeLayout.getHeight()) <= 0.0) {
                        d2 = 1.0;
                        this.g -= 0.5;
                    }
                    this.f[0] = new BorderLine(0.0, d3, 0.0);
                    this.f[0].addOffset(this.h);
                    this.f[0].addValueOffset(this.g);
                    this.f[2] = new BorderLine(0.0, d3, 0.0);
                    this.f[2].addOffset(this.h);
                    this.f[2].addValueOffset(this.g + d2);
                    this.f[1] = new BorderLine(0.0, d2, 0.0);
                    this.f[1].addOffset(this.g);
                    this.f[1].addValueOffset(this.h + d3);
                    this.f[3] = new BorderLine(0.0, d2, 0.0);
                    this.f[3].addOffset(this.g);
                    this.f[3].addValueOffset(this.h);
                    if (node.inDegree() <= 0) break block5;
                    LayoutGraph layoutGraph = (LayoutGraph)node.getGraph();
                    YPoint yPoint = layoutGraph.getTargetPointRel(node.firstInEdge());
                    this.e = yPoint.x + d3 * 0.5;
                    this.d = yPoint.y + d2 * 0.5;
                    if (!bl) break block6;
                    Graph.z = !Graph.z;
                }
                this.e = 0.0;
                this.d = 0.0;
            }
            this.b = 1;
        }

        public Rectangle2D.Double getCoreBounds() {
            return new Rectangle2D.Double(this.c.getX(), this.c.getY(), this.c.getWidth(), this.c.getHeight());
        }

        public Rectangle2D getBounds() {
            double d2 = this.getMinX();
            double d3 = this.getMinY();
            return new Rectangle2D.Double(d2, d3, this.getMaxX() - d2, this.getMaxY() - d3);
        }

        public double getConnectorX() {
            if (this.i == null) {
                return this.e + this.h;
            }
            return ((YPoint)this.i.get((int)(this.i.size() - 1))).x + this.h;
        }

        public double getConnectorY() {
            if (this.i == null) {
                return this.d + this.g;
            }
            return ((YPoint)this.i.get((int)(this.i.size() - 1))).y + this.g;
        }

        public void updateConnectorShape() {
            boolean bl = AbstractRotatableNodePlacer.z;
            if (this.i != null) {
                double d2 = this.e + this.h;
                double d3 = this.d + this.g;
                for (int i2 = 0; i2 < this.i.size(); ++i2) {
                    YPoint yPoint = (YPoint)this.i.get(i2);
                    this.addLineSegment(d2, d3, yPoint.x + this.h, yPoint.y + this.g);
                    d2 = yPoint.x + this.h;
                    d3 = yPoint.y + this.g;
                    if (!bl) continue;
                }
            }
        }

        public void addTargetPoint(double d2, double d3) {
            if (this.i == null) {
                this.i = new ArrayList(8);
            }
            this.i.add(new YPoint(d2 - this.h, d3 - this.g));
        }

        public void addEdgeSegments(LayoutGraph layoutGraph, Edge edge) {
            YPoint yPoint;
            double d2;
            double d3;
            block2: {
                boolean bl = AbstractRotatableNodePlacer.z;
                EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edge);
                YPoint yPoint2 = layoutGraph.getSourcePointAbs(edge);
                d3 = yPoint2.x;
                d2 = yPoint2.y;
                for (int i2 = 0; i2 < edgeLayout.pointCount(); ++i2) {
                    YPoint yPoint3 = edgeLayout.getPoint(i2);
                    this.addLineSegment(d3, d2, yPoint3.x, yPoint3.y);
                    d3 = yPoint3.x;
                    yPoint = yPoint3;
                    if (!bl) {
                        d2 = yPoint.y;
                        if (!bl) continue;
                    }
                    break block2;
                }
                yPoint = layoutGraph.getTargetPointAbs(edge);
            }
            YPoint yPoint4 = yPoint;
            this.addLineSegment(d3, d2, yPoint4.x, yPoint4.y);
        }

        public void appendTargetPoints(EdgeLayout edgeLayout) {
            boolean bl = AbstractRotatableNodePlacer.z;
            if (this.i != null) {
                for (int i2 = this.i.size() - 1; i2 >= 0; --i2) {
                    YPoint yPoint = (YPoint)this.i.get(i2);
                    edgeLayout.addPoint(yPoint.x + this.h, yPoint.y + this.g);
                    if (!bl) continue;
                }
            }
        }

        public byte getConnectorDirection() {
            return this.b;
        }

        public void addLineSegment(double d2, double d3, double d4, double d5) {
            boolean bl;
            block6: {
                double d6;
                double d7;
                double d8;
                double d9;
                block7: {
                    block4: {
                        block5: {
                            double d10;
                            bl = AbstractRotatableNodePlacer.z;
                            d9 = d2 < d4 ? d2 : d4;
                            d8 = d2 < d4 ? d4 : d2;
                            double d11 = d2 < d4 ? d3 : d5;
                            double d12 = d2 < d4 ? d5 : d3;
                            d7 = d3 < d5 ? d3 : d5;
                            d6 = d3 < d5 ? d5 : d3;
                            double d13 = d3 < d5 ? d2 : d4;
                            double d14 = d10 = d3 < d5 ? d4 : d2;
                            if (!(Math.abs(d2 - d4) > 1.0)) break block4;
                            if (!(Math.abs(d3 - d5) > 1.0)) break block5;
                            this.f[0].mergeWithMin(new BorderLine(d9, d8, d11, d12));
                            this.f[1].mergeWithMax(new BorderLine(d7, d6, d13, d10));
                            this.f[2].mergeWithMax(new BorderLine(d9, d8, d11, d12));
                            this.f[3].mergeWithMin(new BorderLine(d7, d6, d13, d10));
                            if (!bl) break block6;
                        }
                        this.f[0].setMinValue(d9, d8, d7);
                        this.f[1].setMaxValue(d7 - 0.5, d6 + 0.5, d8);
                        this.f[2].setMaxValue(d9, d8, d6);
                        this.f[3].setMinValue(d7 - 0.5, d6 + 0.5, d9);
                        if (!bl) break block6;
                    }
                    if (!(Math.abs(d3 - d5) > 1.0)) break block7;
                    this.f[0].setMinValue(d9 - 0.5, d8 + 0.5, d7);
                    this.f[1].setMaxValue(d7, d6, d8);
                    this.f[2].setMaxValue(d9 - 0.5, d8 + 0.5, d6);
                    this.f[3].setMinValue(d7, d6, d9);
                    if (!bl) break block6;
                }
                this.f[0].setMinValue(d9 - 0.5, d8 + 0.5, d7);
                this.f[1].setMaxValue(d7 - 0.5, d6 + 0.5, d8);
                this.f[2].setMaxValue(d9 - 0.5, d8 + 0.5, d6);
                this.f[3].setMinValue(d7 - 0.5, d6 + 0.5, d9);
            }
            if (Graph.z) {
                AbstractRotatableNodePlacer.z = !bl;
            }
        }

        public void addBoundsToShape(double d2, double d3, double d4, double d5) {
            BorderLine borderLine = this.getBorderLine(0);
            BorderLine borderLine2 = this.getBorderLine(1);
            BorderLine borderLine3 = this.getBorderLine(2);
            BorderLine borderLine4 = this.getBorderLine(3);
            if (d4 > 0.0) {
                borderLine.setMinValue(d2, d2 + d4, d3);
                borderLine3.setMaxValue(d2, d2 + d4, d3 + d5);
            }
            if (d5 > 0.0) {
                borderLine2.setMaxValue(d3, d3 + d5, d2 + d4);
                borderLine4.setMinValue(d3, d3 + d5, d2);
            }
        }

        void b(OrientedRectangle orientedRectangle) {
            block4: {
                YPoint[] yPointArray;
                boolean bl;
                block3: {
                    bl = AbstractRotatableNodePlacer.z;
                    if (!SubtreeShape.c(orientedRectangle)) break block3;
                    yPointArray = orientedRectangle.getBoundingBox();
                    this.addBoundsToShape(yPointArray.getX(), yPointArray.getY(), yPointArray.getWidth(), yPointArray.getHeight());
                    if (!bl) break block4;
                }
                yPointArray = OrientedRectangle.calcPoints(orientedRectangle);
                for (int i2 = 0; i2 < yPointArray.length; ++i2) {
                    YPoint yPoint = yPointArray[i2];
                    YPoint yPoint2 = yPointArray[(i2 + 1) % yPointArray.length];
                    this.addLineSegment(yPoint.x, yPoint.y, yPoint2.x, yPoint2.y);
                    if (!bl) continue;
                }
            }
        }

        private static boolean c(OrientedRectangle orientedRectangle) {
            return Math.abs(orientedRectangle.getUpX()) < 1.0E-4 || Math.abs(orientedRectangle.getUpY()) < 1.0E-4;
        }

        public void mergeWith(SubtreeShape subtreeShape) {
            this.f[0].mergeWithMin(subtreeShape.f[0]);
            this.f[1].mergeWithMax(subtreeShape.f[1]);
            this.f[2].mergeWithMax(subtreeShape.f[2]);
            this.f[3].mergeWithMin(subtreeShape.f[3]);
        }

        public double getMinX() {
            return Math.min(this.f[0].getMin(), Math.min(this.f[2].getMin(), this.f[3].getMinValue()));
        }

        public double getMinY() {
            return Math.min(this.f[0].getMinValue(), Math.min(this.f[1].getMin(), this.f[3].getMin()));
        }

        public double getMaxX() {
            return Math.max(this.f[0].getMax(), Math.max(this.f[2].getMax(), this.f[1].getMaxValue()));
        }

        public double getMaxY() {
            return Math.max(this.f[1].getMax(), Math.max(this.f[2].getMaxValue(), this.f[3].getMax()));
        }

        public BorderLine getBorderLine(int n2) {
            if (n2 < 0 || n2 > 3) {
                throw new IllegalArgumentException("Unknown border line index" + n2);
            }
            return this.f[n2];
        }

        public void move(double d2, double d3) {
            this.f[0].addOffset(d2);
            this.f[0].addValueOffset(d3);
            this.f[1].addOffset(d3);
            this.f[1].addValueOffset(d2);
            this.f[2].addOffset(d2);
            this.f[2].addValueOffset(d3);
            this.f[3].addOffset(d3);
            this.f[3].addValueOffset(d2);
            this.h += d2;
            this.g += d3;
            this.c.setLocation(this.c.getX() + d2, this.c.getY() + d3);
        }

        public double getOriginX() {
            return this.h;
        }

        public double getOriginY() {
            return this.g;
        }

        public SubtreeShape createCopy(AbstractRotatableNodePlacer.Matrix matrix) {
            SubtreeShape subtreeShape = new SubtreeShape(this.m, new DefaultNodeLayout());
            subtreeShape.b = this.b;
            this.assignValuesTo(subtreeShape, matrix);
            return subtreeShape;
        }

        public void assignValuesTo(SubtreeShape subtreeShape, AbstractRotatableNodePlacer.Matrix matrix) {
            block9: {
                Object object;
                Object object2;
                Object object3;
                boolean bl;
                block8: {
                    bl = AbstractRotatableNodePlacer.z;
                    AbstractRotatableNodePlacer._b _b2 = AbstractRotatableNodePlacer._b.b(this.c.getWidth(), this.c.getHeight());
                    AbstractRotatableNodePlacer._b _b3 = _b2.b(matrix);
                    subtreeShape.c.setSize(_b3.b(0), _b3.b(1));
                    AbstractRotatableNodePlacer._b _b4 = AbstractRotatableNodePlacer._b.b(this.h, this.g);
                    AbstractRotatableNodePlacer._b _b5 = _b4.b(matrix);
                    subtreeShape.h = _b5.b(0);
                    subtreeShape.g = _b5.b(1);
                    subtreeShape.c.setLocation(_b5.b(0), _b5.b(1));
                    AbstractRotatableNodePlacer._b _b6 = AbstractRotatableNodePlacer._b.b(this.e, this.d);
                    AbstractRotatableNodePlacer._b _b7 = _b6.b(matrix);
                    subtreeShape.e = _b7.b(0);
                    subtreeShape.d = _b7.b(1);
                    BorderLine[] borderLineArray = new BorderLine[4];
                    for (int i2 = 0; i2 < this.f.length; ++i2) {
                        block11: {
                            AbstractRotatableNodePlacer._b _b8;
                            AbstractRotatableNodePlacer._b _b9;
                            block10: {
                                object3 = this.f[i2];
                                object2 = matrix.b();
                                if (bl) break block8;
                                if (i2 != 0 && i2 != 2) break block10;
                                _b9 = ((AbstractRotatableNodePlacer.Matrix)object2).b(0);
                                _b8 = ((AbstractRotatableNodePlacer.Matrix)object2).b(1);
                                object = ((BorderLine)object3).createCopy(_b8.b() < 0.0, _b9.b() < 0.0);
                                if (!bl) break block11;
                            }
                            _b9 = ((AbstractRotatableNodePlacer.Matrix)object2).b(0);
                            _b8 = ((AbstractRotatableNodePlacer.Matrix)object2).b(1);
                            object = ((BorderLine)object3).createCopy(_b9.b() < 0.0, _b8.b() < 0.0);
                        }
                        int n2 = AbstractRotatableNodePlacer._b.c(i2).b(matrix).c();
                        borderLineArray[n2] = object;
                        if (!bl) continue;
                    }
                    subtreeShape.f = borderLineArray;
                }
                if (this.i != null) {
                    ArrayList<YPoint> arrayList = new ArrayList<YPoint>();
                    object3 = this.i.iterator();
                    while (object3.hasNext()) {
                        object2 = (YPoint)object3.next();
                        object = AbstractRotatableNodePlacer._b.b((YPoint)object2);
                        AbstractRotatableNodePlacer._b _b10 = ((AbstractRotatableNodePlacer._b)object).b(matrix);
                        arrayList.add(new YPoint(_b10.b(0), _b10.b(1)));
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block9;
                    }
                    subtreeShape.i = arrayList;
                }
            }
        }

        Node b() {
            return this.m;
        }

        NodeLayout c() {
            return this.c;
        }

        public String toString() {
            return "SubtreeShape{x=" + this.h + ", y=" + this.g + ", dx=" + this.k + ", dy=" + this.j + ", borderLines=" + (this.f == null ? null : Arrays.asList(this.f)) + "}";
        }
    }
}

